# Contributing to TGUI

Thank you for considering contributing to TGUI!

All contributions are highly appreciated, whether they are code patches, bug reports or suggestions. Note that while reported bugs are usually handled very quickly, suggestions can sometimes take a long time to be implemented due to TGUI being developed in the spare time of a single developer with only occasional code contributions by others.


## Need help?

If you have any questions about TGUI, the [Discord server](https://discord.gg/Msf4vyx) and the [forum](https://forum.tgui.eu/) are the best places to get an answer.


## Style guide

TGUI has no official style guide yet, but since its style was heavily influenced by SFML code, the [SFML code style guide](https://www.sfml-dev.org/style.php) mostly matches with TGUI code.

There are 3 differences that I'm aware of:
- TGUI uses `@` in Doxygen documentation where SFML uses `\`
- Lines consisting of only slashes (to separate functions) are longer in TGUI
- TGUI code targets C++14
