# Neovim Tinymist Plugin Specification

This document describes the comprehensive specification for the Neovim Tinymist plugin, which provides Language Server Protocol (LSP) integration for Typst documents. This plugin serves as the heavily-documented canonical implementation of an editor language client for Tinymist.

The specification has special formats:

Example of document a concept or object:

```md
## Tinymist Views

There are following views in the [_Tinymist Views_](#tinymist-views):

- [_Symbol View_](#symbol-view)
- [_Tool View_](#tool-view)
- [_Package View_](#package-view)
- [_Content View_](#content-view)
- [_Label View_](#label-view)
- [_Outline View_](#outline-view)
```

Example of document the actions of a object:

```markdown
### Symbol View

There are following actions that you can perform in the [_Symbol View_](#symbol-view):


- Search Symbol by Names: You can search for a symbol by its name. The search is case-insensitive and supports partial matching.
- Search Symbol by Handwritten Strokes: You can draw a symbol and search for it. The symbol will be highlighted.
- Click to paste: You can click on a symbol to paste it to the editor.
```
