use crate::foundations::{Module, Scope};
use crate::symbols::{symbols, Symbol};

/// A module with all emoji.
pub fn emoji() -> Module {
    let mut scope = Scope::new();
    for (name, symbol) in EMOJI {
        scope.define(*name, symbol.clone());
    }
    Module::new("emoji", scope)
}

/// A list of named emoji.
const EMOJI: &[(&str, Symbol)] = symbols! {
    abacus: '🧮',
    abc: '🔤',
    abcd: '🔡',
    ABCD: '🔠',
    accordion: '🪗',
    aesculapius: '⚕',
    airplane: [
        '✈',
        landing: '🛬',
        small: '🛩',
        takeoff: '🛫',
    ],
    alembic: '⚗',
    alien: ['👽', monster: '👾'],
    ambulance: '🚑',
    amphora: '🏺',
    anchor: '⚓',
    anger: '💢',
    ant: '🐜',
    apple: [green: '🍏', red: '🍎'],
    arm: [mech: '🦾', muscle: '💪', selfie: '🤳'],
    arrow: [
        r.filled: '➡',
        r.hook: '↪',
        r.soon: '🔜',
        l.filled: '⬅',
        l.hook: '↩',
        l.back: '🔙',
        l.end: '🔚',
        t.filled: '⬆',
        t.curve: '⤴',
        t.top: '🔝',
        b.filled: '⬇',
        b.curve: '⤵',
        l.r: '↔',
        l.r.on: '🔛',
        t.b: '↕',
        bl: '↙',
        br: '↘',
        tl: '↖',
        tr: '↗',
    ],
    arrows: [cycle: '🔄'],
    ast: ['*', box: '✳'],
    atm: '🏧',
    atom: '⚛',
    aubergine: '🍆',
    avocado: '🥑',
    axe: '🪓',
    baby: ['👶', angel: '👼', box: '🚼'],
    babybottle: '🍼',
    backpack: '🎒',
    bacon: '🥓',
    badger: '🦡',
    badminton: '🏸',
    bagel: '🥯',
    baggageclaim: '🛄',
    baguette: '🥖',
    balloon: '🎈',
    ballot: [check: '☑'],
    ballotbox: '🗳',
    banana: '🍌',
    banjo: '🪕',
    bank: '🏦',
    barberpole: '💈',
    baseball: '⚾',
    basecap: '🧢',
    basket: '🧺',
    basketball: ['⛹', ball: '🏀'],
    bat: '🦇',
    bathtub: ['🛀', foam: '🛁'],
    battery: ['🔋', low: '🪫'],
    beach: [palm: '🏝', umbrella: '🏖'],
    beads: '📿',
    beans: '🫘',
    bear: '🐻',
    beaver: '🦫',
    bed: ['🛏', person: '🛌'],
    bee: '🐝',
    beer: ['🍺', clink: '🍻'],
    beetle: ['🪲', lady: '🐞'],
    bell: ['🔔', ding: '🛎', not: '🔕'],
    bento: '🍱',
    bicyclist: ['🚴', mountain: '🚵'],
    bike: ['🚲', not: '🚳'],
    bikini: '👙',
    billiards: '🎱',
    bin: '🗑',
    biohazard: '☣',
    bird: '🐦',
    bison: '🦬',
    blood: '🩸',
    blouse: '👚',
    blowfish: '🐡',
    blueberries: '🫐',
    boar: '🐗',
    boat: [
        sail: '⛵',
        row: '🚣',
        motor: '🛥',
        speed: '🚤',
        canoe: '🛶',
    ],
    bolt: '🔩',
    bomb: '💣',
    bone: '🦴',
    book: [
        red: '📕',
        blue: '📘',
        green: '📗',
        orange: '📙',
        spiral: '📒',
        open: '📖',
    ],
    bookmark: '🔖',
    books: '📚',
    boomerang: '🪃',
    bordercontrol: '🛂',
    bouquet: '💐',
    bow: '🏹',
    bowl: [spoon: '🥣', steam: '🍜'],
    bowling: '🎳',
    boxing: '🥊',
    boy: '👦',
    brain: '🧠',
    bread: '🍞',
    brick: '🧱',
    bride: '👰',
    bridge: [fog: '🌁', night: '🌉'],
    briefcase: '💼',
    briefs: '🩲',
    brightness: [high: '🔆', low: '🔅'],
    broccoli: '🥦',
    broom: '🧹',
    brush: '🖌',
    bubble: [
        speech.r: '💬',
        speech.l: '🗨',
        thought: '💭',
        anger.r: '🗯',
    ],
    bubbles: '🫧',
    bubbletea: '🧋',
    bucket: '🪣',
    buffalo: [water: '🐃'],
    bug: '🐛',
    builder: '👷',
    burger: '🍔',
    burrito: '🌯',
    bus: [
        '🚌',
        front: '🚍',
        small: '🚐',
        stop: '🚏',
        trolley: '🚎',
    ],
    butter: '🧈',
    butterfly: '🦋',
    button: ['🔲', alt: '🔳', radio: '🔘'],
    cabinet: [file: '🗄'],
    cablecar: ['🚠', small: '🚡'],
    cactus: '🌵',
    cake: [
        '🎂',
        fish: '🍥',
        moon: '🥮',
        slice: '🍰',
    ],
    calendar: ['📅', spiral: '🗓', tearoff: '📆'],
    camel: ['🐫', dromedar: '🐪'],
    camera: [
        '📷',
        flash: '📸',
        movie: '🎥',
        movie.box: '🎦',
        video: '📹',
    ],
    camping: '🏕',
    can: '🥫',
    candle: '🕯',
    candy: '🍬',
    cane: '🦯',
    car: [
        '🚗',
        front: '🚘',
        pickup: '🛻',
        police: '🚓',
        police.front: '🚔',
        racing: '🏎',
        rickshaw: '🛺',
        suv: '🚙',
    ],
    card: [credit: '💳', id: '🪪'],
    cardindex: '📇',
    carrot: '🥕',
    cart: '🛒',
    cassette: '📼',
    castle: [eu: '🏰', jp: '🏯'],
    cat: [
        '🐈',
        face: '🐱',
        face.angry: '😾',
        face.cry: '😿',
        face.heart: '😻',
        face.joy: '😹',
        face.kiss: '😽',
        face.laugh: '😸',
        face.shock: '🙀',
        face.smile: '😺',
        face.smirk: '😼',
    ],
    chain: '🔗',
    chains: '⛓',
    chair: '🪑',
    champagne: '🍾',
    chart: [
        bar: '📊',
        up: '📈',
        down: '📉',
        yen.up: '💹',
    ],
    checkmark: [heavy: '✔', box: '✅'],
    cheese: '🧀',
    cherries: '🍒',
    chess: '♟',
    chestnut: '🌰',
    chicken: [
        '🐔',
        baby: '🐥',
        baby.egg: '🐣',
        baby.head: '🐤',
        leg: '🍗',
        male: '🐓',
    ],
    child: '🧒',
    chipmunk: '🐿',
    chocolate: '🍫',
    chopsticks: '🥢',
    church: ['⛪', love: '💒'],
    cigarette: ['🚬', not: '🚭'],
    circle: [
        black: '⚫',
        blue: '🔵',
        brown: '🟤',
        green: '🟢',
        orange: '🟠',
        purple: '🟣',
        white: '⚪',
        red: '🔴',
        yellow: '🟡',
        stroked: '⭕',
    ],
    circus: '🎪',
    city: [
        '🏙',
        dusk: '🌆',
        night: '🌃',
        sunset: '🌇',
    ],
    clamp: '🗜',
    clapperboard: '🎬',
    climbing: '🧗',
    clip: '📎',
    clipboard: '📋',
    clips: '🖇',
    clock: [
        one: '🕐',
        one.thirty: '🕜',
        two: '🕑',
        two.thirty: '🕝',
        three: '🕒',
        three.thirty: '🕞',
        four: '🕓',
        four.thirty: '🕟',
        five: '🕔',
        five.thirty: '🕠',
        six: '🕕',
        six.thirty: '🕡',
        seven: '🕖',
        seven.thirty: '🕢',
        eight: '🕗',
        eight.thirty: '🕣',
        nine: '🕘',
        nine.thirty: '🕤',
        ten: '🕙',
        ten.thirty: '🕥',
        eleven: '🕚',
        eleven.thirty: '🕦',
        twelve: '🕛',
        twelve.thirty: '🕧',
        alarm: '⏰',
        old: '🕰',
        timer: '⏲',
    ],
    cloud: [
        '☁',
        dust: '💨',
        rain: '🌧',
        snow: '🌨',
        storm: '⛈',
        sun: '⛅',
        sun.hidden: '🌥',
        sun.rain: '🌦',
        thunder: '🌩',
    ],
    coat: ['🧥', lab: '🥼'],
    cockroach: '🪳',
    cocktail: [martini: '🍸', tropical: '🍹'],
    coconut: '🥥',
    coffee: '☕',
    coffin: '⚰',
    coin: '🪙',
    comet: '☄',
    compass: '🧭',
    computer: '🖥',
    computermouse: '🖱',
    confetti: '🎊',
    construction: '🚧',
    controller: '🎮',
    cookie: ['🍪', fortune: '🥠'],
    cooking: '🍳',
    cool: '🆒',
    copyright: '©',
    coral: '🪸',
    corn: '🌽',
    couch: '🛋',
    couple: '💑',
    cow: ['🐄', face: '🐮'],
    crab: '🦀',
    crane: '🏗',
    crayon: '🖍',
    cricket: '🦗',
    cricketbat: '🏏',
    crocodile: '🐊',
    croissant: '🥐',
    crossmark: ['❌', box: '❎'],
    crown: '👑',
    crutch: '🩼',
    crystal: '🔮',
    cucumber: '🥒',
    cup: [straw: '🥤'],
    cupcake: '🧁',
    curling: '🥌',
    curry: '🍛',
    custard: '🍮',
    customs: '🛃',
    cutlery: '🍴',
    cyclone: '🌀',
    dancing: [man: '🕺', woman: '💃', women.bunny: '👯'],
    darts: '🎯',
    dash: [wave.double: '〰'],
    deer: '🦌',
    desert: '🏜',
    detective: '🕵',
    diamond: [
        blue: '🔷',
        blue.small: '🔹',
        orange: '🔶',
        orange.small: '🔸',
        dot: '💠',
    ],
    die: '🎲',
    dino: [pod: '🦕', rex: '🦖'],
    disc: [cd: '💿', dvd: '📀', mini: '💽'],
    discoball: '🪩',
    diving: '🤿',
    dodo: '🦤',
    dog: [
        '🐕',
        face: '🐶',
        guide: '🦮',
        poodle: '🐩',
    ],
    dollar: '💲',
    dolphin: '🐬',
    donut: '🍩',
    door: '🚪',
    dove: [peace: '🕊'],
    dragon: ['🐉', face: '🐲'],
    dress: ['👗', kimono: '👘', sari: '🥻'],
    drop: '💧',
    drops: '💦',
    drum: ['🥁', big: '🪘'],
    duck: '🦆',
    dumpling: '🥟',
    eagle: '🦅',
    ear: ['👂', aid: '🦻'],
    egg: '🥚',
    eighteen: [not: '🔞'],
    elephant: '🐘',
    elevator: '🛗',
    elf: '🧝',
    email: '📧',
    excl: [
        '❗',
        white: '❕',
        double: '‼',
        quest: '⁉',
    ],
    explosion: '💥',
    extinguisher: '🧯',
    eye: '👁',
    eyes: '👀',
    face: [
        grin: '😀',
        angry: '😠',
        angry.red: '😡',
        anguish: '😧',
        astonish: '😲',
        bandage: '🤕',
        beam: '😁',
        blank: '😶',
        clown: '🤡',
        cold: '🥶',
        concern: '😦',
        cool: '😎',
        cover: '🤭',
        cowboy: '🤠',
        cry: '😭',
        devil.smile: '😈',
        devil.frown: '👿',
        diagonal: '🫤',
        disguise: '🥸',
        dizzy: '😵',
        dotted: '🫥',
        down: '😞',
        down.sweat: '😓',
        drool: '🤤',
        explode: '🤯',
        eyeroll: '🙄',
        friendly: '☺',
        fear: '😨',
        fear.sweat: '😰',
        fever: '🤒',
        flush: '😳',
        frown: '☹',
        frown.slight: '🙁',
        frust: '😣',
        goofy: '🤪',
        halo: '😇',
        happy: '😊',
        heart: '😍',
        hearts: '🥰',
        heat: '🥵',
        hug: '🤗',
        inv: '🙃',
        joy: '😂',
        kiss: '😗',
        kiss.smile: '😙',
        kiss.heart: '😘',
        kiss.blush: '😚',
        lick: '😋',
        lie: '🤥',
        mask: '😷',
        meh: '😒',
        melt: '🫠',
        money: '🤑',
        monocle: '🧐',
        nausea: '🤢',
        nerd: '🤓',
        neutral: '😐',
        open: '😃',
        party: '🥳',
        peek: '🫣',
        plead: '🥺',
        relief: '😌',
        rofl: '🤣',
        sad: '😔',
        salute: '🫡',
        shock: '😱',
        shush: '🤫',
        skeptic: '🤨',
        sleep: '😴',
        sleepy: '😪',
        smile: '😄',
        smile.slight: '🙂',
        smile.sweat: '😅',
        smile.tear: '🥲',
        smirk: '😏',
        sneeze: '🤧',
        speak.not: '🫢',
        squint: '😆',
        stars: '🤩',
        straight: '😑',
        suffer: '😖',
        surprise: '😯',
        symbols: '🤬',
        tear: '😢',
        tear.relief: '😥',
        tear.withheld: '🥹',
        teeth: '😬',
        think: '🤔',
        tired: '😫',
        tongue: '😛',
        tongue.squint: '😝',
        tongue.wink: '😜',
        triumph: '😤',
        unhappy: '😕',
        vomit: '🤮',
        weary: '😩',
        wink: '😉',
        woozy: '🥴',
        worry: '😟',
        wow: '😮',
        yawn: '🥱',
        zip: '🤐',
    ],
    factory: '🏭',
    fairy: '🧚',
    faith: [
        christ: '✝',
        dharma: '☸',
        islam: '☪',
        judaism: '✡',
        menorah: '🕎',
        om: '🕉',
        orthodox: '☦',
        peace: '☮',
        star.dot: '🔯',
        worship: '🛐',
        yinyang: '☯',
    ],
    falafel: '🧆',
    family: '👪',
    fax: '📠',
    feather: '🪶',
    feeding: [breast: '🤱'],
    fencing: '🤺',
    ferriswheel: '🎡',
    filebox: '🗃',
    filedividers: '🗂',
    film: '🎞',
    finger: [
        r: '👉',
        l: '👈',
        t: '👆',
        t.alt: '☝',
        b: '👇',
        front: '🫵',
        m: '🖕',
    ],
    fingers: [cross: '🤞', pinch: '🤌', snap: '🫰'],
    fire: '🔥',
    firecracker: '🧨',
    fireengine: '🚒',
    fireworks: '🎆',
    fish: ['🐟', tropical: '🐠'],
    fishing: '🎣',
    fist: [
        front: '👊',
        r: '🤜',
        l: '🤛',
        raised: '✊',
    ],
    flag: [
        black: '🏴',
        white: '🏳',
        goal: '🏁',
        golf: '⛳',
        red: '🚩',
    ],
    flags: [jp.crossed: '🎌'],
    flamingo: '🦩',
    flashlight: '🔦',
    flatbread: '🫓',
    fleur: '⚜',
    floppy: '💾',
    flower: [
        hibiscus: '🌺',
        lotus: '🪷',
        pink: '🌸',
        rose: '🌹',
        sun: '🌻',
        tulip: '🌷',
        white: '💮',
        wilted: '🥀',
        yellow: '🌼',
    ],
    fly: '🪰',
    fog: '🌫',
    folder: ['📁', open: '📂'],
    fondue: '🫕',
    foot: '🦶',
    football: ['⚽', am: '🏈'],
    forex: '💱',
    fountain: '⛲',
    fox: '🦊',
    free: '🆓',
    fries: '🍟',
    frisbee: '🥏',
    frog: [face: '🐸'],
    fuelpump: '⛽',
    garlic: '🧄',
    gear: '⚙',
    gem: '💎',
    genie: '🧞',
    ghost: '👻',
    giraffe: '🦒',
    girl: '👧',
    glass: [
        clink: '🥂',
        milk: '🥛',
        pour: '🫗',
        tumbler: '🥃',
    ],
    glasses: ['👓', sun: '🕶'],
    globe: [
        am: '🌎',
        as.au: '🌏',
        eu.af: '🌍',
        meridian: '🌐',
    ],
    gloves: '🧤',
    goal: '🥅',
    goat: '🐐',
    goggles: '🥽',
    golfing: '🏌',
    gorilla: '🦍',
    grapes: '🍇',
    guard: [man: '💂'],
    guitar: '🎸',
    gymnastics: '🤸',
    haircut: '💇',
    hammer: ['🔨', pick: '⚒', wrench: '🛠'],
    hamsa: '🪬',
    hamster: [face: '🐹'],
    hand: [
        raised: '✋',
        raised.alt: '🤚',
        r: '🫱',
        l: '🫲',
        t: '🫴',
        b: '🫳',
        ok: '👌',
        call: '🤙',
        love: '🤟',
        part: '🖖',
        peace: '✌',
        pinch: '🤏',
        rock: '🤘',
        splay: '🖐',
        wave: '👋',
        write: '✍',
    ],
    handbag: '👜',
    handball: '🤾',
    handholding: [man.man: '👬', woman.man: '👫', woman.woman: '👭'],
    hands: [
        folded: '🙏',
        palms: '🤲',
        clap: '👏',
        heart: '🫶',
        open: '👐',
        raised: '🙌',
        shake: '🤝',
    ],
    hash: '#',
    hat: [ribbon: '👒', top: '🎩'],
    headphone: '🎧',
    heart: [
        '❤',
        arrow: '💘',
        beat: '💓',
        black: '🖤',
        blue: '💙',
        box: '💟',
        broken: '💔',
        brown: '🤎',
        double: '💕',
        excl: '❣',
        green: '💚',
        grow: '💗',
        orange: '🧡',
        purple: '💜',
        real: '🫀',
        revolve: '💞',
        ribbon: '💝',
        spark: '💖',
        white: '🤍',
        yellow: '💛',
    ],
    hedgehog: '🦔',
    helicopter: '🚁',
    helix: '🧬',
    helmet: [cross: '⛑', military: '🪖'],
    hippo: '🦛',
    hockey: '🏑',
    hole: '🕳',
    honey: '🍯',
    hongbao: '🧧',
    hook: '🪝',
    horn: [postal: '📯'],
    horse: [
        '🐎',
        carousel: '🎠',
        face: '🐴',
        race: '🏇',
    ],
    hospital: '🏥',
    hotdog: '🌭',
    hotel: ['🏨', love: '🏩'],
    hotspring: '♨',
    hourglass: ['⌛', flow: '⏳'],
    house: [
        '🏠',
        derelict: '🏚',
        garden: '🏡',
        multiple: '🏘',
    ],
    hundred: '💯',
    hut: '🛖',
    ice: '🧊',
    icecream: ['🍨', shaved: '🍧', soft: '🍦'],
    icehockey: '🏒',
    id: '🆔',
    info: 'ℹ',
    izakaya: '🏮',
    jar: '🫙',
    jeans: '👖',
    jigsaw: '🧩',
    joystick: '🕹',
    juggling: '🤹',
    juice: '🧃',
    kaaba: '🕋',
    kadomatsu: '🎍',
    kangaroo: '🦘',
    gachi: '🈷',
    go: '🈴',
    hi: '㊙',
    ka: '🉑',
    kachi: '🈹',
    kara: '🈳',
    kon: '🈲',
    man: '🈵',
    muryo: '🈚',
    shin: '🈸',
    shuku: '㊗',
    toku: '🉐',
    yo: '🈺',
    yubi: '🈯',
    yuryo: '🈶',
    koko: '🈁',
    sa: '🈂',
    kebab: '🥙',
    key: ['🔑', old: '🗝'],
    keyboard: '⌨',
    kiss: '💏',
    kissmark: '💋',
    kite: '🪁',
    kiwi: '🥝',
    knife: ['🔪', dagger: '🗡'],
    knot: '🪢',
    koala: '🐨',
    koinobori: '🎏',
    label: '🏷',
    lacrosse: '🥍',
    ladder: '🪜',
    lamp: [diya: '🪔'],
    laptop: '💻',
    a: '🅰',
    ab: '🆎',
    b: '🅱',
    cl: '🆑',
    o: '🅾',
    leaf: [
        clover.three: '☘',
        clover.four: '🍀',
        fall: '🍂',
        herb: '🌿',
        maple: '🍁',
        wind: '🍃',
    ],
    leftluggage: '🛅',
    leg: ['🦵', mech: '🦿'],
    lemon: '🍋',
    leopard: '🐆',
    letter: [love: '💌'],
    liberty: '🗽',
    lightbulb: '💡',
    lightning: '⚡',
    lion: '🦁',
    lipstick: '💄',
    litter: ['🚮', not: '🚯'],
    lizard: '🦎',
    llama: '🦙',
    lobster: '🦞',
    lock: [
        '🔒',
        key: '🔐',
        open: '🔓',
        pen: '🔏',
    ],
    lollipop: '🍭',
    lotion: '🧴',
    luggage: '🧳',
    lungs: '🫁',
    mage: '🧙',
    magnet: '🧲',
    magnify: [r: '🔎', l: '🔍'],
    mahjong: [dragon.red: '🀄'],
    mail: ['✉', arrow: '📩'],
    mailbox: [
        closed.empty: '📪',
        closed.full: '📫',
        open.empty: '📭',
        open.full: '📬',
    ],
    mammoth: '🦣',
    man: [
        '👨',
        box: '🚹',
        crown: '🤴',
        guapimao: '👲',
        levitate: '🕴',
        old: '👴',
        pregnant: '🫃',
        turban: '👳',
        tuxedo: '🤵',
    ],
    mango: '🥭',
    map: [world: '🗺', jp: '🗾'],
    martialarts: '🥋',
    masks: '🎭',
    mate: '🧉',
    matryoshka: '🪆',
    meat: ['🥩', bone: '🍖'],
    medal: [
        first: '🥇',
        second: '🥈',
        third: '🥉',
        sports: '🏅',
        military: '🎖',
    ],
    megaphone: ['📢', simple: '📣'],
    melon: '🍈',
    merperson: '🧜',
    metro: 'Ⓜ',
    microbe: '🦠',
    microphone: ['🎤', studio: '🎙'],
    microscope: '🔬',
    milkyway: '🌌',
    mirror: '🪞',
    mixer: '🎛',
    money: [
        bag: '💰',
        dollar: '💵',
        euro: '💶',
        pound: '💷',
        yen: '💴',
        wings: '💸',
    ],
    monkey: [
        '🐒',
        face: '🐵',
        hear.not: '🙉',
        see.not: '🙈',
        speak.not: '🙊',
    ],
    moon: [
        crescent: '🌙',
        full: '🌕',
        full.face: '🌝',
        new: '🌑',
        new.face: '🌚',
        wane.one: '🌖',
        wane.two: '🌗',
        wane.three.face: '🌜',
        wane.three: '🌘',
        wax.one: '🌒',
        wax.two: '🌓',
        wax.two.face: '🌛',
        wax.three: '🌔',
    ],
    mortarboard: '🎓',
    mosque: '🕌',
    mosquito: '🦟',
    motorcycle: '🏍',
    motorway: '🛣',
    mountain: [
        '⛰',
        fuji: '🗻',
        snow: '🏔',
        sunrise: '🌄',
    ],
    mouse: ['🐁', face: '🐭'],
    mousetrap: '🪤',
    mouth: ['👄', bite: '🫦'],
    moyai: '🗿',
    museum: '🏛',
    mushroom: '🍄',
    musicalscore: '🎼',
    nails: [polish: '💅'],
    namebadge: '📛',
    nazar: '🧿',
    necktie: '👔',
    needle: '🪡',
    nest: [empty: '🪹', eggs: '🪺'],
    new: '🆕',
    newspaper: ['📰', rolled: '🗞'],
    ng: '🆖',
    ningyo: '🎎',
    ninja: '🥷',
    noentry: '⛔',
    nose: '👃',
    notebook: ['📓', deco: '📔'],
    notepad: '🗒',
    notes: ['🎵', triple: '🎶'],
    numbers: '🔢',
    octopus: '🐙',
    office: '🏢',
    oil: '🛢',
    ok: '🆗',
    olive: '🫒',
    oni: '👹',
    onion: '🧅',
    orangutan: '🦧',
    otter: '🦦',
    owl: '🦉',
    ox: '🐂',
    oyster: '🦪',
    package: '📦',
    paella: '🥘',
    page: ['📄', curl: '📃', pencil: '📝'],
    pager: '📟',
    pages: [tabs: '📑'],
    painting: '🖼',
    palette: '🎨',
    pancakes: '🥞',
    panda: '🐼',
    parachute: '🪂',
    park: '🏞',
    parking: '🅿',
    parrot: '🦜',
    partalteration: '〽',
    party: '🎉',
    peach: '🍑',
    peacock: '🦚',
    peanuts: '🥜',
    pear: '🍐',
    pedestrian: ['🚶', not: '🚷'],
    pen: [ball: '🖊', fountain: '🖋'],
    pencil: '✏',
    penguin: '🐧',
    pepper: ['🫑', hot: '🌶'],
    person: [
        '🧑',
        angry: '🙎',
        beard: '🧔',
        blonde: '👱',
        bow: '🙇',
        crown: '🫅',
        deaf: '🧏',
        facepalm: '🤦',
        frown: '🙍',
        hijab: '🧕',
        kneel: '🧎',
        lotus: '🧘',
        massage: '💆',
        no: '🙅',
        ok: '🙆',
        old: '🧓',
        pregnant: '🫄',
        raise: '🙋',
        sassy: '💁',
        shrug: '🤷',
        stand: '🧍',
        steam: '🧖',
    ],
    petri: '🧫',
    phone: [
        '📱',
        arrow: '📲',
        classic: '☎',
        not: '📵',
        off: '📴',
        receiver: '📞',
        signal: '📶',
        vibrate: '📳',
    ],
    piano: '🎹',
    pick: '⛏',
    pie: '🥧',
    pig: ['🐖', face: '🐷', nose: '🐽'],
    pill: '💊',
    pin: ['📌', round: '📍'],
    pinata: '🪅',
    pineapple: '🍍',
    pingpong: '🏓',
    pistol: '🔫',
    pizza: '🍕',
    placard: '🪧',
    planet: '🪐',
    plant: '🪴',
    plaster: '🩹',
    plate: [cutlery: '🍽'],
    playback: [
        down: '⏬',
        eject: '⏏',
        forward: '⏩',
        pause: '⏸',
        record: '⏺',
        repeat: '🔁',
        repeat.once: '🔂',
        repeat.v: '🔃',
        restart: '⏮',
        rewind: '⏪',
        shuffle: '🔀',
        skip: '⏭',
        stop: '⏹',
        toggle: '⏯',
        up: '⏫',
    ],
    playingcard: [flower: '🎴', joker: '🃏'],
    plunger: '🪠',
    policeofficer: '👮',
    poo: '💩',
    popcorn: '🍿',
    post: [eu: '🏤', jp: '🏣'],
    postbox: '📮',
    potato: ['🥔', sweet: '🍠'],
    pouch: '👝',
    powerplug: '🔌',
    present: '🎁',
    pretzel: '🥨',
    printer: '🖨',
    prints: [foot: '👣', paw: '🐾'],
    prohibited: '🚫',
    projector: '📽',
    pumpkin: [lantern: '🎃'],
    purse: '👛',
    quest: ['❓', white: '❔'],
    rabbit: ['🐇', face: '🐰'],
    raccoon: '🦝',
    radio: '📻',
    radioactive: '☢',
    railway: '🛤',
    rainbow: '🌈',
    ram: '🐏',
    rat: '🐀',
    razor: '🪒',
    receipt: '🧾',
    recycling: '♻',
    reg: '®',
    restroom: '🚻',
    rhino: '🦏',
    ribbon: ['🎀', remind: '🎗'],
    rice: [
        '🍚',
        cracker: '🍘',
        ear: '🌾',
        onigiri: '🍙',
    ],
    ring: '💍',
    ringbuoy: '🛟',
    robot: '🤖',
    rock: '🪨',
    rocket: '🚀',
    rollercoaster: '🎢',
    rosette: '🏵',
    rugby: '🏉',
    ruler: ['📏', triangle: '📐'],
    running: '🏃',
    safetypin: '🧷',
    safetyvest: '🦺',
    sake: '🍶',
    salad: '🥗',
    salt: '🧂',
    sandwich: '🥪',
    santa: [man: '🎅', woman: '🤶'],
    satdish: '📡',
    satellite: '🛰',
    saw: '🪚',
    saxophone: '🎷',
    scales: '⚖',
    scarf: '🧣',
    school: '🏫',
    scissors: '✂',
    scooter: ['🛴', motor: '🛵'],
    scorpion: '🦂',
    screwdriver: '🪛',
    scroll: '📜',
    seal: '🦭',
    seat: '💺',
    seedling: '🌱',
    shark: '🦈',
    sheep: '🐑',
    shell: [spiral: '🐚'],
    shield: '🛡',
    ship: ['🚢', cruise: '🛳', ferry: '⛴'],
    shirt: [sports: '🎽', t: '👕'],
    shoe: [
        '👞',
        ballet: '🩰',
        flat: '🥿',
        heel: '👠',
        hike: '🥾',
        ice: '⛸',
        roller: '🛼',
        sandal.heel: '👡',
        ski: '🎿',
        sneaker: '👟',
        tall: '👢',
        thong: '🩴',
    ],
    shopping: '🛍',
    shorts: '🩳',
    shoshinsha: '🔰',
    shower: '🚿',
    shrimp: ['🦐', fried: '🍤'],
    shrine: '⛩',
    sign: [crossing: '🚸', stop: '🛑'],
    silhouette: [
        '👤',
        double: '👥',
        hug: '🫂',
        speak: '🗣',
    ],
    siren: '🚨',
    skateboard: '🛹',
    skewer: [dango: '🍡', oden: '🍢'],
    skiing: '⛷',
    skull: ['💀', bones: '☠'],
    skunk: '🦨',
    sled: '🛷',
    slide: '🛝',
    slider: '🎚',
    sloth: '🦥',
    slots: '🎰',
    snail: '🐌',
    snake: '🐍',
    snowboarding: '🏂',
    snowflake: '❄',
    snowman: ['⛄', snow: '☃'],
    soap: '🧼',
    socks: '🧦',
    softball: '🥎',
    sos: '🆘',
    soup: '🍲',
    spaghetti: '🍝',
    sparkle: [box: '❇'],
    sparkler: '🎇',
    sparkles: '✨',
    speaker: [
        '🔈',
        not: '🔇',
        wave: '🔉',
        waves: '🔊',
    ],
    spider: '🕷',
    spiderweb: '🕸',
    spinach: '🥬',
    sponge: '🧽',
    spoon: '🥄',
    square: [
        black: '⬛',
        black.tiny: '▪',
        black.small: '◾',
        black.medium: '◼',
        white: '⬜',
        white.tiny: '▫',
        white.small: '◽',
        white.medium: '◻',
        blue: '🟦',
        brown: '🟫',
        green: '🟩',
        orange: '🟧',
        purple: '🟪',
        red: '🟥',
        yellow: '🟨',
    ],
    squid: '🦑',
    stadium: '🏟',
    star: [
        '⭐',
        arc: '💫',
        box: '✴',
        glow: '🌟',
        shoot: '🌠',
    ],
    stethoscope: '🩺',
    store: [big: '🏬', small: '🏪'],
    strawberry: '🍓',
    suit: [
        club: '♣',
        diamond: '♦',
        heart: '♥',
        spade: '♠',
    ],
    sun: ['☀', cloud: '🌤', face: '🌞'],
    sunrise: '🌅',
    superhero: '🦸',
    supervillain: '🦹',
    surfing: '🏄',
    sushi: '🍣',
    swan: '🦢',
    swimming: '🏊',
    swimsuit: '🩱',
    swords: '⚔',
    symbols: '🔣',
    synagogue: '🕍',
    syringe: '💉',
    taco: '🌮',
    takeout: '🥡',
    tamale: '🫔',
    tanabata: '🎋',
    tangerine: '🍊',
    tap: ['🚰', not: '🚱'],
    taxi: ['🚕', front: '🚖'],
    teacup: '🍵',
    teapot: '🫖',
    teddy: '🧸',
    telescope: '🔭',
    temple: '🛕',
    ten: '🔟',
    tengu: '👺',
    tennis: '🎾',
    tent: '⛺',
    testtube: '🧪',
    thermometer: '🌡',
    thread: '🧵',
    thumb: [up: '👍', down: '👎'],
    ticket: [event: '🎟', travel: '🎫'],
    tiger: ['🐅', face: '🐯'],
    tm: '™',
    toilet: '🚽',
    toiletpaper: '🧻',
    tomato: '🍅',
    tombstone: '🪦',
    tongue: '👅',
    toolbox: '🧰',
    tooth: '🦷',
    toothbrush: '🪥',
    tornado: '🌪',
    tower: [tokyo: '🗼'],
    trackball: '🖲',
    tractor: '🚜',
    trafficlight: [v: '🚦', h: '🚥'],
    train: [
        '🚆',
        car: '🚃',
        light: '🚈',
        metro: '🚇',
        mono: '🚝',
        mountain: '🚞',
        speed: '🚄',
        speed.bullet: '🚅',
        steam: '🚂',
        stop: '🚉',
        suspend: '🚟',
        tram: '🚊',
        tram.car: '🚋',
    ],
    transgender: '⚧',
    tray: [inbox: '📥', mail: '📨', outbox: '📤'],
    tree: [
        deciduous: '🌳',
        evergreen: '🌲',
        palm: '🌴',
        xmas: '🎄',
    ],
    triangle: [
        r: '▶',
        l: '◀',
        t: '🔼',
        b: '🔽',
        t.red: '🔺',
        b.red: '🔻',
    ],
    trident: '🔱',
    troll: '🧌',
    trophy: '🏆',
    truck: ['🚚', trailer: '🚛'],
    trumpet: '🎺',
    tsukimi: '🎑',
    turkey: '🦃',
    turtle: '🐢',
    tv: '📺',
    ufo: '🛸',
    umbrella: [
        open: '☂',
        closed: '🌂',
        rain: '☔',
        sun: '⛱',
    ],
    unicorn: '🦄',
    unknown: '🦳',
    up: '🆙',
    urn: '⚱',
    vampire: '🧛',
    violin: '🎻',
    volcano: '🌋',
    volleyball: '🏐',
    vs: '🆚',
    waffle: '🧇',
    wand: '🪄',
    warning: '⚠',
    watch: ['⌚', stop: '⏱'],
    watermelon: '🍉',
    waterpolo: '🤽',
    wave: '🌊',
    wc: '🚾',
    weightlifting: '🏋',
    whale: ['🐋', spout: '🐳'],
    wheel: '🛞',
    wheelchair: ['🦽', box: '♿', motor: '🦼'],
    wind: '🌬',
    windchime: '🎐',
    window: '🪟',
    wine: '🍷',
    wolf: '🐺',
    woman: [
        '👩',
        box: '🚺',
        crown: '👸',
        old: '👵',
        pregnant: '🤰',
    ],
    wood: '🪵',
    worm: '🪱',
    wrench: '🔧',
    wrestling: '🤼',
    xray: '🩻',
    yarn: '🧶',
    yoyo: '🪀',
    zebra: '🦓',
    zodiac: [
        aquarius: '♒',
        aries: '♈',
        cancer: '♋',
        capri: '♑',
        gemini: '♊',
        leo: '♌',
        libra: '♎',
        ophi: '⛎',
        pisces: '♓',
        sagit: '♐',
        scorpio: '♏',
        taurus: '♉',
        virgo: '♍',
    ],
    zombie: '🧟',
    zzz: '💤',
};
