# lsof

> 列出打开的文件和相应的进程。
> 注意：列出其他人打开的文件需要 root 权限（或 sudo）。
> 更多信息：<https://manned.org/lsof>。

- 查找打开了给定文件的进程：

`lsof {{路径/到/文件}}`

- 查找打开了本地互联网端口的进程：

`lsof -i :{{端口}}`

- 仅输出进程 ID (PID)：

`lsof -t {{路径/到/文件}}`

- 列出给定用户打开的文件：

`lsof -u {{用户名}}`

- 列出给定命令或进程打开的文件：

`lsof -c {{进程或命令的名称}}`

- 列出特定进程打开的文件（给定其 PID）：

`lsof -p {{PID}}`

- 列出目录中打开的文件：

`lsof +D {{路径/到/目录}}`

- 查找正在监听本地 IPv6 TCP 端口的进程，不转换网络或端口号：

`lsof -i6TCP:{{端口}} -sTCP:LISTEN -n -P`
