// Copyright 2022 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is automatically generated by `tools/dev/gen-static-roots.py`. Do
// not edit manually.

#ifndef V8_ROOTS_STATIC_ROOTS_INTL_NOWASM_H_
#define V8_ROOTS_STATIC_ROOTS_INTL_NOWASM_H_

#include "src/common/globals.h"

#if V8_STATIC_ROOTS_BOOL

#include "src/roots/roots.h"

namespace v8 {
namespace internal {

struct StaticReadOnlyRoot {
  static constexpr Tagged_t kUndefinedValue = 0x11;
  static constexpr Tagged_t kNullValue = 0x2d;
  static constexpr Tagged_t kempty_string = 0x49;
  static constexpr Tagged_t kFalseValue = 0x55;
  static constexpr Tagged_t kTrueValue = 0x71;
  static constexpr Tagged_t kSharedSeqTwoByteStringMap = 0x8d;
  static constexpr Tagged_t kSharedSeqOneByteStringMap = 0xb5;
  static constexpr Tagged_t kSeqTwoByteStringMap = 0xdd;
  static constexpr Tagged_t kSeqOneByteStringMap = 0x105;
  static constexpr Tagged_t kInternalizedTwoByteStringMap = 0x12d;
  static constexpr Tagged_t kInternalizedOneByteStringMap = 0x155;
  static constexpr Tagged_t kExternalInternalizedTwoByteStringMap = 0x17d;
  static constexpr Tagged_t kExternalInternalizedOneByteStringMap = 0x1a5;
  static constexpr Tagged_t kUncachedExternalInternalizedTwoByteStringMap =
      0x1cd;
  static constexpr Tagged_t kUncachedExternalInternalizedOneByteStringMap =
      0x1f5;
  static constexpr Tagged_t kUncachedExternalTwoByteStringMap = 0x21d;
  static constexpr Tagged_t kUncachedExternalOneByteStringMap = 0x245;
  static constexpr Tagged_t kSharedUncachedExternalTwoByteStringMap = 0x26d;
  static constexpr Tagged_t kSharedUncachedExternalOneByteStringMap = 0x295;
  static constexpr Tagged_t kSharedExternalTwoByteStringMap = 0x2bd;
  static constexpr Tagged_t kSharedExternalOneByteStringMap = 0x2e5;
  static constexpr Tagged_t kExternalTwoByteStringMap = 0x30d;
  static constexpr Tagged_t kExternalOneByteStringMap = 0x335;
  static constexpr Tagged_t kConsTwoByteStringMap = 0x35d;
  static constexpr Tagged_t kConsOneByteStringMap = 0x385;
  static constexpr Tagged_t kSlicedTwoByteStringMap = 0x3ad;
  static constexpr Tagged_t kSlicedOneByteStringMap = 0x3d5;
  static constexpr Tagged_t kThinTwoByteStringMap = 0x3fd;
  static constexpr Tagged_t kThinOneByteStringMap = 0x425;
  static constexpr Tagged_t kSymbolMap = 0x44d;
  static constexpr Tagged_t kMetaMap = 0x475;
  static constexpr Tagged_t kUndefinedMap = 0x49d;
  static constexpr Tagged_t kNullMap = 0x4c5;
  static constexpr Tagged_t kBooleanMap = 0x4ed;
  static constexpr Tagged_t kHeapNumberMap = 0x515;
  static constexpr Tagged_t kBigIntMap = 0x53d;
  static constexpr Tagged_t kFreeSpaceMap = 0x565;
  static constexpr Tagged_t kOnePointerFillerMap = 0x58d;
  static constexpr Tagged_t kTwoPointerFillerMap = 0x5b5;
  static constexpr Tagged_t kFixedArrayMap = 0x5dd;
  static constexpr Tagged_t kTrustedFixedArrayMap = 0x605;
  static constexpr Tagged_t kProtectedFixedArrayMap = 0x62d;
  static constexpr Tagged_t kWeakFixedArrayMap = 0x655;
  static constexpr Tagged_t kTrustedWeakFixedArrayMap = 0x67d;
  static constexpr Tagged_t kProtectedWeakFixedArrayMap = 0x6a5;
  static constexpr Tagged_t kWeakArrayListMap = 0x6cd;
  static constexpr Tagged_t kFixedCOWArrayMap = 0x6f5;
  static constexpr Tagged_t kDescriptorArrayMap = 0x71d;
  static constexpr Tagged_t kHoleMap = 0x745;
  static constexpr Tagged_t kCallSiteInfoMap = 0x76d;
  static constexpr Tagged_t kEnumCacheMap = 0x795;
  static constexpr Tagged_t kEmptyFixedArray = 0x7bd;
  static constexpr Tagged_t kEmptyWeakFixedArray = 0x7c5;
  static constexpr Tagged_t kEmptyWeakArrayList = 0x7cd;
  static constexpr Tagged_t kTheHoleValue = 0x7d9;
  static constexpr Tagged_t kEmptyEnumCache = 0x7e5;
  static constexpr Tagged_t kEmptyDescriptorArray = 0x7f1;
  static constexpr Tagged_t kScopeInfoMap = 0x805;
  static constexpr Tagged_t kModuleInfoMap = 0x82d;
  static constexpr Tagged_t kClosureFeedbackCellArrayMap = 0x855;
  static constexpr Tagged_t kFeedbackVectorMap = 0x87d;
  static constexpr Tagged_t kForeignMap = 0x8a5;
  static constexpr Tagged_t kTrustedForeignMap = 0x8cd;
  static constexpr Tagged_t kMegaDomHandlerMap = 0x8f5;
  static constexpr Tagged_t kFixedDoubleArrayMap = 0x91d;
  static constexpr Tagged_t kFeedbackMetadataArrayMap = 0x945;
  static constexpr Tagged_t kByteArrayMap = 0x96d;
  static constexpr Tagged_t kTrustedByteArrayMap = 0x995;
  static constexpr Tagged_t kBytecodeArrayMap = 0x9bd;
  static constexpr Tagged_t kPropertyArrayMap = 0x9e5;
  static constexpr Tagged_t kSmallOrderedHashMapMap = 0xa0d;
  static constexpr Tagged_t kSmallOrderedHashSetMap = 0xa35;
  static constexpr Tagged_t kSmallOrderedNameDictionaryMap = 0xa5d;
  static constexpr Tagged_t kInstructionStreamMap = 0xa85;
  static constexpr Tagged_t kCellMap = 0xaad;
  static constexpr Tagged_t kInvalidPrototypeValidityCell = 0xad5;
  static constexpr Tagged_t kGlobalPropertyCellMap = 0xadd;
  static constexpr Tagged_t kNoClosuresCellMap = 0xb05;
  static constexpr Tagged_t kOneClosureCellMap = 0xb2d;
  static constexpr Tagged_t kManyClosuresCellMap = 0xb55;
  static constexpr Tagged_t kTransitionArrayMap = 0xb7d;
  static constexpr Tagged_t kHashTableMap = 0xba5;
  static constexpr Tagged_t kOrderedNameDictionaryMap = 0xbcd;
  static constexpr Tagged_t kNameDictionaryMap = 0xbf5;
  static constexpr Tagged_t kSwissNameDictionaryMap = 0xc1d;
  static constexpr Tagged_t kGlobalDictionaryMap = 0xc45;
  static constexpr Tagged_t kNumberDictionaryMap = 0xc6d;
  static constexpr Tagged_t kRegisteredSymbolTableMap = 0xc95;
  static constexpr Tagged_t kArrayListMap = 0xcbd;
  static constexpr Tagged_t kAccessorInfoMap = 0xce5;
  static constexpr Tagged_t kInterceptorInfoMap = 0xd0d;
  static constexpr Tagged_t kPreparseDataMap = 0xd35;
  static constexpr Tagged_t kSharedFunctionInfoMap = 0xd5d;
  static constexpr Tagged_t kCodeMap = 0xd85;
  static constexpr Tagged_t kHashSeed = 0xdad;
  static constexpr Tagged_t kprototype_string = 0xdbd;
  static constexpr Tagged_t kname_string = 0xdd5;
  static constexpr Tagged_t klength_string = 0xde5;
  static constexpr Tagged_t kenumerable_string = 0xdf9;
  static constexpr Tagged_t kconfigurable_string = 0xe11;
  static constexpr Tagged_t kvalue_string = 0xe29;
  static constexpr Tagged_t kwritable_string = 0xe3d;
  static constexpr Tagged_t knot_mapped_symbol = 0xe51;
  static constexpr Tagged_t kuninitialized_symbol = 0xe61;
  static constexpr Tagged_t kmegamorphic_symbol = 0xe71;
  static constexpr Tagged_t kelements_transition_symbol = 0xe81;
  static constexpr Tagged_t kmega_dom_symbol = 0xe91;
  static constexpr Tagged_t kEmptyPropertyDictionary = 0xea1;
  static constexpr Tagged_t kEmptyOrderedPropertyDictionary = 0xecd;
  static constexpr Tagged_t kEmptyByteArray = 0xee5;
  static constexpr Tagged_t kEmptyScopeInfo = 0xeed;
  static constexpr Tagged_t kEmptyPropertyArray = 0xf05;
  static constexpr Tagged_t kMinusZeroValue = 0xf0d;
  static constexpr Tagged_t kNanValue = 0xf19;
  static constexpr Tagged_t kUndefinedNanValue = 0xf25;
  static constexpr Tagged_t kHoleNanValue = 0xf31;
  static constexpr Tagged_t kInfinityValue = 0xf3d;
  static constexpr Tagged_t kMinusInfinityValue = 0xf49;
  static constexpr Tagged_t kMaxSafeInteger = 0xf55;
  static constexpr Tagged_t kMaxUInt32 = 0xf61;
  static constexpr Tagged_t kSmiMinValue = 0xf6d;
  static constexpr Tagged_t kSmiMaxValuePlusOne = 0xf79;
  static constexpr Tagged_t kPromiseFulfillReactionJobTaskMap = 0xf85;
  static constexpr Tagged_t kPromiseRejectReactionJobTaskMap = 0xfad;
  static constexpr Tagged_t kCallableTaskMap = 0xfd5;
  static constexpr Tagged_t kCallbackTaskMap = 0xffd;
  static constexpr Tagged_t kPromiseResolveThenableJobTaskMap = 0x1025;
  static constexpr Tagged_t kAccessCheckInfoMap = 0x104d;
  static constexpr Tagged_t kAccessorPairMap = 0x1075;
  static constexpr Tagged_t kAliasedArgumentsEntryMap = 0x109d;
  static constexpr Tagged_t kAllocationMementoMap = 0x10c5;
  static constexpr Tagged_t kArrayBoilerplateDescriptionMap = 0x10ed;
  static constexpr Tagged_t kAsyncGeneratorRequestMap = 0x1115;
  static constexpr Tagged_t kBreakPointMap = 0x113d;
  static constexpr Tagged_t kBreakPointInfoMap = 0x1165;
  static constexpr Tagged_t kBytecodeWrapperMap = 0x118d;
  static constexpr Tagged_t kClassBoilerplateMap = 0x11b5;
  static constexpr Tagged_t kClassPositionsMap = 0x11dd;
  static constexpr Tagged_t kCodeWrapperMap = 0x1205;
  static constexpr Tagged_t kDebugInfoMap = 0x122d;
  static constexpr Tagged_t kErrorStackDataMap = 0x1255;
  static constexpr Tagged_t kFunctionTemplateRareDataMap = 0x127d;
  static constexpr Tagged_t kModuleRequestMap = 0x12a5;
  static constexpr Tagged_t kPromiseCapabilityMap = 0x12cd;
  static constexpr Tagged_t kPromiseReactionMap = 0x12f5;
  static constexpr Tagged_t kPropertyDescriptorObjectMap = 0x131d;
  static constexpr Tagged_t kPrototypeInfoMap = 0x1345;
  static constexpr Tagged_t kRegExpBoilerplateDescriptionMap = 0x136d;
  static constexpr Tagged_t kRegExpDataWrapperMap = 0x1395;
  static constexpr Tagged_t kScriptMap = 0x13bd;
  static constexpr Tagged_t kScriptOrModuleMap = 0x13e5;
  static constexpr Tagged_t kSourceTextModuleInfoEntryMap = 0x140d;
  static constexpr Tagged_t kStackFrameInfoMap = 0x1435;
  static constexpr Tagged_t kStackTraceInfoMap = 0x145d;
  static constexpr Tagged_t kTemplateObjectDescriptionMap = 0x1485;
  static constexpr Tagged_t kTuple2Map = 0x14ad;
  static constexpr Tagged_t kAllocationSiteWithWeakNextMap = 0x14d5;
  static constexpr Tagged_t kAllocationSiteWithoutWeakNextMap = 0x14fd;
  static constexpr Tagged_t kLoadHandler1Map = 0x1525;
  static constexpr Tagged_t kLoadHandler2Map = 0x154d;
  static constexpr Tagged_t kLoadHandler3Map = 0x1575;
  static constexpr Tagged_t kStoreHandler0Map = 0x159d;
  static constexpr Tagged_t kStoreHandler1Map = 0x15c5;
  static constexpr Tagged_t kStoreHandler2Map = 0x15ed;
  static constexpr Tagged_t kStoreHandler3Map = 0x1615;
  static constexpr Tagged_t kFunctionTemplateInfoMap = 0x163d;
  static constexpr Tagged_t kOnHeapBasicBlockProfilerDataMap = 0x1665;
  static constexpr Tagged_t kObjectTemplateInfoMap = 0x168d;
  static constexpr Tagged_t kTurbofanBitsetTypeMap = 0x16b5;
  static constexpr Tagged_t kTurbofanUnionTypeMap = 0x16dd;
  static constexpr Tagged_t kTurbofanRangeTypeMap = 0x1705;
  static constexpr Tagged_t kTurbofanHeapConstantTypeMap = 0x172d;
  static constexpr Tagged_t kTurbofanOtherNumberConstantTypeMap = 0x1755;
  static constexpr Tagged_t kTurboshaftWord32TypeMap = 0x177d;
  static constexpr Tagged_t kTurboshaftWord32RangeTypeMap = 0x17a5;
  static constexpr Tagged_t kTurboshaftWord64TypeMap = 0x17cd;
  static constexpr Tagged_t kTurboshaftWord64RangeTypeMap = 0x17f5;
  static constexpr Tagged_t kTurboshaftFloat64TypeMap = 0x181d;
  static constexpr Tagged_t kTurboshaftFloat64RangeTypeMap = 0x1845;
  static constexpr Tagged_t kInternalClassMap = 0x186d;
  static constexpr Tagged_t kSmiPairMap = 0x1895;
  static constexpr Tagged_t kSmiBoxMap = 0x18bd;
  static constexpr Tagged_t kExportedSubClassBaseMap = 0x18e5;
  static constexpr Tagged_t kExportedSubClassMap = 0x190d;
  static constexpr Tagged_t kAbstractInternalClassSubclass1Map = 0x1935;
  static constexpr Tagged_t kAbstractInternalClassSubclass2Map = 0x195d;
  static constexpr Tagged_t kExportedSubClass2Map = 0x1985;
  static constexpr Tagged_t kSortStateMap = 0x19ad;
  static constexpr Tagged_t kSloppyArgumentsElementsMap = 0x19d5;
  static constexpr Tagged_t kStrongDescriptorArrayMap = 0x19fd;
  static constexpr Tagged_t kTurboshaftWord32SetTypeMap = 0x1a25;
  static constexpr Tagged_t kTurboshaftWord64SetTypeMap = 0x1a4d;
  static constexpr Tagged_t kTurboshaftFloat64SetTypeMap = 0x1a75;
  static constexpr Tagged_t kInternalClassWithStructElementsMap = 0x1a9d;
  static constexpr Tagged_t kOrderedHashMapMap = 0x1ac5;
  static constexpr Tagged_t kOrderedHashSetMap = 0x1aed;
  static constexpr Tagged_t kSimpleNumberDictionaryMap = 0x1b15;
  static constexpr Tagged_t kSimpleNameDictionaryMap = 0x1b3d;
  static constexpr Tagged_t kNameToIndexHashTableMap = 0x1b65;
  static constexpr Tagged_t kDoubleStringCacheMap = 0x1b8d;
  static constexpr Tagged_t kEmbedderDataArrayMap = 0x1bb5;
  static constexpr Tagged_t kEphemeronHashTableMap = 0x1bdd;
  static constexpr Tagged_t kScriptContextTableMap = 0x1c05;
  static constexpr Tagged_t kObjectBoilerplateDescriptionMap = 0x1c2d;
  static constexpr Tagged_t kCoverageInfoMap = 0x1c55;
  static constexpr Tagged_t kRegExpMatchInfoMap = 0x1c7d;
  static constexpr Tagged_t kRegExpDataMap = 0x1ca5;
  static constexpr Tagged_t kAtomRegExpDataMap = 0x1ccd;
  static constexpr Tagged_t kIrRegExpDataMap = 0x1cf5;
  static constexpr Tagged_t kSourceTextModuleMap = 0x1d1d;
  static constexpr Tagged_t kSyntheticModuleMap = 0x1d45;
  static constexpr Tagged_t kContextCellMap = 0x1d6d;
  static constexpr Tagged_t kWeakCellMap = 0x1d95;
  static constexpr Tagged_t kInterpreterDataMap = 0x1dbd;
  static constexpr Tagged_t kUncompiledDataWithoutPreparseDataMap = 0x1de5;
  static constexpr Tagged_t kUncompiledDataWithPreparseDataMap = 0x1e0d;
  static constexpr Tagged_t kUncompiledDataWithoutPreparseDataWithJobMap =
      0x1e35;
  static constexpr Tagged_t kUncompiledDataWithPreparseDataAndJobMap = 0x1e5d;
  static constexpr Tagged_t kSharedFunctionInfoWrapperMap = 0x1e85;
  static constexpr Tagged_t kDictionaryTemplateInfoMap = 0x1ead;
  static constexpr Tagged_t kEmptyArrayList = 0x1ed5;
  static constexpr Tagged_t kEmptyObjectBoilerplateDescription = 0x1ee1;
  static constexpr Tagged_t kEmptyArrayBoilerplateDescription = 0x1ef1;
  static constexpr Tagged_t kEmptyClosureFeedbackCellArray = 0x1efd;
  static constexpr Tagged_t kEmptySwissPropertyDictionary = 0x1f11;
  static constexpr Tagged_t kadoptText_string = 0x1f31;
  static constexpr Tagged_t kapproximatelySign_string = 0x1f49;
  static constexpr Tagged_t kbaseName_string = 0x1f69;
  static constexpr Tagged_t kaccounting_string = 0x1f7d;
  static constexpr Tagged_t kbreakType_string = 0x1f95;
  static constexpr Tagged_t kcalendars_string = 0x1fad;
  static constexpr Tagged_t kcardinal_string = 0x1fc5;
  static constexpr Tagged_t kcaseFirst_string = 0x1fd9;
  static constexpr Tagged_t kceil_string = 0x1ff1;
  static constexpr Tagged_t kcompare_string = 0x2001;
  static constexpr Tagged_t kcollation_string = 0x2015;
  static constexpr Tagged_t kcollations_string = 0x202d;
  static constexpr Tagged_t kcompact_string = 0x2045;
  static constexpr Tagged_t kcompactDisplay_string = 0x2059;
  static constexpr Tagged_t kcurrency_string = 0x2075;
  static constexpr Tagged_t kcurrencyDisplay_string = 0x2089;
  static constexpr Tagged_t kcurrencySign_string = 0x20a5;
  static constexpr Tagged_t kdateStyle_string = 0x20bd;
  static constexpr Tagged_t kdateTimeField_string = 0x20d5;
  static constexpr Tagged_t kdayPeriod_string = 0x20f1;
  static constexpr Tagged_t kdaysDisplay_string = 0x2109;
  static constexpr Tagged_t kdecimal_string = 0x2121;
  static constexpr Tagged_t kdialect_string = 0x2135;
  static constexpr Tagged_t kdigital_string = 0x2149;
  static constexpr Tagged_t kendRange_string = 0x215d;
  static constexpr Tagged_t kengineering_string = 0x2171;
  static constexpr Tagged_t kexceptZero_string = 0x2189;
  static constexpr Tagged_t kexpand_string = 0x21a1;
  static constexpr Tagged_t kexponentInteger_string = 0x21b5;
  static constexpr Tagged_t kexponentMinusSign_string = 0x21d1;
  static constexpr Tagged_t kexponentSeparator_string = 0x21f1;
  static constexpr Tagged_t kfallback_string = 0x2211;
  static constexpr Tagged_t kfirst_string = 0x2225;
  static constexpr Tagged_t kfirstDay_string = 0x2239;
  static constexpr Tagged_t kfirstDayOfWeek_string = 0x224d;
  static constexpr Tagged_t kfloor_string = 0x2269;
  static constexpr Tagged_t kformat_string = 0x227d;
  static constexpr Tagged_t kformatMatcher_string = 0x2291;
  static constexpr Tagged_t kfraction_string = 0x22ad;
  static constexpr Tagged_t kfractionalDigits_string = 0x22c1;
  static constexpr Tagged_t kfractionalSecond_string = 0x22dd;
  static constexpr Tagged_t kfull_string = 0x22f9;
  static constexpr Tagged_t kgranularity_string = 0x2309;
  static constexpr Tagged_t kgrapheme_string = 0x2321;
  static constexpr Tagged_t kgroup_string = 0x2335;
  static constexpr Tagged_t kh11_string = 0x2349;
  static constexpr Tagged_t kh12_string = 0x2359;
  static constexpr Tagged_t kh23_string = 0x2369;
  static constexpr Tagged_t kh24_string = 0x2379;
  static constexpr Tagged_t khalfCeil_string = 0x2389;
  static constexpr Tagged_t khalfEven_string = 0x239d;
  static constexpr Tagged_t khalfExpand_string = 0x23b1;
  static constexpr Tagged_t khalfFloor_string = 0x23c9;
  static constexpr Tagged_t khalfTrunc_string = 0x23e1;
  static constexpr Tagged_t khour12_string = 0x23f9;
  static constexpr Tagged_t khourCycle_string = 0x240d;
  static constexpr Tagged_t khourCycles_string = 0x2425;
  static constexpr Tagged_t khoursDisplay_string = 0x243d;
  static constexpr Tagged_t kideo_string = 0x2455;
  static constexpr Tagged_t kignorePunctuation_string = 0x2465;
  static constexpr Tagged_t kInvalid_Date_string = 0x2485;
  static constexpr Tagged_t kinteger_string = 0x249d;
  static constexpr Tagged_t kisWordLike_string = 0x24b1;
  static constexpr Tagged_t kkana_string = 0x24c9;
  static constexpr Tagged_t klanguage_string = 0x24d9;
  static constexpr Tagged_t klanguageDisplay_string = 0x24ed;
  static constexpr Tagged_t klessPrecision_string = 0x2509;
  static constexpr Tagged_t kletter_string = 0x2525;
  static constexpr Tagged_t klist_string = 0x2539;
  static constexpr Tagged_t kliteral_string = 0x2549;
  static constexpr Tagged_t klocale_string = 0x255d;
  static constexpr Tagged_t klocaleMatcher_string = 0x2571;
  static constexpr Tagged_t kloose_string = 0x258d;
  static constexpr Tagged_t klower_string = 0x25a1;
  static constexpr Tagged_t kltr_string = 0x25b5;
  static constexpr Tagged_t kmaximumFractionDigits_string = 0x25c5;
  static constexpr Tagged_t kmaximumSignificantDigits_string = 0x25e9;
  static constexpr Tagged_t kmicrosecondsDisplay_string = 0x260d;
  static constexpr Tagged_t kmillisecondsDisplay_string = 0x262d;
  static constexpr Tagged_t kmin2_string = 0x264d;
  static constexpr Tagged_t kminimalDays_string = 0x265d;
  static constexpr Tagged_t kminimumFractionDigits_string = 0x2675;
  static constexpr Tagged_t kminimumIntegerDigits_string = 0x2699;
  static constexpr Tagged_t kminimumSignificantDigits_string = 0x26b9;
  static constexpr Tagged_t kminus_0 = 0x26dd;
  static constexpr Tagged_t kminusSign_string = 0x26ed;
  static constexpr Tagged_t kminutesDisplay_string = 0x2705;
  static constexpr Tagged_t kmonthsDisplay_string = 0x2721;
  static constexpr Tagged_t kmorePrecision_string = 0x273d;
  static constexpr Tagged_t knan_string = 0x2759;
  static constexpr Tagged_t knanosecondsDisplay_string = 0x2769;
  static constexpr Tagged_t knarrowSymbol_string = 0x2789;
  static constexpr Tagged_t knegative_string = 0x27a1;
  static constexpr Tagged_t knever_string = 0x27b5;
  static constexpr Tagged_t knone_string = 0x27c9;
  static constexpr Tagged_t knotation_string = 0x27d9;
  static constexpr Tagged_t knormal_string = 0x27ed;
  static constexpr Tagged_t knumberingSystem_string = 0x2801;
  static constexpr Tagged_t knumberingSystems_string = 0x281d;
  static constexpr Tagged_t knumeric_string = 0x2839;
  static constexpr Tagged_t kordinal_string = 0x284d;
  static constexpr Tagged_t kpercentSign_string = 0x2861;
  static constexpr Tagged_t kplusSign_string = 0x2879;
  static constexpr Tagged_t kquarter_string = 0x288d;
  static constexpr Tagged_t kregion_string = 0x28a1;
  static constexpr Tagged_t krelatedYear_string = 0x28b5;
  static constexpr Tagged_t kroundingPriority_string = 0x28cd;
  static constexpr Tagged_t krtl_string = 0x28e9;
  static constexpr Tagged_t kscientific_string = 0x28f9;
  static constexpr Tagged_t ksecondsDisplay_string = 0x2911;
  static constexpr Tagged_t ksegment_string = 0x292d;
  static constexpr Tagged_t kSegmentIterator_string = 0x2941;
  static constexpr Tagged_t kSegments_string = 0x295d;
  static constexpr Tagged_t ksensitivity_string = 0x2971;
  static constexpr Tagged_t ksep_string = 0x2989;
  static constexpr Tagged_t kshared_string = 0x2999;
  static constexpr Tagged_t ksignDisplay_string = 0x29ad;
  static constexpr Tagged_t kstandard_string = 0x29c5;
  static constexpr Tagged_t kstartRange_string = 0x29d9;
  static constexpr Tagged_t kstrict_string = 0x29f1;
  static constexpr Tagged_t kstripIfInteger_string = 0x2a05;
  static constexpr Tagged_t kstyle_string = 0x2a21;
  static constexpr Tagged_t kterm_string = 0x2a35;
  static constexpr Tagged_t ktextInfo_string = 0x2a45;
  static constexpr Tagged_t ktimeStyle_string = 0x2a59;
  static constexpr Tagged_t ktimeZones_string = 0x2a71;
  static constexpr Tagged_t ktimeZoneName_string = 0x2a89;
  static constexpr Tagged_t ktrailingZeroDisplay_string = 0x2aa1;
  static constexpr Tagged_t ktrunc_string = 0x2ac1;
  static constexpr Tagged_t ktwo_digit_string = 0x2ad5;
  static constexpr Tagged_t ktype_string = 0x2ae9;
  static constexpr Tagged_t kunknown_string = 0x2af9;
  static constexpr Tagged_t kupper_string = 0x2b0d;
  static constexpr Tagged_t kusage_string = 0x2b21;
  static constexpr Tagged_t kuseGrouping_string = 0x2b35;
  static constexpr Tagged_t kunitDisplay_string = 0x2b4d;
  static constexpr Tagged_t kweekday_string = 0x2b65;
  static constexpr Tagged_t kweekend_string = 0x2b79;
  static constexpr Tagged_t kweeksDisplay_string = 0x2b8d;
  static constexpr Tagged_t kweekInfo_string = 0x2ba5;
  static constexpr Tagged_t kyearName_string = 0x2bb9;
  static constexpr Tagged_t kyearsDisplay_string = 0x2bcd;
  static constexpr Tagged_t kascii_nul_string = 0x2be5;
  static constexpr Tagged_t kascii_soh_string = 0x2bf5;
  static constexpr Tagged_t kascii_stx_string = 0x2c05;
  static constexpr Tagged_t kascii_etx_string = 0x2c15;
  static constexpr Tagged_t kascii_eot_string = 0x2c25;
  static constexpr Tagged_t kascii_enq_string = 0x2c35;
  static constexpr Tagged_t kascii_ack_string = 0x2c45;
  static constexpr Tagged_t kascii_bel_string = 0x2c55;
  static constexpr Tagged_t kascii_bs_string = 0x2c65;
  static constexpr Tagged_t kascii_ht_string = 0x2c75;
  static constexpr Tagged_t kascii_lf_string = 0x2c85;
  static constexpr Tagged_t kascii_vt_string = 0x2c95;
  static constexpr Tagged_t kascii_ff_string = 0x2ca5;
  static constexpr Tagged_t kascii_cr_string = 0x2cb5;
  static constexpr Tagged_t kascii_so_string = 0x2cc5;
  static constexpr Tagged_t kascii_si_string = 0x2cd5;
  static constexpr Tagged_t kascii_dle_string = 0x2ce5;
  static constexpr Tagged_t kascii_dc1_string = 0x2cf5;
  static constexpr Tagged_t kascii_dc2_string = 0x2d05;
  static constexpr Tagged_t kascii_dc3_string = 0x2d15;
  static constexpr Tagged_t kascii_dc4_string = 0x2d25;
  static constexpr Tagged_t kascii_nak_string = 0x2d35;
  static constexpr Tagged_t kascii_syn_string = 0x2d45;
  static constexpr Tagged_t kascii_etb_string = 0x2d55;
  static constexpr Tagged_t kascii_can_string = 0x2d65;
  static constexpr Tagged_t kascii_em_string = 0x2d75;
  static constexpr Tagged_t kascii_sub_string = 0x2d85;
  static constexpr Tagged_t kascii_esc_string = 0x2d95;
  static constexpr Tagged_t kascii_fs_string = 0x2da5;
  static constexpr Tagged_t kascii_gs_string = 0x2db5;
  static constexpr Tagged_t kascii_rs_string = 0x2dc5;
  static constexpr Tagged_t kascii_us_string = 0x2dd5;
  static constexpr Tagged_t kspace_string = 0x2de5;
  static constexpr Tagged_t kexclamation_mark_string = 0x2df5;
  static constexpr Tagged_t kdouble_quotes_string = 0x2e05;
  static constexpr Tagged_t khash_string = 0x2e15;
  static constexpr Tagged_t kdollar_string = 0x2e25;
  static constexpr Tagged_t kpercent_sign_string = 0x2e35;
  static constexpr Tagged_t kampersand_string = 0x2e45;
  static constexpr Tagged_t ksingle_quote_string = 0x2e55;
  static constexpr Tagged_t kopen_parenthesis_string = 0x2e65;
  static constexpr Tagged_t kclose_parenthesis_string = 0x2e75;
  static constexpr Tagged_t kasterisk_string = 0x2e85;
  static constexpr Tagged_t kplus_string = 0x2e95;
  static constexpr Tagged_t kcomma_string = 0x2ea5;
  static constexpr Tagged_t kminus_string = 0x2eb5;
  static constexpr Tagged_t kdot_string = 0x2ec5;
  static constexpr Tagged_t kslash_string = 0x2ed5;
  static constexpr Tagged_t kzero_string = 0x2ee5;
  static constexpr Tagged_t kone_string = 0x2ef5;
  static constexpr Tagged_t ktwo_string = 0x2f05;
  static constexpr Tagged_t kthree_string = 0x2f15;
  static constexpr Tagged_t kfour_string = 0x2f25;
  static constexpr Tagged_t kfive_string = 0x2f35;
  static constexpr Tagged_t ksix_string = 0x2f45;
  static constexpr Tagged_t kseven_string = 0x2f55;
  static constexpr Tagged_t keight_string = 0x2f65;
  static constexpr Tagged_t knine_string = 0x2f75;
  static constexpr Tagged_t kcolon_string = 0x2f85;
  static constexpr Tagged_t ksemicolon_string = 0x2f95;
  static constexpr Tagged_t kless_than_string = 0x2fa5;
  static constexpr Tagged_t kequals_string = 0x2fb5;
  static constexpr Tagged_t kgreater_than_string = 0x2fc5;
  static constexpr Tagged_t kquestion_mark_string = 0x2fd5;
  static constexpr Tagged_t kat_sign_string = 0x2fe5;
  static constexpr Tagged_t kA_string = 0x2ff5;
  static constexpr Tagged_t kB_string = 0x3005;
  static constexpr Tagged_t kC_string = 0x3015;
  static constexpr Tagged_t kD_string = 0x3025;
  static constexpr Tagged_t kE_string = 0x3035;
  static constexpr Tagged_t kF_string = 0x3045;
  static constexpr Tagged_t kG_string = 0x3055;
  static constexpr Tagged_t kH_string = 0x3065;
  static constexpr Tagged_t kI_string = 0x3075;
  static constexpr Tagged_t kJ_string = 0x3085;
  static constexpr Tagged_t kK_string = 0x3095;
  static constexpr Tagged_t kL_string = 0x30a5;
  static constexpr Tagged_t kM_string = 0x30b5;
  static constexpr Tagged_t kN_string = 0x30c5;
  static constexpr Tagged_t kO_string = 0x30d5;
  static constexpr Tagged_t kP_string = 0x30e5;
  static constexpr Tagged_t kQ_string = 0x30f5;
  static constexpr Tagged_t kR_string = 0x3105;
  static constexpr Tagged_t kS_string = 0x3115;
  static constexpr Tagged_t kT_string = 0x3125;
  static constexpr Tagged_t kU_string = 0x3135;
  static constexpr Tagged_t kV_string = 0x3145;
  static constexpr Tagged_t kW_string = 0x3155;
  static constexpr Tagged_t kX_string = 0x3165;
  static constexpr Tagged_t kY_string = 0x3175;
  static constexpr Tagged_t kZ_string = 0x3185;
  static constexpr Tagged_t kopen_bracket_string = 0x3195;
  static constexpr Tagged_t kbackslash_string = 0x31a5;
  static constexpr Tagged_t kclose_bracket_string = 0x31b5;
  static constexpr Tagged_t kcaret_string = 0x31c5;
  static constexpr Tagged_t kunderscore_string = 0x31d5;
  static constexpr Tagged_t kbacktick_string = 0x31e5;
  static constexpr Tagged_t ka_string = 0x31f5;
  static constexpr Tagged_t kb_string = 0x3205;
  static constexpr Tagged_t kc_string = 0x3215;
  static constexpr Tagged_t kd_string = 0x3225;
  static constexpr Tagged_t ke_string = 0x3235;
  static constexpr Tagged_t kf_string = 0x3245;
  static constexpr Tagged_t kg_string = 0x3255;
  static constexpr Tagged_t kh_string = 0x3265;
  static constexpr Tagged_t ki_string = 0x3275;
  static constexpr Tagged_t kj_string = 0x3285;
  static constexpr Tagged_t kk_string = 0x3295;
  static constexpr Tagged_t kl_string = 0x32a5;
  static constexpr Tagged_t km_string = 0x32b5;
  static constexpr Tagged_t kn_string = 0x32c5;
  static constexpr Tagged_t ko_string = 0x32d5;
  static constexpr Tagged_t kp_string = 0x32e5;
  static constexpr Tagged_t kq_string = 0x32f5;
  static constexpr Tagged_t kr_string = 0x3305;
  static constexpr Tagged_t ks_string = 0x3315;
  static constexpr Tagged_t kt_string = 0x3325;
  static constexpr Tagged_t ku_string = 0x3335;
  static constexpr Tagged_t kv_string = 0x3345;
  static constexpr Tagged_t kw_string = 0x3355;
  static constexpr Tagged_t kx_string = 0x3365;
  static constexpr Tagged_t ky_string = 0x3375;
  static constexpr Tagged_t kz_string = 0x3385;
  static constexpr Tagged_t kopen_brace_string = 0x3395;
  static constexpr Tagged_t kpipe_string = 0x33a5;
  static constexpr Tagged_t kclose_brace_string = 0x33b5;
  static constexpr Tagged_t ktilde_string = 0x33c5;
  static constexpr Tagged_t kascii_del_string = 0x33d5;
  static constexpr Tagged_t klatin1_80_string = 0x33e5;
  static constexpr Tagged_t klatin1_81_string = 0x33f5;
  static constexpr Tagged_t klatin1_82_string = 0x3405;
  static constexpr Tagged_t klatin1_83_string = 0x3415;
  static constexpr Tagged_t klatin1_84_string = 0x3425;
  static constexpr Tagged_t klatin1_85_string = 0x3435;
  static constexpr Tagged_t klatin1_86_string = 0x3445;
  static constexpr Tagged_t klatin1_87_string = 0x3455;
  static constexpr Tagged_t klatin1_88_string = 0x3465;
  static constexpr Tagged_t klatin1_89_string = 0x3475;
  static constexpr Tagged_t klatin1_8a_string = 0x3485;
  static constexpr Tagged_t klatin1_8b_string = 0x3495;
  static constexpr Tagged_t klatin1_8c_string = 0x34a5;
  static constexpr Tagged_t klatin1_8d_string = 0x34b5;
  static constexpr Tagged_t klatin1_8e_string = 0x34c5;
  static constexpr Tagged_t klatin1_8f_string = 0x34d5;
  static constexpr Tagged_t klatin1_90_string = 0x34e5;
  static constexpr Tagged_t klatin1_91_string = 0x34f5;
  static constexpr Tagged_t klatin1_92_string = 0x3505;
  static constexpr Tagged_t klatin1_93_string = 0x3515;
  static constexpr Tagged_t klatin1_94_string = 0x3525;
  static constexpr Tagged_t klatin1_95_string = 0x3535;
  static constexpr Tagged_t klatin1_96_string = 0x3545;
  static constexpr Tagged_t klatin1_97_string = 0x3555;
  static constexpr Tagged_t klatin1_98_string = 0x3565;
  static constexpr Tagged_t klatin1_99_string = 0x3575;
  static constexpr Tagged_t klatin1_9a_string = 0x3585;
  static constexpr Tagged_t klatin1_9b_string = 0x3595;
  static constexpr Tagged_t klatin1_9c_string = 0x35a5;
  static constexpr Tagged_t klatin1_9d_string = 0x35b5;
  static constexpr Tagged_t klatin1_9e_string = 0x35c5;
  static constexpr Tagged_t klatin1_9f_string = 0x35d5;
  static constexpr Tagged_t klatin1_a0_string = 0x35e5;
  static constexpr Tagged_t klatin1_a1_string = 0x35f5;
  static constexpr Tagged_t klatin1_a2_string = 0x3605;
  static constexpr Tagged_t klatin1_a3_string = 0x3615;
  static constexpr Tagged_t klatin1_a4_string = 0x3625;
  static constexpr Tagged_t klatin1_a5_string = 0x3635;
  static constexpr Tagged_t klatin1_a6_string = 0x3645;
  static constexpr Tagged_t klatin1_a7_string = 0x3655;
  static constexpr Tagged_t klatin1_a8_string = 0x3665;
  static constexpr Tagged_t klatin1_a9_string = 0x3675;
  static constexpr Tagged_t klatin1_aa_string = 0x3685;
  static constexpr Tagged_t klatin1_ab_string = 0x3695;
  static constexpr Tagged_t klatin1_ac_string = 0x36a5;
  static constexpr Tagged_t klatin1_ad_string = 0x36b5;
  static constexpr Tagged_t klatin1_ae_string = 0x36c5;
  static constexpr Tagged_t klatin1_af_string = 0x36d5;
  static constexpr Tagged_t klatin1_b0_string = 0x36e5;
  static constexpr Tagged_t klatin1_b1_string = 0x36f5;
  static constexpr Tagged_t klatin1_b2_string = 0x3705;
  static constexpr Tagged_t klatin1_b3_string = 0x3715;
  static constexpr Tagged_t klatin1_b4_string = 0x3725;
  static constexpr Tagged_t klatin1_b5_string = 0x3735;
  static constexpr Tagged_t klatin1_b6_string = 0x3745;
  static constexpr Tagged_t klatin1_b7_string = 0x3755;
  static constexpr Tagged_t klatin1_b8_string = 0x3765;
  static constexpr Tagged_t klatin1_b9_string = 0x3775;
  static constexpr Tagged_t klatin1_ba_string = 0x3785;
  static constexpr Tagged_t klatin1_bb_string = 0x3795;
  static constexpr Tagged_t klatin1_bc_string = 0x37a5;
  static constexpr Tagged_t klatin1_bd_string = 0x37b5;
  static constexpr Tagged_t klatin1_be_string = 0x37c5;
  static constexpr Tagged_t klatin1_bf_string = 0x37d5;
  static constexpr Tagged_t klatin1_c0_string = 0x37e5;
  static constexpr Tagged_t klatin1_c1_string = 0x37f5;
  static constexpr Tagged_t klatin1_c2_string = 0x3805;
  static constexpr Tagged_t klatin1_c3_string = 0x3815;
  static constexpr Tagged_t klatin1_c4_string = 0x3825;
  static constexpr Tagged_t klatin1_c5_string = 0x3835;
  static constexpr Tagged_t klatin1_c6_string = 0x3845;
  static constexpr Tagged_t klatin1_c7_string = 0x3855;
  static constexpr Tagged_t klatin1_c8_string = 0x3865;
  static constexpr Tagged_t klatin1_c9_string = 0x3875;
  static constexpr Tagged_t klatin1_ca_string = 0x3885;
  static constexpr Tagged_t klatin1_cb_string = 0x3895;
  static constexpr Tagged_t klatin1_cc_string = 0x38a5;
  static constexpr Tagged_t klatin1_cd_string = 0x38b5;
  static constexpr Tagged_t klatin1_ce_string = 0x38c5;
  static constexpr Tagged_t klatin1_cf_string = 0x38d5;
  static constexpr Tagged_t klatin1_d0_string = 0x38e5;
  static constexpr Tagged_t klatin1_d1_string = 0x38f5;
  static constexpr Tagged_t klatin1_d2_string = 0x3905;
  static constexpr Tagged_t klatin1_d3_string = 0x3915;
  static constexpr Tagged_t klatin1_d4_string = 0x3925;
  static constexpr Tagged_t klatin1_d5_string = 0x3935;
  static constexpr Tagged_t klatin1_d6_string = 0x3945;
  static constexpr Tagged_t klatin1_d7_string = 0x3955;
  static constexpr Tagged_t klatin1_d8_string = 0x3965;
  static constexpr Tagged_t klatin1_d9_string = 0x3975;
  static constexpr Tagged_t klatin1_da_string = 0x3985;
  static constexpr Tagged_t klatin1_db_string = 0x3995;
  static constexpr Tagged_t klatin1_dc_string = 0x39a5;
  static constexpr Tagged_t klatin1_dd_string = 0x39b5;
  static constexpr Tagged_t klatin1_de_string = 0x39c5;
  static constexpr Tagged_t klatin1_df_string = 0x39d5;
  static constexpr Tagged_t klatin1_e0_string = 0x39e5;
  static constexpr Tagged_t klatin1_e1_string = 0x39f5;
  static constexpr Tagged_t klatin1_e2_string = 0x3a05;
  static constexpr Tagged_t klatin1_e3_string = 0x3a15;
  static constexpr Tagged_t klatin1_e4_string = 0x3a25;
  static constexpr Tagged_t klatin1_e5_string = 0x3a35;
  static constexpr Tagged_t klatin1_e6_string = 0x3a45;
  static constexpr Tagged_t klatin1_e7_string = 0x3a55;
  static constexpr Tagged_t klatin1_e8_string = 0x3a65;
  static constexpr Tagged_t klatin1_e9_string = 0x3a75;
  static constexpr Tagged_t klatin1_ea_string = 0x3a85;
  static constexpr Tagged_t klatin1_eb_string = 0x3a95;
  static constexpr Tagged_t klatin1_ec_string = 0x3aa5;
  static constexpr Tagged_t klatin1_ed_string = 0x3ab5;
  static constexpr Tagged_t klatin1_ee_string = 0x3ac5;
  static constexpr Tagged_t klatin1_ef_string = 0x3ad5;
  static constexpr Tagged_t klatin1_f0_string = 0x3ae5;
  static constexpr Tagged_t klatin1_f1_string = 0x3af5;
  static constexpr Tagged_t klatin1_f2_string = 0x3b05;
  static constexpr Tagged_t klatin1_f3_string = 0x3b15;
  static constexpr Tagged_t klatin1_f4_string = 0x3b25;
  static constexpr Tagged_t klatin1_f5_string = 0x3b35;
  static constexpr Tagged_t klatin1_f6_string = 0x3b45;
  static constexpr Tagged_t klatin1_f7_string = 0x3b55;
  static constexpr Tagged_t klatin1_f8_string = 0x3b65;
  static constexpr Tagged_t klatin1_f9_string = 0x3b75;
  static constexpr Tagged_t klatin1_fa_string = 0x3b85;
  static constexpr Tagged_t klatin1_fb_string = 0x3b95;
  static constexpr Tagged_t klatin1_fc_string = 0x3ba5;
  static constexpr Tagged_t klatin1_fd_string = 0x3bb5;
  static constexpr Tagged_t klatin1_fe_string = 0x3bc5;
  static constexpr Tagged_t klatin1_ff_string = 0x3bd5;
  static constexpr Tagged_t kadd_string = 0x3be5;
  static constexpr Tagged_t kAggregateError_string = 0x3bf5;
  static constexpr Tagged_t kalphabet_string = 0x3c11;
  static constexpr Tagged_t kalways_string = 0x3c25;
  static constexpr Tagged_t kanonymous_string = 0x3c39;
  static constexpr Tagged_t kapply_string = 0x3c51;
  static constexpr Tagged_t kArguments_string = 0x3c65;
  static constexpr Tagged_t karguments_string = 0x3c7d;
  static constexpr Tagged_t karguments_to_string = 0x3c95;
  static constexpr Tagged_t kArray_string = 0x3cb5;
  static constexpr Tagged_t karray_to_string = 0x3cc9;
  static constexpr Tagged_t kArrayBuffer_string = 0x3ce5;
  static constexpr Tagged_t kArrayIterator_string = 0x3cfd;
  static constexpr Tagged_t kas_string = 0x3d19;
  static constexpr Tagged_t kassert_string = 0x3d29;
  static constexpr Tagged_t kasync_string = 0x3d3d;
  static constexpr Tagged_t kAtomicsCondition_string = 0x3d51;
  static constexpr Tagged_t kAtomicsMutex_string = 0x3d71;
  static constexpr Tagged_t kauto_string = 0x3d8d;
  static constexpr Tagged_t kBigInt_string = 0x3d9d;
  static constexpr Tagged_t kbigint_string = 0x3db1;
  static constexpr Tagged_t kBigInt64Array_string = 0x3dc5;
  static constexpr Tagged_t kBigUint64Array_string = 0x3de1;
  static constexpr Tagged_t kbind_string = 0x3dfd;
  static constexpr Tagged_t kblank_string = 0x3e0d;
  static constexpr Tagged_t kBoolean_string = 0x3e21;
  static constexpr Tagged_t kboolean_string = 0x3e35;
  static constexpr Tagged_t kboolean_to_string = 0x3e49;
  static constexpr Tagged_t kbound__string = 0x3e65;
  static constexpr Tagged_t kbuffer_string = 0x3e79;
  static constexpr Tagged_t kbyte_length_string = 0x3e8d;
  static constexpr Tagged_t kbyte_offset_string = 0x3ea5;
  static constexpr Tagged_t kCompileError_string = 0x3ebd;
  static constexpr Tagged_t kcalendar_string = 0x3ed5;
  static constexpr Tagged_t kcalendarId_string = 0x3ee9;
  static constexpr Tagged_t kcalendarName_string = 0x3f01;
  static constexpr Tagged_t kcallee_string = 0x3f19;
  static constexpr Tagged_t kcaller_string = 0x3f2d;
  static constexpr Tagged_t kcause_string = 0x3f41;
  static constexpr Tagged_t kcharacter_string = 0x3f55;
  static constexpr Tagged_t kcode_string = 0x3f6d;
  static constexpr Tagged_t kcolumn_string = 0x3f7d;
  static constexpr Tagged_t kcomputed_string = 0x3f91;
  static constexpr Tagged_t kconjunction_string = 0x3fa9;
  static constexpr Tagged_t kconsole_string = 0x3fc1;
  static constexpr Tagged_t kconstrain_string = 0x3fd5;
  static constexpr Tagged_t kconstruct_string = 0x3fed;
  static constexpr Tagged_t kcurrent_string = 0x4005;
  static constexpr Tagged_t kDate_string = 0x4019;
  static constexpr Tagged_t kdate_to_string = 0x4029;
  static constexpr Tagged_t kdateAdd_string = 0x4045;
  static constexpr Tagged_t kdateFromFields_string = 0x4059;
  static constexpr Tagged_t kdateUntil_string = 0x4075;
  static constexpr Tagged_t kday_string = 0x408d;
  static constexpr Tagged_t kdayOfWeek_string = 0x409d;
  static constexpr Tagged_t kdayOfYear_string = 0x40b5;
  static constexpr Tagged_t kdays_string = 0x40cd;
  static constexpr Tagged_t kdaysInMonth_string = 0x40dd;
  static constexpr Tagged_t kdaysInWeek_string = 0x40f5;
  static constexpr Tagged_t kdaysInYear_string = 0x410d;
  static constexpr Tagged_t kdefault_string = 0x4125;
  static constexpr Tagged_t kdefineProperty_string = 0x4139;
  static constexpr Tagged_t kdeleteProperty_string = 0x4155;
  static constexpr Tagged_t kdetached_string = 0x4171;
  static constexpr Tagged_t kdirection_string = 0x4185;
  static constexpr Tagged_t kdisambiguation_string = 0x419d;
  static constexpr Tagged_t kdisjunction_string = 0x41b9;
  static constexpr Tagged_t kdisposed_string = 0x41d1;
  static constexpr Tagged_t kdone_string = 0x41e5;
  static constexpr Tagged_t kdot_brand_string = 0x41f5;
  static constexpr Tagged_t kdot_catch_string = 0x4209;
  static constexpr Tagged_t kdot_default_string = 0x421d;
  static constexpr Tagged_t kdot_for_string = 0x4231;
  static constexpr Tagged_t kdot_generator_object_string = 0x4241;
  static constexpr Tagged_t kdot_home_object_string = 0x4261;
  static constexpr Tagged_t kdot_new_target_string = 0x4279;
  static constexpr Tagged_t knew_target_string = 0x4279;
  static constexpr Tagged_t kdot_result_string = 0x4291;
  static constexpr Tagged_t kdot_repl_result_string = 0x42a5;
  static constexpr Tagged_t kdot_static_home_object_string = 0x42bd;
  static constexpr Tagged_t kdot_switch_tag_string = 0x42dd;
  static constexpr Tagged_t kdotAll_string = 0x42f5;
  static constexpr Tagged_t kError_string = 0x4309;
  static constexpr Tagged_t kEvalError_string = 0x431d;
  static constexpr Tagged_t kelement_string = 0x4335;
  static constexpr Tagged_t kepochMilliseconds_string = 0x4349;
  static constexpr Tagged_t kepochNanoseconds_string = 0x4369;
  static constexpr Tagged_t kera_string = 0x4385;
  static constexpr Tagged_t keraYear_string = 0x4395;
  static constexpr Tagged_t kerror_string = 0x43a9;
  static constexpr Tagged_t kerrors_string = 0x43bd;
  static constexpr Tagged_t kerror_to_string = 0x43d1;
  static constexpr Tagged_t keval_string = 0x43ed;
  static constexpr Tagged_t kexception_string = 0x43fd;
  static constexpr Tagged_t kexec_string = 0x4415;
  static constexpr Tagged_t kfalse_string = 0x4425;
  static constexpr Tagged_t kfields_string = 0x4439;
  static constexpr Tagged_t kFinalizationRegistry_string = 0x444d;
  static constexpr Tagged_t kflags_string = 0x446d;
  static constexpr Tagged_t kFloat16Array_string = 0x4481;
  static constexpr Tagged_t kFloat32Array_string = 0x4499;
  static constexpr Tagged_t kFloat64Array_string = 0x44b1;
  static constexpr Tagged_t kfractionalSecondDigits_string = 0x44c9;
  static constexpr Tagged_t kfrom_string = 0x44ed;
  static constexpr Tagged_t kFunction_string = 0x44fd;
  static constexpr Tagged_t kfunction_native_code_string = 0x4511;
  static constexpr Tagged_t kfunction_string = 0x453d;
  static constexpr Tagged_t kfunction_to_string = 0x4551;
  static constexpr Tagged_t kGenerator_string = 0x4571;
  static constexpr Tagged_t kget_space_string = 0x4589;
  static constexpr Tagged_t kget_string = 0x4599;
  static constexpr Tagged_t kgetOffsetNanosecondsFor_string = 0x45a9;
  static constexpr Tagged_t kgetOwnPropertyDescriptor_string = 0x45cd;
  static constexpr Tagged_t kgetPossibleInstantsFor_string = 0x45f1;
  static constexpr Tagged_t kgetPrototypeOf_string = 0x4615;
  static constexpr Tagged_t kgetTimeZoneTransition_string = 0x4631;
  static constexpr Tagged_t kglobal_string = 0x4655;
  static constexpr Tagged_t kglobalThis_string = 0x4669;
  static constexpr Tagged_t kgroups_string = 0x4681;
  static constexpr Tagged_t kgrowable_string = 0x4695;
  static constexpr Tagged_t khas_string = 0x46a9;
  static constexpr Tagged_t khasIndices_string = 0x46b9;
  static constexpr Tagged_t khour_string = 0x46d1;
  static constexpr Tagged_t khours_string = 0x46e1;
  static constexpr Tagged_t khoursInDay_string = 0x46f5;
  static constexpr Tagged_t kignoreCase_string = 0x470d;
  static constexpr Tagged_t kid_string = 0x4725;
  static constexpr Tagged_t killegal_access_string = 0x4735;
  static constexpr Tagged_t killegal_argument_string = 0x4751;
  static constexpr Tagged_t kinLeapYear_string = 0x476d;
  static constexpr Tagged_t kindex_string = 0x4785;
  static constexpr Tagged_t kindices_string = 0x4799;
  static constexpr Tagged_t kInfinity_string = 0x47ad;
  static constexpr Tagged_t kinfinity_string = 0x47c1;
  static constexpr Tagged_t kinput_string = 0x47d5;
  static constexpr Tagged_t kinstance_members_initializer_string = 0x47e9;
  static constexpr Tagged_t kInt16Array_string = 0x4815;
  static constexpr Tagged_t kInt32Array_string = 0x482d;
  static constexpr Tagged_t kInt8Array_string = 0x4845;
  static constexpr Tagged_t kisExtensible_string = 0x485d;
  static constexpr Tagged_t kiso8601_string = 0x4875;
  static constexpr Tagged_t kisoDay_string = 0x4889;
  static constexpr Tagged_t kisoHour_string = 0x489d;
  static constexpr Tagged_t kisoMicrosecond_string = 0x48b1;
  static constexpr Tagged_t kisoMillisecond_string = 0x48cd;
  static constexpr Tagged_t kisoMinute_string = 0x48e9;
  static constexpr Tagged_t kisoMonth_string = 0x4901;
  static constexpr Tagged_t kisoNanosecond_string = 0x4915;
  static constexpr Tagged_t kisoSecond_string = 0x4931;
  static constexpr Tagged_t kisoYear_string = 0x4949;
  static constexpr Tagged_t kIterator_string = 0x495d;
  static constexpr Tagged_t kjsMemoryEstimate_string = 0x4971;
  static constexpr Tagged_t kjsMemoryRange_string = 0x498d;
  static constexpr Tagged_t kkeys_string = 0x49a9;
  static constexpr Tagged_t klargestUnit_string = 0x49b9;
  static constexpr Tagged_t klast_chunk_handling_string = 0x49d1;
  static constexpr Tagged_t klastIndex_string = 0x49f1;
  static constexpr Tagged_t klet_string = 0x4a09;
  static constexpr Tagged_t kline_string = 0x4a19;
  static constexpr Tagged_t klinear_string = 0x4a29;
  static constexpr Tagged_t kLinkError_string = 0x4a3d;
  static constexpr Tagged_t klong_string = 0x4a55;
  static constexpr Tagged_t kMap_string = 0x4a65;
  static constexpr Tagged_t kMapIterator_string = 0x4a75;
  static constexpr Tagged_t kmax_byte_length_string = 0x4a8d;
  static constexpr Tagged_t kmedium_string = 0x4aa9;
  static constexpr Tagged_t kmergeFields_string = 0x4abd;
  static constexpr Tagged_t kmessage_string = 0x4ad5;
  static constexpr Tagged_t kmeta_string = 0x4ae9;
  static constexpr Tagged_t kminus_Infinity_string = 0x4af9;
  static constexpr Tagged_t kmicrosecond_string = 0x4b11;
  static constexpr Tagged_t kmicroseconds_string = 0x4b29;
  static constexpr Tagged_t kmillisecond_string = 0x4b41;
  static constexpr Tagged_t kmilliseconds_string = 0x4b59;
  static constexpr Tagged_t kminute_string = 0x4b71;
  static constexpr Tagged_t kminutes_string = 0x4b85;
  static constexpr Tagged_t kModule_string = 0x4b99;
  static constexpr Tagged_t kmonth_string = 0x4bad;
  static constexpr Tagged_t kmonthDayFromFields_string = 0x4bc1;
  static constexpr Tagged_t kmonths_string = 0x4be1;
  static constexpr Tagged_t kmonthsInYear_string = 0x4bf5;
  static constexpr Tagged_t kmonthCode_string = 0x4c0d;
  static constexpr Tagged_t kmultiline_string = 0x4c25;
  static constexpr Tagged_t kNaN_string = 0x4c3d;
  static constexpr Tagged_t knanosecond_string = 0x4c4d;
  static constexpr Tagged_t knanoseconds_string = 0x4c65;
  static constexpr Tagged_t knarrow_string = 0x4c7d;
  static constexpr Tagged_t knative_string = 0x4c91;
  static constexpr Tagged_t kNFC_string = 0x4ca5;
  static constexpr Tagged_t kNFD_string = 0x4cb5;
  static constexpr Tagged_t kNFKC_string = 0x4cc5;
  static constexpr Tagged_t kNFKD_string = 0x4cd5;
  static constexpr Tagged_t knot_equal_string = 0x4ce5;
  static constexpr Tagged_t knull_string = 0x4cfd;
  static constexpr Tagged_t knull_to_string = 0x4d0d;
  static constexpr Tagged_t kNumber_string = 0x4d29;
  static constexpr Tagged_t knumber_string = 0x4d3d;
  static constexpr Tagged_t knumber_to_string = 0x4d51;
  static constexpr Tagged_t kObject_string = 0x4d6d;
  static constexpr Tagged_t kobject_string = 0x4d81;
  static constexpr Tagged_t kobject_to_string = 0x4d95;
  static constexpr Tagged_t kObject_prototype_string = 0x4db1;
  static constexpr Tagged_t koffset_string = 0x4dcd;
  static constexpr Tagged_t koffsetNanoseconds_string = 0x4de1;
  static constexpr Tagged_t kok_string = 0x4e01;
  static constexpr Tagged_t kother_string = 0x4e11;
  static constexpr Tagged_t koverflow_string = 0x4e25;
  static constexpr Tagged_t kownKeys_string = 0x4e39;
  static constexpr Tagged_t kpercent_string = 0x4e4d;
  static constexpr Tagged_t kplainDate_string = 0x4e61;
  static constexpr Tagged_t kplainTime_string = 0x4e79;
  static constexpr Tagged_t kposition_string = 0x4e91;
  static constexpr Tagged_t kpreventExtensions_string = 0x4ea5;
  static constexpr Tagged_t kprivate_constructor_string = 0x4ec5;
  static constexpr Tagged_t kPromise_string = 0x4edd;
  static constexpr Tagged_t kpromise_string = 0x4ef1;
  static constexpr Tagged_t kproto_string = 0x4f05;
  static constexpr Tagged_t kproxy_string = 0x4f1d;
  static constexpr Tagged_t kProxy_string = 0x4f31;
  static constexpr Tagged_t kquery_colon_string = 0x4f45;
  static constexpr Tagged_t kRangeError_string = 0x4f55;
  static constexpr Tagged_t kraw_json_string = 0x4f6d;
  static constexpr Tagged_t kraw_string = 0x4f81;
  static constexpr Tagged_t kread_string = 0x4f91;
  static constexpr Tagged_t kReferenceError_string = 0x4fa1;
  static constexpr Tagged_t kReflectGet_string = 0x4fbd;
  static constexpr Tagged_t kReflectHas_string = 0x4fd5;
  static constexpr Tagged_t kRegExp_string = 0x4fed;
  static constexpr Tagged_t kregexp_to_string = 0x5001;
  static constexpr Tagged_t kreject_string = 0x501d;
  static constexpr Tagged_t krelativeTo_string = 0x5031;
  static constexpr Tagged_t kresizable_string = 0x5049;
  static constexpr Tagged_t kResizableArrayBuffer_string = 0x5061;
  static constexpr Tagged_t kreturn_string = 0x5081;
  static constexpr Tagged_t krevoke_string = 0x5095;
  static constexpr Tagged_t kroundingIncrement_string = 0x50a9;
  static constexpr Tagged_t kroundingMode_string = 0x50c9;
  static constexpr Tagged_t kRuntimeError_string = 0x50e1;
  static constexpr Tagged_t kWebAssemblyException_string = 0x50f9;
  static constexpr Tagged_t kWebAssemblyModule_string = 0x511d;
  static constexpr Tagged_t kScript_string = 0x513d;
  static constexpr Tagged_t kscript_string = 0x5151;
  static constexpr Tagged_t ksecond_string = 0x5165;
  static constexpr Tagged_t kseconds_string = 0x5179;
  static constexpr Tagged_t kshort_string = 0x518d;
  static constexpr Tagged_t kSet_string = 0x51a1;
  static constexpr Tagged_t ksentence_string = 0x51b1;
  static constexpr Tagged_t kset_space_string = 0x51c5;
  static constexpr Tagged_t kset_string = 0x51d5;
  static constexpr Tagged_t kSetIterator_string = 0x51e5;
  static constexpr Tagged_t ksetPrototypeOf_string = 0x51fd;
  static constexpr Tagged_t kShadowRealm_string = 0x5219;
  static constexpr Tagged_t kSharedArray_string = 0x5231;
  static constexpr Tagged_t kSharedArrayBuffer_string = 0x5249;
  static constexpr Tagged_t kSharedStruct_string = 0x5269;
  static constexpr Tagged_t ksign_string = 0x5281;
  static constexpr Tagged_t ksize_string = 0x5291;
  static constexpr Tagged_t ksmallestUnit_string = 0x52a1;
  static constexpr Tagged_t ksource_string = 0x52b9;
  static constexpr Tagged_t ksourceText_string = 0x52cd;
  static constexpr Tagged_t kstack_string = 0x52e5;
  static constexpr Tagged_t kstackTraceLimit_string = 0x52f9;
  static constexpr Tagged_t kstatic_initializer_string = 0x5315;
  static constexpr Tagged_t ksticky_string = 0x5335;
  static constexpr Tagged_t kString_string = 0x5349;
  static constexpr Tagged_t kstring_string = 0x535d;
  static constexpr Tagged_t kstring_to_string = 0x5371;
  static constexpr Tagged_t ksuppressed_string = 0x538d;
  static constexpr Tagged_t kSuppressedError_string = 0x53a5;
  static constexpr Tagged_t kSuspendError_string = 0x53c1;
  static constexpr Tagged_t kSymbol_iterator_string = 0x53d9;
  static constexpr Tagged_t kSymbol_match_all_string = 0x53f5;
  static constexpr Tagged_t kSymbol_replace_string = 0x5411;
  static constexpr Tagged_t ksymbol_species_string = 0x542d;
  static constexpr Tagged_t kSymbol_species_string = 0x5449;
  static constexpr Tagged_t kSymbol_split_string = 0x5465;
  static constexpr Tagged_t kSymbol_string = 0x547d;
  static constexpr Tagged_t ksymbol_string = 0x5491;
  static constexpr Tagged_t kSyntaxError_string = 0x54a5;
  static constexpr Tagged_t ktarget_string = 0x54bd;
  static constexpr Tagged_t kthis_function_string = 0x54d1;
  static constexpr Tagged_t kthis_string = 0x54ed;
  static constexpr Tagged_t kthrow_string = 0x54fd;
  static constexpr Tagged_t ktimed_out_string = 0x5511;
  static constexpr Tagged_t ktimeZone_string = 0x5529;
  static constexpr Tagged_t ktimeZoneId_string = 0x553d;
  static constexpr Tagged_t ktoJSON_string = 0x5555;
  static constexpr Tagged_t ktoString_string = 0x5569;
  static constexpr Tagged_t ktrue_string = 0x557d;
  static constexpr Tagged_t ktotal_string = 0x558d;
  static constexpr Tagged_t kTypedArrayLength_string = 0x55a1;
  static constexpr Tagged_t kTypeError_string = 0x55cd;
  static constexpr Tagged_t kUint16Array_string = 0x55e5;
  static constexpr Tagged_t kUint32Array_string = 0x55fd;
  static constexpr Tagged_t kUint8Array_string = 0x5615;
  static constexpr Tagged_t kUint8ClampedArray_string = 0x562d;
  static constexpr Tagged_t kundefined_string = 0x564d;
  static constexpr Tagged_t kundefined_to_string = 0x5665;
  static constexpr Tagged_t kunicode_string = 0x5685;
  static constexpr Tagged_t kunicodeSets_string = 0x5699;
  static constexpr Tagged_t kunit_string = 0x56b1;
  static constexpr Tagged_t kURIError_string = 0x56c1;
  static constexpr Tagged_t kUTC_string = 0x56d5;
  static constexpr Tagged_t kWeakMap_string = 0x56e5;
  static constexpr Tagged_t kWeakRef_string = 0x56f9;
  static constexpr Tagged_t kWeakSet_string = 0x570d;
  static constexpr Tagged_t kweek_string = 0x5721;
  static constexpr Tagged_t kweeks_string = 0x5731;
  static constexpr Tagged_t kweekOfYear_string = 0x5745;
  static constexpr Tagged_t kwith_string = 0x575d;
  static constexpr Tagged_t kword_string = 0x576d;
  static constexpr Tagged_t kwritten_string = 0x577d;
  static constexpr Tagged_t kyearMonthFromFields_string = 0x5791;
  static constexpr Tagged_t kyear_string = 0x57b1;
  static constexpr Tagged_t kyears_string = 0x57c1;
  static constexpr Tagged_t kyearOfWeek_string = 0x57d5;
  static constexpr Tagged_t kPropertyCellHoleValue = 0x57ed;
  static constexpr Tagged_t kHashTableHoleValue = 0x57f9;
  static constexpr Tagged_t kPromiseHoleValue = 0x5805;
  static constexpr Tagged_t kUninitializedValue = 0x5811;
  static constexpr Tagged_t kArgumentsMarker = 0x581d;
  static constexpr Tagged_t kTerminationException = 0x5829;
  static constexpr Tagged_t kException = 0x5835;
  static constexpr Tagged_t kOptimizedOut = 0x5841;
  static constexpr Tagged_t kStaleRegister = 0x584d;
  static constexpr Tagged_t kSelfReferenceMarker = 0x5859;
  static constexpr Tagged_t kBasicBlockCountersMarker = 0x5865;
  static constexpr Tagged_t karray_buffer_wasm_memory_symbol = 0x5871;
  static constexpr Tagged_t kcall_site_info_symbol = 0x5881;
  static constexpr Tagged_t kclass_fields_symbol = 0x5891;
  static constexpr Tagged_t kclass_positions_symbol = 0x58a1;
  static constexpr Tagged_t kerror_end_pos_symbol = 0x58b1;
  static constexpr Tagged_t kerror_message_symbol = 0x58c1;
  static constexpr Tagged_t kerror_script_symbol = 0x58d1;
  static constexpr Tagged_t kerror_stack_symbol = 0x58e1;
  static constexpr Tagged_t kerror_start_pos_symbol = 0x58f1;
  static constexpr Tagged_t kfrozen_symbol = 0x5901;
  static constexpr Tagged_t kinterpreter_trampoline_symbol = 0x5911;
  static constexpr Tagged_t knative_context_index_symbol = 0x5921;
  static constexpr Tagged_t knonextensible_symbol = 0x5931;
  static constexpr Tagged_t kpromise_debug_message_symbol = 0x5941;
  static constexpr Tagged_t kpromise_forwarding_handler_symbol = 0x5951;
  static constexpr Tagged_t kpromise_handled_by_symbol = 0x5961;
  static constexpr Tagged_t kpromise_awaited_by_symbol = 0x5971;
  static constexpr Tagged_t kregexp_result_names_symbol = 0x5981;
  static constexpr Tagged_t kregexp_result_regexp_input_symbol = 0x5991;
  static constexpr Tagged_t kregexp_result_regexp_last_index_symbol = 0x59a1;
  static constexpr Tagged_t ksealed_symbol = 0x59b1;
  static constexpr Tagged_t kshared_struct_map_elements_template_symbol =
      0x59c1;
  static constexpr Tagged_t kshared_struct_map_registry_key_symbol = 0x59d1;
  static constexpr Tagged_t kstrict_function_transition_symbol = 0x59e1;
  static constexpr Tagged_t ktemplate_literal_function_literal_id_symbol =
      0x59f1;
  static constexpr Tagged_t ktemplate_literal_slot_id_symbol = 0x5a01;
  static constexpr Tagged_t kwasm_cross_instance_call_symbol = 0x5a11;
  static constexpr Tagged_t kwasm_exception_tag_symbol = 0x5a21;
  static constexpr Tagged_t kwasm_exception_values_symbol = 0x5a31;
  static constexpr Tagged_t kwasm_uncatchable_symbol = 0x5a41;
  static constexpr Tagged_t kwasm_debug_proxy_cache_symbol = 0x5a51;
  static constexpr Tagged_t kwasm_debug_proxy_names_symbol = 0x5a61;
  static constexpr Tagged_t kasync_iterator_symbol = 0x5a71;
  static constexpr Tagged_t kintl_fallback_symbol = 0x5aa1;
  static constexpr Tagged_t kmatch_symbol = 0x5ad9;
  static constexpr Tagged_t ksearch_symbol = 0x5b01;
  static constexpr Tagged_t kunscopables_symbol = 0x5b2d;
  static constexpr Tagged_t kdispose_symbol = 0x5b5d;
  static constexpr Tagged_t kasync_dispose_symbol = 0x5b89;
  static constexpr Tagged_t khas_instance_symbol = 0x5bb9;
  static constexpr Tagged_t kto_string_tag_symbol = 0x5be9;
  static constexpr Tagged_t kconstructor_string = 0x5c61;
  static constexpr Tagged_t knext_string = 0x5c79;
  static constexpr Tagged_t kresolve_string = 0x5c89;
  static constexpr Tagged_t kthen_string = 0x5c9d;
  static constexpr Tagged_t kvalueOf_string = 0x5cad;
  static constexpr Tagged_t kiterator_symbol = 0x5cc1;
  static constexpr Tagged_t kmatch_all_symbol = 0x5cd1;
  static constexpr Tagged_t kreplace_symbol = 0x5ce1;
  static constexpr Tagged_t kspecies_symbol = 0x5cf1;
  static constexpr Tagged_t ksplit_symbol = 0x5d01;
  static constexpr Tagged_t kto_primitive_symbol = 0x5d11;
  static constexpr Tagged_t kis_concat_spreadable_symbol = 0x5d21;
  static constexpr Tagged_t kEmptySlowElementDictionary = 0x5d31;
  static constexpr Tagged_t kEmptySymbolTable = 0x5d55;
  static constexpr Tagged_t kUndefinedContextCell = 0x5d71;
  static constexpr Tagged_t kEmptyOrderedHashMap = 0x5d89;
  static constexpr Tagged_t kEmptyOrderedHashSet = 0x5d9d;
  static constexpr Tagged_t kEmptyFeedbackMetadata = 0x5db1;
  static constexpr Tagged_t kGlobalThisBindingScopeInfo = 0x5dbd;
  static constexpr Tagged_t kEmptyFunctionScopeInfo = 0x5ddd;
  static constexpr Tagged_t kNativeScopeInfo = 0x5e01;
  static constexpr Tagged_t kShadowRealmScopeInfo = 0x5e19;
  static constexpr Tagged_t kManyClosuresCell = 0x5e31;
  static constexpr Tagged_t kPreallocatedNumberStringTable = 0x5e41;
  static constexpr Tagged_t kJSMessageObjectMap = 0x6579;
  static constexpr Tagged_t kExternalMap = 0x65a1;
  static constexpr Tagged_t kCppHeapExternalMap = 0x65c9;
  static constexpr Tagged_t kJSSharedArrayMap = 0x65f1;
  static constexpr Tagged_t kJSAtomicsMutexMap = 0x6639;
  static constexpr Tagged_t kJSAtomicsConditionMap = 0x6661;
  static constexpr Tagged_t kNoOpInterceptorInfo = 0x6689;

  static constexpr Tagged_t kFirstAllocatedRoot = 0x11;
  static constexpr Tagged_t kLastAllocatedRoot = 0x6689;
};

static constexpr std::array<Tagged_t, 1022> StaticReadOnlyRootsPointerTable = {
    StaticReadOnlyRoot::kUndefinedValue,
    StaticReadOnlyRoot::kTheHoleValue,
    StaticReadOnlyRoot::kNullValue,
    StaticReadOnlyRoot::kTrueValue,
    StaticReadOnlyRoot::kFalseValue,
    StaticReadOnlyRoot::kempty_string,
    StaticReadOnlyRoot::kprototype_string,
    StaticReadOnlyRoot::kname_string,
    StaticReadOnlyRoot::klength_string,
    StaticReadOnlyRoot::kByteArrayMap,
    StaticReadOnlyRoot::kFixedArrayMap,
    StaticReadOnlyRoot::kFixedCOWArrayMap,
    StaticReadOnlyRoot::kFixedDoubleArrayMap,
    StaticReadOnlyRoot::kHashTableMap,
    StaticReadOnlyRoot::kSymbolMap,
    StaticReadOnlyRoot::kSeqOneByteStringMap,
    StaticReadOnlyRoot::kInternalizedOneByteStringMap,
    StaticReadOnlyRoot::kSharedFunctionInfoMap,
    StaticReadOnlyRoot::kCellMap,
    StaticReadOnlyRoot::kGlobalPropertyCellMap,
    StaticReadOnlyRoot::kHeapNumberMap,
    StaticReadOnlyRoot::kTransitionArrayMap,
    StaticReadOnlyRoot::kPropertyArrayMap,
    StaticReadOnlyRoot::kWeakFixedArrayMap,
    StaticReadOnlyRoot::kEmptyEnumCache,
    StaticReadOnlyRoot::kEmptyScopeInfo,
    StaticReadOnlyRoot::kEmptyPropertyArray,
    StaticReadOnlyRoot::kEmptyFixedArray,
    StaticReadOnlyRoot::kEmptyDescriptorArray,
    StaticReadOnlyRoot::kEmptyWeakArrayList,
    StaticReadOnlyRoot::kInvalidPrototypeValidityCell,
    StaticReadOnlyRoot::kManyClosuresCell,
    StaticReadOnlyRoot::kArgumentsMarker,
    StaticReadOnlyRoot::kException,
    StaticReadOnlyRoot::kHashTableHoleValue,
    StaticReadOnlyRoot::kOptimizedOut,
    StaticReadOnlyRoot::kPromiseHoleValue,
    StaticReadOnlyRoot::kPropertyCellHoleValue,
    StaticReadOnlyRoot::kStaleRegister,
    StaticReadOnlyRoot::kTerminationException,
    StaticReadOnlyRoot::kUninitializedValue,
    StaticReadOnlyRoot::kMetaMap,
    StaticReadOnlyRoot::kFreeSpaceMap,
    StaticReadOnlyRoot::kOnePointerFillerMap,
    StaticReadOnlyRoot::kTwoPointerFillerMap,
    StaticReadOnlyRoot::kAccessorInfoMap,
    StaticReadOnlyRoot::kArrayListMap,
    StaticReadOnlyRoot::kAtomRegExpDataMap,
    StaticReadOnlyRoot::kBigIntMap,
    StaticReadOnlyRoot::kBytecodeArrayMap,
    StaticReadOnlyRoot::kClosureFeedbackCellArrayMap,
    StaticReadOnlyRoot::kCodeMap,
    StaticReadOnlyRoot::kContextCellMap,
    StaticReadOnlyRoot::kCoverageInfoMap,
    StaticReadOnlyRoot::kDictionaryTemplateInfoMap,
    StaticReadOnlyRoot::kDoubleStringCacheMap,
    StaticReadOnlyRoot::kFeedbackMetadataArrayMap,
    StaticReadOnlyRoot::kFeedbackVectorMap,
    StaticReadOnlyRoot::kForeignMap,
    StaticReadOnlyRoot::kGlobalDictionaryMap,
    StaticReadOnlyRoot::kInstructionStreamMap,
    StaticReadOnlyRoot::kInterceptorInfoMap,
    StaticReadOnlyRoot::kIrRegExpDataMap,
    StaticReadOnlyRoot::kManyClosuresCellMap,
    StaticReadOnlyRoot::kMegaDomHandlerMap,
    StaticReadOnlyRoot::kModuleInfoMap,
    StaticReadOnlyRoot::kNameDictionaryMap,
    StaticReadOnlyRoot::kNameToIndexHashTableMap,
    StaticReadOnlyRoot::kNoClosuresCellMap,
    StaticReadOnlyRoot::kNumberDictionaryMap,
    StaticReadOnlyRoot::kObjectBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kOneClosureCellMap,
    StaticReadOnlyRoot::kOrderedHashMapMap,
    StaticReadOnlyRoot::kOrderedHashSetMap,
    StaticReadOnlyRoot::kOrderedNameDictionaryMap,
    StaticReadOnlyRoot::kPreparseDataMap,
    StaticReadOnlyRoot::kRegExpDataMap,
    StaticReadOnlyRoot::kRegExpMatchInfoMap,
    StaticReadOnlyRoot::kRegisteredSymbolTableMap,
    StaticReadOnlyRoot::kScopeInfoMap,
    StaticReadOnlyRoot::kScriptContextTableMap,
    StaticReadOnlyRoot::kSimpleNameDictionaryMap,
    StaticReadOnlyRoot::kSimpleNumberDictionaryMap,
    StaticReadOnlyRoot::kSmallOrderedHashMapMap,
    StaticReadOnlyRoot::kSmallOrderedHashSetMap,
    StaticReadOnlyRoot::kSmallOrderedNameDictionaryMap,
    StaticReadOnlyRoot::kSourceTextModuleMap,
    StaticReadOnlyRoot::kSwissNameDictionaryMap,
    StaticReadOnlyRoot::kSyntheticModuleMap,
    StaticReadOnlyRoot::kWeakArrayListMap,
    StaticReadOnlyRoot::kEphemeronHashTableMap,
    StaticReadOnlyRoot::kEmbedderDataArrayMap,
    StaticReadOnlyRoot::kWeakCellMap,
    StaticReadOnlyRoot::kTrustedFixedArrayMap,
    StaticReadOnlyRoot::kTrustedWeakFixedArrayMap,
    StaticReadOnlyRoot::kTrustedByteArrayMap,
    StaticReadOnlyRoot::kProtectedFixedArrayMap,
    StaticReadOnlyRoot::kProtectedWeakFixedArrayMap,
    StaticReadOnlyRoot::kInterpreterDataMap,
    StaticReadOnlyRoot::kSharedFunctionInfoWrapperMap,
    StaticReadOnlyRoot::kTrustedForeignMap,
    StaticReadOnlyRoot::kUncompiledDataWithoutPreparseDataMap,
    StaticReadOnlyRoot::kUncompiledDataWithPreparseDataMap,
    StaticReadOnlyRoot::kUncompiledDataWithoutPreparseDataWithJobMap,
    StaticReadOnlyRoot::kUncompiledDataWithPreparseDataAndJobMap,
    StaticReadOnlyRoot::kSeqTwoByteStringMap,
    StaticReadOnlyRoot::kConsTwoByteStringMap,
    StaticReadOnlyRoot::kConsOneByteStringMap,
    StaticReadOnlyRoot::kThinTwoByteStringMap,
    StaticReadOnlyRoot::kThinOneByteStringMap,
    StaticReadOnlyRoot::kSlicedTwoByteStringMap,
    StaticReadOnlyRoot::kSlicedOneByteStringMap,
    StaticReadOnlyRoot::kExternalTwoByteStringMap,
    StaticReadOnlyRoot::kExternalOneByteStringMap,
    StaticReadOnlyRoot::kInternalizedTwoByteStringMap,
    StaticReadOnlyRoot::kExternalInternalizedTwoByteStringMap,
    StaticReadOnlyRoot::kExternalInternalizedOneByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalInternalizedTwoByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalInternalizedOneByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalTwoByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedSeqOneByteStringMap,
    StaticReadOnlyRoot::kSharedSeqTwoByteStringMap,
    StaticReadOnlyRoot::kSharedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedExternalTwoByteStringMap,
    StaticReadOnlyRoot::kSharedUncachedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedUncachedExternalTwoByteStringMap,
    StaticReadOnlyRoot::kUndefinedMap,
    StaticReadOnlyRoot::kNullMap,
    StaticReadOnlyRoot::kBooleanMap,
    StaticReadOnlyRoot::kHoleMap,
    StaticReadOnlyRoot::kJSSharedArrayMap,
    StaticReadOnlyRoot::kJSAtomicsMutexMap,
    StaticReadOnlyRoot::kJSAtomicsConditionMap,
    StaticReadOnlyRoot::kEmptyByteArray,
    StaticReadOnlyRoot::kEmptyObjectBoilerplateDescription,
    StaticReadOnlyRoot::kEmptyArrayBoilerplateDescription,
    StaticReadOnlyRoot::kEmptyClosureFeedbackCellArray,
    StaticReadOnlyRoot::kEmptySlowElementDictionary,
    StaticReadOnlyRoot::kEmptyOrderedHashMap,
    StaticReadOnlyRoot::kEmptyOrderedHashSet,
    StaticReadOnlyRoot::kEmptyFeedbackMetadata,
    StaticReadOnlyRoot::kEmptyPropertyDictionary,
    StaticReadOnlyRoot::kEmptyOrderedPropertyDictionary,
    StaticReadOnlyRoot::kEmptySwissPropertyDictionary,
    StaticReadOnlyRoot::kNoOpInterceptorInfo,
    StaticReadOnlyRoot::kEmptyArrayList,
    StaticReadOnlyRoot::kEmptyWeakFixedArray,
    StaticReadOnlyRoot::kNanValue,
    StaticReadOnlyRoot::kUndefinedNanValue,
    StaticReadOnlyRoot::kHoleNanValue,
    StaticReadOnlyRoot::kInfinityValue,
    StaticReadOnlyRoot::kMinusZeroValue,
    StaticReadOnlyRoot::kMinusInfinityValue,
    StaticReadOnlyRoot::kMaxSafeInteger,
    StaticReadOnlyRoot::kMaxUInt32,
    StaticReadOnlyRoot::kSmiMinValue,
    StaticReadOnlyRoot::kSmiMaxValuePlusOne,
    StaticReadOnlyRoot::kSelfReferenceMarker,
    StaticReadOnlyRoot::kBasicBlockCountersMarker,
    StaticReadOnlyRoot::kGlobalThisBindingScopeInfo,
    StaticReadOnlyRoot::kEmptyFunctionScopeInfo,
    StaticReadOnlyRoot::kNativeScopeInfo,
    StaticReadOnlyRoot::kShadowRealmScopeInfo,
    StaticReadOnlyRoot::kEmptySymbolTable,
    StaticReadOnlyRoot::kUndefinedContextCell,
    StaticReadOnlyRoot::kHashSeed,
    StaticReadOnlyRoot::kPreallocatedNumberStringTable,
    StaticReadOnlyRoot::kenumerable_string,
    StaticReadOnlyRoot::kconfigurable_string,
    StaticReadOnlyRoot::kvalue_string,
    StaticReadOnlyRoot::kwritable_string,
    StaticReadOnlyRoot::kadoptText_string,
    StaticReadOnlyRoot::kapproximatelySign_string,
    StaticReadOnlyRoot::kbaseName_string,
    StaticReadOnlyRoot::kaccounting_string,
    StaticReadOnlyRoot::kbreakType_string,
    StaticReadOnlyRoot::kcalendars_string,
    StaticReadOnlyRoot::kcardinal_string,
    StaticReadOnlyRoot::kcaseFirst_string,
    StaticReadOnlyRoot::kceil_string,
    StaticReadOnlyRoot::kcompare_string,
    StaticReadOnlyRoot::kcollation_string,
    StaticReadOnlyRoot::kcollations_string,
    StaticReadOnlyRoot::kcompact_string,
    StaticReadOnlyRoot::kcompactDisplay_string,
    StaticReadOnlyRoot::kcurrency_string,
    StaticReadOnlyRoot::kcurrencyDisplay_string,
    StaticReadOnlyRoot::kcurrencySign_string,
    StaticReadOnlyRoot::kdateStyle_string,
    StaticReadOnlyRoot::kdateTimeField_string,
    StaticReadOnlyRoot::kdayPeriod_string,
    StaticReadOnlyRoot::kdaysDisplay_string,
    StaticReadOnlyRoot::kdecimal_string,
    StaticReadOnlyRoot::kdialect_string,
    StaticReadOnlyRoot::kdigital_string,
    StaticReadOnlyRoot::kendRange_string,
    StaticReadOnlyRoot::kengineering_string,
    StaticReadOnlyRoot::kexceptZero_string,
    StaticReadOnlyRoot::kexpand_string,
    StaticReadOnlyRoot::kexponentInteger_string,
    StaticReadOnlyRoot::kexponentMinusSign_string,
    StaticReadOnlyRoot::kexponentSeparator_string,
    StaticReadOnlyRoot::kfallback_string,
    StaticReadOnlyRoot::kfirst_string,
    StaticReadOnlyRoot::kfirstDay_string,
    StaticReadOnlyRoot::kfirstDayOfWeek_string,
    StaticReadOnlyRoot::kfloor_string,
    StaticReadOnlyRoot::kformat_string,
    StaticReadOnlyRoot::kformatMatcher_string,
    StaticReadOnlyRoot::kfraction_string,
    StaticReadOnlyRoot::kfractionalDigits_string,
    StaticReadOnlyRoot::kfractionalSecond_string,
    StaticReadOnlyRoot::kfull_string,
    StaticReadOnlyRoot::kgranularity_string,
    StaticReadOnlyRoot::kgrapheme_string,
    StaticReadOnlyRoot::kgroup_string,
    StaticReadOnlyRoot::kh11_string,
    StaticReadOnlyRoot::kh12_string,
    StaticReadOnlyRoot::kh23_string,
    StaticReadOnlyRoot::kh24_string,
    StaticReadOnlyRoot::khalfCeil_string,
    StaticReadOnlyRoot::khalfEven_string,
    StaticReadOnlyRoot::khalfExpand_string,
    StaticReadOnlyRoot::khalfFloor_string,
    StaticReadOnlyRoot::khalfTrunc_string,
    StaticReadOnlyRoot::khour12_string,
    StaticReadOnlyRoot::khourCycle_string,
    StaticReadOnlyRoot::khourCycles_string,
    StaticReadOnlyRoot::khoursDisplay_string,
    StaticReadOnlyRoot::kideo_string,
    StaticReadOnlyRoot::kignorePunctuation_string,
    StaticReadOnlyRoot::kInvalid_Date_string,
    StaticReadOnlyRoot::kinteger_string,
    StaticReadOnlyRoot::kisWordLike_string,
    StaticReadOnlyRoot::kkana_string,
    StaticReadOnlyRoot::klanguage_string,
    StaticReadOnlyRoot::klanguageDisplay_string,
    StaticReadOnlyRoot::klessPrecision_string,
    StaticReadOnlyRoot::kletter_string,
    StaticReadOnlyRoot::klist_string,
    StaticReadOnlyRoot::kliteral_string,
    StaticReadOnlyRoot::klocale_string,
    StaticReadOnlyRoot::klocaleMatcher_string,
    StaticReadOnlyRoot::kloose_string,
    StaticReadOnlyRoot::klower_string,
    StaticReadOnlyRoot::kltr_string,
    StaticReadOnlyRoot::kmaximumFractionDigits_string,
    StaticReadOnlyRoot::kmaximumSignificantDigits_string,
    StaticReadOnlyRoot::kmicrosecondsDisplay_string,
    StaticReadOnlyRoot::kmillisecondsDisplay_string,
    StaticReadOnlyRoot::kmin2_string,
    StaticReadOnlyRoot::kminimalDays_string,
    StaticReadOnlyRoot::kminimumFractionDigits_string,
    StaticReadOnlyRoot::kminimumIntegerDigits_string,
    StaticReadOnlyRoot::kminimumSignificantDigits_string,
    StaticReadOnlyRoot::kminus_0,
    StaticReadOnlyRoot::kminusSign_string,
    StaticReadOnlyRoot::kminutesDisplay_string,
    StaticReadOnlyRoot::kmonthsDisplay_string,
    StaticReadOnlyRoot::kmorePrecision_string,
    StaticReadOnlyRoot::knan_string,
    StaticReadOnlyRoot::knanosecondsDisplay_string,
    StaticReadOnlyRoot::knarrowSymbol_string,
    StaticReadOnlyRoot::knegative_string,
    StaticReadOnlyRoot::knever_string,
    StaticReadOnlyRoot::knone_string,
    StaticReadOnlyRoot::knotation_string,
    StaticReadOnlyRoot::knormal_string,
    StaticReadOnlyRoot::knumberingSystem_string,
    StaticReadOnlyRoot::knumberingSystems_string,
    StaticReadOnlyRoot::knumeric_string,
    StaticReadOnlyRoot::kordinal_string,
    StaticReadOnlyRoot::kpercentSign_string,
    StaticReadOnlyRoot::kplusSign_string,
    StaticReadOnlyRoot::kquarter_string,
    StaticReadOnlyRoot::kregion_string,
    StaticReadOnlyRoot::krelatedYear_string,
    StaticReadOnlyRoot::kroundingPriority_string,
    StaticReadOnlyRoot::krtl_string,
    StaticReadOnlyRoot::kscientific_string,
    StaticReadOnlyRoot::ksecondsDisplay_string,
    StaticReadOnlyRoot::ksegment_string,
    StaticReadOnlyRoot::kSegmentIterator_string,
    StaticReadOnlyRoot::kSegments_string,
    StaticReadOnlyRoot::ksensitivity_string,
    StaticReadOnlyRoot::ksep_string,
    StaticReadOnlyRoot::kshared_string,
    StaticReadOnlyRoot::ksignDisplay_string,
    StaticReadOnlyRoot::kstandard_string,
    StaticReadOnlyRoot::kstartRange_string,
    StaticReadOnlyRoot::kstrict_string,
    StaticReadOnlyRoot::kstripIfInteger_string,
    StaticReadOnlyRoot::kstyle_string,
    StaticReadOnlyRoot::kterm_string,
    StaticReadOnlyRoot::ktextInfo_string,
    StaticReadOnlyRoot::ktimeStyle_string,
    StaticReadOnlyRoot::ktimeZones_string,
    StaticReadOnlyRoot::ktimeZoneName_string,
    StaticReadOnlyRoot::ktrailingZeroDisplay_string,
    StaticReadOnlyRoot::ktrunc_string,
    StaticReadOnlyRoot::ktwo_digit_string,
    StaticReadOnlyRoot::ktype_string,
    StaticReadOnlyRoot::kunknown_string,
    StaticReadOnlyRoot::kupper_string,
    StaticReadOnlyRoot::kusage_string,
    StaticReadOnlyRoot::kuseGrouping_string,
    StaticReadOnlyRoot::kunitDisplay_string,
    StaticReadOnlyRoot::kweekday_string,
    StaticReadOnlyRoot::kweekend_string,
    StaticReadOnlyRoot::kweeksDisplay_string,
    StaticReadOnlyRoot::kweekInfo_string,
    StaticReadOnlyRoot::kyearName_string,
    StaticReadOnlyRoot::kyearsDisplay_string,
    StaticReadOnlyRoot::kascii_nul_string,
    StaticReadOnlyRoot::kascii_soh_string,
    StaticReadOnlyRoot::kascii_stx_string,
    StaticReadOnlyRoot::kascii_etx_string,
    StaticReadOnlyRoot::kascii_eot_string,
    StaticReadOnlyRoot::kascii_enq_string,
    StaticReadOnlyRoot::kascii_ack_string,
    StaticReadOnlyRoot::kascii_bel_string,
    StaticReadOnlyRoot::kascii_bs_string,
    StaticReadOnlyRoot::kascii_ht_string,
    StaticReadOnlyRoot::kascii_lf_string,
    StaticReadOnlyRoot::kascii_vt_string,
    StaticReadOnlyRoot::kascii_ff_string,
    StaticReadOnlyRoot::kascii_cr_string,
    StaticReadOnlyRoot::kascii_so_string,
    StaticReadOnlyRoot::kascii_si_string,
    StaticReadOnlyRoot::kascii_dle_string,
    StaticReadOnlyRoot::kascii_dc1_string,
    StaticReadOnlyRoot::kascii_dc2_string,
    StaticReadOnlyRoot::kascii_dc3_string,
    StaticReadOnlyRoot::kascii_dc4_string,
    StaticReadOnlyRoot::kascii_nak_string,
    StaticReadOnlyRoot::kascii_syn_string,
    StaticReadOnlyRoot::kascii_etb_string,
    StaticReadOnlyRoot::kascii_can_string,
    StaticReadOnlyRoot::kascii_em_string,
    StaticReadOnlyRoot::kascii_sub_string,
    StaticReadOnlyRoot::kascii_esc_string,
    StaticReadOnlyRoot::kascii_fs_string,
    StaticReadOnlyRoot::kascii_gs_string,
    StaticReadOnlyRoot::kascii_rs_string,
    StaticReadOnlyRoot::kascii_us_string,
    StaticReadOnlyRoot::kspace_string,
    StaticReadOnlyRoot::kexclamation_mark_string,
    StaticReadOnlyRoot::kdouble_quotes_string,
    StaticReadOnlyRoot::khash_string,
    StaticReadOnlyRoot::kdollar_string,
    StaticReadOnlyRoot::kpercent_sign_string,
    StaticReadOnlyRoot::kampersand_string,
    StaticReadOnlyRoot::ksingle_quote_string,
    StaticReadOnlyRoot::kopen_parenthesis_string,
    StaticReadOnlyRoot::kclose_parenthesis_string,
    StaticReadOnlyRoot::kasterisk_string,
    StaticReadOnlyRoot::kplus_string,
    StaticReadOnlyRoot::kcomma_string,
    StaticReadOnlyRoot::kminus_string,
    StaticReadOnlyRoot::kdot_string,
    StaticReadOnlyRoot::kslash_string,
    StaticReadOnlyRoot::kzero_string,
    StaticReadOnlyRoot::kone_string,
    StaticReadOnlyRoot::ktwo_string,
    StaticReadOnlyRoot::kthree_string,
    StaticReadOnlyRoot::kfour_string,
    StaticReadOnlyRoot::kfive_string,
    StaticReadOnlyRoot::ksix_string,
    StaticReadOnlyRoot::kseven_string,
    StaticReadOnlyRoot::keight_string,
    StaticReadOnlyRoot::knine_string,
    StaticReadOnlyRoot::kcolon_string,
    StaticReadOnlyRoot::ksemicolon_string,
    StaticReadOnlyRoot::kless_than_string,
    StaticReadOnlyRoot::kequals_string,
    StaticReadOnlyRoot::kgreater_than_string,
    StaticReadOnlyRoot::kquestion_mark_string,
    StaticReadOnlyRoot::kat_sign_string,
    StaticReadOnlyRoot::kA_string,
    StaticReadOnlyRoot::kB_string,
    StaticReadOnlyRoot::kC_string,
    StaticReadOnlyRoot::kD_string,
    StaticReadOnlyRoot::kE_string,
    StaticReadOnlyRoot::kF_string,
    StaticReadOnlyRoot::kG_string,
    StaticReadOnlyRoot::kH_string,
    StaticReadOnlyRoot::kI_string,
    StaticReadOnlyRoot::kJ_string,
    StaticReadOnlyRoot::kK_string,
    StaticReadOnlyRoot::kL_string,
    StaticReadOnlyRoot::kM_string,
    StaticReadOnlyRoot::kN_string,
    StaticReadOnlyRoot::kO_string,
    StaticReadOnlyRoot::kP_string,
    StaticReadOnlyRoot::kQ_string,
    StaticReadOnlyRoot::kR_string,
    StaticReadOnlyRoot::kS_string,
    StaticReadOnlyRoot::kT_string,
    StaticReadOnlyRoot::kU_string,
    StaticReadOnlyRoot::kV_string,
    StaticReadOnlyRoot::kW_string,
    StaticReadOnlyRoot::kX_string,
    StaticReadOnlyRoot::kY_string,
    StaticReadOnlyRoot::kZ_string,
    StaticReadOnlyRoot::kopen_bracket_string,
    StaticReadOnlyRoot::kbackslash_string,
    StaticReadOnlyRoot::kclose_bracket_string,
    StaticReadOnlyRoot::kcaret_string,
    StaticReadOnlyRoot::kunderscore_string,
    StaticReadOnlyRoot::kbacktick_string,
    StaticReadOnlyRoot::ka_string,
    StaticReadOnlyRoot::kb_string,
    StaticReadOnlyRoot::kc_string,
    StaticReadOnlyRoot::kd_string,
    StaticReadOnlyRoot::ke_string,
    StaticReadOnlyRoot::kf_string,
    StaticReadOnlyRoot::kg_string,
    StaticReadOnlyRoot::kh_string,
    StaticReadOnlyRoot::ki_string,
    StaticReadOnlyRoot::kj_string,
    StaticReadOnlyRoot::kk_string,
    StaticReadOnlyRoot::kl_string,
    StaticReadOnlyRoot::km_string,
    StaticReadOnlyRoot::kn_string,
    StaticReadOnlyRoot::ko_string,
    StaticReadOnlyRoot::kp_string,
    StaticReadOnlyRoot::kq_string,
    StaticReadOnlyRoot::kr_string,
    StaticReadOnlyRoot::ks_string,
    StaticReadOnlyRoot::kt_string,
    StaticReadOnlyRoot::ku_string,
    StaticReadOnlyRoot::kv_string,
    StaticReadOnlyRoot::kw_string,
    StaticReadOnlyRoot::kx_string,
    StaticReadOnlyRoot::ky_string,
    StaticReadOnlyRoot::kz_string,
    StaticReadOnlyRoot::kopen_brace_string,
    StaticReadOnlyRoot::kpipe_string,
    StaticReadOnlyRoot::kclose_brace_string,
    StaticReadOnlyRoot::ktilde_string,
    StaticReadOnlyRoot::kascii_del_string,
    StaticReadOnlyRoot::klatin1_80_string,
    StaticReadOnlyRoot::klatin1_81_string,
    StaticReadOnlyRoot::klatin1_82_string,
    StaticReadOnlyRoot::klatin1_83_string,
    StaticReadOnlyRoot::klatin1_84_string,
    StaticReadOnlyRoot::klatin1_85_string,
    StaticReadOnlyRoot::klatin1_86_string,
    StaticReadOnlyRoot::klatin1_87_string,
    StaticReadOnlyRoot::klatin1_88_string,
    StaticReadOnlyRoot::klatin1_89_string,
    StaticReadOnlyRoot::klatin1_8a_string,
    StaticReadOnlyRoot::klatin1_8b_string,
    StaticReadOnlyRoot::klatin1_8c_string,
    StaticReadOnlyRoot::klatin1_8d_string,
    StaticReadOnlyRoot::klatin1_8e_string,
    StaticReadOnlyRoot::klatin1_8f_string,
    StaticReadOnlyRoot::klatin1_90_string,
    StaticReadOnlyRoot::klatin1_91_string,
    StaticReadOnlyRoot::klatin1_92_string,
    StaticReadOnlyRoot::klatin1_93_string,
    StaticReadOnlyRoot::klatin1_94_string,
    StaticReadOnlyRoot::klatin1_95_string,
    StaticReadOnlyRoot::klatin1_96_string,
    StaticReadOnlyRoot::klatin1_97_string,
    StaticReadOnlyRoot::klatin1_98_string,
    StaticReadOnlyRoot::klatin1_99_string,
    StaticReadOnlyRoot::klatin1_9a_string,
    StaticReadOnlyRoot::klatin1_9b_string,
    StaticReadOnlyRoot::klatin1_9c_string,
    StaticReadOnlyRoot::klatin1_9d_string,
    StaticReadOnlyRoot::klatin1_9e_string,
    StaticReadOnlyRoot::klatin1_9f_string,
    StaticReadOnlyRoot::klatin1_a0_string,
    StaticReadOnlyRoot::klatin1_a1_string,
    StaticReadOnlyRoot::klatin1_a2_string,
    StaticReadOnlyRoot::klatin1_a3_string,
    StaticReadOnlyRoot::klatin1_a4_string,
    StaticReadOnlyRoot::klatin1_a5_string,
    StaticReadOnlyRoot::klatin1_a6_string,
    StaticReadOnlyRoot::klatin1_a7_string,
    StaticReadOnlyRoot::klatin1_a8_string,
    StaticReadOnlyRoot::klatin1_a9_string,
    StaticReadOnlyRoot::klatin1_aa_string,
    StaticReadOnlyRoot::klatin1_ab_string,
    StaticReadOnlyRoot::klatin1_ac_string,
    StaticReadOnlyRoot::klatin1_ad_string,
    StaticReadOnlyRoot::klatin1_ae_string,
    StaticReadOnlyRoot::klatin1_af_string,
    StaticReadOnlyRoot::klatin1_b0_string,
    StaticReadOnlyRoot::klatin1_b1_string,
    StaticReadOnlyRoot::klatin1_b2_string,
    StaticReadOnlyRoot::klatin1_b3_string,
    StaticReadOnlyRoot::klatin1_b4_string,
    StaticReadOnlyRoot::klatin1_b5_string,
    StaticReadOnlyRoot::klatin1_b6_string,
    StaticReadOnlyRoot::klatin1_b7_string,
    StaticReadOnlyRoot::klatin1_b8_string,
    StaticReadOnlyRoot::klatin1_b9_string,
    StaticReadOnlyRoot::klatin1_ba_string,
    StaticReadOnlyRoot::klatin1_bb_string,
    StaticReadOnlyRoot::klatin1_bc_string,
    StaticReadOnlyRoot::klatin1_bd_string,
    StaticReadOnlyRoot::klatin1_be_string,
    StaticReadOnlyRoot::klatin1_bf_string,
    StaticReadOnlyRoot::klatin1_c0_string,
    StaticReadOnlyRoot::klatin1_c1_string,
    StaticReadOnlyRoot::klatin1_c2_string,
    StaticReadOnlyRoot::klatin1_c3_string,
    StaticReadOnlyRoot::klatin1_c4_string,
    StaticReadOnlyRoot::klatin1_c5_string,
    StaticReadOnlyRoot::klatin1_c6_string,
    StaticReadOnlyRoot::klatin1_c7_string,
    StaticReadOnlyRoot::klatin1_c8_string,
    StaticReadOnlyRoot::klatin1_c9_string,
    StaticReadOnlyRoot::klatin1_ca_string,
    StaticReadOnlyRoot::klatin1_cb_string,
    StaticReadOnlyRoot::klatin1_cc_string,
    StaticReadOnlyRoot::klatin1_cd_string,
    StaticReadOnlyRoot::klatin1_ce_string,
    StaticReadOnlyRoot::klatin1_cf_string,
    StaticReadOnlyRoot::klatin1_d0_string,
    StaticReadOnlyRoot::klatin1_d1_string,
    StaticReadOnlyRoot::klatin1_d2_string,
    StaticReadOnlyRoot::klatin1_d3_string,
    StaticReadOnlyRoot::klatin1_d4_string,
    StaticReadOnlyRoot::klatin1_d5_string,
    StaticReadOnlyRoot::klatin1_d6_string,
    StaticReadOnlyRoot::klatin1_d7_string,
    StaticReadOnlyRoot::klatin1_d8_string,
    StaticReadOnlyRoot::klatin1_d9_string,
    StaticReadOnlyRoot::klatin1_da_string,
    StaticReadOnlyRoot::klatin1_db_string,
    StaticReadOnlyRoot::klatin1_dc_string,
    StaticReadOnlyRoot::klatin1_dd_string,
    StaticReadOnlyRoot::klatin1_de_string,
    StaticReadOnlyRoot::klatin1_df_string,
    StaticReadOnlyRoot::klatin1_e0_string,
    StaticReadOnlyRoot::klatin1_e1_string,
    StaticReadOnlyRoot::klatin1_e2_string,
    StaticReadOnlyRoot::klatin1_e3_string,
    StaticReadOnlyRoot::klatin1_e4_string,
    StaticReadOnlyRoot::klatin1_e5_string,
    StaticReadOnlyRoot::klatin1_e6_string,
    StaticReadOnlyRoot::klatin1_e7_string,
    StaticReadOnlyRoot::klatin1_e8_string,
    StaticReadOnlyRoot::klatin1_e9_string,
    StaticReadOnlyRoot::klatin1_ea_string,
    StaticReadOnlyRoot::klatin1_eb_string,
    StaticReadOnlyRoot::klatin1_ec_string,
    StaticReadOnlyRoot::klatin1_ed_string,
    StaticReadOnlyRoot::klatin1_ee_string,
    StaticReadOnlyRoot::klatin1_ef_string,
    StaticReadOnlyRoot::klatin1_f0_string,
    StaticReadOnlyRoot::klatin1_f1_string,
    StaticReadOnlyRoot::klatin1_f2_string,
    StaticReadOnlyRoot::klatin1_f3_string,
    StaticReadOnlyRoot::klatin1_f4_string,
    StaticReadOnlyRoot::klatin1_f5_string,
    StaticReadOnlyRoot::klatin1_f6_string,
    StaticReadOnlyRoot::klatin1_f7_string,
    StaticReadOnlyRoot::klatin1_f8_string,
    StaticReadOnlyRoot::klatin1_f9_string,
    StaticReadOnlyRoot::klatin1_fa_string,
    StaticReadOnlyRoot::klatin1_fb_string,
    StaticReadOnlyRoot::klatin1_fc_string,
    StaticReadOnlyRoot::klatin1_fd_string,
    StaticReadOnlyRoot::klatin1_fe_string,
    StaticReadOnlyRoot::klatin1_ff_string,
    StaticReadOnlyRoot::kadd_string,
    StaticReadOnlyRoot::kAggregateError_string,
    StaticReadOnlyRoot::kalphabet_string,
    StaticReadOnlyRoot::kalways_string,
    StaticReadOnlyRoot::kanonymous_string,
    StaticReadOnlyRoot::kapply_string,
    StaticReadOnlyRoot::kArguments_string,
    StaticReadOnlyRoot::karguments_string,
    StaticReadOnlyRoot::karguments_to_string,
    StaticReadOnlyRoot::kArray_string,
    StaticReadOnlyRoot::karray_to_string,
    StaticReadOnlyRoot::kArrayBuffer_string,
    StaticReadOnlyRoot::kArrayIterator_string,
    StaticReadOnlyRoot::kas_string,
    StaticReadOnlyRoot::kassert_string,
    StaticReadOnlyRoot::kasync_string,
    StaticReadOnlyRoot::kAtomicsCondition_string,
    StaticReadOnlyRoot::kAtomicsMutex_string,
    StaticReadOnlyRoot::kauto_string,
    StaticReadOnlyRoot::kBigInt_string,
    StaticReadOnlyRoot::kbigint_string,
    StaticReadOnlyRoot::kBigInt64Array_string,
    StaticReadOnlyRoot::kBigUint64Array_string,
    StaticReadOnlyRoot::kbind_string,
    StaticReadOnlyRoot::kblank_string,
    StaticReadOnlyRoot::kBoolean_string,
    StaticReadOnlyRoot::kboolean_string,
    StaticReadOnlyRoot::kboolean_to_string,
    StaticReadOnlyRoot::kbound__string,
    StaticReadOnlyRoot::kbuffer_string,
    StaticReadOnlyRoot::kbyte_length_string,
    StaticReadOnlyRoot::kbyte_offset_string,
    StaticReadOnlyRoot::kCompileError_string,
    StaticReadOnlyRoot::kcalendar_string,
    StaticReadOnlyRoot::kcalendarId_string,
    StaticReadOnlyRoot::kcalendarName_string,
    StaticReadOnlyRoot::kcallee_string,
    StaticReadOnlyRoot::kcaller_string,
    StaticReadOnlyRoot::kcause_string,
    StaticReadOnlyRoot::kcharacter_string,
    StaticReadOnlyRoot::kcode_string,
    StaticReadOnlyRoot::kcolumn_string,
    StaticReadOnlyRoot::kcomputed_string,
    StaticReadOnlyRoot::kconjunction_string,
    StaticReadOnlyRoot::kconsole_string,
    StaticReadOnlyRoot::kconstrain_string,
    StaticReadOnlyRoot::kconstruct_string,
    StaticReadOnlyRoot::kcurrent_string,
    StaticReadOnlyRoot::kDate_string,
    StaticReadOnlyRoot::kdate_to_string,
    StaticReadOnlyRoot::kdateAdd_string,
    StaticReadOnlyRoot::kdateFromFields_string,
    StaticReadOnlyRoot::kdateUntil_string,
    StaticReadOnlyRoot::kday_string,
    StaticReadOnlyRoot::kdayOfWeek_string,
    StaticReadOnlyRoot::kdayOfYear_string,
    StaticReadOnlyRoot::kdays_string,
    StaticReadOnlyRoot::kdaysInMonth_string,
    StaticReadOnlyRoot::kdaysInWeek_string,
    StaticReadOnlyRoot::kdaysInYear_string,
    StaticReadOnlyRoot::kdefault_string,
    StaticReadOnlyRoot::kdefineProperty_string,
    StaticReadOnlyRoot::kdeleteProperty_string,
    StaticReadOnlyRoot::kdetached_string,
    StaticReadOnlyRoot::kdirection_string,
    StaticReadOnlyRoot::kdisambiguation_string,
    StaticReadOnlyRoot::kdisjunction_string,
    StaticReadOnlyRoot::kdisposed_string,
    StaticReadOnlyRoot::kdone_string,
    StaticReadOnlyRoot::kdot_brand_string,
    StaticReadOnlyRoot::kdot_catch_string,
    StaticReadOnlyRoot::kdot_default_string,
    StaticReadOnlyRoot::kdot_for_string,
    StaticReadOnlyRoot::kdot_generator_object_string,
    StaticReadOnlyRoot::kdot_home_object_string,
    StaticReadOnlyRoot::kdot_new_target_string,
    StaticReadOnlyRoot::kdot_result_string,
    StaticReadOnlyRoot::kdot_repl_result_string,
    StaticReadOnlyRoot::kdot_static_home_object_string,
    StaticReadOnlyRoot::kdot_switch_tag_string,
    StaticReadOnlyRoot::kdotAll_string,
    StaticReadOnlyRoot::kError_string,
    StaticReadOnlyRoot::kEvalError_string,
    StaticReadOnlyRoot::kelement_string,
    StaticReadOnlyRoot::kepochMilliseconds_string,
    StaticReadOnlyRoot::kepochNanoseconds_string,
    StaticReadOnlyRoot::kera_string,
    StaticReadOnlyRoot::keraYear_string,
    StaticReadOnlyRoot::kerror_string,
    StaticReadOnlyRoot::kerrors_string,
    StaticReadOnlyRoot::kerror_to_string,
    StaticReadOnlyRoot::keval_string,
    StaticReadOnlyRoot::kexception_string,
    StaticReadOnlyRoot::kexec_string,
    StaticReadOnlyRoot::kfalse_string,
    StaticReadOnlyRoot::kfields_string,
    StaticReadOnlyRoot::kFinalizationRegistry_string,
    StaticReadOnlyRoot::kflags_string,
    StaticReadOnlyRoot::kFloat16Array_string,
    StaticReadOnlyRoot::kFloat32Array_string,
    StaticReadOnlyRoot::kFloat64Array_string,
    StaticReadOnlyRoot::kfractionalSecondDigits_string,
    StaticReadOnlyRoot::kfrom_string,
    StaticReadOnlyRoot::kFunction_string,
    StaticReadOnlyRoot::kfunction_native_code_string,
    StaticReadOnlyRoot::kfunction_string,
    StaticReadOnlyRoot::kfunction_to_string,
    StaticReadOnlyRoot::kGenerator_string,
    StaticReadOnlyRoot::kget_space_string,
    StaticReadOnlyRoot::kget_string,
    StaticReadOnlyRoot::kgetOffsetNanosecondsFor_string,
    StaticReadOnlyRoot::kgetOwnPropertyDescriptor_string,
    StaticReadOnlyRoot::kgetPossibleInstantsFor_string,
    StaticReadOnlyRoot::kgetPrototypeOf_string,
    StaticReadOnlyRoot::kgetTimeZoneTransition_string,
    StaticReadOnlyRoot::kglobal_string,
    StaticReadOnlyRoot::kglobalThis_string,
    StaticReadOnlyRoot::kgroups_string,
    StaticReadOnlyRoot::kgrowable_string,
    StaticReadOnlyRoot::khas_string,
    StaticReadOnlyRoot::khasIndices_string,
    StaticReadOnlyRoot::khour_string,
    StaticReadOnlyRoot::khours_string,
    StaticReadOnlyRoot::khoursInDay_string,
    StaticReadOnlyRoot::kignoreCase_string,
    StaticReadOnlyRoot::kid_string,
    StaticReadOnlyRoot::killegal_access_string,
    StaticReadOnlyRoot::killegal_argument_string,
    StaticReadOnlyRoot::kinLeapYear_string,
    StaticReadOnlyRoot::kindex_string,
    StaticReadOnlyRoot::kindices_string,
    StaticReadOnlyRoot::kInfinity_string,
    StaticReadOnlyRoot::kinfinity_string,
    StaticReadOnlyRoot::kinput_string,
    StaticReadOnlyRoot::kinstance_members_initializer_string,
    StaticReadOnlyRoot::kInt16Array_string,
    StaticReadOnlyRoot::kInt32Array_string,
    StaticReadOnlyRoot::kInt8Array_string,
    StaticReadOnlyRoot::kisExtensible_string,
    StaticReadOnlyRoot::kiso8601_string,
    StaticReadOnlyRoot::kisoDay_string,
    StaticReadOnlyRoot::kisoHour_string,
    StaticReadOnlyRoot::kisoMicrosecond_string,
    StaticReadOnlyRoot::kisoMillisecond_string,
    StaticReadOnlyRoot::kisoMinute_string,
    StaticReadOnlyRoot::kisoMonth_string,
    StaticReadOnlyRoot::kisoNanosecond_string,
    StaticReadOnlyRoot::kisoSecond_string,
    StaticReadOnlyRoot::kisoYear_string,
    StaticReadOnlyRoot::kIterator_string,
    StaticReadOnlyRoot::kjsMemoryEstimate_string,
    StaticReadOnlyRoot::kjsMemoryRange_string,
    StaticReadOnlyRoot::kkeys_string,
    StaticReadOnlyRoot::klargestUnit_string,
    StaticReadOnlyRoot::klast_chunk_handling_string,
    StaticReadOnlyRoot::klastIndex_string,
    StaticReadOnlyRoot::klet_string,
    StaticReadOnlyRoot::kline_string,
    StaticReadOnlyRoot::klinear_string,
    StaticReadOnlyRoot::kLinkError_string,
    StaticReadOnlyRoot::klong_string,
    StaticReadOnlyRoot::kMap_string,
    StaticReadOnlyRoot::kMapIterator_string,
    StaticReadOnlyRoot::kmax_byte_length_string,
    StaticReadOnlyRoot::kmedium_string,
    StaticReadOnlyRoot::kmergeFields_string,
    StaticReadOnlyRoot::kmessage_string,
    StaticReadOnlyRoot::kmeta_string,
    StaticReadOnlyRoot::kminus_Infinity_string,
    StaticReadOnlyRoot::kmicrosecond_string,
    StaticReadOnlyRoot::kmicroseconds_string,
    StaticReadOnlyRoot::kmillisecond_string,
    StaticReadOnlyRoot::kmilliseconds_string,
    StaticReadOnlyRoot::kminute_string,
    StaticReadOnlyRoot::kminutes_string,
    StaticReadOnlyRoot::kModule_string,
    StaticReadOnlyRoot::kmonth_string,
    StaticReadOnlyRoot::kmonthDayFromFields_string,
    StaticReadOnlyRoot::kmonths_string,
    StaticReadOnlyRoot::kmonthsInYear_string,
    StaticReadOnlyRoot::kmonthCode_string,
    StaticReadOnlyRoot::kmultiline_string,
    StaticReadOnlyRoot::kNaN_string,
    StaticReadOnlyRoot::knanosecond_string,
    StaticReadOnlyRoot::knanoseconds_string,
    StaticReadOnlyRoot::knarrow_string,
    StaticReadOnlyRoot::knative_string,
    StaticReadOnlyRoot::knew_target_string,
    StaticReadOnlyRoot::kNFC_string,
    StaticReadOnlyRoot::kNFD_string,
    StaticReadOnlyRoot::kNFKC_string,
    StaticReadOnlyRoot::kNFKD_string,
    StaticReadOnlyRoot::knot_equal_string,
    StaticReadOnlyRoot::knull_string,
    StaticReadOnlyRoot::knull_to_string,
    StaticReadOnlyRoot::kNumber_string,
    StaticReadOnlyRoot::knumber_string,
    StaticReadOnlyRoot::knumber_to_string,
    StaticReadOnlyRoot::kObject_string,
    StaticReadOnlyRoot::kobject_string,
    StaticReadOnlyRoot::kobject_to_string,
    StaticReadOnlyRoot::kObject_prototype_string,
    StaticReadOnlyRoot::koffset_string,
    StaticReadOnlyRoot::koffsetNanoseconds_string,
    StaticReadOnlyRoot::kok_string,
    StaticReadOnlyRoot::kother_string,
    StaticReadOnlyRoot::koverflow_string,
    StaticReadOnlyRoot::kownKeys_string,
    StaticReadOnlyRoot::kpercent_string,
    StaticReadOnlyRoot::kplainDate_string,
    StaticReadOnlyRoot::kplainTime_string,
    StaticReadOnlyRoot::kposition_string,
    StaticReadOnlyRoot::kpreventExtensions_string,
    StaticReadOnlyRoot::kprivate_constructor_string,
    StaticReadOnlyRoot::kPromise_string,
    StaticReadOnlyRoot::kpromise_string,
    StaticReadOnlyRoot::kproto_string,
    StaticReadOnlyRoot::kproxy_string,
    StaticReadOnlyRoot::kProxy_string,
    StaticReadOnlyRoot::kquery_colon_string,
    StaticReadOnlyRoot::kRangeError_string,
    StaticReadOnlyRoot::kraw_json_string,
    StaticReadOnlyRoot::kraw_string,
    StaticReadOnlyRoot::kread_string,
    StaticReadOnlyRoot::kReferenceError_string,
    StaticReadOnlyRoot::kReflectGet_string,
    StaticReadOnlyRoot::kReflectHas_string,
    StaticReadOnlyRoot::kRegExp_string,
    StaticReadOnlyRoot::kregexp_to_string,
    StaticReadOnlyRoot::kreject_string,
    StaticReadOnlyRoot::krelativeTo_string,
    StaticReadOnlyRoot::kresizable_string,
    StaticReadOnlyRoot::kResizableArrayBuffer_string,
    StaticReadOnlyRoot::kreturn_string,
    StaticReadOnlyRoot::krevoke_string,
    StaticReadOnlyRoot::kroundingIncrement_string,
    StaticReadOnlyRoot::kroundingMode_string,
    StaticReadOnlyRoot::kRuntimeError_string,
    StaticReadOnlyRoot::kWebAssemblyException_string,
    StaticReadOnlyRoot::kWebAssemblyModule_string,
    StaticReadOnlyRoot::kScript_string,
    StaticReadOnlyRoot::kscript_string,
    StaticReadOnlyRoot::ksecond_string,
    StaticReadOnlyRoot::kseconds_string,
    StaticReadOnlyRoot::kshort_string,
    StaticReadOnlyRoot::kSet_string,
    StaticReadOnlyRoot::ksentence_string,
    StaticReadOnlyRoot::kset_space_string,
    StaticReadOnlyRoot::kset_string,
    StaticReadOnlyRoot::kSetIterator_string,
    StaticReadOnlyRoot::ksetPrototypeOf_string,
    StaticReadOnlyRoot::kShadowRealm_string,
    StaticReadOnlyRoot::kSharedArray_string,
    StaticReadOnlyRoot::kSharedArrayBuffer_string,
    StaticReadOnlyRoot::kSharedStruct_string,
    StaticReadOnlyRoot::ksign_string,
    StaticReadOnlyRoot::ksize_string,
    StaticReadOnlyRoot::ksmallestUnit_string,
    StaticReadOnlyRoot::ksource_string,
    StaticReadOnlyRoot::ksourceText_string,
    StaticReadOnlyRoot::kstack_string,
    StaticReadOnlyRoot::kstackTraceLimit_string,
    StaticReadOnlyRoot::kstatic_initializer_string,
    StaticReadOnlyRoot::ksticky_string,
    StaticReadOnlyRoot::kString_string,
    StaticReadOnlyRoot::kstring_string,
    StaticReadOnlyRoot::kstring_to_string,
    StaticReadOnlyRoot::ksuppressed_string,
    StaticReadOnlyRoot::kSuppressedError_string,
    StaticReadOnlyRoot::kSuspendError_string,
    StaticReadOnlyRoot::kSymbol_iterator_string,
    StaticReadOnlyRoot::kSymbol_match_all_string,
    StaticReadOnlyRoot::kSymbol_replace_string,
    StaticReadOnlyRoot::ksymbol_species_string,
    StaticReadOnlyRoot::kSymbol_species_string,
    StaticReadOnlyRoot::kSymbol_split_string,
    StaticReadOnlyRoot::kSymbol_string,
    StaticReadOnlyRoot::ksymbol_string,
    StaticReadOnlyRoot::kSyntaxError_string,
    StaticReadOnlyRoot::ktarget_string,
    StaticReadOnlyRoot::kthis_function_string,
    StaticReadOnlyRoot::kthis_string,
    StaticReadOnlyRoot::kthrow_string,
    StaticReadOnlyRoot::ktimed_out_string,
    StaticReadOnlyRoot::ktimeZone_string,
    StaticReadOnlyRoot::ktimeZoneId_string,
    StaticReadOnlyRoot::ktoJSON_string,
    StaticReadOnlyRoot::ktoString_string,
    StaticReadOnlyRoot::ktrue_string,
    StaticReadOnlyRoot::ktotal_string,
    StaticReadOnlyRoot::kTypedArrayLength_string,
    StaticReadOnlyRoot::kTypeError_string,
    StaticReadOnlyRoot::kUint16Array_string,
    StaticReadOnlyRoot::kUint32Array_string,
    StaticReadOnlyRoot::kUint8Array_string,
    StaticReadOnlyRoot::kUint8ClampedArray_string,
    StaticReadOnlyRoot::kundefined_string,
    StaticReadOnlyRoot::kundefined_to_string,
    StaticReadOnlyRoot::kunicode_string,
    StaticReadOnlyRoot::kunicodeSets_string,
    StaticReadOnlyRoot::kunit_string,
    StaticReadOnlyRoot::kURIError_string,
    StaticReadOnlyRoot::kUTC_string,
    StaticReadOnlyRoot::kWeakMap_string,
    StaticReadOnlyRoot::kWeakRef_string,
    StaticReadOnlyRoot::kWeakSet_string,
    StaticReadOnlyRoot::kweek_string,
    StaticReadOnlyRoot::kweeks_string,
    StaticReadOnlyRoot::kweekOfYear_string,
    StaticReadOnlyRoot::kwith_string,
    StaticReadOnlyRoot::kword_string,
    StaticReadOnlyRoot::kwritten_string,
    StaticReadOnlyRoot::kyearMonthFromFields_string,
    StaticReadOnlyRoot::kyear_string,
    StaticReadOnlyRoot::kyears_string,
    StaticReadOnlyRoot::kyearOfWeek_string,
    StaticReadOnlyRoot::knot_mapped_symbol,
    StaticReadOnlyRoot::kuninitialized_symbol,
    StaticReadOnlyRoot::kmegamorphic_symbol,
    StaticReadOnlyRoot::kelements_transition_symbol,
    StaticReadOnlyRoot::kmega_dom_symbol,
    StaticReadOnlyRoot::karray_buffer_wasm_memory_symbol,
    StaticReadOnlyRoot::kcall_site_info_symbol,
    StaticReadOnlyRoot::kclass_fields_symbol,
    StaticReadOnlyRoot::kclass_positions_symbol,
    StaticReadOnlyRoot::kerror_end_pos_symbol,
    StaticReadOnlyRoot::kerror_message_symbol,
    StaticReadOnlyRoot::kerror_script_symbol,
    StaticReadOnlyRoot::kerror_stack_symbol,
    StaticReadOnlyRoot::kerror_start_pos_symbol,
    StaticReadOnlyRoot::kfrozen_symbol,
    StaticReadOnlyRoot::kinterpreter_trampoline_symbol,
    StaticReadOnlyRoot::knative_context_index_symbol,
    StaticReadOnlyRoot::knonextensible_symbol,
    StaticReadOnlyRoot::kpromise_debug_message_symbol,
    StaticReadOnlyRoot::kpromise_forwarding_handler_symbol,
    StaticReadOnlyRoot::kpromise_handled_by_symbol,
    StaticReadOnlyRoot::kpromise_awaited_by_symbol,
    StaticReadOnlyRoot::kregexp_result_names_symbol,
    StaticReadOnlyRoot::kregexp_result_regexp_input_symbol,
    StaticReadOnlyRoot::kregexp_result_regexp_last_index_symbol,
    StaticReadOnlyRoot::ksealed_symbol,
    StaticReadOnlyRoot::kshared_struct_map_elements_template_symbol,
    StaticReadOnlyRoot::kshared_struct_map_registry_key_symbol,
    StaticReadOnlyRoot::kstrict_function_transition_symbol,
    StaticReadOnlyRoot::ktemplate_literal_function_literal_id_symbol,
    StaticReadOnlyRoot::ktemplate_literal_slot_id_symbol,
    StaticReadOnlyRoot::kwasm_cross_instance_call_symbol,
    StaticReadOnlyRoot::kwasm_exception_tag_symbol,
    StaticReadOnlyRoot::kwasm_exception_values_symbol,
    StaticReadOnlyRoot::kwasm_uncatchable_symbol,
    StaticReadOnlyRoot::kwasm_debug_proxy_cache_symbol,
    StaticReadOnlyRoot::kwasm_debug_proxy_names_symbol,
    StaticReadOnlyRoot::kasync_iterator_symbol,
    StaticReadOnlyRoot::kintl_fallback_symbol,
    StaticReadOnlyRoot::kmatch_symbol,
    StaticReadOnlyRoot::ksearch_symbol,
    StaticReadOnlyRoot::kunscopables_symbol,
    StaticReadOnlyRoot::kdispose_symbol,
    StaticReadOnlyRoot::kasync_dispose_symbol,
    StaticReadOnlyRoot::khas_instance_symbol,
    StaticReadOnlyRoot::kto_string_tag_symbol,
    StaticReadOnlyRoot::kPromiseFulfillReactionJobTaskMap,
    StaticReadOnlyRoot::kPromiseRejectReactionJobTaskMap,
    StaticReadOnlyRoot::kCallableTaskMap,
    StaticReadOnlyRoot::kCallbackTaskMap,
    StaticReadOnlyRoot::kPromiseResolveThenableJobTaskMap,
    StaticReadOnlyRoot::kAccessCheckInfoMap,
    StaticReadOnlyRoot::kAccessorPairMap,
    StaticReadOnlyRoot::kAliasedArgumentsEntryMap,
    StaticReadOnlyRoot::kAllocationMementoMap,
    StaticReadOnlyRoot::kArrayBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kAsyncGeneratorRequestMap,
    StaticReadOnlyRoot::kBreakPointMap,
    StaticReadOnlyRoot::kBreakPointInfoMap,
    StaticReadOnlyRoot::kBytecodeWrapperMap,
    StaticReadOnlyRoot::kCallSiteInfoMap,
    StaticReadOnlyRoot::kClassBoilerplateMap,
    StaticReadOnlyRoot::kClassPositionsMap,
    StaticReadOnlyRoot::kCodeWrapperMap,
    StaticReadOnlyRoot::kDebugInfoMap,
    StaticReadOnlyRoot::kEnumCacheMap,
    StaticReadOnlyRoot::kErrorStackDataMap,
    StaticReadOnlyRoot::kFunctionTemplateRareDataMap,
    StaticReadOnlyRoot::kModuleRequestMap,
    StaticReadOnlyRoot::kPromiseCapabilityMap,
    StaticReadOnlyRoot::kPromiseReactionMap,
    StaticReadOnlyRoot::kPropertyDescriptorObjectMap,
    StaticReadOnlyRoot::kPrototypeInfoMap,
    StaticReadOnlyRoot::kRegExpBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kRegExpDataWrapperMap,
    StaticReadOnlyRoot::kScriptMap,
    StaticReadOnlyRoot::kScriptOrModuleMap,
    StaticReadOnlyRoot::kSourceTextModuleInfoEntryMap,
    StaticReadOnlyRoot::kStackFrameInfoMap,
    StaticReadOnlyRoot::kStackTraceInfoMap,
    StaticReadOnlyRoot::kTemplateObjectDescriptionMap,
    StaticReadOnlyRoot::kTuple2Map,
    StaticReadOnlyRoot::kFunctionTemplateInfoMap,
    StaticReadOnlyRoot::kSloppyArgumentsElementsMap,
    StaticReadOnlyRoot::kDescriptorArrayMap,
    StaticReadOnlyRoot::kStrongDescriptorArrayMap,
    StaticReadOnlyRoot::kOnHeapBasicBlockProfilerDataMap,
    StaticReadOnlyRoot::kObjectTemplateInfoMap,
    StaticReadOnlyRoot::kTurbofanBitsetTypeMap,
    StaticReadOnlyRoot::kTurbofanUnionTypeMap,
    StaticReadOnlyRoot::kTurbofanRangeTypeMap,
    StaticReadOnlyRoot::kTurbofanHeapConstantTypeMap,
    StaticReadOnlyRoot::kTurbofanOtherNumberConstantTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32TypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32SetTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64TypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64SetTypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64TypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64SetTypeMap,
    StaticReadOnlyRoot::kInternalClassMap,
    StaticReadOnlyRoot::kSmiPairMap,
    StaticReadOnlyRoot::kSmiBoxMap,
    StaticReadOnlyRoot::kExportedSubClassBaseMap,
    StaticReadOnlyRoot::kExportedSubClassMap,
    StaticReadOnlyRoot::kAbstractInternalClassSubclass1Map,
    StaticReadOnlyRoot::kAbstractInternalClassSubclass2Map,
    StaticReadOnlyRoot::kInternalClassWithStructElementsMap,
    StaticReadOnlyRoot::kExportedSubClass2Map,
    StaticReadOnlyRoot::kSortStateMap,
    StaticReadOnlyRoot::kAllocationSiteWithWeakNextMap,
    StaticReadOnlyRoot::kAllocationSiteWithoutWeakNextMap,
    StaticReadOnlyRoot::kconstructor_string,
    StaticReadOnlyRoot::knext_string,
    StaticReadOnlyRoot::kresolve_string,
    StaticReadOnlyRoot::kthen_string,
    StaticReadOnlyRoot::kvalueOf_string,
    StaticReadOnlyRoot::kiterator_symbol,
    StaticReadOnlyRoot::kmatch_all_symbol,
    StaticReadOnlyRoot::kreplace_symbol,
    StaticReadOnlyRoot::kspecies_symbol,
    StaticReadOnlyRoot::ksplit_symbol,
    StaticReadOnlyRoot::kto_primitive_symbol,
    StaticReadOnlyRoot::kis_concat_spreadable_symbol,
    StaticReadOnlyRoot::kLoadHandler1Map,
    StaticReadOnlyRoot::kLoadHandler2Map,
    StaticReadOnlyRoot::kLoadHandler3Map,
    StaticReadOnlyRoot::kStoreHandler0Map,
    StaticReadOnlyRoot::kStoreHandler1Map,
    StaticReadOnlyRoot::kStoreHandler2Map,
    StaticReadOnlyRoot::kStoreHandler3Map,
    StaticReadOnlyRoot::kExternalMap,
    StaticReadOnlyRoot::kJSMessageObjectMap,
    StaticReadOnlyRoot::kCppHeapExternalMap,
};

}  // namespace internal
}  // namespace v8
#endif  // V8_STATIC_ROOTS_BOOL
#endif  // V8_ROOTS_STATIC_ROOTS_INTL_NOWASM_H_
