/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.5
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_adv.h"
        #include <wx/aboutdlg.h>
        #include <wx/icon.h>


PyDoc_STRVAR(doc_wxAboutDialogInfo_AddArtist, "AddArtist(artist)\n"
"\n"
"Adds an artist name to be shown in the program credits.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_AddArtist(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_AddArtist(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* artist;
        int artistState = 0;
        ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_artist,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString, &artist, &artistState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddArtist(*artist);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(artist), sipType_wxString, artistState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_AddArtist, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_AddDeveloper, "AddDeveloper(developer)\n"
"\n"
"Adds a developer name to be shown in the program credits.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_AddDeveloper(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_AddDeveloper(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* developer;
        int developerState = 0;
        ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_developer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString, &developer, &developerState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddDeveloper(*developer);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(developer), sipType_wxString, developerState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_AddDeveloper, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_AddDocWriter, "AddDocWriter(docwriter)\n"
"\n"
"Adds a documentation writer name to be shown in the program credits.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_AddDocWriter(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_AddDocWriter(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* docwriter;
        int docwriterState = 0;
        ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_docwriter,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString, &docwriter, &docwriterState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddDocWriter(*docwriter);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(docwriter), sipType_wxString, docwriterState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_AddDocWriter, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_AddTranslator, "AddTranslator(translator)\n"
"\n"
"Adds a translator name to be shown in the program credits.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_AddTranslator(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_AddTranslator(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* translator;
        int translatorState = 0;
        ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_translator,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString, &translator, &translatorState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddTranslator(*translator);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(translator), sipType_wxString, translatorState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_AddTranslator, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetName, "GetName() -> String\n"
"\n"
"Get the name of the program.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetName(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_HasDescription, "HasDescription() -> bool\n"
"\n"
"Returns true if a description string has been specified.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_HasDescription(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_HasDescription(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasDescription();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_HasDescription, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetDescription, "GetDescription() -> String\n"
"\n"
"Get the description string.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetDescription(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetDescription(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetDescription());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetDescription, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_HasCopyright, "HasCopyright() -> bool\n"
"\n"
"Returns true if a copyright string has been specified.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_HasCopyright(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_HasCopyright(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasCopyright();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_HasCopyright, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetCopyright, "GetCopyright() -> String\n"
"\n"
"Get the copyright string.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetCopyright(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetCopyright(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetCopyright());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetCopyright, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetArtists, "SetArtists(artists)\n"
"\n"
"Sets the list of artists to be shown in the program credits.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetArtists(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetArtists(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxArrayString* artists;
        int artistsState = 0;
        ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_artists,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxArrayString, &artists, &artistsState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetArtists(*artists);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxArrayString *>(artists), sipType_wxArrayString, artistsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetArtists, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetCopyright, "SetCopyright(copyright)\n"
"\n"
"Set the short string containing the program copyright information.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetCopyright(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetCopyright(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* copyright;
        int copyrightState = 0;
        ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_copyright,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString, &copyright, &copyrightState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetCopyright(*copyright);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(copyright), sipType_wxString, copyrightState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetCopyright, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetDescription, "SetDescription(desc)\n"
"\n"
"Set brief, but possibly multiline, description of the program.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetDescription(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetDescription(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* desc;
        int descState = 0;
        ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_desc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString, &desc, &descState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDescription(*desc);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(desc), sipType_wxString, descState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetDescription, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetDevelopers, "SetDevelopers(developers)\n"
"\n"
"Set the list of developers of the program.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetDevelopers(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetDevelopers(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxArrayString* developers;
        int developersState = 0;
        ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_developers,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxArrayString, &developers, &developersState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDevelopers(*developers);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxArrayString *>(developers), sipType_wxArrayString, developersState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetDevelopers, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetDocWriters, "SetDocWriters(docwriters)\n"
"\n"
"Set the list of documentation writers.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetDocWriters(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetDocWriters(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxArrayString* docwriters;
        int docwritersState = 0;
        ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_docwriters,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxArrayString, &docwriters, &docwritersState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDocWriters(*docwriters);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxArrayString *>(docwriters), sipType_wxArrayString, docwritersState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetDocWriters, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_HasIcon, "HasIcon() -> bool\n"
"\n"
"Returns true if an icon has been set for the about dialog.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_HasIcon(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_HasIcon(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasIcon();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_HasIcon, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetIcon, "GetIcon() -> wx.Icon\n"
"\n"
"Returns the icon set by SetIcon().");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetIcon(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetIcon(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            ::wxIcon*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxIcon(sipCpp->GetIcon());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxIcon, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetIcon, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetIcon, "SetIcon(icon)\n"
"\n"
"Set the icon to be shown in the dialog.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetIcon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetIcon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxIcon* icon;
        ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_icon,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxIcon, &icon))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetIcon(*icon);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetIcon, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_HasLicence, "HasLicence() -> bool\n"
"\n"
"Returns true if the licence string has been set.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_HasLicence(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_HasLicence(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasLicence();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_HasLicence, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetLicence, "GetLicence() -> String\n"
"\n"
"Returns the licence string.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetLicence(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetLicence(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetLicence());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetLicence, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetLicence, "SetLicence(licence)\n"
"\n"
"Set the long, multiline string containing the text of the program\n"
"licence.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetLicence(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetLicence(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* licence;
        int licenceState = 0;
        ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_licence,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString, &licence, &licenceState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLicence(*licence);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(licence), sipType_wxString, licenceState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetLicence, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetLicense, "SetLicense(licence)\n"
"\n"
"This is the same as SetLicence().");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetLicense(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetLicense(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* licence;
        int licenceState = 0;
        ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_licence,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString, &licence, &licenceState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLicense(*licence);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(licence), sipType_wxString, licenceState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetLicense, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetName, "SetName(name)\n"
"\n"
"Set the name of the program.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* name;
        int nameState = 0;
        ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString, &name, &nameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetName(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetTranslators, "SetTranslators(translators)\n"
"\n"
"Set the list of translators.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetTranslators(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetTranslators(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxArrayString* translators;
        int translatorsState = 0;
        ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_translators,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxArrayString, &translators, &translatorsState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTranslators(*translators);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxArrayString *>(translators), sipType_wxArrayString, translatorsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetTranslators, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetVersion, "SetVersion(version, longVersion=\"\")\n"
"\n"
"Set the version of the program.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetVersion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetVersion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* version;
        int versionState = 0;
        const ::wxString& longVersiondef = wxString();
        const ::wxString* longVersion = &longVersiondef;
        int longVersionState = 0;
        ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_version,
            sipName_longVersion,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|J1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString, &version, &versionState, sipType_wxString, &longVersion, &longVersionState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetVersion(*version, *longVersion);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(version), sipType_wxString, versionState);
            sipReleaseType(const_cast<::wxString *>(longVersion), sipType_wxString, longVersionState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetVersion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetVersion, "GetVersion() -> String\n"
"\n"
"Return the short version string.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetVersion(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetVersion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetVersion());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetVersion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetLongVersion, "GetLongVersion() -> String\n"
"\n"
"Return the long version string if set.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetLongVersion(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetLongVersion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetLongVersion());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetLongVersion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_HasWebSite, "HasWebSite() -> bool\n"
"\n"
"Returns true if the website info has been set.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_HasWebSite(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_HasWebSite(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasWebSite();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_HasWebSite, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetWebSiteURL, "GetWebSiteURL() -> String\n"
"\n"
"Returns the website URL set for the dialog.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetWebSiteURL(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetWebSiteURL(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetWebSiteURL());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetWebSiteURL, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetWebSiteDescription, "GetWebSiteDescription() -> String\n"
"\n"
"Returns the description of the website URL set for the dialog.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetWebSiteDescription(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetWebSiteDescription(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetWebSiteDescription());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetWebSiteDescription, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_SetWebSite, "SetWebSite(url, desc=wx.EmptyString)\n"
"\n"
"Set the web site for the program and its description (which defaults\n"
"to url itself if empty).");

extern "C" {static PyObject *meth_wxAboutDialogInfo_SetWebSite(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_SetWebSite(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* url;
        int urlState = 0;
        const ::wxString& descdef = wxEmptyString;
        const ::wxString* desc = &descdef;
        int descState = 0;
        ::wxAboutDialogInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_url,
            sipName_desc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|J1", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp, sipType_wxString, &url, &urlState, sipType_wxString, &desc, &descState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetWebSite(*url, *desc);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(url), sipType_wxString, urlState);
            sipReleaseType(const_cast<::wxString *>(desc), sipType_wxString, descState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_SetWebSite, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_HasDevelopers, "HasDevelopers() -> bool\n"
"\n"
"Returns true if developers have been set in the dialog info.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_HasDevelopers(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_HasDevelopers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasDevelopers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_HasDevelopers, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetDevelopers, "GetDevelopers() -> ArrayString\n"
"\n"
"Returns an array of the developer strings set in the dialog info.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetDevelopers(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetDevelopers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxArrayString(sipCpp->GetDevelopers());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxArrayString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetDevelopers, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_HasDocWriters, "HasDocWriters() -> bool\n"
"\n"
"Returns true if writers have been set in the dialog info.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_HasDocWriters(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_HasDocWriters(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasDocWriters();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_HasDocWriters, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetDocWriters, "GetDocWriters() -> ArrayString\n"
"\n"
"Returns an array of the writer strings set in the dialog info.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetDocWriters(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetDocWriters(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxArrayString(sipCpp->GetDocWriters());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxArrayString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetDocWriters, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_HasArtists, "HasArtists() -> bool\n"
"\n"
"Returns true if artists have been set in the dialog info.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_HasArtists(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_HasArtists(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasArtists();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_HasArtists, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetArtists, "GetArtists() -> ArrayString\n"
"\n"
"Returns an array of the artist strings set in the dialog info.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetArtists(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetArtists(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxArrayString(sipCpp->GetArtists());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxArrayString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetArtists, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_HasTranslators, "HasTranslators() -> bool\n"
"\n"
"Returns true if translators have been set in the dialog info.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_HasTranslators(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_HasTranslators(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasTranslators();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_HasTranslators, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAboutDialogInfo_GetTranslators, "GetTranslators() -> ArrayString\n"
"\n"
"Returns an array of the translator strings set in the dialog info.");

extern "C" {static PyObject *meth_wxAboutDialogInfo_GetTranslators(PyObject *, PyObject *);}
static PyObject *meth_wxAboutDialogInfo_GetTranslators(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAboutDialogInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAboutDialogInfo, &sipCpp))
        {
            ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxArrayString(sipCpp->GetTranslators());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxArrayString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AboutDialogInfo, sipName_GetTranslators, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxAboutDialogInfo(void *, int);}
static void release_wxAboutDialogInfo(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<::wxAboutDialogInfo *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxAboutDialogInfo(Py_ssize_t);}
static void *array_wxAboutDialogInfo(Py_ssize_t sipNrElem)
{
    return new ::wxAboutDialogInfo[sipNrElem];
}


extern "C" {static void assign_wxAboutDialogInfo(void *, Py_ssize_t, void *);}
static void assign_wxAboutDialogInfo(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<::wxAboutDialogInfo *>(sipDst)[sipDstIdx] = *reinterpret_cast<::wxAboutDialogInfo *>(sipSrc);
}


extern "C" {static void *copy_wxAboutDialogInfo(const void *, Py_ssize_t);}
static void *copy_wxAboutDialogInfo(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxAboutDialogInfo(reinterpret_cast<const ::wxAboutDialogInfo *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxAboutDialogInfo(sipSimpleWrapper *);}
static void dealloc_wxAboutDialogInfo(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxAboutDialogInfo(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxAboutDialogInfo(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxAboutDialogInfo(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxAboutDialogInfo *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxAboutDialogInfo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxAboutDialogInfo* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxAboutDialogInfo, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxAboutDialogInfo(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxAboutDialogInfo[] = {
    {sipName_AddArtist, SIP_MLMETH_CAST(meth_wxAboutDialogInfo_AddArtist), METH_VARARGS|METH_KEYWORDS, doc_wxAboutDialogInfo_AddArtist},
    {sipName_AddDeveloper, SIP_MLMETH_CAST(meth_wxAboutDialogInfo_AddDeveloper), METH_VARARGS|METH_KEYWORDS, doc_wxAboutDialogInfo_AddDeveloper},
    {sipName_AddDocWriter, SIP_MLMETH_CAST(meth_wxAboutDialogInfo_AddDocWriter), METH_VARARGS|METH_KEYWORDS, doc_wxAboutDialogInfo_AddDocWriter},
    {sipName_AddTranslator, SIP_MLMETH_CAST(meth_wxAboutDialogInfo_AddTranslator), METH_VARARGS|METH_KEYWORDS, doc_wxAboutDialogInfo_AddTranslator},
    {sipName_GetArtists, meth_wxAboutDialogInfo_GetArtists, METH_VARARGS, doc_wxAboutDialogInfo_GetArtists},
    {sipName_GetCopyright, meth_wxAboutDialogInfo_GetCopyright, METH_VARARGS, doc_wxAboutDialogInfo_GetCopyright},
    {sipName_GetDescription, meth_wxAboutDialogInfo_GetDescription, METH_VARARGS, doc_wxAboutDialogInfo_GetDescription},
    {sipName_GetDevelopers, meth_wxAboutDialogInfo_GetDevelopers, METH_VARARGS, doc_wxAboutDialogInfo_GetDevelopers},
    {sipName_GetDocWriters, meth_wxAboutDialogInfo_GetDocWriters, METH_VARARGS, doc_wxAboutDialogInfo_GetDocWriters},
    {sipName_GetIcon, meth_wxAboutDialogInfo_GetIcon, METH_VARARGS, doc_wxAboutDialogInfo_GetIcon},
    {sipName_GetLicence, meth_wxAboutDialogInfo_GetLicence, METH_VARARGS, doc_wxAboutDialogInfo_GetLicence},
    {sipName_GetLongVersion, meth_wxAboutDialogInfo_GetLongVersion, METH_VARARGS, doc_wxAboutDialogInfo_GetLongVersion},
    {sipName_GetName, meth_wxAboutDialogInfo_GetName, METH_VARARGS, doc_wxAboutDialogInfo_GetName},
    {sipName_GetTranslators, meth_wxAboutDialogInfo_GetTranslators, METH_VARARGS, doc_wxAboutDialogInfo_GetTranslators},
    {sipName_GetVersion, meth_wxAboutDialogInfo_GetVersion, METH_VARARGS, doc_wxAboutDialogInfo_GetVersion},
    {sipName_GetWebSiteDescription, meth_wxAboutDialogInfo_GetWebSiteDescription, METH_VARARGS, doc_wxAboutDialogInfo_GetWebSiteDescription},
    {sipName_GetWebSiteURL, meth_wxAboutDialogInfo_GetWebSiteURL, METH_VARARGS, doc_wxAboutDialogInfo_GetWebSiteURL},
    {sipName_HasArtists, meth_wxAboutDialogInfo_HasArtists, METH_VARARGS, doc_wxAboutDialogInfo_HasArtists},
    {sipName_HasCopyright, meth_wxAboutDialogInfo_HasCopyright, METH_VARARGS, doc_wxAboutDialogInfo_HasCopyright},
    {sipName_HasDescription, meth_wxAboutDialogInfo_HasDescription, METH_VARARGS, doc_wxAboutDialogInfo_HasDescription},
    {sipName_HasDevelopers, meth_wxAboutDialogInfo_HasDevelopers, METH_VARARGS, doc_wxAboutDialogInfo_HasDevelopers},
    {sipName_HasDocWriters, meth_wxAboutDialogInfo_HasDocWriters, METH_VARARGS, doc_wxAboutDialogInfo_HasDocWriters},
    {sipName_HasIcon, meth_wxAboutDialogInfo_HasIcon, METH_VARARGS, doc_wxAboutDialogInfo_HasIcon},
    {sipName_HasLicence, meth_wxAboutDialogInfo_HasLicence, METH_VARARGS, doc_wxAboutDialogInfo_HasLicence},
    {sipName_HasTranslators, meth_wxAboutDialogInfo_HasTranslators, METH_VARARGS, doc_wxAboutDialogInfo_HasTranslators},
    {sipName_HasWebSite, meth_wxAboutDialogInfo_HasWebSite, METH_VARARGS, doc_wxAboutDialogInfo_HasWebSite},
    {sipName_SetArtists, SIP_MLMETH_CAST(meth_wxAboutDialogInfo_SetArtists), METH_VARARGS|METH_KEYWORDS, doc_wxAboutDialogInfo_SetArtists},
    {sipName_SetCopyright, SIP_MLMETH_CAST(meth_wxAboutDialogInfo_SetCopyright), METH_VARARGS|METH_KEYWORDS, doc_wxAboutDialogInfo_SetCopyright},
    {sipName_SetDescription, SIP_MLMETH_CAST(meth_wxAboutDialogInfo_SetDescription), METH_VARARGS|METH_KEYWORDS, doc_wxAboutDialogInfo_SetDescription},
    {sipName_SetDevelopers, SIP_MLMETH_CAST(meth_wxAboutDialogInfo_SetDevelopers), METH_VARARGS|METH_KEYWORDS, doc_wxAboutDialogInfo_SetDevelopers},
    {sipName_SetDocWriters, SIP_MLMETH_CAST(meth_wxAboutDialogInfo_SetDocWriters), METH_VARARGS|METH_KEYWORDS, doc_wxAboutDialogInfo_SetDocWriters},
    {sipName_SetIcon, SIP_MLMETH_CAST(meth_wxAboutDialogInfo_SetIcon), METH_VARARGS|METH_KEYWORDS, doc_wxAboutDialogInfo_SetIcon},
    {sipName_SetLicence, SIP_MLMETH_CAST(meth_wxAboutDialogInfo_SetLicence), METH_VARARGS|METH_KEYWORDS, doc_wxAboutDialogInfo_SetLicence},
    {sipName_SetLicense, SIP_MLMETH_CAST(meth_wxAboutDialogInfo_SetLicense), METH_VARARGS|METH_KEYWORDS, doc_wxAboutDialogInfo_SetLicense},
    {sipName_SetName, SIP_MLMETH_CAST(meth_wxAboutDialogInfo_SetName), METH_VARARGS|METH_KEYWORDS, doc_wxAboutDialogInfo_SetName},
    {sipName_SetTranslators, SIP_MLMETH_CAST(meth_wxAboutDialogInfo_SetTranslators), METH_VARARGS|METH_KEYWORDS, doc_wxAboutDialogInfo_SetTranslators},
    {sipName_SetVersion, SIP_MLMETH_CAST(meth_wxAboutDialogInfo_SetVersion), METH_VARARGS|METH_KEYWORDS, doc_wxAboutDialogInfo_SetVersion},
    {sipName_SetWebSite, SIP_MLMETH_CAST(meth_wxAboutDialogInfo_SetWebSite), METH_VARARGS|METH_KEYWORDS, doc_wxAboutDialogInfo_SetWebSite}
};

sipVariableDef variables_wxAboutDialogInfo[] = {
    {PropertyVariable, sipName_WebSiteURL, &methods_wxAboutDialogInfo[16], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_WebSiteDescription, &methods_wxAboutDialogInfo[15], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Version, &methods_wxAboutDialogInfo[14], &methods_wxAboutDialogInfo[36], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Translators, &methods_wxAboutDialogInfo[13], &methods_wxAboutDialogInfo[35], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Name, &methods_wxAboutDialogInfo[12], &methods_wxAboutDialogInfo[34], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LongVersion, &methods_wxAboutDialogInfo[11], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Licence, &methods_wxAboutDialogInfo[10], &methods_wxAboutDialogInfo[32], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Icon, &methods_wxAboutDialogInfo[9], &methods_wxAboutDialogInfo[31], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_DocWriters, &methods_wxAboutDialogInfo[8], &methods_wxAboutDialogInfo[30], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Developers, &methods_wxAboutDialogInfo[7], &methods_wxAboutDialogInfo[29], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Description, &methods_wxAboutDialogInfo[6], &methods_wxAboutDialogInfo[28], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Copyright, &methods_wxAboutDialogInfo[5], &methods_wxAboutDialogInfo[27], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Artists, &methods_wxAboutDialogInfo[4], &methods_wxAboutDialogInfo[26], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxAboutDialogInfo, "AboutDialogInfo()\n"
"\n"
"wxAboutDialogInfo contains information shown in the standard About\n"
"dialog displayed by the wxAboutBox() function.");


sipClassTypeDef sipTypeDef__adv_wxAboutDialogInfo = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxAboutDialogInfo,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_AboutDialogInfo,
        {0, 0, 1},
        38, methods_wxAboutDialogInfo,
        0, SIP_NULLPTR,
        13, variables_wxAboutDialogInfo,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxAboutDialogInfo,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxAboutDialogInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxAboutDialogInfo,
    assign_wxAboutDialogInfo,
    array_wxAboutDialogInfo,
    copy_wxAboutDialogInfo,
    release_wxAboutDialogInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
