/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.5
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/vscroll.h>
        #include <wx/window.h>


class sipwxVarVScrollHelper : public ::wxVarVScrollHelper
{
public:
    sipwxVarVScrollHelper(::wxWindow*);
    sipwxVarVScrollHelper(const ::wxVarVScrollHelper&);
    virtual ~sipwxVarVScrollHelper();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    void sipProtectVirt_OnGetRowsHeightHint(bool, size_t, size_t) const;
    ::wxCoord sipProtectVirt_EstimateTotalHeight(bool) const;
    ::wxCoord sipProtect_OnGetRowHeight(size_t) const;
    void sipProtectVirt_OnGetUnitsSizeHint(bool, size_t, size_t) const;
    ::wxCoord sipProtectVirt_EstimateTotalSize(bool) const;
    int sipProtectVirt_GetNonOrientationTargetSize(bool) const;
    ::wxOrientation sipProtectVirt_GetOrientation(bool) const;
    int sipProtectVirt_GetOrientationTargetSize(bool) const;
    ::wxCoord sipProtectVirt_OnGetUnitSize(bool, size_t) const;

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::wxCoord OnGetRowHeight(size_t) const SIP_OVERRIDE;
    ::wxCoord EstimateTotalHeight() const SIP_OVERRIDE;
    void OnGetRowsHeightHint(size_t, size_t) const SIP_OVERRIDE;
    bool ScrollRows(int) SIP_OVERRIDE;
    bool ScrollRowPages(int) SIP_OVERRIDE;
    void RefreshRows(size_t, size_t) SIP_OVERRIDE;
    void RefreshRow(size_t) SIP_OVERRIDE;
    int GetNonOrientationTargetSize() const SIP_OVERRIDE;
    ::wxOrientation GetOrientation() const SIP_OVERRIDE;
    int GetOrientationTargetSize() const SIP_OVERRIDE;
    void OnGetUnitsSizeHint(size_t, size_t) const SIP_OVERRIDE;
    ::wxCoord EstimateTotalSize() const SIP_OVERRIDE;
    ::wxCoord OnGetUnitSize(size_t) const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxVarVScrollHelper(const sipwxVarVScrollHelper &);
    sipwxVarVScrollHelper &operator = (const sipwxVarVScrollHelper &);

    char sipPyMethods[13];
};

sipwxVarVScrollHelper::sipwxVarVScrollHelper(::wxWindow*winToScroll): ::wxVarVScrollHelper(winToScroll), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxVarVScrollHelper::sipwxVarVScrollHelper(const ::wxVarVScrollHelper& a0): ::wxVarVScrollHelper(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxVarVScrollHelper::~sipwxVarVScrollHelper()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

::wxCoord sipwxVarVScrollHelper::OnGetRowHeight(size_t row) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[0]), const_cast<sipSimpleWrapper **>(&sipPySelf), sipName_VarVScrollHelper, sipName_OnGetRowHeight);

    if (!sipMeth)
        return 0;

    extern ::wxCoord sipVH__core_145(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t);

    return sipVH__core_145(sipGILState, 0, sipPySelf, sipMeth, row);
}

::wxCoord sipwxVarVScrollHelper::EstimateTotalHeight() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_EstimateTotalHeight);

    if (!sipMeth)
        return ::wxVarVScrollHelper::EstimateTotalHeight();

    extern ::wxCoord sipVH__core_111(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_111(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxVarVScrollHelper::OnGetRowsHeightHint(size_t rowMin, size_t rowMax) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[2]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_OnGetRowsHeightHint);

    if (!sipMeth)
    {
        ::wxVarVScrollHelper::OnGetRowsHeightHint(rowMin, rowMax);
        return;
    }

    extern void sipVH__core_144(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t, size_t);

    sipVH__core_144(sipGILState, 0, sipPySelf, sipMeth, rowMin, rowMax);
}

bool sipwxVarVScrollHelper::ScrollRows(int rows)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_ScrollRows);

    if (!sipMeth)
        return ::wxVarVScrollHelper::ScrollRows(rows);

    extern bool sipVH__core_147(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH__core_147(sipGILState, 0, sipPySelf, sipMeth, rows);
}

bool sipwxVarVScrollHelper::ScrollRowPages(int pages)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[4], &sipPySelf, SIP_NULLPTR, sipName_ScrollRowPages);

    if (!sipMeth)
        return ::wxVarVScrollHelper::ScrollRowPages(pages);

    extern bool sipVH__core_147(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH__core_147(sipGILState, 0, sipPySelf, sipMeth, pages);
}

void sipwxVarVScrollHelper::RefreshRows(size_t from_, size_t to_)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[5], &sipPySelf, SIP_NULLPTR, sipName_RefreshRows);

    if (!sipMeth)
    {
        ::wxVarVScrollHelper::RefreshRows(from_, to_);
        return;
    }

    extern void sipVH__core_144(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t, size_t);

    sipVH__core_144(sipGILState, 0, sipPySelf, sipMeth, from_, to_);
}

void sipwxVarVScrollHelper::RefreshRow(size_t row)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[6], &sipPySelf, SIP_NULLPTR, sipName_RefreshRow);

    if (!sipMeth)
    {
        ::wxVarVScrollHelper::RefreshRow(row);
        return;
    }

    extern void sipVH__core_146(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t);

    sipVH__core_146(sipGILState, 0, sipPySelf, sipMeth, row);
}

int sipwxVarVScrollHelper::GetNonOrientationTargetSize() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[7]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetNonOrientationTargetSize);

    if (!sipMeth)
        return ::wxVarVScrollHelper::GetNonOrientationTargetSize();

    extern int sipVH__core_111(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_111(sipGILState, 0, sipPySelf, sipMeth);
}

::wxOrientation sipwxVarVScrollHelper::GetOrientation() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[8]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetOrientation);

    if (!sipMeth)
        return ::wxVarVScrollHelper::GetOrientation();

    extern ::wxOrientation sipVH__core_143(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_143(sipGILState, 0, sipPySelf, sipMeth);
}

int sipwxVarVScrollHelper::GetOrientationTargetSize() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[9]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetOrientationTargetSize);

    if (!sipMeth)
        return ::wxVarVScrollHelper::GetOrientationTargetSize();

    extern int sipVH__core_111(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_111(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxVarVScrollHelper::OnGetUnitsSizeHint(size_t unitMin, size_t unitMax) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[10]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_OnGetUnitsSizeHint);

    if (!sipMeth)
    {
        ::wxVarVScrollHelper::OnGetUnitsSizeHint(unitMin, unitMax);
        return;
    }

    extern void sipVH__core_144(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t, size_t);

    sipVH__core_144(sipGILState, 0, sipPySelf, sipMeth, unitMin, unitMax);
}

::wxCoord sipwxVarVScrollHelper::EstimateTotalSize() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[11]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_EstimateTotalSize);

    if (!sipMeth)
        return ::wxVarVScrollHelper::EstimateTotalSize();

    extern ::wxCoord sipVH__core_111(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_111(sipGILState, 0, sipPySelf, sipMeth);
}

::wxCoord sipwxVarVScrollHelper::OnGetUnitSize(size_t unit) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[12]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_OnGetUnitSize);

    if (!sipMeth)
        return ::wxVarVScrollHelper::OnGetUnitSize(unit);

    extern ::wxCoord sipVH__core_145(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t);

    return sipVH__core_145(sipGILState, 0, sipPySelf, sipMeth, unit);
}

void sipwxVarVScrollHelper::sipProtectVirt_OnGetRowsHeightHint(bool sipSelfWasArg, size_t rowMin, size_t rowMax) const
{
    (sipSelfWasArg ? ::wxVarVScrollHelper::OnGetRowsHeightHint(rowMin, rowMax) : OnGetRowsHeightHint(rowMin, rowMax));
}

::wxCoord sipwxVarVScrollHelper::sipProtectVirt_EstimateTotalHeight(bool sipSelfWasArg) const
{
    return (sipSelfWasArg ? ::wxVarVScrollHelper::EstimateTotalHeight() : EstimateTotalHeight());
}

::wxCoord sipwxVarVScrollHelper::sipProtect_OnGetRowHeight(size_t row) const
{
    return OnGetRowHeight(row);
}

void sipwxVarVScrollHelper::sipProtectVirt_OnGetUnitsSizeHint(bool sipSelfWasArg, size_t unitMin, size_t unitMax) const
{
    (sipSelfWasArg ? ::wxVarVScrollHelper::OnGetUnitsSizeHint(unitMin, unitMax) : OnGetUnitsSizeHint(unitMin, unitMax));
}

::wxCoord sipwxVarVScrollHelper::sipProtectVirt_EstimateTotalSize(bool sipSelfWasArg) const
{
    return (sipSelfWasArg ? ::wxVarVScrollHelper::EstimateTotalSize() : EstimateTotalSize());
}

int sipwxVarVScrollHelper::sipProtectVirt_GetNonOrientationTargetSize(bool sipSelfWasArg) const
{
    return (sipSelfWasArg ? ::wxVarVScrollHelper::GetNonOrientationTargetSize() : GetNonOrientationTargetSize());
}

::wxOrientation sipwxVarVScrollHelper::sipProtectVirt_GetOrientation(bool sipSelfWasArg) const
{
    return (sipSelfWasArg ? ::wxVarVScrollHelper::GetOrientation() : GetOrientation());
}

int sipwxVarVScrollHelper::sipProtectVirt_GetOrientationTargetSize(bool sipSelfWasArg) const
{
    return (sipSelfWasArg ? ::wxVarVScrollHelper::GetOrientationTargetSize() : GetOrientationTargetSize());
}

::wxCoord sipwxVarVScrollHelper::sipProtectVirt_OnGetUnitSize(bool sipSelfWasArg, size_t unit) const
{
    return (sipSelfWasArg ? ::wxVarVScrollHelper::OnGetUnitSize(unit) : OnGetUnitSize(unit));
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_GetRowCount, "GetRowCount() -> size_t\n"
"\n"
"Returns the number of rows the target window contains.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_GetRowCount(PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_GetRowCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVarVScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp))
        {
            size_t sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRowCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_GetRowCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_GetVisibleRowsBegin, "GetVisibleRowsBegin() -> size_t\n"
"\n"
"Returns the index of the first visible row based on the scroll\n"
"position.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_GetVisibleRowsBegin(PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_GetVisibleRowsBegin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVarVScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp))
        {
            size_t sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetVisibleRowsBegin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_GetVisibleRowsBegin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_GetVisibleRowsEnd, "GetVisibleRowsEnd() -> size_t\n"
"\n"
"Returns the index of the last visible row based on the scroll\n"
"position.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_GetVisibleRowsEnd(PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_GetVisibleRowsEnd(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVarVScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp))
        {
            size_t sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetVisibleRowsEnd();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_GetVisibleRowsEnd, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_IsRowVisible, "IsRowVisible(row) -> bool\n"
"\n"
"Returns true if the given row is currently visible (even if only\n"
"partially visible) or false otherwise.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_IsRowVisible(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_IsRowVisible(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        size_t row;
        const ::wxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_row,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, &row))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsRowVisible(row);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_IsRowVisible, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_RefreshRow, "RefreshRow(row)\n"
"\n"
"Triggers a refresh for just the given row's area of the window if it's\n"
"visible.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_RefreshRow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_RefreshRow(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        size_t row;
        ::wxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_row,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, &row))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxVarVScrollHelper::RefreshRow(row) : sipCpp->RefreshRow(row));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_RefreshRow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_RefreshRows, "RefreshRows(from_, to_)\n"
"\n"
"Triggers a refresh for the area between the specified range of rows\n"
"given (inclusively).");

extern "C" {static PyObject *meth_wxVarVScrollHelper_RefreshRows(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_RefreshRows(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        size_t from_;
        size_t to_;
        ::wxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_from_,
            sipName_to_,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B==", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, &from_, &to_))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxVarVScrollHelper::RefreshRows(from_, to_) : sipCpp->RefreshRows(from_, to_));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_RefreshRows, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_ScrollRowPages, "ScrollRowPages(pages) -> bool\n"
"\n"
"Scroll by the specified number of pages which may be positive (to\n"
"scroll down) or negative (to scroll up).");

extern "C" {static PyObject *meth_wxVarVScrollHelper_ScrollRowPages(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_ScrollRowPages(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int pages;
        ::wxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pages,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, &pages))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxVarVScrollHelper::ScrollRowPages(pages) : sipCpp->ScrollRowPages(pages));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_ScrollRowPages, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_ScrollRows, "ScrollRows(rows) -> bool\n"
"\n"
"Scroll by the specified number of rows which may be positive (to\n"
"scroll down) or negative (to scroll up).");

extern "C" {static PyObject *meth_wxVarVScrollHelper_ScrollRows(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_ScrollRows(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int rows;
        ::wxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rows,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, &rows))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxVarVScrollHelper::ScrollRows(rows) : sipCpp->ScrollRows(rows));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_ScrollRows, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_ScrollToRow, "ScrollToRow(row) -> bool\n"
"\n"
"Scroll to the specified row.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_ScrollToRow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_ScrollToRow(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        size_t row;
        ::wxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_row,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, &row))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ScrollToRow(row);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_ScrollToRow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_SetRowCount, "SetRowCount(rowCount)\n"
"\n"
"Set the number of rows the window contains.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_SetRowCount(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_SetRowCount(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        size_t rowCount;
        ::wxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rowCount,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, &rowCount))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRowCount(rowCount);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_SetRowCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_OnGetRowsHeightHint, "OnGetRowsHeightHint(rowMin, rowMax)\n"
"\n"
"This function doesn't have to be overridden but it may be useful to do\n"
"so if calculating the rows' sizes is a relatively expensive operation\n"
"as it gives your code a chance to calculate several of them at once\n"
"and cache the result if necessary.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_OnGetRowsHeightHint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_OnGetRowsHeightHint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        size_t rowMin;
        size_t rowMax;
        const sipwxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rowMin,
            sipName_rowMax,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B==", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, &rowMin, &rowMax))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->sipProtectVirt_OnGetRowsHeightHint(sipSelfWasArg, rowMin, rowMax);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_OnGetRowsHeightHint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_EstimateTotalHeight, "EstimateTotalHeight() -> Coord\n"
"\n"
"This class forwards calls from EstimateTotalSize() to this function so\n"
"derived classes can override either just the height or the width\n"
"estimation, or just estimate both differently if desired in any\n"
"wxHVScrolledWindow derived class.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_EstimateTotalHeight(PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_EstimateTotalHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const sipwxVarVScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_EstimateTotalHeight(sipSelfWasArg);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_EstimateTotalHeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_OnGetRowHeight, "OnGetRowHeight(row) -> Coord\n"
"\n"
"This function must be overridden in the derived class, and should\n"
"return the height of the given row in pixels.");

extern "C" {static PyObject *meth_wxVarVScrollHelper_OnGetRowHeight(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_OnGetRowHeight(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        size_t row;
        const sipwxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_row,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, &row))
        {
            ::wxCoord sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_VarVScrollHelper, sipName_OnGetRowHeight);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtect_OnGetRowHeight(row);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_OnGetRowHeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_OnGetUnitsSizeHint, "OnGetUnitsSizeHint(self, unitMin: int, unitMax: int)");

extern "C" {static PyObject *meth_wxVarVScrollHelper_OnGetUnitsSizeHint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_OnGetUnitsSizeHint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        size_t unitMin;
        size_t unitMax;
        const sipwxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_unitMin,
            sipName_unitMax,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B==", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, &unitMin, &unitMax))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->sipProtectVirt_OnGetUnitsSizeHint(sipSelfWasArg, unitMin, unitMax);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_OnGetUnitsSizeHint, doc_wxVarVScrollHelper_OnGetUnitsSizeHint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_EstimateTotalSize, "EstimateTotalSize(self) -> int");

extern "C" {static PyObject *meth_wxVarVScrollHelper_EstimateTotalSize(PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_EstimateTotalSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const sipwxVarVScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_EstimateTotalSize(sipSelfWasArg);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_EstimateTotalSize, doc_wxVarVScrollHelper_EstimateTotalSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_GetNonOrientationTargetSize, "GetNonOrientationTargetSize(self) -> int");

extern "C" {static PyObject *meth_wxVarVScrollHelper_GetNonOrientationTargetSize(PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_GetNonOrientationTargetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const sipwxVarVScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_GetNonOrientationTargetSize(sipSelfWasArg);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_GetNonOrientationTargetSize, doc_wxVarVScrollHelper_GetNonOrientationTargetSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_GetOrientation, "GetOrientation(self) -> Orientation");

extern "C" {static PyObject *meth_wxVarVScrollHelper_GetOrientation(PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_GetOrientation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const sipwxVarVScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp))
        {
            ::wxOrientation sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_GetOrientation(sipSelfWasArg);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxOrientation);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_GetOrientation, doc_wxVarVScrollHelper_GetOrientation);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_GetOrientationTargetSize, "GetOrientationTargetSize(self) -> int");

extern "C" {static PyObject *meth_wxVarVScrollHelper_GetOrientationTargetSize(PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_GetOrientationTargetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const sipwxVarVScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_GetOrientationTargetSize(sipSelfWasArg);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_GetOrientationTargetSize, doc_wxVarVScrollHelper_GetOrientationTargetSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarVScrollHelper_OnGetUnitSize, "OnGetUnitSize(self, unit: int) -> int");

extern "C" {static PyObject *meth_wxVarVScrollHelper_OnGetUnitSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarVScrollHelper_OnGetUnitSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        size_t unit;
        const sipwxVarVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_unit,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=", &sipSelf, sipType_wxVarVScrollHelper, &sipCpp, &unit))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_OnGetUnitSize(sipSelfWasArg, unit);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarVScrollHelper, sipName_OnGetUnitSize, doc_wxVarVScrollHelper_OnGetUnitSize);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxVarVScrollHelper(void *, const sipTypeDef *);}
static void *cast_wxVarVScrollHelper(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxVarVScrollHelper *sipCpp = reinterpret_cast<::wxVarVScrollHelper *>(sipCppV);

    if (targetType == sipType_wxVarVScrollHelper)
        return sipCppV;

    if (targetType == sipType_wxVarScrollHelperBase)
        return static_cast<::wxVarScrollHelperBase *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxVarVScrollHelper(void *, int);}
static void release_wxVarVScrollHelper(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxVarVScrollHelper *>(sipCppV);
    else
        delete reinterpret_cast<::wxVarVScrollHelper *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxVarVScrollHelper(sipSimpleWrapper *);}
static void dealloc_wxVarVScrollHelper(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxVarVScrollHelper *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxVarVScrollHelper(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxVarVScrollHelper(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxVarVScrollHelper(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxVarVScrollHelper *sipCpp = SIP_NULLPTR;

    {
        ::wxWindow* winToScroll;

        static const char *sipKwdList[] = {
            sipName_winToScroll,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J8", sipType_wxWindow, &winToScroll))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxVarVScrollHelper(winToScroll);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::wxVarVScrollHelper* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxVarVScrollHelper, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxVarVScrollHelper(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxVarVScrollHelper[] = {{622, 255, 1}};


static PyMethodDef methods_wxVarVScrollHelper[] = {
    {sipName_EstimateTotalHeight, meth_wxVarVScrollHelper_EstimateTotalHeight, METH_VARARGS, doc_wxVarVScrollHelper_EstimateTotalHeight},
    {sipName_EstimateTotalSize, meth_wxVarVScrollHelper_EstimateTotalSize, METH_VARARGS, doc_wxVarVScrollHelper_EstimateTotalSize},
    {sipName_GetNonOrientationTargetSize, meth_wxVarVScrollHelper_GetNonOrientationTargetSize, METH_VARARGS, doc_wxVarVScrollHelper_GetNonOrientationTargetSize},
    {sipName_GetOrientation, meth_wxVarVScrollHelper_GetOrientation, METH_VARARGS, doc_wxVarVScrollHelper_GetOrientation},
    {sipName_GetOrientationTargetSize, meth_wxVarVScrollHelper_GetOrientationTargetSize, METH_VARARGS, doc_wxVarVScrollHelper_GetOrientationTargetSize},
    {sipName_GetRowCount, meth_wxVarVScrollHelper_GetRowCount, METH_VARARGS, doc_wxVarVScrollHelper_GetRowCount},
    {sipName_GetVisibleRowsBegin, meth_wxVarVScrollHelper_GetVisibleRowsBegin, METH_VARARGS, doc_wxVarVScrollHelper_GetVisibleRowsBegin},
    {sipName_GetVisibleRowsEnd, meth_wxVarVScrollHelper_GetVisibleRowsEnd, METH_VARARGS, doc_wxVarVScrollHelper_GetVisibleRowsEnd},
    {sipName_IsRowVisible, SIP_MLMETH_CAST(meth_wxVarVScrollHelper_IsRowVisible), METH_VARARGS|METH_KEYWORDS, doc_wxVarVScrollHelper_IsRowVisible},
    {sipName_OnGetRowHeight, SIP_MLMETH_CAST(meth_wxVarVScrollHelper_OnGetRowHeight), METH_VARARGS|METH_KEYWORDS, doc_wxVarVScrollHelper_OnGetRowHeight},
    {sipName_OnGetRowsHeightHint, SIP_MLMETH_CAST(meth_wxVarVScrollHelper_OnGetRowsHeightHint), METH_VARARGS|METH_KEYWORDS, doc_wxVarVScrollHelper_OnGetRowsHeightHint},
    {sipName_OnGetUnitSize, SIP_MLMETH_CAST(meth_wxVarVScrollHelper_OnGetUnitSize), METH_VARARGS|METH_KEYWORDS, doc_wxVarVScrollHelper_OnGetUnitSize},
    {sipName_OnGetUnitsSizeHint, SIP_MLMETH_CAST(meth_wxVarVScrollHelper_OnGetUnitsSizeHint), METH_VARARGS|METH_KEYWORDS, doc_wxVarVScrollHelper_OnGetUnitsSizeHint},
    {sipName_RefreshRow, SIP_MLMETH_CAST(meth_wxVarVScrollHelper_RefreshRow), METH_VARARGS|METH_KEYWORDS, doc_wxVarVScrollHelper_RefreshRow},
    {sipName_RefreshRows, SIP_MLMETH_CAST(meth_wxVarVScrollHelper_RefreshRows), METH_VARARGS|METH_KEYWORDS, doc_wxVarVScrollHelper_RefreshRows},
    {sipName_ScrollRowPages, SIP_MLMETH_CAST(meth_wxVarVScrollHelper_ScrollRowPages), METH_VARARGS|METH_KEYWORDS, doc_wxVarVScrollHelper_ScrollRowPages},
    {sipName_ScrollRows, SIP_MLMETH_CAST(meth_wxVarVScrollHelper_ScrollRows), METH_VARARGS|METH_KEYWORDS, doc_wxVarVScrollHelper_ScrollRows},
    {sipName_ScrollToRow, SIP_MLMETH_CAST(meth_wxVarVScrollHelper_ScrollToRow), METH_VARARGS|METH_KEYWORDS, doc_wxVarVScrollHelper_ScrollToRow},
    {sipName_SetRowCount, SIP_MLMETH_CAST(meth_wxVarVScrollHelper_SetRowCount), METH_VARARGS|METH_KEYWORDS, doc_wxVarVScrollHelper_SetRowCount}
};

sipVariableDef variables_wxVarVScrollHelper[] = {
    {PropertyVariable, sipName_VisibleRowsEnd, &methods_wxVarVScrollHelper[7], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_VisibleRowsBegin, &methods_wxVarVScrollHelper[6], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RowCount, &methods_wxVarVScrollHelper[5], &methods_wxVarVScrollHelper[18], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxVarVScrollHelper, "VarVScrollHelper(winToScroll)\n"
"\n"
"This class provides functions wrapping the wxVarScrollHelperBase\n"
"class, targeted for vertical-specific scrolling.");


sipClassTypeDef sipTypeDef__core_wxVarVScrollHelper = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxVarVScrollHelper,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_VarVScrollHelper,
        {0, 0, 1},
        19, methods_wxVarVScrollHelper,
        0, SIP_NULLPTR,
        3, variables_wxVarVScrollHelper,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxVarVScrollHelper,
    -1,
    -1,
    supers_wxVarVScrollHelper,
    SIP_NULLPTR,
    init_type_wxVarVScrollHelper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxVarVScrollHelper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxVarVScrollHelper,
    cast_wxVarVScrollHelper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
