/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.5
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_html.h"
        #include <wx/html/htmlcell.h>
        #include <wx/gdicmn.h>
        #include <wx/html/htmlcell.h>
        #include <wx/html/htmlcell.h>
        #include <wx/html/htmlcell.h>
        #include <wx/html/htmlwin.h>
        #include <wx/event.h>
        #include <wx/cursor.h>
        #include <wx/dc.h>
        #include <wx/html/htmlcell.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxHtmlCell : public ::wxHtmlCell
{
public:
    sipwxHtmlCell();
    virtual ~sipwxHtmlCell();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::wxString ConvertToText(::wxHtmlSelection*) const SIP_OVERRIDE;
    void SetPos(int, int) SIP_OVERRIDE;
    bool ProcessMouseClick(::wxHtmlWindowInterface*, const ::wxPoint&, const ::wxMouseEvent&) SIP_OVERRIDE;
    void Layout(int) SIP_OVERRIDE;
    ::wxCursor GetMouseCursorAt(::wxHtmlWindowInterface*, const ::wxPoint&) const SIP_OVERRIDE;
    ::wxCursor GetMouseCursor(::wxHtmlWindowInterface*) const SIP_OVERRIDE;
    ::wxHtmlLinkInfo* GetLink(int, int) const SIP_OVERRIDE;
    ::wxHtmlCell* GetFirstChild() const SIP_OVERRIDE;
    ::wxHtmlCell* FindCellByPos(::wxCoord, ::wxCoord, uint) const SIP_OVERRIDE;
    const ::wxHtmlCell* Find(int, const void*) const SIP_OVERRIDE;
    void DrawInvisible(::wxDC&, int, int, ::wxHtmlRenderingInfo&) SIP_OVERRIDE;
    void Draw(::wxDC&, int, int, int, int, ::wxHtmlRenderingInfo&) SIP_OVERRIDE;
    bool AdjustPagebreak(int*, int) const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxHtmlCell(const sipwxHtmlCell &);
    sipwxHtmlCell &operator = (const sipwxHtmlCell &);

    char sipPyMethods[13];
};

sipwxHtmlCell::sipwxHtmlCell(): ::wxHtmlCell(), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxHtmlCell::~sipwxHtmlCell()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

::wxString sipwxHtmlCell::ConvertToText(::wxHtmlSelection*sel) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[0]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_ConvertToText);

    if (!sipMeth)
        return ::wxHtmlCell::ConvertToText(sel);

    extern ::wxString sipVH__html_13(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxHtmlSelection*);

    return sipVH__html_13(sipGILState, 0, sipPySelf, sipMeth, sel);
}

void sipwxHtmlCell::SetPos(int x, int y)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[1], &sipPySelf, SIP_NULLPTR, sipName_SetPos);

    if (!sipMeth)
    {
        ::wxHtmlCell::SetPos(x, y);
        return;
    }

    extern void sipVH__html_12(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int, int);

    sipVH__html_12(sipGILState, 0, sipPySelf, sipMeth, x, y);
}

bool sipwxHtmlCell::ProcessMouseClick(::wxHtmlWindowInterface*window, const ::wxPoint& pos, const ::wxMouseEvent& event)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_ProcessMouseClick);

    if (!sipMeth)
        return ::wxHtmlCell::ProcessMouseClick(window, pos, event);

    extern bool sipVH__html_11(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxHtmlWindowInterface*, const ::wxPoint&, const ::wxMouseEvent&);

    return sipVH__html_11(sipGILState, 0, sipPySelf, sipMeth, window, pos, event);
}

void sipwxHtmlCell::Layout(int w)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_Layout);

    if (!sipMeth)
    {
        ::wxHtmlCell::Layout(w);
        return;
    }

    extern void sipVH__html_10(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    sipVH__html_10(sipGILState, 0, sipPySelf, sipMeth, w);
}

::wxCursor sipwxHtmlCell::GetMouseCursorAt(::wxHtmlWindowInterface*window, const ::wxPoint& rePos) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[4]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetMouseCursorAt);

    if (!sipMeth)
        return ::wxHtmlCell::GetMouseCursorAt(window, rePos);

    extern ::wxCursor sipVH__html_9(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxHtmlWindowInterface*, const ::wxPoint&);

    return sipVH__html_9(sipGILState, 0, sipPySelf, sipMeth, window, rePos);
}

::wxCursor sipwxHtmlCell::GetMouseCursor(::wxHtmlWindowInterface*window) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[5]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetMouseCursor);

    if (!sipMeth)
        return ::wxHtmlCell::GetMouseCursor(window);

    extern ::wxCursor sipVH__html_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxHtmlWindowInterface*);

    return sipVH__html_8(sipGILState, 0, sipPySelf, sipMeth, window);
}

::wxHtmlLinkInfo* sipwxHtmlCell::GetLink(int x, int y) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[6]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetLink);

    if (!sipMeth)
        return ::wxHtmlCell::GetLink(x, y);

    extern ::wxHtmlLinkInfo* sipVH__html_7(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int, int);

    return sipVH__html_7(sipGILState, 0, sipPySelf, sipMeth, x, y);
}

::wxHtmlCell* sipwxHtmlCell::GetFirstChild() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[7]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetFirstChild);

    if (!sipMeth)
        return ::wxHtmlCell::GetFirstChild();

    extern ::wxHtmlCell* sipVH__html_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__html_6(sipGILState, 0, sipPySelf, sipMeth);
}

::wxHtmlCell* sipwxHtmlCell::FindCellByPos(::wxCoord x, ::wxCoord y, uint flags) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[8]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_FindCellByPos);

    if (!sipMeth)
        return ::wxHtmlCell::FindCellByPos(x, y, flags);

    extern ::wxHtmlCell* sipVH__html_5(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxCoord, ::wxCoord, uint);

    return sipVH__html_5(sipGILState, 0, sipPySelf, sipMeth, x, y, flags);
}

const ::wxHtmlCell* sipwxHtmlCell::Find(int condition, const void*param) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[9]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_Find);

    if (!sipMeth)
        return ::wxHtmlCell::Find(condition, param);

    extern const ::wxHtmlCell* sipVH__html_4(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int, const void*);

    return sipVH__html_4(sipGILState, 0, sipPySelf, sipMeth, condition, param);
}

void sipwxHtmlCell::DrawInvisible(::wxDC& dc, int x, int y, ::wxHtmlRenderingInfo& info)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[10], &sipPySelf, SIP_NULLPTR, sipName_DrawInvisible);

    if (!sipMeth)
    {
        ::wxHtmlCell::DrawInvisible(dc, x, y, info);
        return;
    }

    extern void sipVH__html_3(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxDC&, int, int, ::wxHtmlRenderingInfo&);

    sipVH__html_3(sipGILState, 0, sipPySelf, sipMeth, dc, x, y, info);
}

void sipwxHtmlCell::Draw(::wxDC& dc, int x, int y, int view_y1, int view_y2, ::wxHtmlRenderingInfo& info)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[11], &sipPySelf, SIP_NULLPTR, sipName_Draw);

    if (!sipMeth)
    {
        ::wxHtmlCell::Draw(dc, x, y, view_y1, view_y2, info);
        return;
    }

    extern void sipVH__html_2(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxDC&, int, int, int, int, ::wxHtmlRenderingInfo&);

    sipVH__html_2(sipGILState, 0, sipPySelf, sipMeth, dc, x, y, view_y1, view_y2, info);
}

bool sipwxHtmlCell::AdjustPagebreak(int*pagebreak, int pageHeight) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[12]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_AdjustPagebreak);

    if (!sipMeth)
        return ::wxHtmlCell::AdjustPagebreak(pagebreak, pageHeight);

    extern bool sipVH__html_1(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int*, int);

    return sipVH__html_1(sipGILState, 0, sipPySelf, sipMeth, pagebreak, pageHeight);
}


PyDoc_STRVAR(doc_wxHtmlCell_AdjustPagebreak, "AdjustPagebreak(pagebreak, pageHeight) -> (bool, pagebreak)\n"
"\n"
"This method is called when paginating HTML, e.g. when printing.");

extern "C" {static PyObject *meth_wxHtmlCell_AdjustPagebreak(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_AdjustPagebreak(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int pagebreak;
        int pageHeight;
        const ::wxHtmlCell *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pagebreak,
            sipName_pageHeight,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxHtmlCell, &sipCpp, &pagebreak, &pageHeight))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxHtmlCell::AdjustPagebreak(&pagebreak, pageHeight) : sipCpp->AdjustPagebreak(&pagebreak, pageHeight));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0, "(bi)", sipRes, pagebreak);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_AdjustPagebreak, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_Draw, "Draw(dc, x, y, view_y1, view_y2, info)\n"
"\n"
"Renders the cell.");

extern "C" {static PyObject *meth_wxHtmlCell_Draw(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_Draw(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxDC* dc;
        int x;
        int y;
        int view_y1;
        int view_y2;
        ::wxHtmlRenderingInfo* info;
        ::wxHtmlCell *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dc,
            sipName_x,
            sipName_y,
            sipName_view_y1,
            sipName_view_y2,
            sipName_info,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9iiiiJ9", &sipSelf, sipType_wxHtmlCell, &sipCpp, sipType_wxDC, &dc, &x, &y, &view_y1, &view_y2, sipType_wxHtmlRenderingInfo, &info))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxHtmlCell::Draw(*dc, x, y, view_y1, view_y2, *info) : sipCpp->Draw(*dc, x, y, view_y1, view_y2, *info));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_Draw, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_DrawInvisible, "DrawInvisible(dc, x, y, info)\n"
"\n"
"This method is called instead of Draw() when the cell is certainly out\n"
"of the screen (and thus invisible).");

extern "C" {static PyObject *meth_wxHtmlCell_DrawInvisible(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_DrawInvisible(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxDC* dc;
        int x;
        int y;
        ::wxHtmlRenderingInfo* info;
        ::wxHtmlCell *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dc,
            sipName_x,
            sipName_y,
            sipName_info,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9iiJ9", &sipSelf, sipType_wxHtmlCell, &sipCpp, sipType_wxDC, &dc, &x, &y, sipType_wxHtmlRenderingInfo, &info))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxHtmlCell::DrawInvisible(*dc, x, y, *info) : sipCpp->DrawInvisible(*dc, x, y, *info));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_DrawInvisible, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_Find, "Find(condition, param) -> HtmlCell\n"
"\n"
"Returns pointer to itself if this cell matches condition (or if any of\n"
"the cells following in the list matches), NULL otherwise.");

extern "C" {static PyObject *meth_wxHtmlCell_Find(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_Find(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int condition;
        const char* param;
        const ::wxHtmlCell *sipCpp;

        static const char *sipKwdList[] = {
            sipName_condition,
            sipName_param,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bis", &sipSelf, sipType_wxHtmlCell, &sipCpp, &condition, &param))
        {
            const ::wxHtmlCell*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxHtmlCell::Find(condition, param) : sipCpp->Find(condition, param));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(const_cast<::wxHtmlCell *>(sipRes), sipType_wxHtmlCell, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_Find, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_FindCellByPos, "FindCellByPos(x, y, flags=HTML_FIND_EXACT) -> HtmlCell\n"
"\n"
"Find a cell inside this cell positioned at the given coordinates\n"
"(relative to this's positions).");

extern "C" {static PyObject *meth_wxHtmlCell_FindCellByPos(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_FindCellByPos(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxCoord x;
        ::wxCoord y;
        uint flags = wxHTML_FIND_EXACT;
        const ::wxHtmlCell *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii|u", &sipSelf, sipType_wxHtmlCell, &sipCpp, &x, &y, &flags))
        {
            ::wxHtmlCell*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxHtmlCell::FindCellByPos(x, y, flags) : sipCpp->FindCellByPos(x, y, flags));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxHtmlCell, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_FindCellByPos, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_GetDescent, "GetDescent() -> int\n"
"\n"
"Returns descent value of the cell (m_Descent member).");

extern "C" {static PyObject *meth_wxHtmlCell_GetDescent(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_GetDescent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxHtmlCell *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlCell, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDescent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_GetDescent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_GetFirstChild, "GetFirstChild() -> HtmlCell\n"
"\n"
"Returns pointer to the first cell in the list.");

extern "C" {static PyObject *meth_wxHtmlCell_GetFirstChild(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_GetFirstChild(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxHtmlCell *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlCell, &sipCpp))
        {
            ::wxHtmlCell*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxHtmlCell::GetFirstChild() : sipCpp->GetFirstChild());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxHtmlCell, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_GetFirstChild, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_GetHeight, "GetHeight() -> int\n"
"\n"
"Returns height of the cell (m_Height member).");

extern "C" {static PyObject *meth_wxHtmlCell_GetHeight(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_GetHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxHtmlCell *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlCell, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetHeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_GetHeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_GetId, "GetId() -> String\n"
"\n"
"Returns unique cell identifier if there is any, the empty string\n"
"otherwise.");

extern "C" {static PyObject *meth_wxHtmlCell_GetId(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_GetId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxHtmlCell *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlCell, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetId());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_GetId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_GetLink, "GetLink(x=0, y=0) -> HtmlLinkInfo\n"
"\n"
"Returns hypertext link if associated with this cell or NULL otherwise.");

extern "C" {static PyObject *meth_wxHtmlCell_GetLink(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_GetLink(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int x = 0;
        int y = 0;
        const ::wxHtmlCell *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|ii", &sipSelf, sipType_wxHtmlCell, &sipCpp, &x, &y))
        {
            ::wxHtmlLinkInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxHtmlCell::GetLink(x, y) : sipCpp->GetLink(x, y));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxHtmlLinkInfo, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_GetLink, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_GetMouseCursor, "GetMouseCursor(window) -> wx.Cursor\n"
"\n"
"Returns cursor to show when mouse pointer is over the cell.");

extern "C" {static PyObject *meth_wxHtmlCell_GetMouseCursor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_GetMouseCursor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxHtmlWindowInterface* window;
        const ::wxHtmlCell *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxHtmlCell, &sipCpp, sipType_wxHtmlWindowInterface, &window))
        {
            ::wxCursor*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxCursor((sipSelfWasArg ? sipCpp->::wxHtmlCell::GetMouseCursor(window) : sipCpp->GetMouseCursor(window)));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxCursor, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_GetMouseCursor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_GetMouseCursorAt, "GetMouseCursorAt(window, rePos) -> wx.Cursor\n"
"\n"
"Returns cursor to show when mouse pointer is over the specified point.");

extern "C" {static PyObject *meth_wxHtmlCell_GetMouseCursorAt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_GetMouseCursorAt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxHtmlWindowInterface* window;
        const ::wxPoint* rePos;
        int rePosState = 0;
        const ::wxHtmlCell *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
            sipName_rePos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1", &sipSelf, sipType_wxHtmlCell, &sipCpp, sipType_wxHtmlWindowInterface, &window, sipType_wxPoint, &rePos, &rePosState))
        {
            ::wxCursor*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxCursor((sipSelfWasArg ? sipCpp->::wxHtmlCell::GetMouseCursorAt(window, *rePos) : sipCpp->GetMouseCursorAt(window, *rePos)));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint *>(rePos), sipType_wxPoint, rePosState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxCursor, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_GetMouseCursorAt, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_GetNext, "GetNext() -> HtmlCell\n"
"\n"
"Returns pointer to the next cell in list (see htmlcell.h if you're\n"
"interested in details).");

extern "C" {static PyObject *meth_wxHtmlCell_GetNext(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_GetNext(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxHtmlCell *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlCell, &sipCpp))
        {
            ::wxHtmlCell*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNext();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxHtmlCell, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_GetNext, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_GetParent, "GetParent() -> HtmlContainerCell\n"
"\n"
"Returns pointer to parent container.");

extern "C" {static PyObject *meth_wxHtmlCell_GetParent(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_GetParent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxHtmlCell *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlCell, &sipCpp))
        {
            ::wxHtmlContainerCell*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetParent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxHtmlContainerCell, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_GetParent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_GetPosX, "GetPosX() -> int\n"
"\n"
"Returns X position within parent (the value is relative to parent's\n"
"upper left corner).");

extern "C" {static PyObject *meth_wxHtmlCell_GetPosX(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_GetPosX(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxHtmlCell *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlCell, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPosX();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_GetPosX, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_GetPosY, "GetPosY() -> int\n"
"\n"
"Returns Y position within parent (the value is relative to parent's\n"
"upper left corner).");

extern "C" {static PyObject *meth_wxHtmlCell_GetPosY(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_GetPosY(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxHtmlCell *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlCell, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPosY();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_GetPosY, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_GetWidth, "GetWidth() -> int\n"
"\n"
"Returns width of the cell (m_Width member).");

extern "C" {static PyObject *meth_wxHtmlCell_GetWidth(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_GetWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxHtmlCell *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlCell, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_GetWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_Layout, "Layout(w)\n"
"\n"
"Layouts the cell.");

extern "C" {static PyObject *meth_wxHtmlCell_Layout(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_Layout(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int w;
        ::wxHtmlCell *sipCpp;

        static const char *sipKwdList[] = {
            sipName_w,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxHtmlCell, &sipCpp, &w))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxHtmlCell::Layout(w) : sipCpp->Layout(w));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_Layout, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_ProcessMouseClick, "ProcessMouseClick(window, pos, event) -> bool\n"
"\n"
"This function is simple event handler.");

extern "C" {static PyObject *meth_wxHtmlCell_ProcessMouseClick(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_ProcessMouseClick(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxHtmlWindowInterface* window;
        const ::wxPoint* pos;
        int posState = 0;
        const ::wxMouseEvent* event;
        ::wxHtmlCell *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
            sipName_pos,
            sipName_event,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1J9", &sipSelf, sipType_wxHtmlCell, &sipCpp, sipType_wxHtmlWindowInterface, &window, sipType_wxPoint, &pos, &posState, sipType_wxMouseEvent, &event))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxHtmlCell::ProcessMouseClick(window, *pos, *event) : sipCpp->ProcessMouseClick(window, *pos, *event));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint *>(pos), sipType_wxPoint, posState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_ProcessMouseClick, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_SetId, "SetId(id)\n"
"\n"
"Sets unique cell identifier.");

extern "C" {static PyObject *meth_wxHtmlCell_SetId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_SetId(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* id;
        int idState = 0;
        ::wxHtmlCell *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxHtmlCell, &sipCpp, sipType_wxString, &id, &idState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetId(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(id), sipType_wxString, idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_SetId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_SetLink, "SetLink(link)\n"
"\n"
"Sets the hypertext link associated with this cell.");

extern "C" {static PyObject *meth_wxHtmlCell_SetLink(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_SetLink(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxHtmlLinkInfo* link;
        ::wxHtmlCell *sipCpp;

        static const char *sipKwdList[] = {
            sipName_link,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxHtmlCell, &sipCpp, sipType_wxHtmlLinkInfo, &link))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLink(*link);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_SetLink, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_SetNext, "SetNext(cell)\n"
"\n"
"Sets the next cell in the list.");

extern "C" {static PyObject *meth_wxHtmlCell_SetNext(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_SetNext(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxHtmlCell* cell;
        ::wxHtmlCell *sipCpp;

        static const char *sipKwdList[] = {
            sipName_cell,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_wxHtmlCell, &sipCpp, sipType_wxHtmlCell, &cell))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetNext(cell);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_SetNext, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_SetParent, "SetParent(p)\n"
"\n"
"Sets parent container of this cell.");

extern "C" {static PyObject *meth_wxHtmlCell_SetParent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_SetParent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxHtmlContainerCell* p;
        ::wxHtmlCell *sipCpp;

        static const char *sipKwdList[] = {
            sipName_p,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxHtmlCell, &sipCpp, sipType_wxHtmlContainerCell, &p))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetParent(p);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_SetParent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_SetPos, "SetPos(x, y)\n"
"\n"
"Sets the cell's position within parent container.");

extern "C" {static PyObject *meth_wxHtmlCell_SetPos(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_SetPos(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int x;
        int y;
        ::wxHtmlCell *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxHtmlCell, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxHtmlCell::SetPos(x, y) : sipCpp->SetPos(x, y));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_SetPos, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlCell_ConvertToText, "ConvertToText(sel) -> String\n"
"\n"
"Converts the cell into text representation.");

extern "C" {static PyObject *meth_wxHtmlCell_ConvertToText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_ConvertToText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxHtmlSelection* sel;
        const ::wxHtmlCell *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxHtmlCell, &sipCpp, sipType_wxHtmlSelection, &sel))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString((sipSelfWasArg ? sipCpp->::wxHtmlCell::ConvertToText(sel) : sipCpp->ConvertToText(sel)));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlCell, sipName_ConvertToText, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *meth_wxHtmlCell_GetAbsPos(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_GetAbsPos(PyObject *, PyObject *)
{

    sipNoMethod(SIP_NULLPTR, sipName_HtmlCell, sipName_GetAbsPos, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *meth_wxHtmlCell_GetRootCell(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlCell_GetRootCell(PyObject *, PyObject *)
{

    sipNoMethod(SIP_NULLPTR, sipName_HtmlCell, sipName_GetRootCell, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxHtmlCell(void *, const sipTypeDef *);}
static void *cast_wxHtmlCell(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxHtmlCell *sipCpp = reinterpret_cast<::wxHtmlCell *>(sipCppV);

    if (targetType == sipType_wxHtmlCell)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast<::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxHtmlCell(void *, int);}
static void release_wxHtmlCell(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxHtmlCell *>(sipCppV);
    else
        delete reinterpret_cast<::wxHtmlCell *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxHtmlCell(Py_ssize_t);}
static void *array_wxHtmlCell(Py_ssize_t sipNrElem)
{
    return new ::wxHtmlCell[sipNrElem];
}


extern "C" {static void dealloc_wxHtmlCell(sipSimpleWrapper *);}
static void dealloc_wxHtmlCell(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxHtmlCell *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxHtmlCell(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxHtmlCell(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxHtmlCell(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxHtmlCell *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxHtmlCell();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxHtmlCell[] = {{25, 0, 1}};


static PyMethodDef methods_wxHtmlCell[] = {
    {sipName_AdjustPagebreak, SIP_MLMETH_CAST(meth_wxHtmlCell_AdjustPagebreak), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlCell_AdjustPagebreak},
    {sipName_ConvertToText, SIP_MLMETH_CAST(meth_wxHtmlCell_ConvertToText), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlCell_ConvertToText},
    {sipName_Draw, SIP_MLMETH_CAST(meth_wxHtmlCell_Draw), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlCell_Draw},
    {sipName_DrawInvisible, SIP_MLMETH_CAST(meth_wxHtmlCell_DrawInvisible), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlCell_DrawInvisible},
    {sipName_Find, SIP_MLMETH_CAST(meth_wxHtmlCell_Find), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlCell_Find},
    {sipName_FindCellByPos, SIP_MLMETH_CAST(meth_wxHtmlCell_FindCellByPos), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlCell_FindCellByPos},
    {sipName_GetAbsPos, meth_wxHtmlCell_GetAbsPos, METH_VARARGS, SIP_NULLPTR},
    {sipName_GetDescent, meth_wxHtmlCell_GetDescent, METH_VARARGS, doc_wxHtmlCell_GetDescent},
    {sipName_GetFirstChild, meth_wxHtmlCell_GetFirstChild, METH_VARARGS, doc_wxHtmlCell_GetFirstChild},
    {sipName_GetHeight, meth_wxHtmlCell_GetHeight, METH_VARARGS, doc_wxHtmlCell_GetHeight},
    {sipName_GetId, meth_wxHtmlCell_GetId, METH_VARARGS, doc_wxHtmlCell_GetId},
    {sipName_GetLink, SIP_MLMETH_CAST(meth_wxHtmlCell_GetLink), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlCell_GetLink},
    {sipName_GetMouseCursor, SIP_MLMETH_CAST(meth_wxHtmlCell_GetMouseCursor), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlCell_GetMouseCursor},
    {sipName_GetMouseCursorAt, SIP_MLMETH_CAST(meth_wxHtmlCell_GetMouseCursorAt), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlCell_GetMouseCursorAt},
    {sipName_GetNext, meth_wxHtmlCell_GetNext, METH_VARARGS, doc_wxHtmlCell_GetNext},
    {sipName_GetParent, meth_wxHtmlCell_GetParent, METH_VARARGS, doc_wxHtmlCell_GetParent},
    {sipName_GetPosX, meth_wxHtmlCell_GetPosX, METH_VARARGS, doc_wxHtmlCell_GetPosX},
    {sipName_GetPosY, meth_wxHtmlCell_GetPosY, METH_VARARGS, doc_wxHtmlCell_GetPosY},
    {sipName_GetRootCell, meth_wxHtmlCell_GetRootCell, METH_VARARGS, SIP_NULLPTR},
    {sipName_GetWidth, meth_wxHtmlCell_GetWidth, METH_VARARGS, doc_wxHtmlCell_GetWidth},
    {sipName_Layout, SIP_MLMETH_CAST(meth_wxHtmlCell_Layout), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlCell_Layout},
    {sipName_ProcessMouseClick, SIP_MLMETH_CAST(meth_wxHtmlCell_ProcessMouseClick), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlCell_ProcessMouseClick},
    {sipName_SetId, SIP_MLMETH_CAST(meth_wxHtmlCell_SetId), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlCell_SetId},
    {sipName_SetLink, SIP_MLMETH_CAST(meth_wxHtmlCell_SetLink), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlCell_SetLink},
    {sipName_SetNext, SIP_MLMETH_CAST(meth_wxHtmlCell_SetNext), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlCell_SetNext},
    {sipName_SetParent, SIP_MLMETH_CAST(meth_wxHtmlCell_SetParent), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlCell_SetParent},
    {sipName_SetPos, SIP_MLMETH_CAST(meth_wxHtmlCell_SetPos), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlCell_SetPos}
};

sipVariableDef variables_wxHtmlCell[] = {
    {PropertyVariable, sipName_Width, &methods_wxHtmlCell[19], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RootCell, &methods_wxHtmlCell[18], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_PosY, &methods_wxHtmlCell[17], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_PosX, &methods_wxHtmlCell[16], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Parent, &methods_wxHtmlCell[15], &methods_wxHtmlCell[25], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Next, &methods_wxHtmlCell[14], &methods_wxHtmlCell[24], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Link, &methods_wxHtmlCell[11], &methods_wxHtmlCell[23], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Id, &methods_wxHtmlCell[10], &methods_wxHtmlCell[22], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Height, &methods_wxHtmlCell[9], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_FirstChild, &methods_wxHtmlCell[8], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Descent, &methods_wxHtmlCell[7], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_AbsPos, &methods_wxHtmlCell[6], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxHtmlCell, "HtmlCell()\n"
"\n"
"Internal data structure.");


sipClassTypeDef sipTypeDef__html_wxHtmlCell = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxHtmlCell,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_HtmlCell,
        {0, 0, 1},
        27, methods_wxHtmlCell,
        0, SIP_NULLPTR,
        12, variables_wxHtmlCell,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxHtmlCell,
    -1,
    -1,
    supers_wxHtmlCell,
    SIP_NULLPTR,
    init_type_wxHtmlCell,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxHtmlCell,
    SIP_NULLPTR,
    array_wxHtmlCell,
    SIP_NULLPTR,
    release_wxHtmlCell,
    cast_wxHtmlCell,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
