/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.5
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_xml.h"
        #include <wx/xml/xml.h>



PyDoc_STRVAR(doc_wxXmlDoctype_Clear, "Clear()\n"
"\n"
"Removes all the DOCTYPE values.");

extern "C" {static PyObject *meth_wxXmlDoctype_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxXmlDoctype_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxXmlDoctype *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlDoctype, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlDoctype, sipName_Clear, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlDoctype_GetRootName, "GetRootName() -> String\n"
"\n"
"Returns the root name of the document.");

extern "C" {static PyObject *meth_wxXmlDoctype_GetRootName(PyObject *, PyObject *);}
static PyObject *meth_wxXmlDoctype_GetRootName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxXmlDoctype *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlDoctype, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetRootName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlDoctype, sipName_GetRootName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlDoctype_GetSystemId, "GetSystemId() -> String\n"
"\n"
"Returns the system id of the document.");

extern "C" {static PyObject *meth_wxXmlDoctype_GetSystemId(PyObject *, PyObject *);}
static PyObject *meth_wxXmlDoctype_GetSystemId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxXmlDoctype *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlDoctype, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetSystemId());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlDoctype, sipName_GetSystemId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlDoctype_GetPublicId, "GetPublicId() -> String\n"
"\n"
"Returns the public id of the document.");

extern "C" {static PyObject *meth_wxXmlDoctype_GetPublicId(PyObject *, PyObject *);}
static PyObject *meth_wxXmlDoctype_GetPublicId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxXmlDoctype *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlDoctype, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetPublicId());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlDoctype, sipName_GetPublicId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlDoctype_GetFullString, "GetFullString() -> String\n"
"\n"
"Returns the formatted DOCTYPE contents.");

extern "C" {static PyObject *meth_wxXmlDoctype_GetFullString(PyObject *, PyObject *);}
static PyObject *meth_wxXmlDoctype_GetFullString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxXmlDoctype *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlDoctype, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetFullString());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlDoctype, sipName_GetFullString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlDoctype_IsValid, "IsValid() -> bool\n"
"\n"
"Returns true if the contents can produce a valid DOCTYPE string.");

extern "C" {static PyObject *meth_wxXmlDoctype_IsValid(PyObject *, PyObject *);}
static PyObject *meth_wxXmlDoctype_IsValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxXmlDoctype *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlDoctype, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsValid();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlDoctype, sipName_IsValid, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxXmlDoctype(void *, int);}
static void release_wxXmlDoctype(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<::wxXmlDoctype *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxXmlDoctype(Py_ssize_t);}
static void *array_wxXmlDoctype(Py_ssize_t sipNrElem)
{
    return new ::wxXmlDoctype[sipNrElem];
}


extern "C" {static void assign_wxXmlDoctype(void *, Py_ssize_t, void *);}
static void assign_wxXmlDoctype(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<::wxXmlDoctype *>(sipDst)[sipDstIdx] = *reinterpret_cast<::wxXmlDoctype *>(sipSrc);
}


extern "C" {static void *copy_wxXmlDoctype(const void *, Py_ssize_t);}
static void *copy_wxXmlDoctype(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxXmlDoctype(reinterpret_cast<const ::wxXmlDoctype *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxXmlDoctype(sipSimpleWrapper *);}
static void dealloc_wxXmlDoctype(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxXmlDoctype(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxXmlDoctype(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxXmlDoctype(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxXmlDoctype *sipCpp = SIP_NULLPTR;

    {
        const ::wxString& rootNamedef = wxString();
        const ::wxString* rootName = &rootNamedef;
        int rootNameState = 0;
        const ::wxString& systemIddef = wxString();
        const ::wxString* systemId = &systemIddef;
        int systemIdState = 0;
        const ::wxString& publicIddef = wxString();
        const ::wxString* publicId = &publicIddef;
        int publicIdState = 0;

        static const char *sipKwdList[] = {
            sipName_rootName,
            sipName_systemId,
            sipName_publicId,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J1J1J1", sipType_wxString, &rootName, &rootNameState, sipType_wxString, &systemId, &systemIdState, sipType_wxString, &publicId, &publicIdState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxXmlDoctype(*rootName, *systemId, *publicId);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(rootName), sipType_wxString, rootNameState);
            sipReleaseType(const_cast<::wxString *>(systemId), sipType_wxString, systemIdState);
            sipReleaseType(const_cast<::wxString *>(publicId), sipType_wxString, publicIdState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxXmlDoctype* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxXmlDoctype, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxXmlDoctype(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxXmlDoctype[] = {
    {sipName_Clear, meth_wxXmlDoctype_Clear, METH_VARARGS, doc_wxXmlDoctype_Clear},
    {sipName_GetFullString, meth_wxXmlDoctype_GetFullString, METH_VARARGS, doc_wxXmlDoctype_GetFullString},
    {sipName_GetPublicId, meth_wxXmlDoctype_GetPublicId, METH_VARARGS, doc_wxXmlDoctype_GetPublicId},
    {sipName_GetRootName, meth_wxXmlDoctype_GetRootName, METH_VARARGS, doc_wxXmlDoctype_GetRootName},
    {sipName_GetSystemId, meth_wxXmlDoctype_GetSystemId, METH_VARARGS, doc_wxXmlDoctype_GetSystemId},
    {sipName_IsValid, meth_wxXmlDoctype_IsValid, METH_VARARGS, doc_wxXmlDoctype_IsValid}
};

sipVariableDef variables_wxXmlDoctype[] = {
    {PropertyVariable, sipName_SystemId, &methods_wxXmlDoctype[4], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RootName, &methods_wxXmlDoctype[3], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_PublicId, &methods_wxXmlDoctype[2], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_FullString, &methods_wxXmlDoctype[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxXmlDoctype, "XmlDoctype(rootName=\"\", systemId=\"\", publicId=\"\")\n"
"\n"
"Represents a DOCTYPE Declaration.");


sipClassTypeDef sipTypeDef__xml_wxXmlDoctype = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxXmlDoctype,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_XmlDoctype,
        {0, 0, 1},
        6, methods_wxXmlDoctype,
        0, SIP_NULLPTR,
        4, variables_wxXmlDoctype,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxXmlDoctype,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxXmlDoctype,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxXmlDoctype,
    assign_wxXmlDoctype,
    array_wxXmlDoctype,
    copy_wxXmlDoctype,
    release_wxXmlDoctype,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
