/*
 * This file is part of the Yices SMT Solver.
 * Copyright (C) 2017 SRI International.
 *
 * Yices is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Yices is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Yices.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * TEMPLATE FOR GENERATING yices_version.c
 */


/*
 * Visibility control: version strings are part of the API.
 *
 * On cygwin/mingw, we have two cases:
 * - static build: NOYICES_DLL is defined
 * - dynamic build: NOYICES_DLL is not defined
 *
 * If NOYICES_DLL not defined, we must predix the version strings
 * with __declspec(dllexport)
 */
#if defined(CYGWIN) || defined(MINGW)
#if defined(NOYICES_DLL)
#define EXPORTED
#else
#define EXPORTED __declspec(dllexport)
#endif
#else
#define EXPORTED __attribute__((visibility("default")))
#endif


EXPORTED const char * const yices_version = "2.6.2";
EXPORTED const char * const yices_build_date = "2020-03-11";
EXPORTED const char * const yices_build_arch = "x86_64-pc-linux-gnu";

#if defined(YICES_STATIC)
EXPORTED const char * const yices_build_mode = "profile/static";
#else
EXPORTED const char * const yices_build_mode = "profile";
#endif

EXPORTED const char * const yices_rev = "76bb20888e24681be740c6bd65ea0d00f9419ea6";
