# Debugging Crashes

## Crashes

When an app crashes, macOS creates a `.ips` file in `~/Library/Logs/DiagnosticReports`. You can view these using the built in Console app (`cmd-space Console`) under "Crash Reports".

If you have enabled Zed's telemetry these will be uploaded to us when you restart the app. They end up in Datadog, and a [Slack channel (internal only)](https://zed-industries.slack.com/archives/C04S6T1T7TQ).

These crash reports are generated by the crashing binary, and contain a wealth of information; but they are hard to read for a few reasons:

- They don't contain source files and line numbers
- The symbols are [mangled](https://doc.rust-lang.org/rustc/symbol-mangling/index.html)
- Inlined functions are elided

To get a better sense of the backtrace of a crash you can download the `.ips` file locally and run:

```
./script/symbolicate ~/path/zed-XXX-XXX.ips
```

This will download the correct debug symbols from our public [digital ocean bucket](https://zed-debug-symbols.nyc3.digitaloceanspaces.com), and run [symbolicate](https://crates.io/crates/symbolicate) for you.

The output contains the source file and line number, and the demangled symbol information for every inlined frame.

## Panics

When the app panics at the rust level, Zed creates a file in `~/Library/Logs/Zed` with the text of the panic, and a summary of the backtrace. On boot, if you have telemetry enabled, we upload these panics so we can keep track of them.

A panic is also considered a crash, and so for most panics we get both the crash report and the panic.
