﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sts/STS_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Xml
{
  class XmlNode;
} // namespace Xml
} // namespace Utils
namespace STS
{
namespace Model
{

  /**
   * <p>The identifiers for the temporary security credentials that the operation
   * returns.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/AssumedRoleUser">AWS
   * API Reference</a></p>
   */
  class AssumedRoleUser
  {
  public:
    AWS_STS_API AssumedRoleUser();
    AWS_STS_API AssumedRoleUser(const Aws::Utils::Xml::XmlNode& xmlNode);
    AWS_STS_API AssumedRoleUser& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

    AWS_STS_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
    AWS_STS_API void OutputToStream(Aws::OStream& oStream, const char* location) const;


    ///@{
    /**
     * <p>A unique identifier that contains the role ID and the role session name of
     * the role that is being assumed. The role ID is generated by Amazon Web Services
     * when the role is created.</p>
     */
    inline const Aws::String& GetAssumedRoleId() const{ return m_assumedRoleId; }
    inline bool AssumedRoleIdHasBeenSet() const { return m_assumedRoleIdHasBeenSet; }
    inline void SetAssumedRoleId(const Aws::String& value) { m_assumedRoleIdHasBeenSet = true; m_assumedRoleId = value; }
    inline void SetAssumedRoleId(Aws::String&& value) { m_assumedRoleIdHasBeenSet = true; m_assumedRoleId = std::move(value); }
    inline void SetAssumedRoleId(const char* value) { m_assumedRoleIdHasBeenSet = true; m_assumedRoleId.assign(value); }
    inline AssumedRoleUser& WithAssumedRoleId(const Aws::String& value) { SetAssumedRoleId(value); return *this;}
    inline AssumedRoleUser& WithAssumedRoleId(Aws::String&& value) { SetAssumedRoleId(std::move(value)); return *this;}
    inline AssumedRoleUser& WithAssumedRoleId(const char* value) { SetAssumedRoleId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ARN of the temporary security credentials that are returned from the
     * <a>AssumeRole</a> action. For more information about ARNs and how to use them in
     * policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
     * Identifiers</a> in the <i>IAM User Guide</i>.</p>
     */
    inline const Aws::String& GetArn() const{ return m_arn; }
    inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
    inline void SetArn(const Aws::String& value) { m_arnHasBeenSet = true; m_arn = value; }
    inline void SetArn(Aws::String&& value) { m_arnHasBeenSet = true; m_arn = std::move(value); }
    inline void SetArn(const char* value) { m_arnHasBeenSet = true; m_arn.assign(value); }
    inline AssumedRoleUser& WithArn(const Aws::String& value) { SetArn(value); return *this;}
    inline AssumedRoleUser& WithArn(Aws::String&& value) { SetArn(std::move(value)); return *this;}
    inline AssumedRoleUser& WithArn(const char* value) { SetArn(value); return *this;}
    ///@}
  private:

    Aws::String m_assumedRoleId;
    bool m_assumedRoleIdHasBeenSet = false;

    Aws::String m_arn;
    bool m_arnHasBeenSet = false;
  };

} // namespace Model
} // namespace STS
} // namespace Aws
