/*--------------------------------------------------------------------------*/
/* Copyright 2022 NXP                                                       */
/*                                                                          */
/* NXP Confidential. This software is owned or controlled by NXP and may    */
/* only be used strictly in accordance with the applicable license terms.   */
/* By expressly accepting such terms or by downloading, installing,         */
/* activating and/or otherwise using the software, you are agreeing that    */
/* you have read, and that you agree to comply with and are bound by, such  */
/* license terms. If you do not agree to be bound by the applicable license */
/* terms, then you may not retain, install, activate or otherwise use the   */
/* software.                                                                */
/*--------------------------------------------------------------------------*/

/**
 * @file  mcuxClEls_mapping.h
 * @brief Header providing mapping for legacy function/definition names (with CSS)
 */


#ifndef MCUXCLELS_MAPPING_H_
#define MCUXCLELS_MAPPING_H_

/* Public definitions */
/**
 * MCUXCLCSS_CSS_((?:INTERRUPT_DISABLE|INTERRUPT_ENABLE|INTERRUPT_KEEP|INTERRUPT_SET|RESET_CLEAR|RESET_KEEP))(?!\w)
 * -->
 * MCUXCLELS_ELS_\1
 *
 * MCUXCLCSS_((?:API|AEAD_AAD_BLOCK_SIZE|AEAD_ACPMOD_AADPROC|AEAD_ACPMOD_FINAL|AEAD_ACPMOD_INIT|AEAD_ACPMOD_MSGPROC|AEAD_CONTEXT_SIZE|AEAD_DECRYPT|AEAD_ENCRYPT|AEAD_EXTERN_KEY|AEAD_INTERN_KEY|AEAD_IV_BLOCK_SIZE|AEAD_LASTINIT_FALSE|AEAD_LASTINIT_TRUE|AEAD_STATE_IN_DISABLE|AEAD_STATE_IN_ENABLE|AEAD_STATE_OUT_ENABLE|AEAD_TAG_SIZE|CIPHERPARAM_ALGORITHM_AES_CBC|CIPHERPARAM_ALGORITHM_AES_CTR|CIPHERPARAM_ALGORITHM_AES_ECB|CIPHER_BLOCK_SIZE_AES|CIPHER_DECRYPT|CIPHER_ENCRYPT|CIPHER_EXTERNAL_KEY|CIPHER_INTERNAL_KEY|CIPHER_KEY_SIZE_AES_128|CIPHER_KEY_SIZE_AES_192|CIPHER_KEY_SIZE_AES_256|CIPHER_STATE_IN_DISABLE|CIPHER_STATE_IN_ENABLE|CIPHER_STATE_OUT_DISABLE|CIPHER_STATE_OUT_ENABLE|CKDF_ALGO_SP800108|CKDF_ALGO_SP80056C_EXPAND|CKDF_ALGO_SP80056C_EXTRACT|CKDF_DERIVATIONDATA_SIZE|CKDF_RTF_DERIV|CKDF_SP80056C_DERIVATIONDATA_SIZE_16|CKDF_SP80056C_DERIVATIONDATA_SIZE_32|CKDF_SYSTEM_MEMORY_DERIV|CMAC_EXTERNAL_KEY_DISABLE|CMAC_EXTERNAL_KEY_ENABLE|CMAC_FINALIZE_DISABLE|CMAC_FINALIZE_ENABLE|CMAC_INITIALIZE_DISABLE|CMAC_INITIALIZE_ENABLE|CMAC_KEY_SIZE_128|CMAC_KEY_SIZE_256|CMAC_OUT_SIZE))(?!\w)
 * MCUXCLCSS_((?:CMD_CRC_CMD_ID_AUTH_CIPHER|CMD_CRC_CMD_ID_CHAL_RESP_GEN|CMD_CRC_CMD_ID_CIPHER|CMD_CRC_CMD_ID_CKDF|CMD_CRC_CMD_ID_CMAC|CMD_CRC_CMD_ID_DRBG_TEST|CMD_CRC_CMD_ID_DTRNG_CFG_LOAD|CMD_CRC_CMD_ID_DTRNG_EVAL|CMD_CRC_CMD_ID_ECKXH|CMD_CRC_CMD_ID_ECSIGN|CMD_CRC_CMD_ID_ECVFY|CMD_CRC_CMD_ID_GDET_CFG_LOAD|CMD_CRC_CMD_ID_GDET_TRIM|CMD_CRC_CMD_ID_HASH|CMD_CRC_CMD_ID_HKDF|CMD_CRC_CMD_ID_HMAC|CMD_CRC_CMD_ID_KDELETE|CMD_CRC_CMD_ID_KEYGEN|CMD_CRC_CMD_ID_KEYIN|CMD_CRC_CMD_ID_KEYOUT|CMD_CRC_CMD_ID_KEYPROV|CMD_CRC_CMD_ID_RND_REQ|CMD_CRC_CMD_ID_TLS|CMD_CRC_DISABLE|CMD_CRC_ENABLE|CMD_CRC_INITIAL_VALUE|CMD_CRC_POLYNOMIAL|CMD_CRC_REFERENCE_INIT|CMD_CRC_REFERENCE_RESET|CMD_CRC_REFERENCE_UPDATE_AEAD_FINALIZE|CMD_CRC_REFERENCE_UPDATE_AEAD_INIT|CMD_CRC_REFERENCE_UPDATE_AEAD_PARTIALINIT|CMD_CRC_REFERENCE_UPDATE_AEAD_UPDATEAAD|CMD_CRC_REFERENCE_UPDATE_AEAD_UPDATEDATA|CMD_CRC_REFERENCE_UPDATE_CIPHER|CMD_CRC_REFERENCE_UPDATE_CKDF_SP800108|CMD_CRC_REFERENCE_UPDATE_CKDF_SP80056C_EXPAND|CMD_CRC_REFERENCE_UPDATE_CKDF_SP80056C_EXTRACT|CMD_CRC_REFERENCE_UPDATE_CMAC))(?!\w)
 * MCUXCLCSS_((?:CMD_CRC_REFERENCE_UPDATE_ECCKEYEXCHANGE|CMD_CRC_REFERENCE_UPDATE_ECCKEYEXCHANGEINT|CMD_CRC_REFERENCE_UPDATE_ECCKEYGEN|CMD_CRC_REFERENCE_UPDATE_ECCSIGN|CMD_CRC_REFERENCE_UPDATE_ECCVERFIFY|CMD_CRC_REFERENCE_UPDATE_ECCVERFIFYINT|CMD_CRC_REFERENCE_UPDATE_GLITCHDETECTOR_LOADCONFIG|CMD_CRC_REFERENCE_UPDATE_GLITCHDETECTOR_TRIM|CMD_CRC_REFERENCE_UPDATE_HASH|CMD_CRC_REFERENCE_UPDATE_HKDF_RFC5869|CMD_CRC_REFERENCE_UPDATE_HKDF_SP80056C|CMD_CRC_REFERENCE_UPDATE_HMAC|CMD_CRC_REFERENCE_UPDATE_KEYDELETE|CMD_CRC_REFERENCE_UPDATE_KEYEXPORT|CMD_CRC_REFERENCE_UPDATE_KEYIMPORT|CMD_CRC_REFERENCE_UPDATE_KEYIMPORTPUK|CMD_CRC_REFERENCE_UPDATE_KEYPROVISION|CMD_CRC_REFERENCE_UPDATE_KEYPROVISIONROM|CMD_CRC_REFERENCE_UPDATE_PRNG_INIT|CMD_CRC_REFERENCE_UPDATE_RESPGEN|CMD_CRC_REFERENCE_UPDATE_RNG_DRBGREQUEST|CMD_CRC_REFERENCE_UPDATE_RNG_DRBGREQUESTRAW|CMD_CRC_REFERENCE_UPDATE_RNG_DRBGTESTAESCTR|CMD_CRC_REFERENCE_UPDATE_RNG_DRBGTESTAESECB|CMD_CRC_REFERENCE_UPDATE_RNG_DRBGTESTEXTRACT|CMD_CRC_REFERENCE_UPDATE_RNG_DRBGTESTINSTANTIATE|CMD_CRC_REFERENCE_UPDATE_RNG_DTRNG_CONFIGEVALUATE))(?!\w)
 * MCUXCLCSS_((?:CMD_CRC_REFERENCE_UPDATE_RNG_DTRNG_CONFIGLOAD|CMD_CRC_REFERENCE_UPDATE_TLSGENERATEMASTERKEYFROMPREMASTERKEY|CMD_CRC_REFERENCE_UPDATE_TLSGENERATESESSIONKEYSFROMMASTERKEY|CMD_CRC_RESET|CMD_CRC_VALUE_DISABLE|CMD_CRC_VALUE_ENABLE|CMD_CRC_VALUE_RESET|DMA_READBACK_PROTECTION_TOKEN|ECC_EXTKEY_EXTERNAL|ECC_EXTKEY_INTERNAL|ECC_GEN_PUBLIC_KEY|ECC_HASHED|ECC_INCLUDE_RANDOM_DATA|ECC_NOT_HASHED|ECC_NO_RANDOM_DATA|ECC_NO_RTF|ECC_OUTPUTKEY_DETERMINISTIC|ECC_OUTPUTKEY_KEYEXCHANGE|ECC_OUTPUTKEY_RANDOM|ECC_OUTPUTKEY_SIGN|ECC_PUBLICKEY_SIGN_DISABLE|ECC_PUBLICKEY_SIGN_ENABLE|ECC_PUBLICKEY_SIZE|ECC_REVERSEFETCH_DISABLE|ECC_REVERSEFETCH_ENABLE|ECC_RTF|ECC_SIGNATURE_R_SIZE|ECC_SIGNATURE_SIZE|ECC_SKIP_PUBLIC_KEY|ECC_VALUE_HASHED|ECC_VALUE_NOT_HASHED|ECC_VALUE_NO_RTF|ECC_VALUE_RTF|ERROR_FLAGS_CLEAR|ERROR_FLAGS_KEEP|GLITCHDETECTOR_CFG_SIZE|GLITCHDETECTOR_TRIM_SIZE|GLITCH_DETECTOR_INTERRUPT_DISABLE|GLITCH_DETECTOR_INTERRUPT_ENABLE|GLITCH_DETECTOR_NEG_KEEP))(?!\w)
 * MCUXCLCSS_((?:GLITCH_DETECTOR_NEG_SET|GLITCH_DETECTOR_POS_KEEP|GLITCH_DETECTOR_POS_SET|GLITCH_DETECTOR_RESET_CLEAR|GLITCH_DETECTOR_RESET_KEEP|HASH_BLOCK_SIZE_SHA_224|HASH_BLOCK_SIZE_SHA_256|HASH_BLOCK_SIZE_SHA_384|HASH_BLOCK_SIZE_SHA_512|HASH_INIT_DISABLE|HASH_INIT_ENABLE|HASH_LOAD_DISABLE|HASH_LOAD_ENABLE|HASH_MODE_SHA_224|HASH_MODE_SHA_256|HASH_MODE_SHA_384|HASH_MODE_SHA_512|HASH_OUTPUT_DISABLE|HASH_OUTPUT_ENABLE|HASH_OUTPUT_SIZE_SHA_224|HASH_OUTPUT_SIZE_SHA_256|HASH_OUTPUT_SIZE_SHA_384|HASH_OUTPUT_SIZE_SHA_512|HASH_RTF_OUTPUT_DISABLE|HASH_RTF_OUTPUT_ENABLE|HASH_RTF_OUTPUT_SIZE|HASH_RTF_UPDATE_DISABLE|HASH_RTF_UPDATE_ENABLE|HASH_STATE_SIZE_SHA_224|HASH_STATE_SIZE_SHA_256|HASH_STATE_SIZE_SHA_384|HASH_STATE_SIZE_SHA_512|HASH_VALUE_MODE_SHA_224|HASH_VALUE_MODE_SHA_256|HASH_VALUE_MODE_SHA_384|HASH_VALUE_MODE_SHA_512|HKDF_ALGO_RFC5869|HKDF_ALGO_SP80056C|HKDF_RFC5869_DERIVATIONDATA_SIZE|HKDF_SP80056C_TARGETKEY_SIZE|HKDF_VALUE_MEMORY_DERIV|HKDF_VALUE_RTF_DERIV|HMAC_EXTERNAL_KEY_DISABLE|HMAC_EXTERNAL_KEY_ENABLE|HMAC_OUTPUT_SIZE|HMAC_PADDED_KEY_SIZE|HW_VERSION))(?!\w)
 * MCUXCLCSS_((?:KEYGEN_VALUE_DETERMINISTIC|KEYGEN_VALUE_GEN_PUB_KEY|KEYGEN_VALUE_NO_PUB_KEY|KEYGEN_VALUE_NO_RANDOM_DATA|KEYGEN_VALUE_RANDOM|KEYGEN_VALUE_SIGN_PUBLICKEY|KEYGEN_VALUE_TYPE_KEYEXCHANGE|KEYGEN_VALUE_TYPE_SIGN|KEYGEN_VALUE_USE_RANDOM_DATA|KEYIMPORT_KFMT_PBK|KEYIMPORT_KFMT_PUF|KEYIMPORT_KFMT_RFC3394|KEYIMPORT_KFMT_UDF|KEYIMPORT_REVERSEFETCH_DISABLE|KEYIMPORT_REVERSEFETCH_ENABLE|KEYIMPORT_VALUE_KFMT_PBK|KEYIMPORT_VALUE_KFMT_PUF|KEYIMPORT_VALUE_KFMT_RFC3394|KEYIMPORT_VALUE_KFMT_UDF|KEYPROPERTY_ACTIVE_FALSE|KEYPROPERTY_ACTIVE_TRUE|KEYPROPERTY_AES_FALSE|KEYPROPERTY_AES_TRUE|KEYPROPERTY_BASE_SLOT|KEYPROPERTY_CKDF_FALSE|KEYPROPERTY_CKDF_TRUE|KEYPROPERTY_CMAC_FALSE|KEYPROPERTY_CMAC_TRUE|KEYPROPERTY_DEVICE_UNIQUE_FALSE|KEYPROPERTY_DEVICE_UNIQUE_TRUE|KEYPROPERTY_ECC_DH_PRIVATE_FALSE|KEYPROPERTY_ECC_DH_PRIVATE_TRUE|KEYPROPERTY_ECC_FALSE|KEYPROPERTY_ECC_TRUE|KEYPROPERTY_GENERAL_PURPOSE_SLOT_FALSE|KEYPROPERTY_GENERAL_PURPOSE_SLOT_TRUE|KEYPROPERTY_HKDF_FALSE|KEYPROPERTY_HKDF_TRUE|KEYPROPERTY_HMAC_FALSE|KEYPROPERTY_HMAC_TRUE|KEYPROPERTY_HW_OUT_FALSE|KEYPROPERTY_HW_OUT_SLOT_FALSE))(?!\w)
 * MCUXCLCSS_((?:KEYPROPERTY_HW_OUT_SLOT_TRUE|KEYPROPERTY_HW_OUT_TRUE|KEYPROPERTY_INPUT_FOR_ECC_FALSE|KEYPROPERTY_INPUT_FOR_ECC_TRUE|KEYPROPERTY_KEY_SIZE_128|KEYPROPERTY_KEY_SIZE_256|KEYPROPERTY_KEY_SIZE_512|KEYPROPERTY_KSK_FALSE|KEYPROPERTY_KSK_TRUE|KEYPROPERTY_KUOK_FALSE|KEYPROPERTY_KUOK_TRUE|KEYPROPERTY_KWK_FALSE|KEYPROPERTY_KWK_TRUE|KEYPROPERTY_PRIVILEGED_FALSE|KEYPROPERTY_PRIVILEGED_TRUE|KEYPROPERTY_PUK_FALSE|KEYPROPERTY_PUK_TRUE|KEYPROPERTY_RETENTION_SLOT_FALSE|KEYPROPERTY_RETENTION_SLOT_TRUE|KEYPROPERTY_RTF_FALSE|KEYPROPERTY_RTF_TRUE|KEYPROPERTY_SECOND_SLOT|KEYPROPERTY_SECURE_FALSE|KEYPROPERTY_SECURE_TRUE|KEYPROPERTY_TECDH_FALSE|KEYPROPERTY_TECDH_TRUE|KEYPROPERTY_TLS_MASTER_SECRET_FALSE|KEYPROPERTY_TLS_MASTER_SECRET_TRUE|KEYPROPERTY_TLS_PREMASTER_SECRET_FALSE|KEYPROPERTY_TLS_PREMASTER_SECRET_TRUE|KEYPROPERTY_VALUE_ACTIVE|KEYPROPERTY_VALUE_AES|KEYPROPERTY_VALUE_BASE_SLOT|KEYPROPERTY_VALUE_CKDF|KEYPROPERTY_VALUE_CMAC|KEYPROPERTY_VALUE_DUK|KEYPROPERTY_VALUE_ECDH|KEYPROPERTY_VALUE_ECSGN|KEYPROPERTY_VALUE_GENERAL_PURPOSE_SLOT|KEYPROPERTY_VALUE_HKDF|KEYPROPERTY_VALUE_HMAC))(?!\w)
 * MCUXCLCSS_((?:KEYPROPERTY_VALUE_HW_OUT|KEYPROPERTY_VALUE_HW_OUT_SLOT|KEYPROPERTY_VALUE_KEY_SIZE_128|KEYPROPERTY_VALUE_KEY_SIZE_256|KEYPROPERTY_VALUE_KEY_SIZE_512|KEYPROPERTY_VALUE_KGSRC|KEYPROPERTY_VALUE_KSK|KEYPROPERTY_VALUE_KUOK|KEYPROPERTY_VALUE_KWK|KEYPROPERTY_VALUE_NOTPRIVILEGED|KEYPROPERTY_VALUE_NOTSECURE|KEYPROPERTY_VALUE_PRIVILEGED|KEYPROPERTY_VALUE_PUK|KEYPROPERTY_VALUE_RETENTION_SLOT|KEYPROPERTY_VALUE_RTF|KEYPROPERTY_VALUE_SECURE|KEYPROPERTY_VALUE_TECDH|KEYPROPERTY_VALUE_TLS_MASTER_SECRET|KEYPROPERTY_VALUE_TLS_PREMASTER_SECRET|KEYPROPERTY_VALUE_WRPOK|KEYPROPERTY_WRAP_FALSE|KEYPROPERTY_WRAP_TRUE|KEYPROV_DUK_UPDATE_DISABLE|KEYPROV_DUK_UPDATE_ENABLE|KEYPROV_KEYSHARE_TABLE_SIZE|KEYPROV_KEY_PART_1_SIZE|KEYPROV_NOIC_DISABLE|KEYPROV_NOIC_ENABLE|KEYPROV_TESTERSHARE_SIZE|KEYPROV_VALUE_NOIC|KEY_SLOTS|MASTER_UNLOCK_ANY|RESET_CANCEL|RESET_DO_NOT_CANCEL|RESP_GEN_AVAILABLE_SLOT_0|RESP_GEN_AVAILABLE_SLOT_1|RESP_GEN_AVAILABLE_SLOT_2|RESP_GEN_SLOTS|RFC3394_CONTAINER_SIZE_128|RFC3394_CONTAINER_SIZE_256|RFC3394_CONTAINER_SIZE_P256|RFC3394_OVERHEAD|RNG_DRBG_TEST_EXTRACT_OUTPUT_MAX_SIZE))(?!\w)
 * MCUXCLCSS_((?:RNG_DRBG_TEST_EXTRACT_OUTPUT_MIN_SIZE|RNG_DRBG_TEST_MODE_AES_CTR|RNG_DRBG_TEST_MODE_AES_ECB|RNG_DRBG_TEST_MODE_EXTRACT|RNG_DRBG_TEST_MODE_INSTANTIATE|RNG_DTRNG_CONFIG_SIZE|RNG_DTRNG_EVAL_CONFIG_SIZE|RNG_DTRNG_EVAL_RESULT_SIZE|RNG_RAW_ENTROPY_SIZE|RNG_RND_REQ_PRND_INIT|RNG_RND_REQ_RND_RAW|STATUS_DRBGENTLVL_HIGH|STATUS_DRBGENTLVL_LOW|STATUS_DRBGENTLVL_NONE|STATUS_ECDSAVFY_ERROR|STATUS_ECDSAVFY_FAIL|STATUS_ECDSAVFY_NORUN|STATUS_ECDSAVFY_OK|STATUS_HW_ALGORITHM|STATUS_HW_BUS|STATUS_HW_DTRNG|STATUS_HW_FAULT|STATUS_HW_INTEGRITY|STATUS_HW_OPERATIONAL|STATUS_HW_PRNG|STATUS_IS_HW_ERROR|STATUS_IS_SW_ERROR|STATUS_OK|STATUS_OK_WAIT|STATUS_PPROT_PRIVILEGED_NONSECURE|STATUS_PPROT_PRIVILEGED_SECURE|STATUS_PPROT_UNPRIVILEGED_NONSECURE|STATUS_PPROT_UNPRIVILEGED_SECURE|STATUS_SW_CANNOT_INTERRUPT|STATUS_SW_COMPARISON_FAILED|STATUS_SW_COUNTER_EXPIRED|STATUS_SW_FAULT|STATUS_SW_INVALID_PARAM|STATUS_SW_INVALID_STATE|STATUS_SW_LOCKING_FAILED|STATUS_SW_STATUS_LOCKED|TLS_DERIVATIONDATA_SIZE|TLS_FINALIZE|TLS_INIT|TLS_RANDOM_SIZE))(?!\w)
 * -->
 * MCUXCLELS_\1
 */
#define MCUXCLCSS_API  MCUXCLELS_API
#define MCUXCLCSS_AEAD_AAD_BLOCK_SIZE  MCUXCLELS_AEAD_AAD_BLOCK_SIZE
#define MCUXCLCSS_AEAD_ACPMOD_AADPROC  MCUXCLELS_AEAD_ACPMOD_AADPROC
#define MCUXCLCSS_AEAD_ACPMOD_FINAL  MCUXCLELS_AEAD_ACPMOD_FINAL
#define MCUXCLCSS_AEAD_ACPMOD_INIT  MCUXCLELS_AEAD_ACPMOD_INIT
#define MCUXCLCSS_AEAD_ACPMOD_MSGPROC  MCUXCLELS_AEAD_ACPMOD_MSGPROC
#define MCUXCLCSS_AEAD_CONTEXT_SIZE  MCUXCLELS_AEAD_CONTEXT_SIZE
#define MCUXCLCSS_AEAD_DECRYPT  MCUXCLELS_AEAD_DECRYPT
#define MCUXCLCSS_AEAD_ENCRYPT  MCUXCLELS_AEAD_ENCRYPT
#define MCUXCLCSS_AEAD_EXTERN_KEY  MCUXCLELS_AEAD_EXTERN_KEY
#define MCUXCLCSS_AEAD_INTERN_KEY  MCUXCLELS_AEAD_INTERN_KEY
#define MCUXCLCSS_AEAD_IV_BLOCK_SIZE  MCUXCLELS_AEAD_IV_BLOCK_SIZE
#define MCUXCLCSS_AEAD_LASTINIT_FALSE  MCUXCLELS_AEAD_LASTINIT_FALSE
#define MCUXCLCSS_AEAD_LASTINIT_TRUE  MCUXCLELS_AEAD_LASTINIT_TRUE
#define MCUXCLCSS_AEAD_STATE_IN_DISABLE  MCUXCLELS_AEAD_STATE_IN_DISABLE
#define MCUXCLCSS_AEAD_STATE_IN_ENABLE  MCUXCLELS_AEAD_STATE_IN_ENABLE
#define MCUXCLCSS_AEAD_STATE_OUT_ENABLE  MCUXCLELS_AEAD_STATE_OUT_ENABLE
#define MCUXCLCSS_AEAD_TAG_SIZE  MCUXCLELS_AEAD_TAG_SIZE
#define MCUXCLCSS_CIPHERPARAM_ALGORITHM_AES_CBC  MCUXCLELS_CIPHERPARAM_ALGORITHM_AES_CBC
#define MCUXCLCSS_CIPHERPARAM_ALGORITHM_AES_CTR  MCUXCLELS_CIPHERPARAM_ALGORITHM_AES_CTR
#define MCUXCLCSS_CIPHERPARAM_ALGORITHM_AES_ECB  MCUXCLELS_CIPHERPARAM_ALGORITHM_AES_ECB
#define MCUXCLCSS_CIPHER_BLOCK_SIZE_AES  MCUXCLELS_CIPHER_BLOCK_SIZE_AES
#define MCUXCLCSS_CIPHER_DECRYPT  MCUXCLELS_CIPHER_DECRYPT
#define MCUXCLCSS_CIPHER_ENCRYPT  MCUXCLELS_CIPHER_ENCRYPT
#define MCUXCLCSS_CIPHER_EXTERNAL_KEY  MCUXCLELS_CIPHER_EXTERNAL_KEY
#define MCUXCLCSS_CIPHER_INTERNAL_KEY  MCUXCLELS_CIPHER_INTERNAL_KEY
#define MCUXCLCSS_CIPHER_KEY_SIZE_AES_128  MCUXCLELS_CIPHER_KEY_SIZE_AES_128
#define MCUXCLCSS_CIPHER_KEY_SIZE_AES_192  MCUXCLELS_CIPHER_KEY_SIZE_AES_192
#define MCUXCLCSS_CIPHER_KEY_SIZE_AES_256  MCUXCLELS_CIPHER_KEY_SIZE_AES_256
#define MCUXCLCSS_CIPHER_STATE_IN_DISABLE  MCUXCLELS_CIPHER_STATE_IN_DISABLE
#define MCUXCLCSS_CIPHER_STATE_IN_ENABLE  MCUXCLELS_CIPHER_STATE_IN_ENABLE
#define MCUXCLCSS_CIPHER_STATE_OUT_DISABLE  MCUXCLELS_CIPHER_STATE_OUT_DISABLE
#define MCUXCLCSS_CIPHER_STATE_OUT_ENABLE  MCUXCLELS_CIPHER_STATE_OUT_ENABLE
#define MCUXCLCSS_CKDF_ALGO_SP800108  MCUXCLELS_CKDF_ALGO_SP800108
#define MCUXCLCSS_CKDF_ALGO_SP80056C_EXPAND  MCUXCLELS_CKDF_ALGO_SP80056C_EXPAND
#define MCUXCLCSS_CKDF_ALGO_SP80056C_EXTRACT  MCUXCLELS_CKDF_ALGO_SP80056C_EXTRACT
#define MCUXCLCSS_CKDF_DERIVATIONDATA_SIZE  MCUXCLELS_CKDF_DERIVATIONDATA_SIZE
#define MCUXCLCSS_HKDF_RTF_DERIV  MCUXCLELS_HKDF_RTF_DERIV
#define MCUXCLCSS_CKDF_SP80056C_DERIVATIONDATA_SIZE_16  MCUXCLELS_CKDF_SP80056C_DERIVATIONDATA_SIZE_16
#define MCUXCLCSS_CKDF_SP80056C_DERIVATIONDATA_SIZE_32  MCUXCLELS_CKDF_SP80056C_DERIVATIONDATA_SIZE_32
#define MCUXCLCSS_HKDF_SYSTEM_MEMORY_DERIV  MCUXCLELS_HKDF_SYSTEM_MEMORY_DERIV
#define MCUXCLCSS_CMAC_EXTERNAL_KEY_DISABLE  MCUXCLELS_CMAC_EXTERNAL_KEY_DISABLE
#define MCUXCLCSS_CMAC_EXTERNAL_KEY_ENABLE  MCUXCLELS_CMAC_EXTERNAL_KEY_ENABLE
#define MCUXCLCSS_CMAC_FINALIZE_DISABLE  MCUXCLELS_CMAC_FINALIZE_DISABLE
#define MCUXCLCSS_CMAC_FINALIZE_ENABLE  MCUXCLELS_CMAC_FINALIZE_ENABLE
#define MCUXCLCSS_CMAC_INITIALIZE_DISABLE  MCUXCLELS_CMAC_INITIALIZE_DISABLE
#define MCUXCLCSS_CMAC_INITIALIZE_ENABLE  MCUXCLELS_CMAC_INITIALIZE_ENABLE
#define MCUXCLCSS_CMAC_KEY_SIZE_128  MCUXCLELS_CMAC_KEY_SIZE_128
#define MCUXCLCSS_CMAC_KEY_SIZE_256  MCUXCLELS_CMAC_KEY_SIZE_256
#define MCUXCLCSS_CMAC_OUT_SIZE  MCUXCLELS_CMAC_OUT_SIZE
#define MCUXCLCSS_CMD_CRC_CMD_ID_AUTH_CIPHER  MCUXCLELS_CMD_CRC_CMD_ID_AUTH_CIPHER
#define MCUXCLCSS_CMD_CRC_CMD_ID_CHAL_RESP_GEN  MCUXCLELS_CMD_CRC_CMD_ID_CHAL_RESP_GEN
#define MCUXCLCSS_CMD_CRC_CMD_ID_CIPHER  MCUXCLELS_CMD_CRC_CMD_ID_CIPHER
#define MCUXCLCSS_CMD_CRC_CMD_ID_CKDF  MCUXCLELS_CMD_CRC_CMD_ID_CKDF
#define MCUXCLCSS_CMD_CRC_CMD_ID_CMAC  MCUXCLELS_CMD_CRC_CMD_ID_CMAC
#define MCUXCLCSS_CMD_CRC_CMD_ID_DRBG_TEST  MCUXCLELS_CMD_CRC_CMD_ID_DRBG_TEST
#define MCUXCLCSS_CMD_CRC_CMD_ID_DTRNG_CFG_LOAD  MCUXCLELS_CMD_CRC_CMD_ID_DTRNG_CFG_LOAD
#define MCUXCLCSS_CMD_CRC_CMD_ID_DTRNG_EVAL  MCUXCLELS_CMD_CRC_CMD_ID_DTRNG_EVAL
#define MCUXCLCSS_CMD_CRC_CMD_ID_ECKXH  MCUXCLELS_CMD_CRC_CMD_ID_ECKXH
#define MCUXCLCSS_CMD_CRC_CMD_ID_ECSIGN  MCUXCLELS_CMD_CRC_CMD_ID_ECSIGN
#define MCUXCLCSS_CMD_CRC_CMD_ID_ECVFY  MCUXCLELS_CMD_CRC_CMD_ID_ECVFY
#define MCUXCLCSS_CMD_CRC_CMD_ID_GDET_CFG_LOAD  MCUXCLELS_CMD_CRC_CMD_ID_GDET_CFG_LOAD
#define MCUXCLCSS_CMD_CRC_CMD_ID_GDET_TRIM  MCUXCLELS_CMD_CRC_CMD_ID_GDET_TRIM
#define MCUXCLCSS_CMD_CRC_CMD_ID_HASH  MCUXCLELS_CMD_CRC_CMD_ID_HASH
#define MCUXCLCSS_CMD_CRC_CMD_ID_HKDF  MCUXCLELS_CMD_CRC_CMD_ID_HKDF
#define MCUXCLCSS_CMD_CRC_CMD_ID_HMAC  MCUXCLELS_CMD_CRC_CMD_ID_HMAC
#define MCUXCLCSS_CMD_CRC_CMD_ID_KDELETE  MCUXCLELS_CMD_CRC_CMD_ID_KDELETE
#define MCUXCLCSS_CMD_CRC_CMD_ID_KEYGEN  MCUXCLELS_CMD_CRC_CMD_ID_KEYGEN
#define MCUXCLCSS_CMD_CRC_CMD_ID_KEYIN  MCUXCLELS_CMD_CRC_CMD_ID_KEYIN
#define MCUXCLCSS_CMD_CRC_CMD_ID_KEYOUT  MCUXCLELS_CMD_CRC_CMD_ID_KEYOUT
#define MCUXCLCSS_CMD_CRC_CMD_ID_KEYPROV  MCUXCLELS_CMD_CRC_CMD_ID_KEYPROV
#define MCUXCLCSS_CMD_CRC_CMD_ID_RND_REQ  MCUXCLELS_CMD_CRC_CMD_ID_RND_REQ
#define MCUXCLCSS_CMD_CRC_CMD_ID_TLS  MCUXCLELS_CMD_CRC_CMD_ID_TLS
#define MCUXCLCSS_CMD_CRC_DISABLE  MCUXCLELS_CMD_CRC_DISABLE
#define MCUXCLCSS_CMD_CRC_ENABLE  MCUXCLELS_CMD_CRC_ENABLE
#define MCUXCLCSS_CMD_CRC_INITIAL_VALUE  MCUXCLELS_CMD_CRC_INITIAL_VALUE
#define MCUXCLCSS_CMD_CRC_POLYNOMIAL  MCUXCLELS_CMD_CRC_POLYNOMIAL
#define MCUXCLCSS_CMD_CRC_REFERENCE_INIT  MCUXCLELS_CMD_CRC_REFERENCE_INIT
#define MCUXCLCSS_CMD_CRC_REFERENCE_RESET  MCUXCLELS_CMD_CRC_REFERENCE_RESET
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_AEAD_FINALIZE  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_AEAD_FINALIZE
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_AEAD_INIT  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_AEAD_INIT
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_AEAD_PARTIALINIT  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_AEAD_PARTIALINIT
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_AEAD_UPDATEAAD  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_AEAD_UPDATEAAD
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_AEAD_UPDATEDATA  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_AEAD_UPDATEDATA
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_CIPHER  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_CIPHER
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_CKDF_SP800108  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_CKDF_SP800108
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_CKDF_SP80056C_EXPAND  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_CKDF_SP80056C_EXPAND
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_CKDF_SP80056C_EXTRACT  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_CKDF_SP80056C_EXTRACT
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_CMAC  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_CMAC
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_ECCKEYEXCHANGE  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_ECCKEYEXCHANGE
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_ECCKEYEXCHANGEINT  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_ECCKEYEXCHANGEINT
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_ECCKEYGEN  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_ECCKEYGEN
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_ECCSIGN  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_ECCSIGN
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_ECCVERFIFY  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_ECCVERFIFY
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_ECCVERFIFYINT  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_ECCVERFIFYINT
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_GLITCHDETECTOR_LOADCONFIG  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_GLITCHDETECTOR_LOADCONFIG
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_GLITCHDETECTOR_TRIM  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_GLITCHDETECTOR_TRIM
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_HASH  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_HASH
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_HKDF_RFC5869  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_HKDF_RFC5869
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_HKDF_SP80056C  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_HKDF_SP80056C
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_HMAC  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_HMAC
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_KEYDELETE  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_KEYDELETE
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_KEYEXPORT  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_KEYEXPORT
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_KEYIMPORT  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_KEYIMPORT
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_KEYIMPORTPUK  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_KEYIMPORTPUK
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_KEYPROVISION  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_KEYPROVISION
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_KEYPROVISIONROM  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_KEYPROVISIONROM
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_PRNG_INIT  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_PRNG_INIT
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_RESPGEN  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_RESPGEN
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_RNG_DRBGREQUEST  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_RNG_DRBGREQUEST
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_RNG_DRBGREQUESTRAW  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_RNG_DRBGREQUESTRAW
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_RNG_DRBGTESTAESCTR  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_RNG_DRBGTESTAESCTR
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_RNG_DRBGTESTAESECB  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_RNG_DRBGTESTAESECB
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_RNG_DRBGTESTEXTRACT  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_RNG_DRBGTESTEXTRACT
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_RNG_DRBGTESTINSTANTIATE  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_RNG_DRBGTESTINSTANTIATE
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_RNG_DTRNG_CONFIGEVALUATE  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_RNG_DTRNG_CONFIGEVALUATE
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_RNG_DTRNG_CONFIGLOAD  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_RNG_DTRNG_CONFIGLOAD
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_TLSGENERATEMASTERKEYFROMPREMASTERKEY  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_TLSGENERATEMASTERKEYFROMPREMASTERKEY
#define MCUXCLCSS_CMD_CRC_REFERENCE_UPDATE_TLSGENERATESESSIONKEYSFROMMASTERKEY  MCUXCLELS_CMD_CRC_REFERENCE_UPDATE_TLSGENERATESESSIONKEYSFROMMASTERKEY
#define MCUXCLCSS_CMD_CRC_RESET  MCUXCLELS_CMD_CRC_RESET
#define MCUXCLCSS_CMD_CRC_VALUE_DISABLE  MCUXCLELS_CMD_CRC_VALUE_DISABLE
#define MCUXCLCSS_CMD_CRC_VALUE_ENABLE  MCUXCLELS_CMD_CRC_VALUE_ENABLE
#define MCUXCLCSS_CMD_CRC_VALUE_RESET  MCUXCLELS_CMD_CRC_VALUE_RESET
#define MCUXCLCSS_CSS_INTERRUPT_DISABLE  MCUXCLELS_ELS_INTERRUPT_DISABLE
#define MCUXCLCSS_CSS_INTERRUPT_ENABLE  MCUXCLELS_ELS_INTERRUPT_ENABLE
#define MCUXCLCSS_CSS_INTERRUPT_KEEP  MCUXCLELS_ELS_INTERRUPT_KEEP
#define MCUXCLCSS_CSS_INTERRUPT_SET  MCUXCLELS_ELS_INTERRUPT_SET
#define MCUXCLCSS_CSS_RESET_CLEAR  MCUXCLELS_ELS_RESET_CLEAR
#define MCUXCLCSS_CSS_RESET_KEEP  MCUXCLELS_ELS_RESET_KEEP
#define MCUXCLCSS_DMA_READBACK_PROTECTION_TOKEN  MCUXCLELS_DMA_READBACK_PROTECTION_TOKEN
#define MCUXCLCSS_ECC_EXTKEY_EXTERNAL  MCUXCLELS_ECC_EXTKEY_EXTERNAL
#define MCUXCLCSS_ECC_EXTKEY_INTERNAL  MCUXCLELS_ECC_EXTKEY_INTERNAL
#define MCUXCLCSS_ECC_GEN_PUBLIC_KEY  MCUXCLELS_ECC_GEN_PUBLIC_KEY
#define MCUXCLCSS_ECC_HASHED  MCUXCLELS_ECC_HASHED
#define MCUXCLCSS_ECC_INCLUDE_RANDOM_DATA  MCUXCLELS_ECC_INCLUDE_RANDOM_DATA
#define MCUXCLCSS_ECC_NOT_HASHED  MCUXCLELS_ECC_NOT_HASHED
#define MCUXCLCSS_ECC_NO_RANDOM_DATA  MCUXCLELS_ECC_NO_RANDOM_DATA
#define MCUXCLCSS_ECC_NO_RTF  MCUXCLELS_ECC_NO_RTF
#define MCUXCLCSS_ECC_OUTPUTKEY_DETERMINISTIC  MCUXCLELS_ECC_OUTPUTKEY_DETERMINISTIC
#define MCUXCLCSS_ECC_OUTPUTKEY_KEYEXCHANGE  MCUXCLELS_ECC_OUTPUTKEY_KEYEXCHANGE
#define MCUXCLCSS_ECC_OUTPUTKEY_RANDOM  MCUXCLELS_ECC_OUTPUTKEY_RANDOM
#define MCUXCLCSS_ECC_OUTPUTKEY_SIGN  MCUXCLELS_ECC_OUTPUTKEY_SIGN
#define MCUXCLCSS_ECC_PUBLICKEY_SIGN_DISABLE  MCUXCLELS_ECC_PUBLICKEY_SIGN_DISABLE
#define MCUXCLCSS_ECC_PUBLICKEY_SIGN_ENABLE  MCUXCLELS_ECC_PUBLICKEY_SIGN_ENABLE
#define MCUXCLCSS_ECC_PUBLICKEY_SIZE  MCUXCLELS_ECC_PUBLICKEY_SIZE
#define MCUXCLCSS_ECC_REVERSEFETCH_DISABLE  MCUXCLELS_ECC_REVERSEFETCH_DISABLE
#define MCUXCLCSS_ECC_REVERSEFETCH_ENABLE  MCUXCLELS_ECC_REVERSEFETCH_ENABLE
#define MCUXCLCSS_ECC_RTF  MCUXCLELS_ECC_RTF
#define MCUXCLCSS_ECC_SIGNATURE_R_SIZE  MCUXCLELS_ECC_SIGNATURE_R_SIZE
#define MCUXCLCSS_ECC_SIGNATURE_SIZE  MCUXCLELS_ECC_SIGNATURE_SIZE
#define MCUXCLCSS_ECC_SKIP_PUBLIC_KEY  MCUXCLELS_ECC_SKIP_PUBLIC_KEY
#define MCUXCLCSS_ECC_VALUE_HASHED  MCUXCLELS_ECC_VALUE_HASHED
#define MCUXCLCSS_ECC_VALUE_NOT_HASHED  MCUXCLELS_ECC_VALUE_NOT_HASHED
#define MCUXCLCSS_ECC_VALUE_NO_RTF  MCUXCLELS_ECC_VALUE_NO_RTF
#define MCUXCLCSS_ECC_VALUE_RTF  MCUXCLELS_ECC_VALUE_RTF
#define MCUXCLCSS_ERROR_FLAGS_CLEAR  MCUXCLELS_ERROR_FLAGS_CLEAR
#define MCUXCLCSS_ERROR_FLAGS_KEEP  MCUXCLELS_ERROR_FLAGS_KEEP
#define MCUXCLCSS_GLITCHDETECTOR_CFG_SIZE  MCUXCLELS_GLITCHDETECTOR_CFG_SIZE
#define MCUXCLCSS_GLITCHDETECTOR_TRIM_SIZE  MCUXCLELS_GLITCHDETECTOR_TRIM_SIZE
#define MCUXCLCSS_GLITCH_DETECTOR_INTERRUPT_DISABLE  MCUXCLELS_GLITCH_DETECTOR_INTERRUPT_DISABLE
#define MCUXCLCSS_GLITCH_DETECTOR_INTERRUPT_ENABLE  MCUXCLELS_GLITCH_DETECTOR_INTERRUPT_ENABLE
#define MCUXCLCSS_GLITCH_DETECTOR_NEG_KEEP  MCUXCLELS_GLITCH_DETECTOR_NEG_KEEP
#define MCUXCLCSS_GLITCH_DETECTOR_NEG_SET  MCUXCLELS_GLITCH_DETECTOR_NEG_SET
#define MCUXCLCSS_GLITCH_DETECTOR_POS_KEEP  MCUXCLELS_GLITCH_DETECTOR_POS_KEEP
#define MCUXCLCSS_GLITCH_DETECTOR_POS_SET  MCUXCLELS_GLITCH_DETECTOR_POS_SET
#define MCUXCLCSS_GLITCH_DETECTOR_RESET_CLEAR  MCUXCLELS_GLITCH_DETECTOR_RESET_CLEAR
#define MCUXCLCSS_GLITCH_DETECTOR_RESET_KEEP  MCUXCLELS_GLITCH_DETECTOR_RESET_KEEP
#define MCUXCLCSS_HASH_BLOCK_SIZE_SHA_224  MCUXCLELS_HASH_BLOCK_SIZE_SHA_224
#define MCUXCLCSS_HASH_BLOCK_SIZE_SHA_256  MCUXCLELS_HASH_BLOCK_SIZE_SHA_256
#define MCUXCLCSS_HASH_BLOCK_SIZE_SHA_384  MCUXCLELS_HASH_BLOCK_SIZE_SHA_384
#define MCUXCLCSS_HASH_BLOCK_SIZE_SHA_512  MCUXCLELS_HASH_BLOCK_SIZE_SHA_512
#define MCUXCLCSS_HASH_INIT_DISABLE  MCUXCLELS_HASH_INIT_DISABLE
#define MCUXCLCSS_HASH_INIT_ENABLE  MCUXCLELS_HASH_INIT_ENABLE
#define MCUXCLCSS_HASH_LOAD_DISABLE  MCUXCLELS_HASH_LOAD_DISABLE
#define MCUXCLCSS_HASH_LOAD_ENABLE  MCUXCLELS_HASH_LOAD_ENABLE
#define MCUXCLCSS_HASH_MODE_SHA_224  MCUXCLELS_HASH_MODE_SHA_224
#define MCUXCLCSS_HASH_MODE_SHA_256  MCUXCLELS_HASH_MODE_SHA_256
#define MCUXCLCSS_HASH_MODE_SHA_384  MCUXCLELS_HASH_MODE_SHA_384
#define MCUXCLCSS_HASH_MODE_SHA_512  MCUXCLELS_HASH_MODE_SHA_512
#define MCUXCLCSS_HASH_OUTPUT_DISABLE  MCUXCLELS_HASH_OUTPUT_DISABLE
#define MCUXCLCSS_HASH_OUTPUT_ENABLE  MCUXCLELS_HASH_OUTPUT_ENABLE
#define MCUXCLCSS_HASH_OUTPUT_SIZE_SHA_224  MCUXCLELS_HASH_OUTPUT_SIZE_SHA_224
#define MCUXCLCSS_HASH_OUTPUT_SIZE_SHA_256  MCUXCLELS_HASH_OUTPUT_SIZE_SHA_256
#define MCUXCLCSS_HASH_OUTPUT_SIZE_SHA_384  MCUXCLELS_HASH_OUTPUT_SIZE_SHA_384
#define MCUXCLCSS_HASH_OUTPUT_SIZE_SHA_512  MCUXCLELS_HASH_OUTPUT_SIZE_SHA_512
#define MCUXCLCSS_HASH_RTF_OUTPUT_DISABLE  MCUXCLELS_HASH_RTF_OUTPUT_DISABLE
#define MCUXCLCSS_HASH_RTF_OUTPUT_ENABLE  MCUXCLELS_HASH_RTF_OUTPUT_ENABLE
#define MCUXCLCSS_HASH_RTF_OUTPUT_SIZE  MCUXCLELS_HASH_RTF_OUTPUT_SIZE
#define MCUXCLCSS_HASH_RTF_UPDATE_DISABLE  MCUXCLELS_HASH_RTF_UPDATE_DISABLE
#define MCUXCLCSS_HASH_RTF_UPDATE_ENABLE  MCUXCLELS_HASH_RTF_UPDATE_ENABLE
#define MCUXCLCSS_HASH_STATE_SIZE_SHA_224  MCUXCLELS_HASH_STATE_SIZE_SHA_224
#define MCUXCLCSS_HASH_STATE_SIZE_SHA_256  MCUXCLELS_HASH_STATE_SIZE_SHA_256
#define MCUXCLCSS_HASH_STATE_SIZE_SHA_384  MCUXCLELS_HASH_STATE_SIZE_SHA_384
#define MCUXCLCSS_HASH_STATE_SIZE_SHA_512  MCUXCLELS_HASH_STATE_SIZE_SHA_512
#define MCUXCLCSS_HASH_VALUE_MODE_SHA_224  MCUXCLELS_HASH_VALUE_MODE_SHA_224
#define MCUXCLCSS_HASH_VALUE_MODE_SHA_256  MCUXCLELS_HASH_VALUE_MODE_SHA_256
#define MCUXCLCSS_HASH_VALUE_MODE_SHA_384  MCUXCLELS_HASH_VALUE_MODE_SHA_384
#define MCUXCLCSS_HASH_VALUE_MODE_SHA_512  MCUXCLELS_HASH_VALUE_MODE_SHA_512
#define MCUXCLCSS_HKDF_ALGO_RFC5869  MCUXCLELS_HKDF_ALGO_RFC5869
#define MCUXCLCSS_HKDF_ALGO_SP80056C  MCUXCLELS_HKDF_ALGO_SP80056C
#define MCUXCLCSS_HKDF_RFC5869_DERIVATIONDATA_SIZE  MCUXCLELS_HKDF_RFC5869_DERIVATIONDATA_SIZE
#define MCUXCLCSS_HKDF_SP80056C_TARGETKEY_SIZE  MCUXCLELS_HKDF_SP80056C_TARGETKEY_SIZE
#define MCUXCLCSS_HKDF_VALUE_MEMORY_DERIV  MCUXCLELS_HKDF_VALUE_MEMORY_DERIV
#define MCUXCLCSS_HKDF_VALUE_RTF_DERIV  MCUXCLELS_HKDF_VALUE_RTF_DERIV
#define MCUXCLCSS_HMAC_EXTERNAL_KEY_DISABLE  MCUXCLELS_HMAC_EXTERNAL_KEY_DISABLE
#define MCUXCLCSS_HMAC_EXTERNAL_KEY_ENABLE  MCUXCLELS_HMAC_EXTERNAL_KEY_ENABLE
#define MCUXCLCSS_HMAC_OUTPUT_SIZE  MCUXCLELS_HMAC_OUTPUT_SIZE
#define MCUXCLCSS_HMAC_PADDED_KEY_SIZE  MCUXCLELS_HMAC_PADDED_KEY_SIZE
#define MCUXCLCSS_HW_VERSION  MCUXCLELS_HW_VERSION
#define MCUXCLCSS_KEYGEN_VALUE_DETERMINISTIC  MCUXCLELS_KEYGEN_VALUE_DETERMINISTIC
#define MCUXCLCSS_KEYGEN_VALUE_GEN_PUB_KEY  MCUXCLELS_KEYGEN_VALUE_GEN_PUB_KEY
#define MCUXCLCSS_KEYGEN_VALUE_NO_PUB_KEY  MCUXCLELS_KEYGEN_VALUE_NO_PUB_KEY
#define MCUXCLCSS_KEYGEN_VALUE_NO_RANDOM_DATA  MCUXCLELS_KEYGEN_VALUE_NO_RANDOM_DATA
#define MCUXCLCSS_KEYGEN_VALUE_RANDOM  MCUXCLELS_KEYGEN_VALUE_RANDOM
#define MCUXCLCSS_KEYGEN_VALUE_SIGN_PUBLICKEY  MCUXCLELS_KEYGEN_VALUE_SIGN_PUBLICKEY
#define MCUXCLCSS_KEYGEN_VALUE_TYPE_KEYEXCHANGE  MCUXCLELS_KEYGEN_VALUE_TYPE_KEYEXCHANGE
#define MCUXCLCSS_KEYGEN_VALUE_TYPE_SIGN  MCUXCLELS_KEYGEN_VALUE_TYPE_SIGN
#define MCUXCLCSS_KEYGEN_VALUE_USE_RANDOM_DATA  MCUXCLELS_KEYGEN_VALUE_USE_RANDOM_DATA
#define MCUXCLCSS_KEYIMPORT_KFMT_PBK  MCUXCLELS_KEYIMPORT_KFMT_PBK
#define MCUXCLCSS_KEYIMPORT_KFMT_PUF  MCUXCLELS_KEYIMPORT_KFMT_PUF
#define MCUXCLCSS_KEYIMPORT_KFMT_RFC3394  MCUXCLELS_KEYIMPORT_KFMT_RFC3394
#define MCUXCLCSS_KEYIMPORT_KFMT_UDF  MCUXCLELS_KEYIMPORT_KFMT_UDF
#define MCUXCLCSS_KEYIMPORT_REVERSEFETCH_DISABLE  MCUXCLELS_KEYIMPORT_REVERSEFETCH_DISABLE
#define MCUXCLCSS_KEYIMPORT_REVERSEFETCH_ENABLE  MCUXCLELS_KEYIMPORT_REVERSEFETCH_ENABLE
#define MCUXCLCSS_KEYIMPORT_VALUE_KFMT_PBK  MCUXCLELS_KEYIMPORT_VALUE_KFMT_PBK
#define MCUXCLCSS_KEYIMPORT_VALUE_KFMT_PUF  MCUXCLELS_KEYIMPORT_VALUE_KFMT_PUF
#define MCUXCLCSS_KEYIMPORT_VALUE_KFMT_RFC3394  MCUXCLELS_KEYIMPORT_VALUE_KFMT_RFC3394
#define MCUXCLCSS_KEYIMPORT_VALUE_KFMT_UDF  MCUXCLELS_KEYIMPORT_VALUE_KFMT_UDF
#define MCUXCLCSS_KEYPROPERTY_ACTIVE_FALSE  MCUXCLELS_KEYPROPERTY_ACTIVE_FALSE
#define MCUXCLCSS_KEYPROPERTY_ACTIVE_TRUE  MCUXCLELS_KEYPROPERTY_ACTIVE_TRUE
#define MCUXCLCSS_KEYPROPERTY_AES_FALSE  MCUXCLELS_KEYPROPERTY_AES_FALSE
#define MCUXCLCSS_KEYPROPERTY_AES_TRUE  MCUXCLELS_KEYPROPERTY_AES_TRUE
#define MCUXCLCSS_KEYPROPERTY_BASE_SLOT  MCUXCLELS_KEYPROPERTY_BASE_SLOT
#define MCUXCLCSS_KEYPROPERTY_CKDF_FALSE  MCUXCLELS_KEYPROPERTY_CKDF_FALSE
#define MCUXCLCSS_KEYPROPERTY_CKDF_TRUE  MCUXCLELS_KEYPROPERTY_CKDF_TRUE
#define MCUXCLCSS_KEYPROPERTY_CMAC_FALSE  MCUXCLELS_KEYPROPERTY_CMAC_FALSE
#define MCUXCLCSS_KEYPROPERTY_CMAC_TRUE  MCUXCLELS_KEYPROPERTY_CMAC_TRUE
#define MCUXCLCSS_KEYPROPERTY_DEVICE_UNIQUE_FALSE  MCUXCLELS_KEYPROPERTY_DEVICE_UNIQUE_FALSE
#define MCUXCLCSS_KEYPROPERTY_DEVICE_UNIQUE_TRUE  MCUXCLELS_KEYPROPERTY_DEVICE_UNIQUE_TRUE
#define MCUXCLCSS_KEYPROPERTY_ECC_DH_PRIVATE_FALSE  MCUXCLELS_KEYPROPERTY_ECC_DH_PRIVATE_FALSE
#define MCUXCLCSS_KEYPROPERTY_ECC_DH_PRIVATE_TRUE  MCUXCLELS_KEYPROPERTY_ECC_DH_PRIVATE_TRUE
#define MCUXCLCSS_KEYPROPERTY_ECC_FALSE  MCUXCLELS_KEYPROPERTY_ECC_FALSE
#define MCUXCLCSS_KEYPROPERTY_ECC_TRUE  MCUXCLELS_KEYPROPERTY_ECC_TRUE
#define MCUXCLCSS_KEYPROPERTY_GENERAL_PURPOSE_SLOT_FALSE  MCUXCLELS_KEYPROPERTY_GENERAL_PURPOSE_SLOT_FALSE
#define MCUXCLCSS_KEYPROPERTY_GENERAL_PURPOSE_SLOT_TRUE  MCUXCLELS_KEYPROPERTY_GENERAL_PURPOSE_SLOT_TRUE
#define MCUXCLCSS_KEYPROPERTY_HKDF_FALSE  MCUXCLELS_KEYPROPERTY_HKDF_FALSE
#define MCUXCLCSS_KEYPROPERTY_HKDF_TRUE  MCUXCLELS_KEYPROPERTY_HKDF_TRUE
#define MCUXCLCSS_KEYPROPERTY_HMAC_FALSE  MCUXCLELS_KEYPROPERTY_HMAC_FALSE
#define MCUXCLCSS_KEYPROPERTY_HMAC_TRUE  MCUXCLELS_KEYPROPERTY_HMAC_TRUE
#define MCUXCLCSS_KEYPROPERTY_HW_OUT_FALSE  MCUXCLELS_KEYPROPERTY_HW_OUT_FALSE
#define MCUXCLCSS_KEYPROPERTY_HW_OUT_SLOT_FALSE  MCUXCLELS_KEYPROPERTY_HW_OUT_SLOT_FALSE
#define MCUXCLCSS_KEYPROPERTY_HW_OUT_SLOT_TRUE  MCUXCLELS_KEYPROPERTY_HW_OUT_SLOT_TRUE
#define MCUXCLCSS_KEYPROPERTY_HW_OUT_TRUE  MCUXCLELS_KEYPROPERTY_HW_OUT_TRUE
#define MCUXCLCSS_KEYPROPERTY_INPUT_FOR_ECC_FALSE  MCUXCLELS_KEYPROPERTY_INPUT_FOR_ECC_FALSE
#define MCUXCLCSS_KEYPROPERTY_INPUT_FOR_ECC_TRUE  MCUXCLELS_KEYPROPERTY_INPUT_FOR_ECC_TRUE
#define MCUXCLCSS_KEYPROPERTY_KEY_SIZE_128  MCUXCLELS_KEYPROPERTY_KEY_SIZE_128
#define MCUXCLCSS_KEYPROPERTY_KEY_SIZE_256  MCUXCLELS_KEYPROPERTY_KEY_SIZE_256
#define MCUXCLCSS_KEYPROPERTY_KEY_SIZE_512  MCUXCLELS_KEYPROPERTY_KEY_SIZE_512
#define MCUXCLCSS_KEYPROPERTY_KSK_FALSE  MCUXCLELS_KEYPROPERTY_KSK_FALSE
#define MCUXCLCSS_KEYPROPERTY_KSK_TRUE  MCUXCLELS_KEYPROPERTY_KSK_TRUE
#define MCUXCLCSS_KEYPROPERTY_KUOK_FALSE  MCUXCLELS_KEYPROPERTY_KUOK_FALSE
#define MCUXCLCSS_KEYPROPERTY_KUOK_TRUE  MCUXCLELS_KEYPROPERTY_KUOK_TRUE
#define MCUXCLCSS_KEYPROPERTY_KWK_FALSE  MCUXCLELS_KEYPROPERTY_KWK_FALSE
#define MCUXCLCSS_KEYPROPERTY_KWK_TRUE  MCUXCLELS_KEYPROPERTY_KWK_TRUE
#define MCUXCLCSS_KEYPROPERTY_PRIVILEGED_FALSE  MCUXCLELS_KEYPROPERTY_PRIVILEGED_FALSE
#define MCUXCLCSS_KEYPROPERTY_PRIVILEGED_TRUE  MCUXCLELS_KEYPROPERTY_PRIVILEGED_TRUE
#define MCUXCLCSS_KEYPROPERTY_PUK_FALSE  MCUXCLELS_KEYPROPERTY_PUK_FALSE
#define MCUXCLCSS_KEYPROPERTY_PUK_TRUE  MCUXCLELS_KEYPROPERTY_PUK_TRUE
#define MCUXCLCSS_KEYPROPERTY_RETENTION_SLOT_FALSE  MCUXCLELS_KEYPROPERTY_RETENTION_SLOT_FALSE
#define MCUXCLCSS_KEYPROPERTY_RETENTION_SLOT_TRUE  MCUXCLELS_KEYPROPERTY_RETENTION_SLOT_TRUE
#define MCUXCLCSS_KEYPROPERTY_RTF_FALSE  MCUXCLELS_KEYPROPERTY_RTF_FALSE
#define MCUXCLCSS_KEYPROPERTY_RTF_TRUE  MCUXCLELS_KEYPROPERTY_RTF_TRUE
#define MCUXCLCSS_KEYPROPERTY_SECOND_SLOT  MCUXCLELS_KEYPROPERTY_SECOND_SLOT
#define MCUXCLCSS_KEYPROPERTY_SECURE_FALSE  MCUXCLELS_KEYPROPERTY_SECURE_FALSE
#define MCUXCLCSS_KEYPROPERTY_SECURE_TRUE  MCUXCLELS_KEYPROPERTY_SECURE_TRUE
#define MCUXCLCSS_KEYPROPERTY_TECDH_FALSE  MCUXCLELS_KEYPROPERTY_TECDH_FALSE
#define MCUXCLCSS_KEYPROPERTY_TECDH_TRUE  MCUXCLELS_KEYPROPERTY_TECDH_TRUE
#define MCUXCLCSS_KEYPROPERTY_TLS_MASTER_SECRET_FALSE  MCUXCLELS_KEYPROPERTY_TLS_MASTER_SECRET_FALSE
#define MCUXCLCSS_KEYPROPERTY_TLS_MASTER_SECRET_TRUE  MCUXCLELS_KEYPROPERTY_TLS_MASTER_SECRET_TRUE
#define MCUXCLCSS_KEYPROPERTY_TLS_PREMASTER_SECRET_FALSE  MCUXCLELS_KEYPROPERTY_TLS_PREMASTER_SECRET_FALSE
#define MCUXCLCSS_KEYPROPERTY_TLS_PREMASTER_SECRET_TRUE  MCUXCLELS_KEYPROPERTY_TLS_PREMASTER_SECRET_TRUE
#define MCUXCLCSS_KEYPROPERTY_VALUE_ACTIVE  MCUXCLELS_KEYPROPERTY_VALUE_ACTIVE
#define MCUXCLCSS_KEYPROPERTY_VALUE_AES  MCUXCLELS_KEYPROPERTY_VALUE_AES
#define MCUXCLCSS_KEYPROPERTY_VALUE_BASE_SLOT  MCUXCLELS_KEYPROPERTY_VALUE_BASE_SLOT
#define MCUXCLCSS_KEYPROPERTY_VALUE_CKDF  MCUXCLELS_KEYPROPERTY_VALUE_CKDF
#define MCUXCLCSS_KEYPROPERTY_VALUE_CMAC  MCUXCLELS_KEYPROPERTY_VALUE_CMAC
#define MCUXCLCSS_KEYPROPERTY_VALUE_DUK  MCUXCLELS_KEYPROPERTY_VALUE_DUK
#define MCUXCLCSS_KEYPROPERTY_VALUE_ECDH  MCUXCLELS_KEYPROPERTY_VALUE_ECDH
#define MCUXCLCSS_KEYPROPERTY_VALUE_ECSGN  MCUXCLELS_KEYPROPERTY_VALUE_ECSGN
#define MCUXCLCSS_KEYPROPERTY_VALUE_GENERAL_PURPOSE_SLOT  MCUXCLELS_KEYPROPERTY_VALUE_GENERAL_PURPOSE_SLOT
#define MCUXCLCSS_KEYPROPERTY_VALUE_HKDF  MCUXCLELS_KEYPROPERTY_VALUE_HKDF
#define MCUXCLCSS_KEYPROPERTY_VALUE_HMAC  MCUXCLELS_KEYPROPERTY_VALUE_HMAC
#define MCUXCLCSS_KEYPROPERTY_VALUE_HW_OUT  MCUXCLELS_KEYPROPERTY_VALUE_HW_OUT
#define MCUXCLCSS_KEYPROPERTY_VALUE_HW_OUT_SLOT  MCUXCLELS_KEYPROPERTY_VALUE_HW_OUT_SLOT
#define MCUXCLCSS_KEYPROPERTY_VALUE_KEY_SIZE_128  MCUXCLELS_KEYPROPERTY_VALUE_KEY_SIZE_128
#define MCUXCLCSS_KEYPROPERTY_VALUE_KEY_SIZE_256  MCUXCLELS_KEYPROPERTY_VALUE_KEY_SIZE_256
#define MCUXCLCSS_KEYPROPERTY_VALUE_KEY_SIZE_512  MCUXCLELS_KEYPROPERTY_VALUE_KEY_SIZE_512
#define MCUXCLCSS_KEYPROPERTY_VALUE_KGSRC  MCUXCLELS_KEYPROPERTY_VALUE_KGSRC
#define MCUXCLCSS_KEYPROPERTY_VALUE_KSK  MCUXCLELS_KEYPROPERTY_VALUE_KSK
#define MCUXCLCSS_KEYPROPERTY_VALUE_KUOK  MCUXCLELS_KEYPROPERTY_VALUE_KUOK
#define MCUXCLCSS_KEYPROPERTY_VALUE_KWK  MCUXCLELS_KEYPROPERTY_VALUE_KWK
#define MCUXCLCSS_KEYPROPERTY_VALUE_NOTPRIVILEGED  MCUXCLELS_KEYPROPERTY_VALUE_NOTPRIVILEGED
#define MCUXCLCSS_KEYPROPERTY_VALUE_NOTSECURE  MCUXCLELS_KEYPROPERTY_VALUE_NOTSECURE
#define MCUXCLCSS_KEYPROPERTY_VALUE_PRIVILEGED  MCUXCLELS_KEYPROPERTY_VALUE_PRIVILEGED
#define MCUXCLCSS_KEYPROPERTY_VALUE_PUK  MCUXCLELS_KEYPROPERTY_VALUE_PUK
#define MCUXCLCSS_KEYPROPERTY_VALUE_RETENTION_SLOT  MCUXCLELS_KEYPROPERTY_VALUE_RETENTION_SLOT
#define MCUXCLCSS_KEYPROPERTY_VALUE_RTF  MCUXCLELS_KEYPROPERTY_VALUE_RTF
#define MCUXCLCSS_KEYPROPERTY_VALUE_SECURE  MCUXCLELS_KEYPROPERTY_VALUE_SECURE
#define MCUXCLCSS_KEYPROPERTY_VALUE_TECDH  MCUXCLELS_KEYPROPERTY_VALUE_TECDH
#define MCUXCLCSS_KEYPROPERTY_VALUE_TLS_MASTER_SECRET  MCUXCLELS_KEYPROPERTY_VALUE_TLS_MASTER_SECRET
#define MCUXCLCSS_KEYPROPERTY_VALUE_TLS_PREMASTER_SECRET  MCUXCLELS_KEYPROPERTY_VALUE_TLS_PREMASTER_SECRET
#define MCUXCLCSS_KEYPROPERTY_VALUE_WRPOK  MCUXCLELS_KEYPROPERTY_VALUE_WRPOK
#define MCUXCLCSS_KEYPROPERTY_WRAP_FALSE  MCUXCLELS_KEYPROPERTY_WRAP_FALSE
#define MCUXCLCSS_KEYPROPERTY_WRAP_TRUE  MCUXCLELS_KEYPROPERTY_WRAP_TRUE
#define MCUXCLCSS_KEYPROV_DUK_UPDATE_DISABLE  MCUXCLELS_KEYPROV_DUK_UPDATE_DISABLE
#define MCUXCLCSS_KEYPROV_DUK_UPDATE_ENABLE  MCUXCLELS_KEYPROV_DUK_UPDATE_ENABLE
#define MCUXCLCSS_KEYPROV_KEYSHARE_TABLE_SIZE  MCUXCLELS_KEYPROV_KEYSHARE_TABLE_SIZE
#define MCUXCLCSS_KEYPROV_KEY_PART_1_SIZE  MCUXCLELS_KEYPROV_KEY_PART_1_SIZE
#define MCUXCLCSS_KEYPROV_NOIC_DISABLE  MCUXCLELS_KEYPROV_NOIC_DISABLE
#define MCUXCLCSS_KEYPROV_NOIC_ENABLE  MCUXCLELS_KEYPROV_NOIC_ENABLE
#define MCUXCLCSS_KEYPROV_TESTERSHARE_SIZE  MCUXCLELS_KEYPROV_TESTERSHARE_SIZE
#define MCUXCLCSS_KEYPROV_VALUE_NOIC  MCUXCLELS_KEYPROV_VALUE_NOIC
#define MCUXCLCSS_KEY_SLOTS  MCUXCLELS_KEY_SLOTS
#define MCUXCLCSS_MASTER_UNLOCK_ANY  MCUXCLELS_MASTER_UNLOCK_ANY
#define MCUXCLCSS_RESET_CANCEL  MCUXCLELS_RESET_CANCEL
#define MCUXCLCSS_RESET_DO_NOT_CANCEL  MCUXCLELS_RESET_DO_NOT_CANCEL
#define MCUXCLCSS_RESP_GEN_AVAILABLE_SLOT_0  MCUXCLELS_RESP_GEN_AVAILABLE_SLOT_0
#define MCUXCLCSS_RESP_GEN_AVAILABLE_SLOT_1  MCUXCLELS_RESP_GEN_AVAILABLE_SLOT_1
#define MCUXCLCSS_RESP_GEN_AVAILABLE_SLOT_2  MCUXCLELS_RESP_GEN_AVAILABLE_SLOT_2
#define MCUXCLCSS_RESP_GEN_SLOTS  MCUXCLELS_RESP_GEN_SLOTS
#define MCUXCLCSS_RFC3394_CONTAINER_SIZE_128  MCUXCLELS_RFC3394_CONTAINER_SIZE_128
#define MCUXCLCSS_RFC3394_CONTAINER_SIZE_256  MCUXCLELS_RFC3394_CONTAINER_SIZE_256
#define MCUXCLCSS_RFC3394_CONTAINER_SIZE_P256  MCUXCLELS_RFC3394_CONTAINER_SIZE_P256
#define MCUXCLCSS_RFC3394_OVERHEAD  MCUXCLELS_RFC3394_OVERHEAD
#define MCUXCLCSS_RNG_DRBG_TEST_EXTRACT_OUTPUT_MAX_SIZE  MCUXCLELS_RNG_DRBG_TEST_EXTRACT_OUTPUT_MAX_SIZE
#define MCUXCLCSS_RNG_DRBG_TEST_EXTRACT_OUTPUT_MIN_SIZE  MCUXCLELS_RNG_DRBG_TEST_EXTRACT_OUTPUT_MIN_SIZE
#define MCUXCLCSS_RNG_DRBG_TEST_MODE_AES_CTR  MCUXCLELS_RNG_DRBG_TEST_MODE_AES_CTR
#define MCUXCLCSS_RNG_DRBG_TEST_MODE_AES_ECB  MCUXCLELS_RNG_DRBG_TEST_MODE_AES_ECB
#define MCUXCLCSS_RNG_DRBG_TEST_MODE_EXTRACT  MCUXCLELS_RNG_DRBG_TEST_MODE_EXTRACT
#define MCUXCLCSS_RNG_DRBG_TEST_MODE_INSTANTIATE  MCUXCLELS_RNG_DRBG_TEST_MODE_INSTANTIATE
#define MCUXCLCSS_RNG_DTRNG_CONFIG_SIZE  MCUXCLELS_RNG_DTRNG_CONFIG_SIZE
#define MCUXCLCSS_RNG_DTRNG_EVAL_CONFIG_SIZE  MCUXCLELS_RNG_DTRNG_EVAL_CONFIG_SIZE
#define MCUXCLCSS_RNG_DTRNG_EVAL_RESULT_SIZE  MCUXCLELS_RNG_DTRNG_EVAL_RESULT_SIZE
#define MCUXCLCSS_RNG_RAW_ENTROPY_SIZE  MCUXCLELS_RNG_RAW_ENTROPY_SIZE
#define MCUXCLCSS_RNG_RND_REQ_PRND_INIT  MCUXCLELS_RNG_RND_REQ_PRND_INIT
#define MCUXCLCSS_RNG_RND_REQ_RND_RAW  MCUXCLELS_RNG_RND_REQ_RND_RAW
#define MCUXCLCSS_STATUS_DRBGENTLVL_HIGH  MCUXCLELS_STATUS_DRBGENTLVL_HIGH
#define MCUXCLCSS_STATUS_DRBGENTLVL_LOW  MCUXCLELS_STATUS_DRBGENTLVL_LOW
#define MCUXCLCSS_STATUS_DRBGENTLVL_NONE  MCUXCLELS_STATUS_DRBGENTLVL_NONE
#define MCUXCLCSS_STATUS_ECDSAVFY_ERROR  MCUXCLELS_STATUS_ECDSAVFY_ERROR
#define MCUXCLCSS_STATUS_ECDSAVFY_FAIL  MCUXCLELS_STATUS_ECDSAVFY_FAIL
#define MCUXCLCSS_STATUS_ECDSAVFY_NORUN  MCUXCLELS_STATUS_ECDSAVFY_NORUN
#define MCUXCLCSS_STATUS_ECDSAVFY_OK  MCUXCLELS_STATUS_ECDSAVFY_OK
#define MCUXCLCSS_STATUS_HW_ALGORITHM  MCUXCLELS_STATUS_HW_ALGORITHM
#define MCUXCLCSS_STATUS_HW_BUS  MCUXCLELS_STATUS_HW_BUS
#define MCUXCLCSS_STATUS_HW_DTRNG  MCUXCLELS_STATUS_HW_DTRNG
#define MCUXCLCSS_STATUS_HW_FAULT  MCUXCLELS_STATUS_HW_FAULT
#define MCUXCLCSS_STATUS_HW_INTEGRITY  MCUXCLELS_STATUS_HW_INTEGRITY
#define MCUXCLCSS_STATUS_HW_OPERATIONAL  MCUXCLELS_STATUS_HW_OPERATIONAL
#define MCUXCLCSS_STATUS_HW_PRNG  MCUXCLELS_STATUS_HW_PRNG
#define MCUXCLCSS_STATUS_IS_HW_ERROR  MCUXCLELS_STATUS_IS_HW_ERROR
#define MCUXCLCSS_STATUS_IS_SW_ERROR  MCUXCLELS_STATUS_IS_SW_ERROR
#define MCUXCLCSS_STATUS_OK  MCUXCLELS_STATUS_OK
#define MCUXCLCSS_STATUS_OK_WAIT  MCUXCLELS_STATUS_OK_WAIT
#define MCUXCLCSS_STATUS_PPROT_PRIVILEGED_NONSECURE  MCUXCLELS_STATUS_PPROT_PRIVILEGED_NONSECURE
#define MCUXCLCSS_STATUS_PPROT_PRIVILEGED_SECURE  MCUXCLELS_STATUS_PPROT_PRIVILEGED_SECURE
#define MCUXCLCSS_STATUS_PPROT_UNPRIVILEGED_NONSECURE  MCUXCLELS_STATUS_PPROT_UNPRIVILEGED_NONSECURE
#define MCUXCLCSS_STATUS_PPROT_UNPRIVILEGED_SECURE  MCUXCLELS_STATUS_PPROT_UNPRIVILEGED_SECURE
#define MCUXCLCSS_STATUS_SW_CANNOT_INTERRUPT  MCUXCLELS_STATUS_SW_CANNOT_INTERRUPT
#define MCUXCLCSS_STATUS_SW_COMPARISON_FAILED  MCUXCLELS_STATUS_SW_COMPARISON_FAILED
#define MCUXCLCSS_STATUS_SW_COUNTER_EXPIRED  MCUXCLELS_STATUS_SW_COUNTER_EXPIRED
#define MCUXCLCSS_STATUS_SW_FAULT  MCUXCLELS_STATUS_SW_FAULT
#define MCUXCLCSS_STATUS_SW_INVALID_PARAM  MCUXCLELS_STATUS_SW_INVALID_PARAM
#define MCUXCLCSS_STATUS_SW_INVALID_STATE  MCUXCLELS_STATUS_SW_INVALID_STATE
#define MCUXCLCSS_STATUS_SW_LOCKING_FAILED  MCUXCLELS_STATUS_SW_LOCKING_FAILED
#define MCUXCLCSS_STATUS_SW_STATUS_LOCKED  MCUXCLELS_STATUS_SW_STATUS_LOCKED
#define MCUXCLCSS_TLS_DERIVATIONDATA_SIZE  MCUXCLELS_TLS_DERIVATIONDATA_SIZE
#define MCUXCLCSS_TLS_FINALIZE  MCUXCLELS_TLS_FINALIZE
#define MCUXCLCSS_TLS_INIT  MCUXCLELS_TLS_INIT
#define MCUXCLCSS_TLS_RANDOM_SIZE  MCUXCLELS_TLS_RANDOM_SIZE


/* Public types */
/**
 * mcuxClCss_((?:AeadOption_t|CipherOption_t|CkdfOption_t|CmacOption_t|CommandCrcConfig_t|EccByte_t|EccKeyExchOption_t|EccKeyGenOption_t|EccSignOption_t|EccVerifyOption_t|ErrorHandling_t|HashOption_t|HkdfOption_t|HmacOption_t|HwConfig_t|HwState_t|HwVersion_t|InterruptOptionEn_t|InterruptOptionRst_t|InterruptOptionSet_t|KeyImportOption_t|KeyIndex_t|KeyProp_t|KeyProvisionOption_t|ResetOption_t|Status_Protected_t|Status_t|TlsOption_t|TransferToRegisterFunction_t))(?!\w)
 * -->
 * mcuxClEls_\1
 */
#define mcuxClCss_AeadOption_t  mcuxClEls_AeadOption_t
#define mcuxClCss_CipherOption_t  mcuxClEls_CipherOption_t
#define mcuxClCss_CkdfOption_t  mcuxClEls_CkdfOption_t
#define mcuxClCss_CmacOption_t  mcuxClEls_CmacOption_t
#define mcuxClCss_CommandCrcConfig_t  mcuxClEls_CommandCrcConfig_t
#define mcuxClCss_EccByte_t  mcuxClEls_EccByte_t
#define mcuxClCss_EccKeyExchOption_t  mcuxClEls_EccKeyExchOption_t
#define mcuxClCss_EccKeyGenOption_t  mcuxClEls_EccKeyGenOption_t
#define mcuxClCss_EccSignOption_t  mcuxClEls_EccSignOption_t
#define mcuxClCss_EccVerifyOption_t  mcuxClEls_EccVerifyOption_t
#define mcuxClCss_ErrorHandling_t  mcuxClEls_ErrorHandling_t
#define mcuxClCss_HashOption_t  mcuxClEls_HashOption_t
#define mcuxClCss_HkdfOption_t  mcuxClEls_HkdfOption_t
#define mcuxClCss_HmacOption_t  mcuxClEls_HmacOption_t
#define mcuxClCss_HwConfig_t  mcuxClEls_HwConfig_t
#define mcuxClCss_HwState_t  mcuxClEls_HwState_t
#define mcuxClCss_HwVersion_t  mcuxClEls_HwVersion_t
#define mcuxClCss_InterruptOptionEn_t  mcuxClEls_InterruptOptionEn_t
#define mcuxClCss_InterruptOptionRst_t  mcuxClEls_InterruptOptionRst_t
#define mcuxClCss_InterruptOptionSet_t  mcuxClEls_InterruptOptionSet_t
#define mcuxClCss_KeyImportOption_t  mcuxClEls_KeyImportOption_t
#define mcuxClCss_KeyIndex_t  mcuxClEls_KeyIndex_t
#define mcuxClCss_KeyProp_t  mcuxClEls_KeyProp_t
#define mcuxClCss_KeyProvisionOption_t  mcuxClEls_KeyProvisionOption_t
#define mcuxClCss_ResetOption_t  mcuxClEls_ResetOption_t
#define mcuxClCss_Status_Protected_t  mcuxClEls_Status_Protected_t
#define mcuxClCss_Status_t  mcuxClEls_Status_t
#define mcuxClCss_TlsOption_t  mcuxClEls_TlsOption_t
#define mcuxClCss_TransferToRegisterFunction_t  mcuxClEls_TransferToRegisterFunction_t


/* Public functions */
/**
 * mcuxClCss_((?:Aead_Finalize_Async|Aead_Init_Async|Aead_PartialInit_Async|Aead_UpdateAad_Async|Aead_UpdateData_Async|Cipher_Async|Ckdf_Sp800108_Async|Ckdf_Sp80056c_Expand_Async|Ckdf_Sp80056c_Extract_Async|Cmac_Async|CompareDmaFinalOutputAddress|ConfigureCommandCRC|Disable|EccKeyExchangeInt_Async|EccKeyExchange_Async|EccKeyGen_Async|EccSign_Async|EccVerifyInt_Async|EccVerify_Async|Enable_Async|GetCommandCRC|GetErrorCode|GetErrorLevel|GetHwConfig|GetHwState|GetHwVersion|GetIntEnableFlags|GetKeyProperties|GetLastDmaAddress|GetLock|GetRandomStartDelay|GlitchDetector_GetEventCounter|GlitchDetector_LoadConfig_Async|GlitchDetector_ResetEventCounter|GlitchDetector_Trim_Async|Hash_Async|Hash_ShaDirect|Hkdf_Rfc5869_Async|Hkdf_Sp80056c_Async|Hmac_Async|IsLocked|KeyDelete_Async|KeyExport_Async|KeyImportPuk_Async|KeyImport_Async|KeyProvisionRom_Async|KeyProvision_Async|LimitedWaitForOperation|Prng_GetRandom|Prng_GetRandomWord|Prng_Init_Async|ReleaseLock|ResetErrorFlags|ResetIntFlags|Reset_Async|RespGen_Async|Rng_DrbgRequestRaw_Async|Rng_DrbgRequest_Async|Rng_DrbgTestAesCtr_Async|Rng_DrbgTestAesEcb_Async|Rng_DrbgTestExtract_Async|Rng_DrbgTestInstantiate_Async|Rng_Dtrng_ConfigEvaluate_Async|Rng_Dtrng_ConfigLoadPrv_Async|Rng_Dtrng_ConfigLoad_Async|SetIntEnableFlags|SetIntFlags|SetMasterUnlock|SetRandomStartDelay|ShaDirect_Disable|ShaDirect_Enable|TlsGenerateMasterKeyFromPreMasterKey_Async|TlsGenerateSessionKeysFromMasterKey_Async|UpdateRefCRC|VerifyVsRefCRC|WaitForOperation))(?!\w)
 * -->
 * mcuxClEls_\1
 */
#define mcuxClCss_Aead_Finalize_Async  mcuxClEls_Aead_Finalize_Async
#define mcuxClCss_Aead_Init_Async  mcuxClEls_Aead_Init_Async
#define mcuxClCss_Aead_PartialInit_Async  mcuxClEls_Aead_PartialInit_Async
#define mcuxClCss_Aead_UpdateAad_Async  mcuxClEls_Aead_UpdateAad_Async
#define mcuxClCss_Aead_UpdateData_Async  mcuxClEls_Aead_UpdateData_Async
#define mcuxClCss_Cipher_Async  mcuxClEls_Cipher_Async
#define mcuxClCss_Ckdf_Sp800108_Async  mcuxClEls_Ckdf_Sp800108_Async
#define mcuxClCss_Ckdf_Sp80056c_Expand_Async  mcuxClEls_Ckdf_Sp80056c_Expand_Async
#define mcuxClCss_Ckdf_Sp80056c_Extract_Async  mcuxClEls_Ckdf_Sp80056c_Extract_Async
#define mcuxClCss_Cmac_Async  mcuxClEls_Cmac_Async
#define mcuxClCss_CompareDmaFinalOutputAddress  mcuxClEls_CompareDmaFinalOutputAddress
#define mcuxClCss_ConfigureCommandCRC  mcuxClEls_ConfigureCommandCRC
#define mcuxClCss_Disable  mcuxClEls_Disable
#define mcuxClCss_EccKeyExchangeInt_Async  mcuxClEls_EccKeyExchangeInt_Async
#define mcuxClCss_EccKeyExchange_Async  mcuxClEls_EccKeyExchange_Async
#define mcuxClCss_EccKeyGen_Async  mcuxClEls_EccKeyGen_Async
#define mcuxClCss_EccSign_Async  mcuxClEls_EccSign_Async
#define mcuxClCss_EccVerifyInt_Async  mcuxClEls_EccVerifyInt_Async
#define mcuxClCss_EccVerify_Async  mcuxClEls_EccVerify_Async
#define mcuxClCss_Enable_Async  mcuxClEls_Enable_Async
#define mcuxClCss_GetCommandCRC  mcuxClEls_GetCommandCRC
#define mcuxClCss_GetErrorCode  mcuxClEls_GetErrorCode
#define mcuxClCss_GetErrorLevel  mcuxClEls_GetErrorLevel
#define mcuxClCss_GetHwConfig  mcuxClEls_GetHwConfig
#define mcuxClCss_GetHwState  mcuxClEls_GetHwState
#define mcuxClCss_GetHwVersion  mcuxClEls_GetHwVersion
#define mcuxClCss_GetIntEnableFlags  mcuxClEls_GetIntEnableFlags
#define mcuxClCss_GetKeyProperties  mcuxClEls_GetKeyProperties
#define mcuxClCss_GetLastDmaAddress  mcuxClEls_GetLastDmaAddress
#define mcuxClCss_GetLock  mcuxClEls_GetLock
#define mcuxClCss_GetRandomStartDelay  mcuxClEls_GetRandomStartDelay
#define mcuxClCss_GlitchDetector_GetEventCounter  mcuxClEls_GlitchDetector_GetEventCounter
#define mcuxClCss_GlitchDetector_LoadConfig_Async  mcuxClEls_GlitchDetector_LoadConfig_Async
#define mcuxClCss_GlitchDetector_ResetEventCounter  mcuxClEls_GlitchDetector_ResetEventCounter
#define mcuxClCss_GlitchDetector_Trim_Async  mcuxClEls_GlitchDetector_Trim_Async
#define mcuxClCss_Hash_Async  mcuxClEls_Hash_Async
#define mcuxClCss_Hash_ShaDirect  mcuxClEls_Hash_ShaDirect
#define mcuxClCss_Hkdf_Rfc5869_Async  mcuxClEls_Hkdf_Rfc5869_Async
#define mcuxClCss_Hkdf_Sp80056c_Async  mcuxClEls_Hkdf_Sp80056c_Async
#define mcuxClCss_Hmac_Async  mcuxClEls_Hmac_Async
#define mcuxClCss_IsLocked  mcuxClEls_IsLocked
#define mcuxClCss_KeyDelete_Async  mcuxClEls_KeyDelete_Async
#define mcuxClCss_KeyExport_Async  mcuxClEls_KeyExport_Async
#define mcuxClCss_KeyImportPuk_Async  mcuxClEls_KeyImportPuk_Async
#define mcuxClCss_KeyImport_Async  mcuxClEls_KeyImport_Async
#define mcuxClCss_KeyProvisionRom_Async  mcuxClEls_KeyProvisionRom_Async
#define mcuxClCss_KeyProvision_Async  mcuxClEls_KeyProvision_Async
#define mcuxClCss_LimitedWaitForOperation  mcuxClEls_LimitedWaitForOperation
#define mcuxClCss_Prng_GetRandom  mcuxClEls_Prng_GetRandom
#define mcuxClCss_Prng_GetRandomWord  mcuxClEls_Prng_GetRandomWord
#define mcuxClCss_Prng_Init_Async  mcuxClEls_Prng_Init_Async
#define mcuxClCss_ReleaseLock  mcuxClEls_ReleaseLock
#define mcuxClCss_ResetErrorFlags  mcuxClEls_ResetErrorFlags
#define mcuxClCss_ResetIntFlags  mcuxClEls_ResetIntFlags
#define mcuxClCss_Reset_Async  mcuxClEls_Reset_Async
#define mcuxClCss_RespGen_Async  mcuxClEls_RespGen_Async
#define mcuxClCss_Rng_DrbgRequestRaw_Async  mcuxClEls_Rng_DrbgRequestRaw_Async
#define mcuxClCss_Rng_DrbgRequest_Async  mcuxClEls_Rng_DrbgRequest_Async
#define mcuxClCss_Rng_DrbgTestAesCtr_Async  mcuxClEls_Rng_DrbgTestAesCtr_Async
#define mcuxClCss_Rng_DrbgTestAesEcb_Async  mcuxClEls_Rng_DrbgTestAesEcb_Async
#define mcuxClCss_Rng_DrbgTestExtract_Async  mcuxClEls_Rng_DrbgTestExtract_Async
#define mcuxClCss_Rng_DrbgTestInstantiate_Async  mcuxClEls_Rng_DrbgTestInstantiate_Async
#define mcuxClCss_Rng_Dtrng_ConfigEvaluate_Async  mcuxClEls_Rng_Dtrng_ConfigEvaluate_Async
#define mcuxClCss_Rng_Dtrng_ConfigLoadPrv_Async  mcuxClEls_Rng_Dtrng_ConfigLoadPrv_Async
#define mcuxClCss_Rng_Dtrng_ConfigLoad_Async  mcuxClEls_Rng_Dtrng_ConfigLoad_Async
#define mcuxClCss_SetIntEnableFlags  mcuxClEls_SetIntEnableFlags
#define mcuxClCss_SetIntFlags  mcuxClEls_SetIntFlags
#define mcuxClCss_SetMasterUnlock  mcuxClEls_SetMasterUnlock
#define mcuxClCss_SetRandomStartDelay  mcuxClEls_SetRandomStartDelay
#define mcuxClCss_ShaDirect_Disable  mcuxClEls_ShaDirect_Disable
#define mcuxClCss_ShaDirect_Enable  mcuxClEls_ShaDirect_Enable
#define mcuxClCss_TlsGenerateMasterKeyFromPreMasterKey_Async  mcuxClEls_TlsGenerateMasterKeyFromPreMasterKey_Async
#define mcuxClCss_TlsGenerateSessionKeysFromMasterKey_Async  mcuxClEls_TlsGenerateSessionKeysFromMasterKey_Async
#define mcuxClCss_UpdateRefCRC  mcuxClEls_UpdateRefCRC
#define mcuxClCss_VerifyVsRefCRC  mcuxClEls_VerifyVsRefCRC
#define mcuxClCss_WaitForOperation  mcuxClEls_WaitForOperation

/**
 * There are also corresponding changes in other components:
 * mcuxClMac_Mode_HMAC_SHA2_256_CSS  ->  mcuxClMac_Mode_HMAC_SHA2_256_ELS
 * mcuxClRandomModes_Mode_CSS_Drbg   ->  mcuxClRandomModes_Mode_ELS_Drbg
 */

#endif /* MCUXCLELS_MAPPING_H_ */
