'''OpenGL extension ARB.shader_ballot

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.shader_ballot to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides the ability for a group of invocations which
	execute in lockstep to do limited forms of cross-invocation communication
	via a group broadcast of a invocation value, or broadcast of a bitarray
	representing a predicate value from each invocation in the group.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/shader_ballot.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.ARB.shader_ballot import *
from OpenGL.raw.GL.ARB.shader_ballot import _EXTENSION_NAME

def glInitShaderBallotARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION