/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.GradleInternal;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.execution.BuildConfigurationActionExecuter;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.initialization.ProjectsEvaluatedNotifier;
import org.gradle.initialization.TaskExecutionPreparer;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.operations.BuildOperationExecutor;

public class DefaultTaskExecutionPreparer
implements TaskExecutionPreparer {
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildConfigurationActionExecuter buildConfigurationActionExecuter;
    private final IncludedBuildControllers includedBuildControllers;
    private final BuildModelParameters buildModelParameters;

    public DefaultTaskExecutionPreparer(BuildConfigurationActionExecuter buildConfigurationActionExecuter, IncludedBuildControllers includedBuildControllers, BuildOperationExecutor buildOperationExecutor, BuildModelParameters buildModelParameters) {
        this.buildConfigurationActionExecuter = buildConfigurationActionExecuter;
        this.includedBuildControllers = includedBuildControllers;
        this.buildOperationExecutor = buildOperationExecutor;
        this.buildModelParameters = buildModelParameters;
    }

    @Override
    public void prepareForTaskExecution(GradleInternal gradle) {
        this.buildConfigurationActionExecuter.select(gradle);
        TaskExecutionGraphInternal taskGraph = gradle.getTaskGraph();
        taskGraph.populate();
        if (gradle.isRootBuild()) {
            this.includedBuildControllers.populateTaskGraphs();
        }
        if (this.buildModelParameters.isConfigureOnDemand() && gradle.isRootBuild()) {
            new ProjectsEvaluatedNotifier(this.buildOperationExecutor).notify(gradle);
        }
    }
}

