# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=x86-64 -iterations=1 -timeline -resource-pressure=false < %s | FileCheck %s

# The vmul can start executing 2cy in advance. That is beause the first use
# operand (i.e. %xmm1) is a ReadAfterLd. That means, the memory operand is
# evaluated before %xmm1.

addps  %xmm0, %xmm1
mulps  (%rdi), %xmm1

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      2
# CHECK-NEXT: Total Cycles:      14
# CHECK-NEXT: Total uOps:        3

# CHECK:      Dispatch Width:    4
# CHECK-NEXT: uOps Per Cycle:    0.21
# CHECK-NEXT: IPC:               0.14
# CHECK-NEXT: Block RThroughput: 1.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     1.00                        addps	%xmm0, %xmm1
# CHECK-NEXT:  2      11    1.00    *                   mulps	(%rdi), %xmm1

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123
# CHECK-NEXT: Index     0123456789

# CHECK:      [0,0]     DeeeER    .  .   addps	%xmm0, %xmm1
# CHECK-NEXT: [0,1]     DeeeeeeeeeeeER   mulps	(%rdi), %xmm1

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     1     1.0    1.0    0.0       addps	%xmm0, %xmm1
# CHECK-NEXT: 1.     1     1.0    0.0    0.0       mulps	(%rdi), %xmm1
# CHECK-NEXT:        1     1.0    0.5    0.0       <total>
