; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple aarch64 -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc < %s -mtriple aarch64 -o - -global-isel | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define <8 x i16> @extadds_v8i8_i16(<8 x i8> %s0, <8 x i8> %s1) {
; CHECK-LABEL: extadds_v8i8_i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    saddl v0.8h, v0.8b, v1.8b
; CHECK-NEXT:    ret
entry:
  %s0s = sext <8 x i8> %s0 to <8 x i16>
  %s1s = sext <8 x i8> %s1 to <8 x i16>
  %m = add <8 x i16> %s0s, %s1s
  ret <8 x i16> %m
}

define <8 x i16> @extaddu_v8i8_i16(<8 x i8> %s0, <8 x i8> %s1) {
; CHECK-LABEL: extaddu_v8i8_i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uaddl v0.8h, v0.8b, v1.8b
; CHECK-NEXT:    ret
entry:
  %s0s = zext <8 x i8> %s0 to <8 x i16>
  %s1s = zext <8 x i8> %s1 to <8 x i16>
  %m = add <8 x i16> %s0s, %s1s
  ret <8 x i16> %m
}

define <16 x i16> @extadds_v16i8_i16(<16 x i8> %s0, <16 x i8> %s1) {
; CHECK-SD-LABEL: extadds_v16i8_i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    saddl2 v2.8h, v0.16b, v1.16b
; CHECK-SD-NEXT:    saddl v0.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    mov v1.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extadds_v16i8_i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    saddl v2.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    saddl2 v1.8h, v0.16b, v1.16b
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    ret
entry:
  %s0s = sext <16 x i8> %s0 to <16 x i16>
  %s1s = sext <16 x i8> %s1 to <16 x i16>
  %m = add <16 x i16> %s0s, %s1s
  ret <16 x i16> %m
}

define <16 x i16> @extaddu_v16i8_i16(<16 x i8> %s0, <16 x i8> %s1) {
; CHECK-SD-LABEL: extaddu_v16i8_i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uaddl2 v2.8h, v0.16b, v1.16b
; CHECK-SD-NEXT:    uaddl v0.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    mov v1.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extaddu_v16i8_i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uaddl v2.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    uaddl2 v1.8h, v0.16b, v1.16b
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <16 x i8> %s0 to <16 x i16>
  %s1s = zext <16 x i8> %s1 to <16 x i16>
  %m = add <16 x i16> %s0s, %s1s
  ret <16 x i16> %m
}

define <32 x i16> @extadds_v32i8_i16(<32 x i8> %s0, <32 x i8> %s1) {
; CHECK-SD-LABEL: extadds_v32i8_i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    saddl2 v4.8h, v1.16b, v3.16b
; CHECK-SD-NEXT:    saddl v5.8h, v0.8b, v2.8b
; CHECK-SD-NEXT:    saddl2 v6.8h, v0.16b, v2.16b
; CHECK-SD-NEXT:    saddl v2.8h, v1.8b, v3.8b
; CHECK-SD-NEXT:    mov v0.16b, v5.16b
; CHECK-SD-NEXT:    mov v1.16b, v6.16b
; CHECK-SD-NEXT:    mov v3.16b, v4.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extadds_v32i8_i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    saddl v4.8h, v0.8b, v2.8b
; CHECK-GI-NEXT:    saddl2 v5.8h, v0.16b, v2.16b
; CHECK-GI-NEXT:    saddl v2.8h, v1.8b, v3.8b
; CHECK-GI-NEXT:    saddl2 v3.8h, v1.16b, v3.16b
; CHECK-GI-NEXT:    mov v0.16b, v4.16b
; CHECK-GI-NEXT:    mov v1.16b, v5.16b
; CHECK-GI-NEXT:    ret
entry:
  %s0s = sext <32 x i8> %s0 to <32 x i16>
  %s1s = sext <32 x i8> %s1 to <32 x i16>
  %m = add <32 x i16> %s0s, %s1s
  ret <32 x i16> %m
}

define <32 x i16> @extaddu_v32i8_i16(<32 x i8> %s0, <32 x i8> %s1) {
; CHECK-SD-LABEL: extaddu_v32i8_i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uaddl2 v4.8h, v1.16b, v3.16b
; CHECK-SD-NEXT:    uaddl v5.8h, v0.8b, v2.8b
; CHECK-SD-NEXT:    uaddl2 v6.8h, v0.16b, v2.16b
; CHECK-SD-NEXT:    uaddl v2.8h, v1.8b, v3.8b
; CHECK-SD-NEXT:    mov v0.16b, v5.16b
; CHECK-SD-NEXT:    mov v1.16b, v6.16b
; CHECK-SD-NEXT:    mov v3.16b, v4.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extaddu_v32i8_i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uaddl v4.8h, v0.8b, v2.8b
; CHECK-GI-NEXT:    uaddl2 v5.8h, v0.16b, v2.16b
; CHECK-GI-NEXT:    uaddl v2.8h, v1.8b, v3.8b
; CHECK-GI-NEXT:    uaddl2 v3.8h, v1.16b, v3.16b
; CHECK-GI-NEXT:    mov v0.16b, v4.16b
; CHECK-GI-NEXT:    mov v1.16b, v5.16b
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <32 x i8> %s0 to <32 x i16>
  %s1s = zext <32 x i8> %s1 to <32 x i16>
  %m = add <32 x i16> %s0s, %s1s
  ret <32 x i16> %m
}

define <8 x i32> @extadds_v8i8_i32(<8 x i8> %s0, <8 x i8> %s1) {
; CHECK-SD-LABEL: extadds_v8i8_i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    saddl v0.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    sshll2 v1.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extadds_v8i8_i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    saddl v1.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    sshll v0.4s, v1.4h, #0
; CHECK-GI-NEXT:    sshll2 v1.4s, v1.8h, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = sext <8 x i8> %s0 to <8 x i32>
  %s1s = sext <8 x i8> %s1 to <8 x i32>
  %m = add <8 x i32> %s0s, %s1s
  ret <8 x i32> %m
}

define <8 x i32> @extaddu_v8i8_i32(<8 x i8> %s0, <8 x i8> %s1) {
; CHECK-SD-LABEL: extaddu_v8i8_i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uaddl v0.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    ushll2 v1.4s, v0.8h, #0
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extaddu_v8i8_i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uaddl v1.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    ushll v0.4s, v1.4h, #0
; CHECK-GI-NEXT:    ushll2 v1.4s, v1.8h, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <8 x i8> %s0 to <8 x i32>
  %s1s = zext <8 x i8> %s1 to <8 x i32>
  %m = add <8 x i32> %s0s, %s1s
  ret <8 x i32> %m
}

define <8 x i32> @extsubs_v8i8_i32(<8 x i8> %s0, <8 x i8> %s1) {
; CHECK-SD-LABEL: extsubs_v8i8_i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ssubl v0.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    sshll2 v1.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extsubs_v8i8_i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ssubl v1.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    sshll v0.4s, v1.4h, #0
; CHECK-GI-NEXT:    sshll2 v1.4s, v1.8h, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = sext <8 x i8> %s0 to <8 x i32>
  %s1s = sext <8 x i8> %s1 to <8 x i32>
  %m = sub <8 x i32> %s0s, %s1s
  ret <8 x i32> %m
}

define <8 x i32> @extsubu_v8i8_i32(<8 x i8> %s0, <8 x i8> %s1) {
; CHECK-SD-LABEL: extsubu_v8i8_i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    usubl v0.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    sshll2 v1.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extsubu_v8i8_i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    usubl v1.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    sshll v0.4s, v1.4h, #0
; CHECK-GI-NEXT:    sshll2 v1.4s, v1.8h, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <8 x i8> %s0 to <8 x i32>
  %s1s = zext <8 x i8> %s1 to <8 x i32>
  %m = sub <8 x i32> %s0s, %s1s
  ret <8 x i32> %m
}

define <16 x i32> @extadds_v16i8_i32(<16 x i8> %s0, <16 x i8> %s1) {
; CHECK-SD-LABEL: extadds_v16i8_i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    saddl v2.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    saddl2 v4.8h, v0.16b, v1.16b
; CHECK-SD-NEXT:    sshll v0.4s, v2.4h, #0
; CHECK-SD-NEXT:    sshll2 v3.4s, v4.8h, #0
; CHECK-SD-NEXT:    sshll2 v1.4s, v2.8h, #0
; CHECK-SD-NEXT:    sshll v2.4s, v4.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extadds_v16i8_i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    saddl v2.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    saddl2 v3.8h, v0.16b, v1.16b
; CHECK-GI-NEXT:    sshll v0.4s, v2.4h, #0
; CHECK-GI-NEXT:    sshll2 v1.4s, v2.8h, #0
; CHECK-GI-NEXT:    sshll v2.4s, v3.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v3.8h, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = sext <16 x i8> %s0 to <16 x i32>
  %s1s = sext <16 x i8> %s1 to <16 x i32>
  %m = add <16 x i32> %s0s, %s1s
  ret <16 x i32> %m
}

define <16 x i32> @extaddu_v16i8_i32(<16 x i8> %s0, <16 x i8> %s1) {
; CHECK-SD-LABEL: extaddu_v16i8_i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uaddl v2.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    uaddl2 v4.8h, v0.16b, v1.16b
; CHECK-SD-NEXT:    ushll v0.4s, v2.4h, #0
; CHECK-SD-NEXT:    ushll2 v3.4s, v4.8h, #0
; CHECK-SD-NEXT:    ushll2 v1.4s, v2.8h, #0
; CHECK-SD-NEXT:    ushll v2.4s, v4.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extaddu_v16i8_i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uaddl v2.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    uaddl2 v3.8h, v0.16b, v1.16b
; CHECK-GI-NEXT:    ushll v0.4s, v2.4h, #0
; CHECK-GI-NEXT:    ushll2 v1.4s, v2.8h, #0
; CHECK-GI-NEXT:    ushll v2.4s, v3.4h, #0
; CHECK-GI-NEXT:    ushll2 v3.4s, v3.8h, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <16 x i8> %s0 to <16 x i32>
  %s1s = zext <16 x i8> %s1 to <16 x i32>
  %m = add <16 x i32> %s0s, %s1s
  ret <16 x i32> %m
}

define <16 x i32> @extsubs_v16i8_i32(<16 x i8> %s0, <16 x i8> %s1) {
; CHECK-SD-LABEL: extsubs_v16i8_i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ssubl v2.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    ssubl2 v4.8h, v0.16b, v1.16b
; CHECK-SD-NEXT:    sshll v0.4s, v2.4h, #0
; CHECK-SD-NEXT:    sshll2 v3.4s, v4.8h, #0
; CHECK-SD-NEXT:    sshll2 v1.4s, v2.8h, #0
; CHECK-SD-NEXT:    sshll v2.4s, v4.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extsubs_v16i8_i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ssubl v2.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    ssubl2 v3.8h, v0.16b, v1.16b
; CHECK-GI-NEXT:    sshll v0.4s, v2.4h, #0
; CHECK-GI-NEXT:    sshll2 v1.4s, v2.8h, #0
; CHECK-GI-NEXT:    sshll v2.4s, v3.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v3.8h, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = sext <16 x i8> %s0 to <16 x i32>
  %s1s = sext <16 x i8> %s1 to <16 x i32>
  %m = sub <16 x i32> %s0s, %s1s
  ret <16 x i32> %m
}

define <16 x i32> @extsubu_v16i8_i32(<16 x i8> %s0, <16 x i8> %s1) {
; CHECK-SD-LABEL: extsubu_v16i8_i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    usubl v2.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    usubl2 v4.8h, v0.16b, v1.16b
; CHECK-SD-NEXT:    sshll v0.4s, v2.4h, #0
; CHECK-SD-NEXT:    sshll2 v3.4s, v4.8h, #0
; CHECK-SD-NEXT:    sshll2 v1.4s, v2.8h, #0
; CHECK-SD-NEXT:    sshll v2.4s, v4.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extsubu_v16i8_i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    usubl v2.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    usubl2 v3.8h, v0.16b, v1.16b
; CHECK-GI-NEXT:    sshll v0.4s, v2.4h, #0
; CHECK-GI-NEXT:    sshll2 v1.4s, v2.8h, #0
; CHECK-GI-NEXT:    sshll v2.4s, v3.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v3.8h, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <16 x i8> %s0 to <16 x i32>
  %s1s = zext <16 x i8> %s1 to <16 x i32>
  %m = sub <16 x i32> %s0s, %s1s
  ret <16 x i32> %m
}

define <8 x i64> @extadds_v8i8_i64(<8 x i8> %s0, <8 x i8> %s1) {
; CHECK-SD-LABEL: extadds_v8i8_i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    saddl v0.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll2 v2.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll v0.2d, v1.2s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extadds_v8i8_i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    saddl v0.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v0.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    sshll v2.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = sext <8 x i8> %s0 to <8 x i64>
  %s1s = sext <8 x i8> %s1 to <8 x i64>
  %m = add <8 x i64> %s0s, %s1s
  ret <8 x i64> %m
}

define <8 x i64> @extaddu_v8i8_i64(<8 x i8> %s0, <8 x i8> %s1) {
; CHECK-SD-LABEL: extaddu_v8i8_i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uaddl v0.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-SD-NEXT:    ushll2 v2.4s, v0.8h, #0
; CHECK-SD-NEXT:    ushll v0.2d, v1.2s, #0
; CHECK-SD-NEXT:    ushll2 v3.2d, v2.4s, #0
; CHECK-SD-NEXT:    ushll2 v1.2d, v1.4s, #0
; CHECK-SD-NEXT:    ushll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extaddu_v8i8_i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uaddl v0.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v3.4s, v0.8h, #0
; CHECK-GI-NEXT:    ushll v0.2d, v1.2s, #0
; CHECK-GI-NEXT:    ushll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    ushll v2.2d, v3.2s, #0
; CHECK-GI-NEXT:    ushll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <8 x i8> %s0 to <8 x i64>
  %s1s = zext <8 x i8> %s1 to <8 x i64>
  %m = add <8 x i64> %s0s, %s1s
  ret <8 x i64> %m
}

define <8 x i64> @extsubs_v8i8_i64(<8 x i8> %s0, <8 x i8> %s1) {
; CHECK-SD-LABEL: extsubs_v8i8_i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ssubl v0.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll2 v2.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll v0.2d, v1.2s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extsubs_v8i8_i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ssubl v0.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v0.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    sshll v2.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = sext <8 x i8> %s0 to <8 x i64>
  %s1s = sext <8 x i8> %s1 to <8 x i64>
  %m = sub <8 x i64> %s0s, %s1s
  ret <8 x i64> %m
}

define <8 x i64> @extsubu_v8i8_i64(<8 x i8> %s0, <8 x i8> %s1) {
; CHECK-SD-LABEL: extsubu_v8i8_i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    usubl v0.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll2 v2.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll v0.2d, v1.2s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extsubu_v8i8_i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    usubl v0.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v0.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    sshll v2.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <8 x i8> %s0 to <8 x i64>
  %s1s = zext <8 x i8> %s1 to <8 x i64>
  %m = sub <8 x i64> %s0s, %s1s
  ret <8 x i64> %m
}

define <16 x i64> @extaddu_v16i8_i64(<16 x i8> %a, <16 x i8> %b) {
; CHECK-SD-LABEL: extaddu_v16i8_i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    uaddl v2.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    uaddl2 v0.8h, v0.16b, v1.16b
; CHECK-SD-NEXT:    ushll v3.4s, v2.4h, #0
; CHECK-SD-NEXT:    ushll2 v2.4s, v2.8h, #0
; CHECK-SD-NEXT:    ushll v5.4s, v0.4h, #0
; CHECK-SD-NEXT:    ushll2 v6.4s, v0.8h, #0
; CHECK-SD-NEXT:    ushll2 v1.2d, v3.4s, #0
; CHECK-SD-NEXT:    ushll v0.2d, v3.2s, #0
; CHECK-SD-NEXT:    ushll2 v3.2d, v2.4s, #0
; CHECK-SD-NEXT:    ushll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    ushll v4.2d, v5.2s, #0
; CHECK-SD-NEXT:    ushll2 v7.2d, v6.4s, #0
; CHECK-SD-NEXT:    ushll2 v5.2d, v5.4s, #0
; CHECK-SD-NEXT:    ushll v6.2d, v6.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extaddu_v16i8_i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    uaddl v2.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    uaddl2 v0.8h, v0.16b, v1.16b
; CHECK-GI-NEXT:    ushll v1.4s, v2.4h, #0
; CHECK-GI-NEXT:    ushll2 v3.4s, v2.8h, #0
; CHECK-GI-NEXT:    ushll v5.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v7.4s, v0.8h, #0
; CHECK-GI-NEXT:    ushll v0.2d, v1.2s, #0
; CHECK-GI-NEXT:    ushll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    ushll v2.2d, v3.2s, #0
; CHECK-GI-NEXT:    ushll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    ushll v4.2d, v5.2s, #0
; CHECK-GI-NEXT:    ushll2 v5.2d, v5.4s, #0
; CHECK-GI-NEXT:    ushll v6.2d, v7.2s, #0
; CHECK-GI-NEXT:    ushll2 v7.2d, v7.4s, #0
; CHECK-GI-NEXT:    ret
    %c = zext <16 x i8> %a to <16 x i64>
    %d = zext <16 x i8> %b to <16 x i64>
    %e = add <16 x i64> %c, %d
    ret <16 x i64> %e
}

define <16 x i64> @extadds_v16i8_i64(<16 x i8> %a, <16 x i8> %b) {
; CHECK-SD-LABEL: extadds_v16i8_i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    saddl v2.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    saddl2 v0.8h, v0.16b, v1.16b
; CHECK-SD-NEXT:    sshll v3.4s, v2.4h, #0
; CHECK-SD-NEXT:    sshll2 v2.4s, v2.8h, #0
; CHECK-SD-NEXT:    sshll v5.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll2 v6.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll2 v1.2d, v3.4s, #0
; CHECK-SD-NEXT:    sshll v0.2d, v3.2s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    sshll v4.2d, v5.2s, #0
; CHECK-SD-NEXT:    sshll2 v7.2d, v6.4s, #0
; CHECK-SD-NEXT:    sshll2 v5.2d, v5.4s, #0
; CHECK-SD-NEXT:    sshll v6.2d, v6.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extadds_v16i8_i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    saddl v2.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    saddl2 v0.8h, v0.16b, v1.16b
; CHECK-GI-NEXT:    sshll v1.4s, v2.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v2.8h, #0
; CHECK-GI-NEXT:    sshll v5.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v7.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v0.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    sshll v2.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    sshll v4.2d, v5.2s, #0
; CHECK-GI-NEXT:    sshll2 v5.2d, v5.4s, #0
; CHECK-GI-NEXT:    sshll v6.2d, v7.2s, #0
; CHECK-GI-NEXT:    sshll2 v7.2d, v7.4s, #0
; CHECK-GI-NEXT:    ret
    %c = sext <16 x i8> %a to <16 x i64>
    %d = sext <16 x i8> %b to <16 x i64>
    %e = add <16 x i64> %c, %d
    ret <16 x i64> %e
}

define <16 x i64> @extsubu_v16i8_i64(<16 x i8> %a, <16 x i8> %b) {
; CHECK-SD-LABEL: extsubu_v16i8_i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    usubl v2.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    usubl2 v0.8h, v0.16b, v1.16b
; CHECK-SD-NEXT:    sshll v3.4s, v2.4h, #0
; CHECK-SD-NEXT:    sshll2 v2.4s, v2.8h, #0
; CHECK-SD-NEXT:    sshll v5.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll2 v6.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll2 v1.2d, v3.4s, #0
; CHECK-SD-NEXT:    sshll v0.2d, v3.2s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    sshll v4.2d, v5.2s, #0
; CHECK-SD-NEXT:    sshll2 v7.2d, v6.4s, #0
; CHECK-SD-NEXT:    sshll2 v5.2d, v5.4s, #0
; CHECK-SD-NEXT:    sshll v6.2d, v6.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extsubu_v16i8_i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    usubl v2.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    usubl2 v0.8h, v0.16b, v1.16b
; CHECK-GI-NEXT:    sshll v1.4s, v2.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v2.8h, #0
; CHECK-GI-NEXT:    sshll v5.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v7.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v0.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    sshll v2.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    sshll v4.2d, v5.2s, #0
; CHECK-GI-NEXT:    sshll2 v5.2d, v5.4s, #0
; CHECK-GI-NEXT:    sshll v6.2d, v7.2s, #0
; CHECK-GI-NEXT:    sshll2 v7.2d, v7.4s, #0
; CHECK-GI-NEXT:    ret
    %c = zext <16 x i8> %a to <16 x i64>
    %d = zext <16 x i8> %b to <16 x i64>
    %e = sub <16 x i64> %c, %d
    ret <16 x i64> %e
}

define <16 x i64> @extsubs_v16i8_i64(<16 x i8> %a, <16 x i8> %b) {
; CHECK-SD-LABEL: extsubs_v16i8_i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ssubl v2.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    ssubl2 v0.8h, v0.16b, v1.16b
; CHECK-SD-NEXT:    sshll v3.4s, v2.4h, #0
; CHECK-SD-NEXT:    sshll2 v2.4s, v2.8h, #0
; CHECK-SD-NEXT:    sshll v5.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll2 v6.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll2 v1.2d, v3.4s, #0
; CHECK-SD-NEXT:    sshll v0.2d, v3.2s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    sshll v4.2d, v5.2s, #0
; CHECK-SD-NEXT:    sshll2 v7.2d, v6.4s, #0
; CHECK-SD-NEXT:    sshll2 v5.2d, v5.4s, #0
; CHECK-SD-NEXT:    sshll v6.2d, v6.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extsubs_v16i8_i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    ssubl v2.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    ssubl2 v0.8h, v0.16b, v1.16b
; CHECK-GI-NEXT:    sshll v1.4s, v2.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v2.8h, #0
; CHECK-GI-NEXT:    sshll v5.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v7.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v0.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    sshll v2.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    sshll v4.2d, v5.2s, #0
; CHECK-GI-NEXT:    sshll2 v5.2d, v5.4s, #0
; CHECK-GI-NEXT:    sshll v6.2d, v7.2s, #0
; CHECK-GI-NEXT:    sshll2 v7.2d, v7.4s, #0
; CHECK-GI-NEXT:    ret
    %c = sext <16 x i8> %a to <16 x i64>
    %d = sext <16 x i8> %b to <16 x i64>
    %e = sub <16 x i64> %c, %d
    ret <16 x i64> %e
}

define <16 x i64> @extaddu_v16i16_i64(<16 x i16> %a, <16 x i16> %b) {
; CHECK-SD-LABEL: extaddu_v16i16_i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    uaddl v5.4s, v1.4h, v3.4h
; CHECK-SD-NEXT:    uaddl v4.4s, v0.4h, v2.4h
; CHECK-SD-NEXT:    uaddl2 v2.4s, v0.8h, v2.8h
; CHECK-SD-NEXT:    uaddl2 v6.4s, v1.8h, v3.8h
; CHECK-SD-NEXT:    ushll2 v1.2d, v4.4s, #0
; CHECK-SD-NEXT:    ushll v0.2d, v4.2s, #0
; CHECK-SD-NEXT:    ushll2 v3.2d, v2.4s, #0
; CHECK-SD-NEXT:    ushll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    ushll v4.2d, v5.2s, #0
; CHECK-SD-NEXT:    ushll2 v7.2d, v6.4s, #0
; CHECK-SD-NEXT:    ushll2 v5.2d, v5.4s, #0
; CHECK-SD-NEXT:    ushll v6.2d, v6.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extaddu_v16i16_i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    uaddl v4.4s, v0.4h, v2.4h
; CHECK-GI-NEXT:    uaddl2 v5.4s, v0.8h, v2.8h
; CHECK-GI-NEXT:    uaddl v6.4s, v1.4h, v3.4h
; CHECK-GI-NEXT:    uaddl2 v7.4s, v1.8h, v3.8h
; CHECK-GI-NEXT:    ushll v0.2d, v4.2s, #0
; CHECK-GI-NEXT:    ushll2 v1.2d, v4.4s, #0
; CHECK-GI-NEXT:    ushll v2.2d, v5.2s, #0
; CHECK-GI-NEXT:    ushll2 v3.2d, v5.4s, #0
; CHECK-GI-NEXT:    ushll v4.2d, v6.2s, #0
; CHECK-GI-NEXT:    ushll2 v5.2d, v6.4s, #0
; CHECK-GI-NEXT:    ushll v6.2d, v7.2s, #0
; CHECK-GI-NEXT:    ushll2 v7.2d, v7.4s, #0
; CHECK-GI-NEXT:    ret
    %c = zext <16 x i16> %a to <16 x i64>
    %d = zext <16 x i16> %b to <16 x i64>
    %e = add <16 x i64> %c, %d
    ret <16 x i64> %e
}

define <16 x i64> @extadds_v16i16_i64(<16 x i16> %a, <16 x i16> %b) {
; CHECK-SD-LABEL: extadds_v16i16_i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    saddl v5.4s, v1.4h, v3.4h
; CHECK-SD-NEXT:    saddl v4.4s, v0.4h, v2.4h
; CHECK-SD-NEXT:    saddl2 v2.4s, v0.8h, v2.8h
; CHECK-SD-NEXT:    saddl2 v6.4s, v1.8h, v3.8h
; CHECK-SD-NEXT:    sshll2 v1.2d, v4.4s, #0
; CHECK-SD-NEXT:    sshll v0.2d, v4.2s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    sshll v4.2d, v5.2s, #0
; CHECK-SD-NEXT:    sshll2 v7.2d, v6.4s, #0
; CHECK-SD-NEXT:    sshll2 v5.2d, v5.4s, #0
; CHECK-SD-NEXT:    sshll v6.2d, v6.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extadds_v16i16_i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    saddl v4.4s, v0.4h, v2.4h
; CHECK-GI-NEXT:    saddl2 v5.4s, v0.8h, v2.8h
; CHECK-GI-NEXT:    saddl v6.4s, v1.4h, v3.4h
; CHECK-GI-NEXT:    saddl2 v7.4s, v1.8h, v3.8h
; CHECK-GI-NEXT:    sshll v0.2d, v4.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v4.4s, #0
; CHECK-GI-NEXT:    sshll v2.2d, v5.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v5.4s, #0
; CHECK-GI-NEXT:    sshll v4.2d, v6.2s, #0
; CHECK-GI-NEXT:    sshll2 v5.2d, v6.4s, #0
; CHECK-GI-NEXT:    sshll v6.2d, v7.2s, #0
; CHECK-GI-NEXT:    sshll2 v7.2d, v7.4s, #0
; CHECK-GI-NEXT:    ret
    %c = sext <16 x i16> %a to <16 x i64>
    %d = sext <16 x i16> %b to <16 x i64>
    %e = add <16 x i64> %c, %d
    ret <16 x i64> %e
}

define <16 x i64> @extsubu_v16i16_i64(<16 x i16> %a, <16 x i16> %b) {
; CHECK-SD-LABEL: extsubu_v16i16_i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    usubl v5.4s, v1.4h, v3.4h
; CHECK-SD-NEXT:    usubl v4.4s, v0.4h, v2.4h
; CHECK-SD-NEXT:    usubl2 v2.4s, v0.8h, v2.8h
; CHECK-SD-NEXT:    usubl2 v6.4s, v1.8h, v3.8h
; CHECK-SD-NEXT:    sshll2 v1.2d, v4.4s, #0
; CHECK-SD-NEXT:    sshll v0.2d, v4.2s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    sshll v4.2d, v5.2s, #0
; CHECK-SD-NEXT:    sshll2 v7.2d, v6.4s, #0
; CHECK-SD-NEXT:    sshll2 v5.2d, v5.4s, #0
; CHECK-SD-NEXT:    sshll v6.2d, v6.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extsubu_v16i16_i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    usubl v4.4s, v0.4h, v2.4h
; CHECK-GI-NEXT:    usubl2 v5.4s, v0.8h, v2.8h
; CHECK-GI-NEXT:    usubl v6.4s, v1.4h, v3.4h
; CHECK-GI-NEXT:    usubl2 v7.4s, v1.8h, v3.8h
; CHECK-GI-NEXT:    sshll v0.2d, v4.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v4.4s, #0
; CHECK-GI-NEXT:    sshll v2.2d, v5.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v5.4s, #0
; CHECK-GI-NEXT:    sshll v4.2d, v6.2s, #0
; CHECK-GI-NEXT:    sshll2 v5.2d, v6.4s, #0
; CHECK-GI-NEXT:    sshll v6.2d, v7.2s, #0
; CHECK-GI-NEXT:    sshll2 v7.2d, v7.4s, #0
; CHECK-GI-NEXT:    ret
    %c = zext <16 x i16> %a to <16 x i64>
    %d = zext <16 x i16> %b to <16 x i64>
    %e = sub <16 x i64> %c, %d
    ret <16 x i64> %e
}

define <16 x i64> @extsubs_v16i16_i64(<16 x i16> %a, <16 x i16> %b) {
; CHECK-SD-LABEL: extsubs_v16i16_i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ssubl v5.4s, v1.4h, v3.4h
; CHECK-SD-NEXT:    ssubl v4.4s, v0.4h, v2.4h
; CHECK-SD-NEXT:    ssubl2 v2.4s, v0.8h, v2.8h
; CHECK-SD-NEXT:    ssubl2 v6.4s, v1.8h, v3.8h
; CHECK-SD-NEXT:    sshll2 v1.2d, v4.4s, #0
; CHECK-SD-NEXT:    sshll v0.2d, v4.2s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    sshll v4.2d, v5.2s, #0
; CHECK-SD-NEXT:    sshll2 v7.2d, v6.4s, #0
; CHECK-SD-NEXT:    sshll2 v5.2d, v5.4s, #0
; CHECK-SD-NEXT:    sshll v6.2d, v6.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extsubs_v16i16_i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    ssubl v4.4s, v0.4h, v2.4h
; CHECK-GI-NEXT:    ssubl2 v5.4s, v0.8h, v2.8h
; CHECK-GI-NEXT:    ssubl v6.4s, v1.4h, v3.4h
; CHECK-GI-NEXT:    ssubl2 v7.4s, v1.8h, v3.8h
; CHECK-GI-NEXT:    sshll v0.2d, v4.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v4.4s, #0
; CHECK-GI-NEXT:    sshll v2.2d, v5.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v5.4s, #0
; CHECK-GI-NEXT:    sshll v4.2d, v6.2s, #0
; CHECK-GI-NEXT:    sshll2 v5.2d, v6.4s, #0
; CHECK-GI-NEXT:    sshll v6.2d, v7.2s, #0
; CHECK-GI-NEXT:    sshll2 v7.2d, v7.4s, #0
; CHECK-GI-NEXT:    ret
    %c = sext <16 x i16> %a to <16 x i64>
    %d = sext <16 x i16> %b to <16 x i64>
    %e = sub <16 x i64> %c, %d
    ret <16 x i64> %e
}

define <4 x i32> @extadds_v4i16_i32(<4 x i16> %s0, <4 x i16> %s1) {
; CHECK-LABEL: extadds_v4i16_i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    saddl v0.4s, v0.4h, v1.4h
; CHECK-NEXT:    ret
entry:
  %s0s = sext <4 x i16> %s0 to <4 x i32>
  %s1s = sext <4 x i16> %s1 to <4 x i32>
  %m = add <4 x i32> %s0s, %s1s
  ret <4 x i32> %m
}

define <4 x i32> @extaddu_v4i16_i32(<4 x i16> %s0, <4 x i16> %s1) {
; CHECK-LABEL: extaddu_v4i16_i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uaddl v0.4s, v0.4h, v1.4h
; CHECK-NEXT:    ret
entry:
  %s0s = zext <4 x i16> %s0 to <4 x i32>
  %s1s = zext <4 x i16> %s1 to <4 x i32>
  %m = add <4 x i32> %s0s, %s1s
  ret <4 x i32> %m
}

define <8 x i32> @extadds_v8i16_i32(<8 x i16> %s0, <8 x i16> %s1) {
; CHECK-SD-LABEL: extadds_v8i16_i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    saddl2 v2.4s, v0.8h, v1.8h
; CHECK-SD-NEXT:    saddl v0.4s, v0.4h, v1.4h
; CHECK-SD-NEXT:    mov v1.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extadds_v8i16_i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    saddl v2.4s, v0.4h, v1.4h
; CHECK-GI-NEXT:    saddl2 v1.4s, v0.8h, v1.8h
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    ret
entry:
  %s0s = sext <8 x i16> %s0 to <8 x i32>
  %s1s = sext <8 x i16> %s1 to <8 x i32>
  %m = add <8 x i32> %s0s, %s1s
  ret <8 x i32> %m
}

define <8 x i32> @extaddu_v8i16_i32(<8 x i16> %s0, <8 x i16> %s1) {
; CHECK-SD-LABEL: extaddu_v8i16_i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uaddl2 v2.4s, v0.8h, v1.8h
; CHECK-SD-NEXT:    uaddl v0.4s, v0.4h, v1.4h
; CHECK-SD-NEXT:    mov v1.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extaddu_v8i16_i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uaddl v2.4s, v0.4h, v1.4h
; CHECK-GI-NEXT:    uaddl2 v1.4s, v0.8h, v1.8h
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <8 x i16> %s0 to <8 x i32>
  %s1s = zext <8 x i16> %s1 to <8 x i32>
  %m = add <8 x i32> %s0s, %s1s
  ret <8 x i32> %m
}

define <16 x i32> @extadds_v16i16_i32(<16 x i16> %s0, <16 x i16> %s1) {
; CHECK-SD-LABEL: extadds_v16i16_i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    saddl2 v4.4s, v1.8h, v3.8h
; CHECK-SD-NEXT:    saddl v5.4s, v0.4h, v2.4h
; CHECK-SD-NEXT:    saddl2 v6.4s, v0.8h, v2.8h
; CHECK-SD-NEXT:    saddl v2.4s, v1.4h, v3.4h
; CHECK-SD-NEXT:    mov v0.16b, v5.16b
; CHECK-SD-NEXT:    mov v1.16b, v6.16b
; CHECK-SD-NEXT:    mov v3.16b, v4.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extadds_v16i16_i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    saddl v4.4s, v0.4h, v2.4h
; CHECK-GI-NEXT:    saddl2 v5.4s, v0.8h, v2.8h
; CHECK-GI-NEXT:    saddl v2.4s, v1.4h, v3.4h
; CHECK-GI-NEXT:    saddl2 v3.4s, v1.8h, v3.8h
; CHECK-GI-NEXT:    mov v0.16b, v4.16b
; CHECK-GI-NEXT:    mov v1.16b, v5.16b
; CHECK-GI-NEXT:    ret
entry:
  %s0s = sext <16 x i16> %s0 to <16 x i32>
  %s1s = sext <16 x i16> %s1 to <16 x i32>
  %m = add <16 x i32> %s0s, %s1s
  ret <16 x i32> %m
}

define <16 x i32> @extaddu_v16i16_i32(<16 x i16> %s0, <16 x i16> %s1) {
; CHECK-SD-LABEL: extaddu_v16i16_i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uaddl2 v4.4s, v1.8h, v3.8h
; CHECK-SD-NEXT:    uaddl v5.4s, v0.4h, v2.4h
; CHECK-SD-NEXT:    uaddl2 v6.4s, v0.8h, v2.8h
; CHECK-SD-NEXT:    uaddl v2.4s, v1.4h, v3.4h
; CHECK-SD-NEXT:    mov v0.16b, v5.16b
; CHECK-SD-NEXT:    mov v1.16b, v6.16b
; CHECK-SD-NEXT:    mov v3.16b, v4.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extaddu_v16i16_i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uaddl v4.4s, v0.4h, v2.4h
; CHECK-GI-NEXT:    uaddl2 v5.4s, v0.8h, v2.8h
; CHECK-GI-NEXT:    uaddl v2.4s, v1.4h, v3.4h
; CHECK-GI-NEXT:    uaddl2 v3.4s, v1.8h, v3.8h
; CHECK-GI-NEXT:    mov v0.16b, v4.16b
; CHECK-GI-NEXT:    mov v1.16b, v5.16b
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <16 x i16> %s0 to <16 x i32>
  %s1s = zext <16 x i16> %s1 to <16 x i32>
  %m = add <16 x i32> %s0s, %s1s
  ret <16 x i32> %m
}

define <4 x i64> @extadds_v4i16_i64(<4 x i16> %s0, <4 x i16> %s1) {
; CHECK-SD-LABEL: extadds_v4i16_i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    saddl v0.4s, v0.4h, v1.4h
; CHECK-SD-NEXT:    sshll2 v1.2d, v0.4s, #0
; CHECK-SD-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extadds_v4i16_i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    saddl v1.4s, v0.4h, v1.4h
; CHECK-GI-NEXT:    sshll v0.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = sext <4 x i16> %s0 to <4 x i64>
  %s1s = sext <4 x i16> %s1 to <4 x i64>
  %m = add <4 x i64> %s0s, %s1s
  ret <4 x i64> %m
}

define <4 x i64> @extaddu_v4i16_i64(<4 x i16> %s0, <4 x i16> %s1) {
; CHECK-SD-LABEL: extaddu_v4i16_i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uaddl v0.4s, v0.4h, v1.4h
; CHECK-SD-NEXT:    ushll2 v1.2d, v0.4s, #0
; CHECK-SD-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extaddu_v4i16_i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uaddl v1.4s, v0.4h, v1.4h
; CHECK-GI-NEXT:    ushll v0.2d, v1.2s, #0
; CHECK-GI-NEXT:    ushll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <4 x i16> %s0 to <4 x i64>
  %s1s = zext <4 x i16> %s1 to <4 x i64>
  %m = add <4 x i64> %s0s, %s1s
  ret <4 x i64> %m
}

define <8 x i64> @extadds_v8i16_i64(<8 x i16> %s0, <8 x i16> %s1) {
; CHECK-SD-LABEL: extadds_v8i16_i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    saddl v2.4s, v0.4h, v1.4h
; CHECK-SD-NEXT:    saddl2 v4.4s, v0.8h, v1.8h
; CHECK-SD-NEXT:    sshll v0.2d, v2.2s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v4.4s, #0
; CHECK-SD-NEXT:    sshll2 v1.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v4.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extadds_v8i16_i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    saddl v2.4s, v0.4h, v1.4h
; CHECK-GI-NEXT:    saddl2 v3.4s, v0.8h, v1.8h
; CHECK-GI-NEXT:    sshll v0.2d, v2.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v2.4s, #0
; CHECK-GI-NEXT:    sshll v2.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = sext <8 x i16> %s0 to <8 x i64>
  %s1s = sext <8 x i16> %s1 to <8 x i64>
  %m = add <8 x i64> %s0s, %s1s
  ret <8 x i64> %m
}

define <8 x i64> @extaddu_v8i16_i64(<8 x i16> %s0, <8 x i16> %s1) {
; CHECK-SD-LABEL: extaddu_v8i16_i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uaddl v2.4s, v0.4h, v1.4h
; CHECK-SD-NEXT:    uaddl2 v4.4s, v0.8h, v1.8h
; CHECK-SD-NEXT:    ushll v0.2d, v2.2s, #0
; CHECK-SD-NEXT:    ushll2 v3.2d, v4.4s, #0
; CHECK-SD-NEXT:    ushll2 v1.2d, v2.4s, #0
; CHECK-SD-NEXT:    ushll v2.2d, v4.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extaddu_v8i16_i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uaddl v2.4s, v0.4h, v1.4h
; CHECK-GI-NEXT:    uaddl2 v3.4s, v0.8h, v1.8h
; CHECK-GI-NEXT:    ushll v0.2d, v2.2s, #0
; CHECK-GI-NEXT:    ushll2 v1.2d, v2.4s, #0
; CHECK-GI-NEXT:    ushll v2.2d, v3.2s, #0
; CHECK-GI-NEXT:    ushll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <8 x i16> %s0 to <8 x i64>
  %s1s = zext <8 x i16> %s1 to <8 x i64>
  %m = add <8 x i64> %s0s, %s1s
  ret <8 x i64> %m
}

define <8 x i64> @extsubs_v8i16_i64(<8 x i16> %s0, <8 x i16> %s1) {
; CHECK-SD-LABEL: extsubs_v8i16_i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ssubl v2.4s, v0.4h, v1.4h
; CHECK-SD-NEXT:    ssubl2 v4.4s, v0.8h, v1.8h
; CHECK-SD-NEXT:    sshll v0.2d, v2.2s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v4.4s, #0
; CHECK-SD-NEXT:    sshll2 v1.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v4.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extsubs_v8i16_i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ssubl v2.4s, v0.4h, v1.4h
; CHECK-GI-NEXT:    ssubl2 v3.4s, v0.8h, v1.8h
; CHECK-GI-NEXT:    sshll v0.2d, v2.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v2.4s, #0
; CHECK-GI-NEXT:    sshll v2.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = sext <8 x i16> %s0 to <8 x i64>
  %s1s = sext <8 x i16> %s1 to <8 x i64>
  %m = sub <8 x i64> %s0s, %s1s
  ret <8 x i64> %m
}

define <8 x i64> @extsubu_v8i16_i64(<8 x i16> %s0, <8 x i16> %s1) {
; CHECK-SD-LABEL: extsubu_v8i16_i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    usubl v2.4s, v0.4h, v1.4h
; CHECK-SD-NEXT:    usubl2 v4.4s, v0.8h, v1.8h
; CHECK-SD-NEXT:    sshll v0.2d, v2.2s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v4.4s, #0
; CHECK-SD-NEXT:    sshll2 v1.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v4.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extsubu_v8i16_i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    usubl v2.4s, v0.4h, v1.4h
; CHECK-GI-NEXT:    usubl2 v3.4s, v0.8h, v1.8h
; CHECK-GI-NEXT:    sshll v0.2d, v2.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v2.4s, #0
; CHECK-GI-NEXT:    sshll v2.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <8 x i16> %s0 to <8 x i64>
  %s1s = zext <8 x i16> %s1 to <8 x i64>
  %m = sub <8 x i64> %s0s, %s1s
  ret <8 x i64> %m
}

define <2 x i64> @extadds_v2i32_i64(<2 x i32> %s0, <2 x i32> %s1) {
; CHECK-LABEL: extadds_v2i32_i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    saddl v0.2d, v0.2s, v1.2s
; CHECK-NEXT:    ret
entry:
  %s0s = sext <2 x i32> %s0 to <2 x i64>
  %s1s = sext <2 x i32> %s1 to <2 x i64>
  %m = add <2 x i64> %s0s, %s1s
  ret <2 x i64> %m
}

define <2 x i64> @extaddu_v2i32_i64(<2 x i32> %s0, <2 x i32> %s1) {
; CHECK-LABEL: extaddu_v2i32_i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uaddl v0.2d, v0.2s, v1.2s
; CHECK-NEXT:    ret
entry:
  %s0s = zext <2 x i32> %s0 to <2 x i64>
  %s1s = zext <2 x i32> %s1 to <2 x i64>
  %m = add <2 x i64> %s0s, %s1s
  ret <2 x i64> %m
}

define <4 x i64> @extadds_v4i32_i64(<4 x i32> %s0, <4 x i32> %s1) {
; CHECK-SD-LABEL: extadds_v4i32_i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    saddl2 v2.2d, v0.4s, v1.4s
; CHECK-SD-NEXT:    saddl v0.2d, v0.2s, v1.2s
; CHECK-SD-NEXT:    mov v1.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extadds_v4i32_i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    saddl v2.2d, v0.2s, v1.2s
; CHECK-GI-NEXT:    saddl2 v1.2d, v0.4s, v1.4s
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    ret
entry:
  %s0s = sext <4 x i32> %s0 to <4 x i64>
  %s1s = sext <4 x i32> %s1 to <4 x i64>
  %m = add <4 x i64> %s0s, %s1s
  ret <4 x i64> %m
}

define <4 x i64> @extaddu_v4i32_i64(<4 x i32> %s0, <4 x i32> %s1) {
; CHECK-SD-LABEL: extaddu_v4i32_i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uaddl2 v2.2d, v0.4s, v1.4s
; CHECK-SD-NEXT:    uaddl v0.2d, v0.2s, v1.2s
; CHECK-SD-NEXT:    mov v1.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extaddu_v4i32_i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uaddl v2.2d, v0.2s, v1.2s
; CHECK-GI-NEXT:    uaddl2 v1.2d, v0.4s, v1.4s
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <4 x i32> %s0 to <4 x i64>
  %s1s = zext <4 x i32> %s1 to <4 x i64>
  %m = add <4 x i64> %s0s, %s1s
  ret <4 x i64> %m
}

define <8 x i64> @extadds_v8i32_i64(<8 x i32> %s0, <8 x i32> %s1) {
; CHECK-SD-LABEL: extadds_v8i32_i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    saddl2 v4.2d, v1.4s, v3.4s
; CHECK-SD-NEXT:    saddl v5.2d, v0.2s, v2.2s
; CHECK-SD-NEXT:    saddl2 v6.2d, v0.4s, v2.4s
; CHECK-SD-NEXT:    saddl v2.2d, v1.2s, v3.2s
; CHECK-SD-NEXT:    mov v0.16b, v5.16b
; CHECK-SD-NEXT:    mov v1.16b, v6.16b
; CHECK-SD-NEXT:    mov v3.16b, v4.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extadds_v8i32_i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    saddl v4.2d, v0.2s, v2.2s
; CHECK-GI-NEXT:    saddl2 v5.2d, v0.4s, v2.4s
; CHECK-GI-NEXT:    saddl v2.2d, v1.2s, v3.2s
; CHECK-GI-NEXT:    saddl2 v3.2d, v1.4s, v3.4s
; CHECK-GI-NEXT:    mov v0.16b, v4.16b
; CHECK-GI-NEXT:    mov v1.16b, v5.16b
; CHECK-GI-NEXT:    ret
entry:
  %s0s = sext <8 x i32> %s0 to <8 x i64>
  %s1s = sext <8 x i32> %s1 to <8 x i64>
  %m = add <8 x i64> %s0s, %s1s
  ret <8 x i64> %m
}

define <8 x i64> @extaddu_v8i32_i64(<8 x i32> %s0, <8 x i32> %s1) {
; CHECK-SD-LABEL: extaddu_v8i32_i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    uaddl2 v4.2d, v1.4s, v3.4s
; CHECK-SD-NEXT:    uaddl v5.2d, v0.2s, v2.2s
; CHECK-SD-NEXT:    uaddl2 v6.2d, v0.4s, v2.4s
; CHECK-SD-NEXT:    uaddl v2.2d, v1.2s, v3.2s
; CHECK-SD-NEXT:    mov v0.16b, v5.16b
; CHECK-SD-NEXT:    mov v1.16b, v6.16b
; CHECK-SD-NEXT:    mov v3.16b, v4.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: extaddu_v8i32_i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    uaddl v4.2d, v0.2s, v2.2s
; CHECK-GI-NEXT:    uaddl2 v5.2d, v0.4s, v2.4s
; CHECK-GI-NEXT:    uaddl v2.2d, v1.2s, v3.2s
; CHECK-GI-NEXT:    uaddl2 v3.2d, v1.4s, v3.4s
; CHECK-GI-NEXT:    mov v0.16b, v4.16b
; CHECK-GI-NEXT:    mov v1.16b, v5.16b
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <8 x i32> %s0 to <8 x i64>
  %s1s = zext <8 x i32> %s1 to <8 x i64>
  %m = add <8 x i64> %s0s, %s1s
  ret <8 x i64> %m
}

define <16 x i32> @add_zs(<16 x i8> %s0, <16 x i8> %s1) {
; CHECK-SD-LABEL: add_zs:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll v2.8h, v0.8b, #0
; CHECK-SD-NEXT:    ushll2 v0.8h, v0.16b, #0
; CHECK-SD-NEXT:    saddw v2.8h, v2.8h, v1.8b
; CHECK-SD-NEXT:    saddw2 v4.8h, v0.8h, v1.16b
; CHECK-SD-NEXT:    sshll v0.4s, v2.4h, #0
; CHECK-SD-NEXT:    sshll2 v3.4s, v4.8h, #0
; CHECK-SD-NEXT:    sshll2 v1.4s, v2.8h, #0
; CHECK-SD-NEXT:    sshll v2.4s, v4.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: add_zs:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v2.8h, v1.8b, #0
; CHECK-GI-NEXT:    sshll2 v1.8h, v1.16b, #0
; CHECK-GI-NEXT:    ushll v3.8h, v0.8b, #0
; CHECK-GI-NEXT:    ushll2 v4.8h, v0.16b, #0
; CHECK-GI-NEXT:    sshll v0.4s, v2.4h, #0
; CHECK-GI-NEXT:    sshll2 v2.4s, v2.8h, #0
; CHECK-GI-NEXT:    sshll v5.4s, v1.4h, #0
; CHECK-GI-NEXT:    sshll2 v6.4s, v1.8h, #0
; CHECK-GI-NEXT:    uaddw v0.4s, v0.4s, v3.4h
; CHECK-GI-NEXT:    uaddw2 v1.4s, v2.4s, v3.8h
; CHECK-GI-NEXT:    uaddw v2.4s, v5.4s, v4.4h
; CHECK-GI-NEXT:    uaddw2 v3.4s, v6.4s, v4.8h
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <16 x i8> %s0 to <16 x i32>
  %s1s = sext <16 x i8> %s1 to <16 x i32>
  %m = add <16 x i32> %s0s, %s1s
  ret <16 x i32> %m
}

define <20 x i32> @v20(<20 x i8> %s0, <20 x i8> %s1) {
; CHECK-SD-LABEL: v20:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    fmov s0, w0
; CHECK-SD-NEXT:    ldr b2, [sp, #160]
; CHECK-SD-NEXT:    add x10, sp, #168
; CHECK-SD-NEXT:    ldr b3, [sp]
; CHECK-SD-NEXT:    add x11, sp, #8
; CHECK-SD-NEXT:    ldr b1, [sp, #96]
; CHECK-SD-NEXT:    ld1 { v2.b }[1], [x10]
; CHECK-SD-NEXT:    add x9, sp, #104
; CHECK-SD-NEXT:    add x10, sp, #176
; CHECK-SD-NEXT:    mov v0.b[1], w1
; CHECK-SD-NEXT:    ld1 { v3.b }[1], [x11]
; CHECK-SD-NEXT:    ld1 { v1.b }[1], [x9]
; CHECK-SD-NEXT:    add x11, sp, #16
; CHECK-SD-NEXT:    add x9, sp, #112
; CHECK-SD-NEXT:    add x13, sp, #184
; CHECK-SD-NEXT:    ld1 { v2.b }[2], [x10]
; CHECK-SD-NEXT:    add x12, sp, #120
; CHECK-SD-NEXT:    add x14, sp, #32
; CHECK-SD-NEXT:    ld1 { v3.b }[2], [x11]
; CHECK-SD-NEXT:    ld1 { v1.b }[2], [x9]
; CHECK-SD-NEXT:    ldr b5, [sp, #64]
; CHECK-SD-NEXT:    mov v0.b[2], w2
; CHECK-SD-NEXT:    ldr b4, [sp, #224]
; CHECK-SD-NEXT:    add x11, sp, #128
; CHECK-SD-NEXT:    ld1 { v2.b }[3], [x13]
; CHECK-SD-NEXT:    add x13, sp, #24
; CHECK-SD-NEXT:    add x10, sp, #136
; CHECK-SD-NEXT:    ld1 { v3.b }[3], [x13]
; CHECK-SD-NEXT:    ld1 { v1.b }[3], [x12]
; CHECK-SD-NEXT:    add x12, sp, #192
; CHECK-SD-NEXT:    add x13, sp, #200
; CHECK-SD-NEXT:    add x15, sp, #80
; CHECK-SD-NEXT:    add x9, sp, #144
; CHECK-SD-NEXT:    mov v0.b[3], w3
; CHECK-SD-NEXT:    ld1 { v2.b }[4], [x12]
; CHECK-SD-NEXT:    add x12, sp, #232
; CHECK-SD-NEXT:    ld1 { v3.b }[4], [x14]
; CHECK-SD-NEXT:    add x14, sp, #72
; CHECK-SD-NEXT:    ld1 { v4.b }[1], [x12]
; CHECK-SD-NEXT:    ld1 { v5.b }[1], [x14]
; CHECK-SD-NEXT:    add x14, sp, #40
; CHECK-SD-NEXT:    ld1 { v1.b }[4], [x11]
; CHECK-SD-NEXT:    ld1 { v2.b }[5], [x13]
; CHECK-SD-NEXT:    add x12, sp, #208
; CHECK-SD-NEXT:    add x13, sp, #48
; CHECK-SD-NEXT:    mov v0.b[4], w4
; CHECK-SD-NEXT:    ld1 { v3.b }[5], [x14]
; CHECK-SD-NEXT:    add x14, sp, #240
; CHECK-SD-NEXT:    ld1 { v4.b }[2], [x14]
; CHECK-SD-NEXT:    ld1 { v5.b }[2], [x15]
; CHECK-SD-NEXT:    ld1 { v1.b }[5], [x10]
; CHECK-SD-NEXT:    ld1 { v2.b }[6], [x12]
; CHECK-SD-NEXT:    add x11, sp, #216
; CHECK-SD-NEXT:    add x10, sp, #56
; CHECK-SD-NEXT:    ld1 { v3.b }[6], [x13]
; CHECK-SD-NEXT:    add x12, sp, #248
; CHECK-SD-NEXT:    add x13, sp, #88
; CHECK-SD-NEXT:    mov v0.b[5], w5
; CHECK-SD-NEXT:    ld1 { v4.b }[3], [x12]
; CHECK-SD-NEXT:    ld1 { v5.b }[3], [x13]
; CHECK-SD-NEXT:    ld1 { v1.b }[6], [x9]
; CHECK-SD-NEXT:    ld1 { v2.b }[7], [x11]
; CHECK-SD-NEXT:    add x9, sp, #152
; CHECK-SD-NEXT:    ld1 { v3.b }[7], [x10]
; CHECK-SD-NEXT:    uaddl v4.8h, v5.8b, v4.8b
; CHECK-SD-NEXT:    mov v0.b[6], w6
; CHECK-SD-NEXT:    ld1 { v1.b }[7], [x9]
; CHECK-SD-NEXT:    uaddl v2.8h, v3.8b, v2.8b
; CHECK-SD-NEXT:    ushll v3.4s, v4.4h, #0
; CHECK-SD-NEXT:    mov v0.b[7], w7
; CHECK-SD-NEXT:    uaddl v0.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    ushll2 v1.4s, v2.8h, #0
; CHECK-SD-NEXT:    ushll v2.4s, v2.4h, #0
; CHECK-SD-NEXT:    stp q1, q3, [x8, #48]
; CHECK-SD-NEXT:    ushll2 v3.4s, v0.8h, #0
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    stp q3, q2, [x8, #16]
; CHECK-SD-NEXT:    str q0, [x8]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: v20:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    and w9, w0, #0xff
; CHECK-GI-NEXT:    ldrb w10, [sp, #96]
; CHECK-GI-NEXT:    and w11, w1, #0xff
; CHECK-GI-NEXT:    fmov s0, w9
; CHECK-GI-NEXT:    ldrb w9, [sp]
; CHECK-GI-NEXT:    ldrb w12, [sp, #104]
; CHECK-GI-NEXT:    fmov s2, w10
; CHECK-GI-NEXT:    ldrb w10, [sp, #160]
; CHECK-GI-NEXT:    fmov s1, w9
; CHECK-GI-NEXT:    ldrb w9, [sp, #168]
; CHECK-GI-NEXT:    mov v0.h[1], w11
; CHECK-GI-NEXT:    ldrb w11, [sp, #8]
; CHECK-GI-NEXT:    fmov s3, w10
; CHECK-GI-NEXT:    mov v2.h[1], w12
; CHECK-GI-NEXT:    and w10, w2, #0xff
; CHECK-GI-NEXT:    and w12, w5, #0xff
; CHECK-GI-NEXT:    mov v1.h[1], w11
; CHECK-GI-NEXT:    and w11, w4, #0xff
; CHECK-GI-NEXT:    mov v3.h[1], w9
; CHECK-GI-NEXT:    ldrb w9, [sp, #112]
; CHECK-GI-NEXT:    mov v0.h[2], w10
; CHECK-GI-NEXT:    ldrb w10, [sp, #16]
; CHECK-GI-NEXT:    mov v2.h[2], w9
; CHECK-GI-NEXT:    ldrb w9, [sp, #176]
; CHECK-GI-NEXT:    mov v1.h[2], w10
; CHECK-GI-NEXT:    and w10, w3, #0xff
; CHECK-GI-NEXT:    mov v3.h[2], w9
; CHECK-GI-NEXT:    ldrb w9, [sp, #120]
; CHECK-GI-NEXT:    mov v0.h[3], w10
; CHECK-GI-NEXT:    ldrb w10, [sp, #24]
; CHECK-GI-NEXT:    mov v2.h[3], w9
; CHECK-GI-NEXT:    ldrb w9, [sp, #184]
; CHECK-GI-NEXT:    mov v1.h[3], w10
; CHECK-GI-NEXT:    ldr w10, [sp, #64]
; CHECK-GI-NEXT:    mov v3.h[3], w9
; CHECK-GI-NEXT:    ldrb w9, [sp, #128]
; CHECK-GI-NEXT:    mov v0.h[4], w11
; CHECK-GI-NEXT:    ldrb w11, [sp, #32]
; CHECK-GI-NEXT:    fmov s4, w10
; CHECK-GI-NEXT:    ldrb w10, [sp, #192]
; CHECK-GI-NEXT:    mov v2.h[4], w9
; CHECK-GI-NEXT:    ldr w9, [sp, #72]
; CHECK-GI-NEXT:    mov v1.h[4], w11
; CHECK-GI-NEXT:    ldr w11, [sp, #224]
; CHECK-GI-NEXT:    mov v3.h[4], w10
; CHECK-GI-NEXT:    ldrb w10, [sp, #136]
; CHECK-GI-NEXT:    mov v4.b[1], w9
; CHECK-GI-NEXT:    fmov s5, w11
; CHECK-GI-NEXT:    ldr w11, [sp, #232]
; CHECK-GI-NEXT:    mov v0.h[5], w12
; CHECK-GI-NEXT:    ldrb w12, [sp, #40]
; CHECK-GI-NEXT:    mov v2.h[5], w10
; CHECK-GI-NEXT:    ldrb w10, [sp, #200]
; CHECK-GI-NEXT:    ldrb w9, [sp, #144]
; CHECK-GI-NEXT:    mov v5.b[1], w11
; CHECK-GI-NEXT:    mov v1.h[5], w12
; CHECK-GI-NEXT:    mov v3.h[5], w10
; CHECK-GI-NEXT:    ldr w10, [sp, #80]
; CHECK-GI-NEXT:    ldr w12, [sp, #240]
; CHECK-GI-NEXT:    and w11, w6, #0xff
; CHECK-GI-NEXT:    mov v0.h[6], w11
; CHECK-GI-NEXT:    ldrb w11, [sp, #48]
; CHECK-GI-NEXT:    mov v2.h[6], w9
; CHECK-GI-NEXT:    ldrb w9, [sp, #208]
; CHECK-GI-NEXT:    mov v4.b[2], w10
; CHECK-GI-NEXT:    ldrb w10, [sp, #152]
; CHECK-GI-NEXT:    mov v5.b[2], w12
; CHECK-GI-NEXT:    mov v1.h[6], w11
; CHECK-GI-NEXT:    ldr w11, [sp, #248]
; CHECK-GI-NEXT:    mov v3.h[6], w9
; CHECK-GI-NEXT:    ldr w9, [sp, #88]
; CHECK-GI-NEXT:    and w12, w7, #0xff
; CHECK-GI-NEXT:    mov v0.h[7], w12
; CHECK-GI-NEXT:    mov v2.h[7], w10
; CHECK-GI-NEXT:    ldrb w12, [sp, #56]
; CHECK-GI-NEXT:    mov v4.b[3], w9
; CHECK-GI-NEXT:    ldrb w10, [sp, #216]
; CHECK-GI-NEXT:    mov v5.b[3], w11
; CHECK-GI-NEXT:    mov v1.h[7], w12
; CHECK-GI-NEXT:    mov v3.h[7], w10
; CHECK-GI-NEXT:    add v0.8h, v0.8h, v2.8h
; CHECK-GI-NEXT:    ushll v2.8h, v4.8b, #0
; CHECK-GI-NEXT:    ushll v4.8h, v5.8b, #0
; CHECK-GI-NEXT:    add v1.8h, v1.8h, v3.8h
; CHECK-GI-NEXT:    ushll v3.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-GI-NEXT:    add v2.4h, v2.4h, v4.4h
; CHECK-GI-NEXT:    ushll v4.4s, v1.4h, #0
; CHECK-GI-NEXT:    ushll2 v1.4s, v1.8h, #0
; CHECK-GI-NEXT:    stp q3, q0, [x8]
; CHECK-GI-NEXT:    ushll v2.4s, v2.4h, #0
; CHECK-GI-NEXT:    stp q4, q1, [x8, #32]
; CHECK-GI-NEXT:    str q2, [x8, #64]
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <20 x i8> %s0 to <20 x i32>
  %s1s = zext <20 x i8> %s1 to <20 x i32>
  %m = add <20 x i32> %s0s, %s1s
  ret <20 x i32> %m
}

define <16 x i32> @i12(<16 x i12> %s0, <16 x i12> %s1) {
; CHECK-SD-LABEL: i12:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    str x23, [sp, #-48]! // 8-byte Folded Spill
; CHECK-SD-NEXT:    stp x22, x21, [sp, #16] // 16-byte Folded Spill
; CHECK-SD-NEXT:    stp x20, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 48
; CHECK-SD-NEXT:    .cfi_offset w19, -8
; CHECK-SD-NEXT:    .cfi_offset w20, -16
; CHECK-SD-NEXT:    .cfi_offset w21, -24
; CHECK-SD-NEXT:    .cfi_offset w22, -32
; CHECK-SD-NEXT:    .cfi_offset w23, -48
; CHECK-SD-NEXT:    ldr w13, [sp, #112]
; CHECK-SD-NEXT:    ldr w14, [sp, #144]
; CHECK-SD-NEXT:    fmov s2, w4
; CHECK-SD-NEXT:    ldr w17, [sp, #176]
; CHECK-SD-NEXT:    ldr w19, [sp, #208]
; CHECK-SD-NEXT:    fmov s3, w0
; CHECK-SD-NEXT:    ldr w20, [sp, #80]
; CHECK-SD-NEXT:    ldr w21, [sp, #48]
; CHECK-SD-NEXT:    fmov s5, w13
; CHECK-SD-NEXT:    fmov s4, w19
; CHECK-SD-NEXT:    fmov s6, w17
; CHECK-SD-NEXT:    fmov s7, w14
; CHECK-SD-NEXT:    fmov s0, w20
; CHECK-SD-NEXT:    fmov s1, w21
; CHECK-SD-NEXT:    ldr w10, [sp, #120]
; CHECK-SD-NEXT:    ldr w11, [sp, #152]
; CHECK-SD-NEXT:    ldr w12, [sp, #184]
; CHECK-SD-NEXT:    ldr w15, [sp, #216]
; CHECK-SD-NEXT:    ldr w22, [sp, #88]
; CHECK-SD-NEXT:    ldr w23, [sp, #56]
; CHECK-SD-NEXT:    mov v2.h[1], w5
; CHECK-SD-NEXT:    mov v3.h[1], w1
; CHECK-SD-NEXT:    mov v5.h[1], w10
; CHECK-SD-NEXT:    mov v4.h[1], w15
; CHECK-SD-NEXT:    mov v0.h[1], w22
; CHECK-SD-NEXT:    mov v1.h[1], w23
; CHECK-SD-NEXT:    mov v6.h[1], w12
; CHECK-SD-NEXT:    mov v7.h[1], w11
; CHECK-SD-NEXT:    ldr w8, [sp, #128]
; CHECK-SD-NEXT:    ldr w9, [sp, #160]
; CHECK-SD-NEXT:    ldr w16, [sp, #64]
; CHECK-SD-NEXT:    ldr w18, [sp, #96]
; CHECK-SD-NEXT:    ldr w10, [sp, #192]
; CHECK-SD-NEXT:    ldr w11, [sp, #224]
; CHECK-SD-NEXT:    mov v2.h[2], w6
; CHECK-SD-NEXT:    mov v3.h[2], w2
; CHECK-SD-NEXT:    mov v0.h[2], w18
; CHECK-SD-NEXT:    mov v1.h[2], w16
; CHECK-SD-NEXT:    mov v5.h[2], w8
; CHECK-SD-NEXT:    mov v4.h[2], w11
; CHECK-SD-NEXT:    mov v6.h[2], w10
; CHECK-SD-NEXT:    mov v7.h[2], w9
; CHECK-SD-NEXT:    ldr w12, [sp, #72]
; CHECK-SD-NEXT:    ldr w13, [sp, #104]
; CHECK-SD-NEXT:    ldr w8, [sp, #136]
; CHECK-SD-NEXT:    ldr w9, [sp, #168]
; CHECK-SD-NEXT:    ldr w10, [sp, #200]
; CHECK-SD-NEXT:    ldr w11, [sp, #232]
; CHECK-SD-NEXT:    mov v0.h[3], w13
; CHECK-SD-NEXT:    mov v1.h[3], w12
; CHECK-SD-NEXT:    mov v2.h[3], w7
; CHECK-SD-NEXT:    mov v3.h[3], w3
; CHECK-SD-NEXT:    mov v5.h[3], w8
; CHECK-SD-NEXT:    mov v4.h[3], w11
; CHECK-SD-NEXT:    mov v6.h[3], w10
; CHECK-SD-NEXT:    mov v7.h[3], w9
; CHECK-SD-NEXT:    movi v16.4s, #15, msl #8
; CHECK-SD-NEXT:    ldp x20, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ushll v1.4s, v1.4h, #0
; CHECK-SD-NEXT:    ushll v2.4s, v2.4h, #0
; CHECK-SD-NEXT:    ushll v3.4s, v3.4h, #0
; CHECK-SD-NEXT:    ushll v5.4s, v5.4h, #0
; CHECK-SD-NEXT:    ushll v4.4s, v4.4h, #0
; CHECK-SD-NEXT:    ushll v6.4s, v6.4h, #0
; CHECK-SD-NEXT:    ushll v7.4s, v7.4h, #0
; CHECK-SD-NEXT:    and v17.16b, v0.16b, v16.16b
; CHECK-SD-NEXT:    and v18.16b, v1.16b, v16.16b
; CHECK-SD-NEXT:    and v1.16b, v2.16b, v16.16b
; CHECK-SD-NEXT:    and v0.16b, v3.16b, v16.16b
; CHECK-SD-NEXT:    and v2.16b, v5.16b, v16.16b
; CHECK-SD-NEXT:    and v3.16b, v4.16b, v16.16b
; CHECK-SD-NEXT:    and v4.16b, v6.16b, v16.16b
; CHECK-SD-NEXT:    and v5.16b, v7.16b, v16.16b
; CHECK-SD-NEXT:    ldp x22, x21, [sp, #16] // 16-byte Folded Reload
; CHECK-SD-NEXT:    add v0.4s, v0.4s, v2.4s
; CHECK-SD-NEXT:    add v3.4s, v17.4s, v3.4s
; CHECK-SD-NEXT:    add v1.4s, v1.4s, v5.4s
; CHECK-SD-NEXT:    add v2.4s, v18.4s, v4.4s
; CHECK-SD-NEXT:    ldr x23, [sp], #48 // 8-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: i12:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldr w12, [sp]
; CHECK-GI-NEXT:    ldr w14, [sp, #32]
; CHECK-GI-NEXT:    fmov s0, w0
; CHECK-GI-NEXT:    ldr w16, [sp, #128]
; CHECK-GI-NEXT:    ldr w17, [sp, #160]
; CHECK-GI-NEXT:    fmov s1, w4
; CHECK-GI-NEXT:    fmov s2, w12
; CHECK-GI-NEXT:    fmov s3, w14
; CHECK-GI-NEXT:    ldr w12, [sp, #64]
; CHECK-GI-NEXT:    ldr w14, [sp, #96]
; CHECK-GI-NEXT:    ldr w13, [sp, #8]
; CHECK-GI-NEXT:    ldr w15, [sp, #40]
; CHECK-GI-NEXT:    fmov s4, w12
; CHECK-GI-NEXT:    fmov s6, w16
; CHECK-GI-NEXT:    fmov s7, w17
; CHECK-GI-NEXT:    fmov s5, w14
; CHECK-GI-NEXT:    mov v2.h[1], w13
; CHECK-GI-NEXT:    mov v3.h[1], w15
; CHECK-GI-NEXT:    ldr w13, [sp, #72]
; CHECK-GI-NEXT:    ldr w15, [sp, #104]
; CHECK-GI-NEXT:    ldr w12, [sp, #136]
; CHECK-GI-NEXT:    ldr w18, [sp, #168]
; CHECK-GI-NEXT:    mov v0.h[1], w1
; CHECK-GI-NEXT:    mov v1.h[1], w5
; CHECK-GI-NEXT:    mov v4.h[1], w13
; CHECK-GI-NEXT:    mov v5.h[1], w15
; CHECK-GI-NEXT:    mov v6.h[1], w12
; CHECK-GI-NEXT:    mov v7.h[1], w18
; CHECK-GI-NEXT:    ldr w10, [sp, #16]
; CHECK-GI-NEXT:    ldr w11, [sp, #48]
; CHECK-GI-NEXT:    ldr w12, [sp, #80]
; CHECK-GI-NEXT:    ldr w13, [sp, #112]
; CHECK-GI-NEXT:    ldr w14, [sp, #144]
; CHECK-GI-NEXT:    ldr w15, [sp, #176]
; CHECK-GI-NEXT:    mov v0.h[2], w2
; CHECK-GI-NEXT:    mov v1.h[2], w6
; CHECK-GI-NEXT:    mov v2.h[2], w10
; CHECK-GI-NEXT:    mov v3.h[2], w11
; CHECK-GI-NEXT:    mov v4.h[2], w12
; CHECK-GI-NEXT:    mov v5.h[2], w13
; CHECK-GI-NEXT:    mov v6.h[2], w14
; CHECK-GI-NEXT:    mov v7.h[2], w15
; CHECK-GI-NEXT:    ldr w8, [sp, #24]
; CHECK-GI-NEXT:    ldr w9, [sp, #56]
; CHECK-GI-NEXT:    ldr w10, [sp, #88]
; CHECK-GI-NEXT:    ldr w11, [sp, #120]
; CHECK-GI-NEXT:    ldr w12, [sp, #152]
; CHECK-GI-NEXT:    ldr w13, [sp, #184]
; CHECK-GI-NEXT:    mov v0.h[3], w3
; CHECK-GI-NEXT:    mov v1.h[3], w7
; CHECK-GI-NEXT:    mov v2.h[3], w8
; CHECK-GI-NEXT:    mov v3.h[3], w9
; CHECK-GI-NEXT:    mov v4.h[3], w10
; CHECK-GI-NEXT:    mov v5.h[3], w11
; CHECK-GI-NEXT:    mov v6.h[3], w12
; CHECK-GI-NEXT:    mov v7.h[3], w13
; CHECK-GI-NEXT:    movi v16.4s, #15, msl #8
; CHECK-GI-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll v1.4s, v1.4h, #0
; CHECK-GI-NEXT:    ushll v2.4s, v2.4h, #0
; CHECK-GI-NEXT:    ushll v3.4s, v3.4h, #0
; CHECK-GI-NEXT:    ushll v4.4s, v4.4h, #0
; CHECK-GI-NEXT:    ushll v5.4s, v5.4h, #0
; CHECK-GI-NEXT:    ushll v6.4s, v6.4h, #0
; CHECK-GI-NEXT:    ushll v7.4s, v7.4h, #0
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v16.16b
; CHECK-GI-NEXT:    and v1.16b, v1.16b, v16.16b
; CHECK-GI-NEXT:    and v2.16b, v2.16b, v16.16b
; CHECK-GI-NEXT:    and v3.16b, v3.16b, v16.16b
; CHECK-GI-NEXT:    and v4.16b, v4.16b, v16.16b
; CHECK-GI-NEXT:    and v5.16b, v5.16b, v16.16b
; CHECK-GI-NEXT:    and v6.16b, v6.16b, v16.16b
; CHECK-GI-NEXT:    and v7.16b, v7.16b, v16.16b
; CHECK-GI-NEXT:    add v0.4s, v0.4s, v4.4s
; CHECK-GI-NEXT:    add v1.4s, v1.4s, v5.4s
; CHECK-GI-NEXT:    add v2.4s, v2.4s, v6.4s
; CHECK-GI-NEXT:    add v3.4s, v3.4s, v7.4s
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <16 x i12> %s0 to <16 x i32>
  %s1s = zext <16 x i12> %s1 to <16 x i32>
  %m = add <16 x i32> %s0s, %s1s
  ret <16 x i32> %m
}

define <16 x i32> @sub_zz(<16 x i8> %s0, <16 x i8> %s1) {
; CHECK-SD-LABEL: sub_zz:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    usubl v2.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    usubl2 v4.8h, v0.16b, v1.16b
; CHECK-SD-NEXT:    sshll v0.4s, v2.4h, #0
; CHECK-SD-NEXT:    sshll2 v3.4s, v4.8h, #0
; CHECK-SD-NEXT:    sshll2 v1.4s, v2.8h, #0
; CHECK-SD-NEXT:    sshll v2.4s, v4.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sub_zz:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    usubl v2.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    usubl2 v3.8h, v0.16b, v1.16b
; CHECK-GI-NEXT:    sshll v0.4s, v2.4h, #0
; CHECK-GI-NEXT:    sshll2 v1.4s, v2.8h, #0
; CHECK-GI-NEXT:    sshll v2.4s, v3.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v3.8h, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <16 x i8> %s0 to <16 x i32>
  %s1s = zext <16 x i8> %s1 to <16 x i32>
  %m = sub <16 x i32> %s0s, %s1s
  ret <16 x i32> %m
}

define <16 x i32> @sub_ss(<16 x i8> %s0, <16 x i8> %s1) {
; CHECK-SD-LABEL: sub_ss:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ssubl v2.8h, v0.8b, v1.8b
; CHECK-SD-NEXT:    ssubl2 v4.8h, v0.16b, v1.16b
; CHECK-SD-NEXT:    sshll v0.4s, v2.4h, #0
; CHECK-SD-NEXT:    sshll2 v3.4s, v4.8h, #0
; CHECK-SD-NEXT:    sshll2 v1.4s, v2.8h, #0
; CHECK-SD-NEXT:    sshll v2.4s, v4.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sub_ss:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ssubl v2.8h, v0.8b, v1.8b
; CHECK-GI-NEXT:    ssubl2 v3.8h, v0.16b, v1.16b
; CHECK-GI-NEXT:    sshll v0.4s, v2.4h, #0
; CHECK-GI-NEXT:    sshll2 v1.4s, v2.8h, #0
; CHECK-GI-NEXT:    sshll v2.4s, v3.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v3.8h, #0
; CHECK-GI-NEXT:    ret
entry:
  %s0s = sext <16 x i8> %s0 to <16 x i32>
  %s1s = sext <16 x i8> %s1 to <16 x i32>
  %m = sub <16 x i32> %s0s, %s1s
  ret <16 x i32> %m
}

define <16 x i32> @sub_zs(<16 x i8> %s0, <16 x i8> %s1) {
; CHECK-SD-LABEL: sub_zs:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll v2.8h, v0.8b, #0
; CHECK-SD-NEXT:    ushll2 v0.8h, v0.16b, #0
; CHECK-SD-NEXT:    ssubw v2.8h, v2.8h, v1.8b
; CHECK-SD-NEXT:    ssubw2 v4.8h, v0.8h, v1.16b
; CHECK-SD-NEXT:    sshll v0.4s, v2.4h, #0
; CHECK-SD-NEXT:    sshll2 v3.4s, v4.8h, #0
; CHECK-SD-NEXT:    sshll2 v1.4s, v2.8h, #0
; CHECK-SD-NEXT:    sshll v2.4s, v4.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sub_zs:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v2.8h, v0.8b, #0
; CHECK-GI-NEXT:    ushll2 v0.8h, v0.16b, #0
; CHECK-GI-NEXT:    sshll v3.8h, v1.8b, #0
; CHECK-GI-NEXT:    sshll2 v4.8h, v1.16b, #0
; CHECK-GI-NEXT:    ushll v1.4s, v2.4h, #0
; CHECK-GI-NEXT:    ushll2 v2.4s, v2.8h, #0
; CHECK-GI-NEXT:    ushll v5.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v6.4s, v0.8h, #0
; CHECK-GI-NEXT:    ssubw v0.4s, v1.4s, v3.4h
; CHECK-GI-NEXT:    ssubw2 v1.4s, v2.4s, v3.8h
; CHECK-GI-NEXT:    ssubw v2.4s, v5.4s, v4.4h
; CHECK-GI-NEXT:    ssubw2 v3.4s, v6.4s, v4.8h
; CHECK-GI-NEXT:    ret
entry:
  %s0s = zext <16 x i8> %s0 to <16 x i32>
  %s1s = sext <16 x i8> %s1 to <16 x i32>
  %m = sub <16 x i32> %s0s, %s1s
  ret <16 x i32> %m
}
