; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve.fp,+fp64 -mve-max-interleave-factor=4 -verify-machineinstrs %s -o - | FileCheck %s

; i32

define void @vst4_v2i32(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v2i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, lr}
; CHECK-NEXT:    push {r4, r5, r6, lr}
; CHECK-NEXT:    add.w r6, r0, #16
; CHECK-NEXT:    ldrd lr, r12, [r0]
; CHECK-NEXT:    ldrd r3, r2, [r0, #8]
; CHECK-NEXT:    ldm r6, {r4, r5, r6}
; CHECK-NEXT:    vmov q1[2], q1[0], lr, r3
; CHECK-NEXT:    ldr r0, [r0, #28]
; CHECK-NEXT:    vmov q1[3], q1[1], r12, r2
; CHECK-NEXT:    vmov q0[2], q0[0], r4, r6
; CHECK-NEXT:    vmov.f32 s8, s4
; CHECK-NEXT:    vmov q0[3], q0[1], r5, r0
; CHECK-NEXT:    vmov.f32 s9, s6
; CHECK-NEXT:    vmov.f32 s4, s5
; CHECK-NEXT:    vmov.f32 s5, s7
; CHECK-NEXT:    vmov.f32 s10, s0
; CHECK-NEXT:    vmov.f32 s11, s2
; CHECK-NEXT:    vmov.f32 s6, s1
; CHECK-NEXT:    vstrw.32 q2, [r1]
; CHECK-NEXT:    vmov.f32 s7, s3
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    pop {r4, r5, r6, pc}
entry:
  %l1 = load <2 x i32>, ptr %src, align 4
  %s2 = getelementptr <2 x i32>, ptr %src, i32 1
  %l2 = load <2 x i32>, ptr %s2, align 4
  %s3 = getelementptr <2 x i32>, ptr %src, i32 2
  %l3 = load <2 x i32>, ptr %s3, align 4
  %s4 = getelementptr <2 x i32>, ptr %src, i32 3
  %l4 = load <2 x i32>, ptr %s4, align 4
  %t1 = shufflevector <2 x i32> %l1, <2 x i32> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x i32> %l3, <2 x i32> %l4, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %s = shufflevector <4 x i32> %t1, <4 x i32> %t2, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  store <8 x i32> %s, ptr %dst, align 4
  ret void
}

define void @vst4_v4i32(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q3, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vst40.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst41.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst42.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst43.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <4 x i32>, ptr %src, align 4
  %s2 = getelementptr <4 x i32>, ptr %src, i32 1
  %l2 = load <4 x i32>, ptr %s2, align 4
  %s3 = getelementptr <4 x i32>, ptr %src, i32 2
  %l3 = load <4 x i32>, ptr %s3, align 4
  %s4 = getelementptr <4 x i32>, ptr %src, i32 3
  %l4 = load <4 x i32>, ptr %s4, align 4
  %t1 = shufflevector <4 x i32> %l1, <4 x i32> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x i32> %l3, <4 x i32> %l4, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %s = shufflevector <8 x i32> %t1, <8 x i32> %t2, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  store <16 x i32> %s, ptr %dst, align 4
  ret void
}

define void @vst4_v8i32(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v8i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vldrw.u32 q7, [r0, #96]
; CHECK-NEXT:    vldrw.u32 q6, [r0, #64]
; CHECK-NEXT:    vldrw.u32 q5, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q4, [r0]
; CHECK-NEXT:    vldrw.u32 q3, [r0, #112]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #80]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    vst40.32 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    vst41.32 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    vst42.32 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    vst43.32 {q4, q5, q6, q7}, [r1]!
; CHECK-NEXT:    vst40.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst41.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst42.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst43.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x i32>, ptr %src, align 4
  %s2 = getelementptr <8 x i32>, ptr %src, i32 1
  %l2 = load <8 x i32>, ptr %s2, align 4
  %s3 = getelementptr <8 x i32>, ptr %src, i32 2
  %l3 = load <8 x i32>, ptr %s3, align 4
  %s4 = getelementptr <8 x i32>, ptr %src, i32 3
  %l4 = load <8 x i32>, ptr %s4, align 4
  %t1 = shufflevector <8 x i32> %l1, <8 x i32> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x i32> %l3, <8 x i32> %l4, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %s = shufflevector <16 x i32> %t1, <16 x i32> %t2, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
  store <32 x i32> %s, ptr %dst, align 4
  ret void
}

define void @vst4_v16i32(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v16i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5}
; CHECK-NEXT:    push {r4, r5}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #192
; CHECK-NEXT:    sub sp, #192
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    add r2, sp, #64
; CHECK-NEXT:    vldrw.u32 q4, [r0, #176]
; CHECK-NEXT:    vldrw.u32 q3, [r0, #208]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #144]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #80]
; CHECK-NEXT:    vstmia r2, {d0, d1, d2, d3, d4, d5, d6, d7} @ 64-byte Spill
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #128]
; CHECK-NEXT:    vldrw.u32 q5, [r0, #240]
; CHECK-NEXT:    vmov q6, q4
; CHECK-NEXT:    vldrw.u32 q3, [r0, #192]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #64]
; CHECK-NEXT:    vstmia sp, {d0, d1, d2, d3, d4, d5, d6, d7} @ 64-byte Spill
; CHECK-NEXT:    vldrw.u32 q2, [r0, #160]
; CHECK-NEXT:    vldrw.u32 q4, [r0, #48]
; CHECK-NEXT:    add r2, sp, #128
; CHECK-NEXT:    vmov q7, q5
; CHECK-NEXT:    vldrw.u32 q3, [r0, #224]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #96]
; CHECK-NEXT:    vldrw.u32 q5, [r0, #112]
; CHECK-NEXT:    vstmia r2, {d8, d9, d10, d11, d12, d13, d14, d15} @ 64-byte Spill
; CHECK-NEXT:    vmov q6, q2
; CHECK-NEXT:    vmov q5, q1
; CHECK-NEXT:    vmov q7, q3
; CHECK-NEXT:    vldmia sp, {d0, d1, d2, d3, d4, d5, d6, d7} @ 64-byte Reload
; CHECK-NEXT:    add r2, sp, #64
; CHECK-NEXT:    vldrw.u32 q4, [r0, #32]
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    vst40.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst41.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst42.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst43.32 {q0, q1, q2, q3}, [r0]!
; CHECK-NEXT:    vldmia r2, {d0, d1, d2, d3, d4, d5, d6, d7} @ 64-byte Reload
; CHECK-NEXT:    vst40.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vst41.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vst42.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vst43.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    add.w r0, r1, #192
; CHECK-NEXT:    adds r1, #128
; CHECK-NEXT:    vst40.32 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    vst41.32 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    vst42.32 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    vst43.32 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    add r1, sp, #128
; CHECK-NEXT:    vldmia r1, {d0, d1, d2, d3, d4, d5, d6, d7} @ 64-byte Reload
; CHECK-NEXT:    vst40.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vst41.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vst42.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vst43.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    add sp, #192
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    pop {r4, r5}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x i32>, ptr %src, align 4
  %s2 = getelementptr <16 x i32>, ptr %src, i32 1
  %l2 = load <16 x i32>, ptr %s2, align 4
  %s3 = getelementptr <16 x i32>, ptr %src, i32 2
  %l3 = load <16 x i32>, ptr %s3, align 4
  %s4 = getelementptr <16 x i32>, ptr %src, i32 3
  %l4 = load <16 x i32>, ptr %s4, align 4
  %t1 = shufflevector <16 x i32> %l1, <16 x i32> %l2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %t2 = shufflevector <16 x i32> %l3, <16 x i32> %l4, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %s = shufflevector <32 x i32> %t1, <32 x i32> %t2, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
  store <64 x i32> %s, ptr %dst, align 4
  ret void
}

define void @vst4_v4i32_align1(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v4i32_align1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vldrw.u32 q1, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q4, [r0]
; CHECK-NEXT:    vmov.f32 s14, s1
; CHECK-NEXT:    vmov.f32 s22, s0
; CHECK-NEXT:    vmov.f32 s26, s3
; CHECK-NEXT:    vmov.f32 s12, s17
; CHECK-NEXT:    vmov.f32 s13, s9
; CHECK-NEXT:    vmov.f32 s15, s5
; CHECK-NEXT:    vmov.f32 s20, s16
; CHECK-NEXT:    vstrb.8 q3, [r1, #16]
; CHECK-NEXT:    vmov.f32 s21, s8
; CHECK-NEXT:    vmov.f32 s23, s4
; CHECK-NEXT:    vmov.f32 s24, s19
; CHECK-NEXT:    vstrb.8 q5, [r1]
; CHECK-NEXT:    vmov.f32 s25, s11
; CHECK-NEXT:    vmov.f32 s27, s7
; CHECK-NEXT:    vmov.f32 s0, s18
; CHECK-NEXT:    vstrb.8 q6, [r1, #48]
; CHECK-NEXT:    vmov.f32 s1, s10
; CHECK-NEXT:    vmov.f32 s3, s6
; CHECK-NEXT:    vstrb.8 q0, [r1, #32]
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <4 x i32>, ptr %src, align 4
  %s2 = getelementptr <4 x i32>, ptr %src, i32 1
  %l2 = load <4 x i32>, ptr %s2, align 4
  %s3 = getelementptr <4 x i32>, ptr %src, i32 2
  %l3 = load <4 x i32>, ptr %s3, align 4
  %s4 = getelementptr <4 x i32>, ptr %src, i32 3
  %l4 = load <4 x i32>, ptr %s4, align 4
  %t1 = shufflevector <4 x i32> %l1, <4 x i32> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x i32> %l3, <4 x i32> %l4, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %s = shufflevector <8 x i32> %t1, <8 x i32> %t2, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  store <16 x i32> %s, ptr %dst, align 1
  ret void
}

; i16

define void @vst4_v2i16(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v2i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, lr}
; CHECK-NEXT:    push {r4, r5, r6, lr}
; CHECK-NEXT:    ldrh r2, [r0, #4]
; CHECK-NEXT:    ldrh r3, [r0, #8]
; CHECK-NEXT:    ldrh.w r12, [r0, #12]
; CHECK-NEXT:    ldrh.w lr, [r0, #2]
; CHECK-NEXT:    ldrh r4, [r0, #6]
; CHECK-NEXT:    ldrh r5, [r0, #10]
; CHECK-NEXT:    ldrh r6, [r0, #14]
; CHECK-NEXT:    ldrh r0, [r0]
; CHECK-NEXT:    vmov.16 q0[0], r0
; CHECK-NEXT:    vmov.16 q0[1], r2
; CHECK-NEXT:    vmov.16 q0[2], r3
; CHECK-NEXT:    vmov.16 q0[3], r12
; CHECK-NEXT:    vmov.16 q0[4], lr
; CHECK-NEXT:    vmov.16 q0[5], r4
; CHECK-NEXT:    vmov.16 q0[6], r5
; CHECK-NEXT:    vmov.16 q0[7], r6
; CHECK-NEXT:    vstrh.16 q0, [r1]
; CHECK-NEXT:    pop {r4, r5, r6, pc}
entry:
  %l1 = load <2 x i16>, ptr %src, align 4
  %s2 = getelementptr <2 x i16>, ptr %src, i32 1
  %l2 = load <2 x i16>, ptr %s2, align 4
  %s3 = getelementptr <2 x i16>, ptr %src, i32 2
  %l3 = load <2 x i16>, ptr %s3, align 4
  %s4 = getelementptr <2 x i16>, ptr %src, i32 3
  %l4 = load <2 x i16>, ptr %s4, align 4
  %t1 = shufflevector <2 x i16> %l1, <2 x i16> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x i16> %l3, <2 x i16> %l4, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %s = shufflevector <4 x i16> %t1, <4 x i16> %t2, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  store <8 x i16> %s, ptr %dst, align 2
  ret void
}

define void @vst4_v4i16(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v4i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, lr}
; CHECK-NEXT:    push {r4, r5, r6, lr}
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vldrh.u32 q0, [r0]
; CHECK-NEXT:    vldrh.u32 q3, [r0, #8]
; CHECK-NEXT:    vldrh.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrh.u32 q4, [r0, #24]
; CHECK-NEXT:    vmov r3, r4, d1
; CHECK-NEXT:    vmov r5, r12, d0
; CHECK-NEXT:    vmov.16 q2[0], r3
; CHECK-NEXT:    vmov.16 q0[0], r5
; CHECK-NEXT:    vmov r0, r5, d7
; CHECK-NEXT:    vmov.16 q2[1], r0
; CHECK-NEXT:    vmov r2, lr, d3
; CHECK-NEXT:    vmov r0, r3, d9
; CHECK-NEXT:    vmov.16 q2[2], r2
; CHECK-NEXT:    vmov.16 q2[3], r0
; CHECK-NEXT:    vmov r0, r6, d8
; CHECK-NEXT:    vmov.16 q2[4], r4
; CHECK-NEXT:    vmov.16 q2[5], r5
; CHECK-NEXT:    vmov r4, r5, d6
; CHECK-NEXT:    vmov.16 q2[6], lr
; CHECK-NEXT:    vmov.16 q0[1], r4
; CHECK-NEXT:    vmov.16 q2[7], r3
; CHECK-NEXT:    vmov r3, r2, d2
; CHECK-NEXT:    vmov.16 q0[2], r3
; CHECK-NEXT:    vstrh.16 q2, [r1, #16]
; CHECK-NEXT:    vmov.16 q0[3], r0
; CHECK-NEXT:    vmov.16 q0[4], r12
; CHECK-NEXT:    vmov.16 q0[5], r5
; CHECK-NEXT:    vmov.16 q0[6], r2
; CHECK-NEXT:    vmov.16 q0[7], r6
; CHECK-NEXT:    vstrh.16 q0, [r1]
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    pop {r4, r5, r6, pc}
entry:
  %l1 = load <4 x i16>, ptr %src, align 4
  %s2 = getelementptr <4 x i16>, ptr %src, i32 1
  %l2 = load <4 x i16>, ptr %s2, align 4
  %s3 = getelementptr <4 x i16>, ptr %src, i32 2
  %l3 = load <4 x i16>, ptr %s3, align 4
  %s4 = getelementptr <4 x i16>, ptr %src, i32 3
  %l4 = load <4 x i16>, ptr %s4, align 4
  %t1 = shufflevector <4 x i16> %l1, <4 x i16> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x i16> %l3, <4 x i16> %l4, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %s = shufflevector <8 x i16> %t1, <8 x i16> %t2, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  store <16 x i16> %s, ptr %dst, align 2
  ret void
}

define void @vst4_v8i16(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q3, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vst40.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst41.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst42.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst43.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x i16>, ptr %src, align 4
  %s2 = getelementptr <8 x i16>, ptr %src, i32 1
  %l2 = load <8 x i16>, ptr %s2, align 4
  %s3 = getelementptr <8 x i16>, ptr %src, i32 2
  %l3 = load <8 x i16>, ptr %s3, align 4
  %s4 = getelementptr <8 x i16>, ptr %src, i32 3
  %l4 = load <8 x i16>, ptr %s4, align 4
  %t1 = shufflevector <8 x i16> %l1, <8 x i16> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x i16> %l3, <8 x i16> %l4, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %s = shufflevector <16 x i16> %t1, <16 x i16> %t2, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
  store <32 x i16> %s, ptr %dst, align 2
  ret void
}

define void @vst4_v16i16(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v16i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vldrw.u32 q7, [r0, #96]
; CHECK-NEXT:    vldrw.u32 q6, [r0, #64]
; CHECK-NEXT:    vldrw.u32 q5, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q4, [r0]
; CHECK-NEXT:    vldrw.u32 q3, [r0, #112]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #80]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    vst40.16 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    vst41.16 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    vst42.16 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    vst43.16 {q4, q5, q6, q7}, [r1]!
; CHECK-NEXT:    vst40.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst41.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst42.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst43.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x i16>, ptr %src, align 4
  %s2 = getelementptr <16 x i16>, ptr %src, i32 1
  %l2 = load <16 x i16>, ptr %s2, align 4
  %s3 = getelementptr <16 x i16>, ptr %src, i32 2
  %l3 = load <16 x i16>, ptr %s3, align 4
  %s4 = getelementptr <16 x i16>, ptr %src, i32 3
  %l4 = load <16 x i16>, ptr %s4, align 4
  %t1 = shufflevector <16 x i16> %l1, <16 x i16> %l2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %t2 = shufflevector <16 x i16> %l3, <16 x i16> %l4, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %s = shufflevector <32 x i16> %t1, <32 x i16> %t2, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
  store <64 x i16> %s, ptr %dst, align 2
  ret void
}

define void @vst4_v8i16_align1(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v8i16_align1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vldrw.u32 q1, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q4, [r0, #16]
; CHECK-NEXT:    vmovx.f16 s12, s5
; CHECK-NEXT:    vmovx.f16 s0, s9
; CHECK-NEXT:    vins.f16 s5, s9
; CHECK-NEXT:    vins.f16 s12, s0
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    vmovx.f16 s27, s4
; CHECK-NEXT:    vins.f16 s4, s8
; CHECK-NEXT:    vmov.f32 s3, s12
; CHECK-NEXT:    vldrw.u32 q3, [r0]
; CHECK-NEXT:    vmov.f32 s5, s4
; CHECK-NEXT:    vmovx.f16 s8, s8
; CHECK-NEXT:    vmovx.f16 s0, s17
; CHECK-NEXT:    vmovx.f16 s2, s13
; CHECK-NEXT:    vins.f16 s27, s8
; CHECK-NEXT:    vmovx.f16 s4, s12
; CHECK-NEXT:    vmovx.f16 s8, s16
; CHECK-NEXT:    vins.f16 s13, s17
; CHECK-NEXT:    vins.f16 s12, s16
; CHECK-NEXT:    vmov q5, q3
; CHECK-NEXT:    vins.f16 s4, s8
; CHECK-NEXT:    vmov.f32 s22, s4
; CHECK-NEXT:    vmovx.f16 s4, s11
; CHECK-NEXT:    vmov.f32 s23, s27
; CHECK-NEXT:    vmovx.f16 s27, s7
; CHECK-NEXT:    vins.f16 s7, s11
; CHECK-NEXT:    vins.f16 s27, s4
; CHECK-NEXT:    vmovx.f16 s26, s15
; CHECK-NEXT:    vmovx.f16 s4, s19
; CHECK-NEXT:    vmov.f32 s25, s7
; CHECK-NEXT:    vins.f16 s26, s4
; CHECK-NEXT:    vmovx.f16 s7, s6
; CHECK-NEXT:    vmovx.f16 s4, s10
; CHECK-NEXT:    vins.f16 s6, s10
; CHECK-NEXT:    vmov.f32 s21, s5
; CHECK-NEXT:    vins.f16 s15, s19
; CHECK-NEXT:    vins.f16 s7, s4
; CHECK-NEXT:    vmov.f32 s5, s6
; CHECK-NEXT:    vmovx.f16 s6, s14
; CHECK-NEXT:    vmovx.f16 s4, s18
; CHECK-NEXT:    vins.f16 s14, s18
; CHECK-NEXT:    vins.f16 s2, s0
; CHECK-NEXT:    vmov.f32 s0, s13
; CHECK-NEXT:    vmov.f32 s24, s15
; CHECK-NEXT:    vins.f16 s6, s4
; CHECK-NEXT:    vmov.f32 s4, s14
; CHECK-NEXT:    vstrb.8 q6, [r1, #48]
; CHECK-NEXT:    vstrb.8 q1, [r1, #32]
; CHECK-NEXT:    vstrb.8 q0, [r1, #16]
; CHECK-NEXT:    vstrb.8 q5, [r1]
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x i16>, ptr %src, align 4
  %s2 = getelementptr <8 x i16>, ptr %src, i32 1
  %l2 = load <8 x i16>, ptr %s2, align 4
  %s3 = getelementptr <8 x i16>, ptr %src, i32 2
  %l3 = load <8 x i16>, ptr %s3, align 4
  %s4 = getelementptr <8 x i16>, ptr %src, i32 3
  %l4 = load <8 x i16>, ptr %s4, align 4
  %t1 = shufflevector <8 x i16> %l1, <8 x i16> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x i16> %l3, <8 x i16> %l4, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %s = shufflevector <16 x i16> %t1, <16 x i16> %t2, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
  store <32 x i16> %s, ptr %dst, align 1
  ret void
}

; i8

define void @vst4_v2i8(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v2i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, lr}
; CHECK-NEXT:    push {r4, r5, r6, lr}
; CHECK-NEXT:    ldrb r4, [r0]
; CHECK-NEXT:    ldrb r6, [r0, #2]
; CHECK-NEXT:    vmov.16 q0[0], r4
; CHECK-NEXT:    ldrb r2, [r0, #4]
; CHECK-NEXT:    vmov.16 q0[1], r6
; CHECK-NEXT:    ldrb r3, [r0, #6]
; CHECK-NEXT:    vmov.16 q0[2], r2
; CHECK-NEXT:    ldrb r5, [r0, #1]
; CHECK-NEXT:    vmov.16 q0[3], r3
; CHECK-NEXT:    ldrb.w r12, [r0, #5]
; CHECK-NEXT:    ldrb.w lr, [r0, #7]
; CHECK-NEXT:    vmov.16 q0[4], r5
; CHECK-NEXT:    ldrb r0, [r0, #3]
; CHECK-NEXT:    vmov.16 q0[5], r0
; CHECK-NEXT:    vmov.16 q0[6], r12
; CHECK-NEXT:    vmov.16 q0[7], lr
; CHECK-NEXT:    vstrb.16 q0, [r1]
; CHECK-NEXT:    pop {r4, r5, r6, pc}
entry:
  %l1 = load <2 x i8>, ptr %src, align 4
  %s2 = getelementptr <2 x i8>, ptr %src, i32 1
  %l2 = load <2 x i8>, ptr %s2, align 4
  %s3 = getelementptr <2 x i8>, ptr %src, i32 2
  %l3 = load <2 x i8>, ptr %s3, align 4
  %s4 = getelementptr <2 x i8>, ptr %src, i32 3
  %l4 = load <2 x i8>, ptr %s4, align 4
  %t1 = shufflevector <2 x i8> %l1, <2 x i8> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x i8> %l3, <2 x i8> %l4, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %s = shufflevector <4 x i8> %t1, <4 x i8> %t2, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  store <8 x i8> %s, ptr %dst, align 1
  ret void
}

define void @vst4_v4i8(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v4i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, r7, lr}
; CHECK-NEXT:    push {r4, r5, r6, r7, lr}
; CHECK-NEXT:    .pad #4
; CHECK-NEXT:    sub sp, #4
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vldrb.u32 q2, [r0]
; CHECK-NEXT:    vldrb.u32 q3, [r0, #4]
; CHECK-NEXT:    vldrb.u32 q1, [r0, #8]
; CHECK-NEXT:    vldrb.u32 q4, [r0, #12]
; CHECK-NEXT:    vmov r4, r5, d4
; CHECK-NEXT:    vmov.8 q0[0], r4
; CHECK-NEXT:    vmov r2, lr, d6
; CHECK-NEXT:    vmov.8 q0[1], r2
; CHECK-NEXT:    vmov r0, r4, d2
; CHECK-NEXT:    vmov r3, r12, d8
; CHECK-NEXT:    vmov.8 q0[2], r0
; CHECK-NEXT:    vmov.8 q0[3], r3
; CHECK-NEXT:    vmov r2, r7, d9
; CHECK-NEXT:    vmov.8 q0[4], r5
; CHECK-NEXT:    vmov r3, r5, d7
; CHECK-NEXT:    vmov.8 q0[5], lr
; CHECK-NEXT:    vmov.8 q0[6], r4
; CHECK-NEXT:    vmov r4, r0, d5
; CHECK-NEXT:    vmov.8 q0[7], r12
; CHECK-NEXT:    vmov.8 q0[8], r4
; CHECK-NEXT:    vmov r4, r6, d3
; CHECK-NEXT:    vmov.8 q0[9], r3
; CHECK-NEXT:    vmov.8 q0[10], r4
; CHECK-NEXT:    vmov.8 q0[11], r2
; CHECK-NEXT:    vmov.8 q0[12], r0
; CHECK-NEXT:    vmov.8 q0[13], r5
; CHECK-NEXT:    vmov.8 q0[14], r6
; CHECK-NEXT:    vmov.8 q0[15], r7
; CHECK-NEXT:    vstrb.8 q0, [r1]
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    add sp, #4
; CHECK-NEXT:    pop {r4, r5, r6, r7, pc}
entry:
  %l1 = load <4 x i8>, ptr %src, align 4
  %s2 = getelementptr <4 x i8>, ptr %src, i32 1
  %l2 = load <4 x i8>, ptr %s2, align 4
  %s3 = getelementptr <4 x i8>, ptr %src, i32 2
  %l3 = load <4 x i8>, ptr %s3, align 4
  %s4 = getelementptr <4 x i8>, ptr %src, i32 3
  %l4 = load <4 x i8>, ptr %s4, align 4
  %t1 = shufflevector <4 x i8> %l1, <4 x i8> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x i8> %l3, <4 x i8> %l4, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %s = shufflevector <8 x i8> %t1, <8 x i8> %t2, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  store <16 x i8> %s, ptr %dst, align 1
  ret void
}

define void @vst4_v8i8(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v8i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    vldrb.u16 q1, [r0]
; CHECK-NEXT:    vldrb.u16 q2, [r0, #8]
; CHECK-NEXT:    vldrb.u16 q3, [r0, #16]
; CHECK-NEXT:    vldrb.u16 q4, [r0, #24]
; CHECK-NEXT:    vmov.u16 r2, q1[4]
; CHECK-NEXT:    vmov.8 q0[0], r2
; CHECK-NEXT:    vmov.u16 r2, q2[4]
; CHECK-NEXT:    vmov.8 q0[1], r2
; CHECK-NEXT:    vmov.u16 r2, q3[4]
; CHECK-NEXT:    vmov.8 q0[2], r2
; CHECK-NEXT:    vmov.u16 r0, q4[4]
; CHECK-NEXT:    vmov.8 q0[3], r0
; CHECK-NEXT:    vmov.u16 r0, q1[5]
; CHECK-NEXT:    vmov.8 q0[4], r0
; CHECK-NEXT:    vmov.u16 r0, q2[5]
; CHECK-NEXT:    vmov.8 q0[5], r0
; CHECK-NEXT:    vmov.u16 r0, q3[5]
; CHECK-NEXT:    vmov.8 q0[6], r0
; CHECK-NEXT:    vmov.u16 r0, q4[5]
; CHECK-NEXT:    vmov.8 q0[7], r0
; CHECK-NEXT:    vmov.u16 r0, q1[6]
; CHECK-NEXT:    vmov.8 q0[8], r0
; CHECK-NEXT:    vmov.u16 r0, q2[6]
; CHECK-NEXT:    vmov.8 q0[9], r0
; CHECK-NEXT:    vmov.u16 r0, q3[6]
; CHECK-NEXT:    vmov.8 q0[10], r0
; CHECK-NEXT:    vmov.u16 r0, q4[6]
; CHECK-NEXT:    vmov.8 q0[11], r0
; CHECK-NEXT:    vmov.u16 r0, q1[7]
; CHECK-NEXT:    vmov.8 q0[12], r0
; CHECK-NEXT:    vmov.u16 r0, q2[7]
; CHECK-NEXT:    vmov.8 q0[13], r0
; CHECK-NEXT:    vmov.u16 r0, q3[7]
; CHECK-NEXT:    vmov.8 q0[14], r0
; CHECK-NEXT:    vmov.u16 r0, q4[7]
; CHECK-NEXT:    vmov.8 q0[15], r0
; CHECK-NEXT:    vmov.u16 r0, q1[0]
; CHECK-NEXT:    vmov.8 q5[0], r0
; CHECK-NEXT:    vmov.u16 r0, q2[0]
; CHECK-NEXT:    vmov.8 q5[1], r0
; CHECK-NEXT:    vmov.u16 r0, q3[0]
; CHECK-NEXT:    vmov.8 q5[2], r0
; CHECK-NEXT:    vmov.u16 r0, q4[0]
; CHECK-NEXT:    vmov.8 q5[3], r0
; CHECK-NEXT:    vmov.u16 r0, q1[1]
; CHECK-NEXT:    vmov.8 q5[4], r0
; CHECK-NEXT:    vmov.u16 r0, q2[1]
; CHECK-NEXT:    vmov.8 q5[5], r0
; CHECK-NEXT:    vmov.u16 r0, q3[1]
; CHECK-NEXT:    vmov.8 q5[6], r0
; CHECK-NEXT:    vmov.u16 r0, q4[1]
; CHECK-NEXT:    vmov.8 q5[7], r0
; CHECK-NEXT:    vmov.u16 r0, q1[2]
; CHECK-NEXT:    vmov.8 q5[8], r0
; CHECK-NEXT:    vmov.u16 r0, q2[2]
; CHECK-NEXT:    vmov.8 q5[9], r0
; CHECK-NEXT:    vmov.u16 r0, q3[2]
; CHECK-NEXT:    vmov.8 q5[10], r0
; CHECK-NEXT:    vmov.u16 r0, q4[2]
; CHECK-NEXT:    vmov.8 q5[11], r0
; CHECK-NEXT:    vmov.u16 r0, q1[3]
; CHECK-NEXT:    vmov.8 q5[12], r0
; CHECK-NEXT:    vmov.u16 r0, q2[3]
; CHECK-NEXT:    vmov.8 q5[13], r0
; CHECK-NEXT:    vmov.u16 r0, q3[3]
; CHECK-NEXT:    vmov.8 q5[14], r0
; CHECK-NEXT:    vmov.u16 r0, q4[3]
; CHECK-NEXT:    vmov.8 q5[15], r0
; CHECK-NEXT:    vstrb.8 q0, [r1, #16]
; CHECK-NEXT:    vstrb.8 q5, [r1]
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x i8>, ptr %src, align 4
  %s2 = getelementptr <8 x i8>, ptr %src, i32 1
  %l2 = load <8 x i8>, ptr %s2, align 4
  %s3 = getelementptr <8 x i8>, ptr %src, i32 2
  %l3 = load <8 x i8>, ptr %s3, align 4
  %s4 = getelementptr <8 x i8>, ptr %src, i32 3
  %l4 = load <8 x i8>, ptr %s4, align 4
  %t1 = shufflevector <8 x i8> %l1, <8 x i8> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x i8> %l3, <8 x i8> %l4, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %s = shufflevector <16 x i8> %t1, <16 x i8> %t2, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
  store <32 x i8> %s, ptr %dst, align 1
  ret void
}

define void @vst4_v16i8(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q3, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vst40.8 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst41.8 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst42.8 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst43.8 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x i8>, ptr %src, align 4
  %s2 = getelementptr <16 x i8>, ptr %src, i32 1
  %l2 = load <16 x i8>, ptr %s2, align 4
  %s3 = getelementptr <16 x i8>, ptr %src, i32 2
  %l3 = load <16 x i8>, ptr %s3, align 4
  %s4 = getelementptr <16 x i8>, ptr %src, i32 3
  %l4 = load <16 x i8>, ptr %s4, align 4
  %t1 = shufflevector <16 x i8> %l1, <16 x i8> %l2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %t2 = shufflevector <16 x i8> %l3, <16 x i8> %l4, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %s = shufflevector <32 x i8> %t1, <32 x i8> %t2, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
  store <64 x i8> %s, ptr %dst, align 1
  ret void
}

; i64

define void @vst4_v2i64(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v2i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    vldrw.u32 q0, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q3, [r0]
; CHECK-NEXT:    vmov.f64 d9, d0
; CHECK-NEXT:    vmov.f64 d8, d4
; CHECK-NEXT:    vmov.f64 d11, d2
; CHECK-NEXT:    vstrw.32 q4, [r1, #16]
; CHECK-NEXT:    vmov.f64 d10, d6
; CHECK-NEXT:    vmov.f64 d0, d5
; CHECK-NEXT:    vstrw.32 q5, [r1]
; CHECK-NEXT:    vmov.f64 d2, d7
; CHECK-NEXT:    vstrw.32 q0, [r1, #48]
; CHECK-NEXT:    vstrw.32 q1, [r1, #32]
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <2 x i64>, ptr %src, align 4
  %s2 = getelementptr <2 x i64>, ptr %src, i32 1
  %l2 = load <2 x i64>, ptr %s2, align 4
  %s3 = getelementptr <2 x i64>, ptr %src, i32 2
  %l3 = load <2 x i64>, ptr %s3, align 4
  %s4 = getelementptr <2 x i64>, ptr %src, i32 3
  %l4 = load <2 x i64>, ptr %s4, align 4
  %t1 = shufflevector <2 x i64> %l1, <2 x i64> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x i64> %l3, <2 x i64> %l4, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %s = shufflevector <4 x i64> %t1, <4 x i64> %t2, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  store <8 x i64> %s, ptr %dst, align 8
  ret void
}

define void @vst4_v4i64(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v4i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #64
; CHECK-NEXT:    sub sp, #64
; CHECK-NEXT:    vldrw.u32 q7, [r0, #80]
; CHECK-NEXT:    vldrw.u32 q5, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q6, [r0]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #96]
; CHECK-NEXT:    vstrw.32 q7, [sp, #32] @ 16-byte Spill
; CHECK-NEXT:    vmov.f64 d15, d10
; CHECK-NEXT:    vldrw.u32 q2, [r0, #64]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q3, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q4, [r0, #112]
; CHECK-NEXT:    vstrw.32 q0, [sp, #16] @ 16-byte Spill
; CHECK-NEXT:    vmov.f64 d14, d12
; CHECK-NEXT:    vstrw.32 q7, [sp, #48] @ 16-byte Spill
; CHECK-NEXT:    vmov.f64 d14, d4
; CHECK-NEXT:    vmov.f64 d15, d2
; CHECK-NEXT:    vstrw.32 q7, [sp] @ 16-byte Spill
; CHECK-NEXT:    vmov.f64 d4, d0
; CHECK-NEXT:    vldrw.u32 q0, [sp, #32] @ 16-byte Reload
; CHECK-NEXT:    vldrw.u32 q7, [sp, #16] @ 16-byte Reload
; CHECK-NEXT:    vmov.f64 d10, d13
; CHECK-NEXT:    vmov.f64 d2, d5
; CHECK-NEXT:    vstrw.32 q5, [r1, #32]
; CHECK-NEXT:    vmov.f64 d5, d6
; CHECK-NEXT:    vstrw.32 q1, [r1, #48]
; CHECK-NEXT:    vmov.f64 d13, d8
; CHECK-NEXT:    vstrw.32 q2, [r1, #64]
; CHECK-NEXT:    vmov.f64 d12, d0
; CHECK-NEXT:    vmov.f64 d8, d1
; CHECK-NEXT:    vldrw.u32 q0, [sp, #48] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q6, [r1, #80]
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vldrw.u32 q0, [sp] @ 16-byte Reload
; CHECK-NEXT:    vmov.f64 d6, d15
; CHECK-NEXT:    vstrw.32 q4, [r1, #112]
; CHECK-NEXT:    vstrw.32 q0, [r1, #16]
; CHECK-NEXT:    vstrw.32 q3, [r1, #96]
; CHECK-NEXT:    add sp, #64
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <4 x i64>, ptr %src, align 4
  %s2 = getelementptr <4 x i64>, ptr %src, i32 1
  %l2 = load <4 x i64>, ptr %s2, align 4
  %s3 = getelementptr <4 x i64>, ptr %src, i32 2
  %l3 = load <4 x i64>, ptr %s3, align 4
  %s4 = getelementptr <4 x i64>, ptr %src, i32 3
  %l4 = load <4 x i64>, ptr %s4, align 4
  %t1 = shufflevector <4 x i64> %l1, <4 x i64> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x i64> %l3, <4 x i64> %l4, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %s = shufflevector <8 x i64> %t1, <8 x i64> %t2, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  store <16 x i64> %s, ptr %dst, align 8
  ret void
}

; f32

define void @vst4_v2f32(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v2f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldr s0, [r0]
; CHECK-NEXT:    vldr s4, [r0, #4]
; CHECK-NEXT:    vldr s1, [r0, #8]
; CHECK-NEXT:    vldr s5, [r0, #12]
; CHECK-NEXT:    vldr s2, [r0, #16]
; CHECK-NEXT:    vldr s6, [r0, #20]
; CHECK-NEXT:    vldr s3, [r0, #24]
; CHECK-NEXT:    vldr s7, [r0, #28]
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <2 x float>, ptr %src, align 4
  %s2 = getelementptr <2 x float>, ptr %src, i32 1
  %l2 = load <2 x float>, ptr %s2, align 4
  %s3 = getelementptr <2 x float>, ptr %src, i32 2
  %l3 = load <2 x float>, ptr %s3, align 4
  %s4 = getelementptr <2 x float>, ptr %src, i32 3
  %l4 = load <2 x float>, ptr %s4, align 4
  %t1 = shufflevector <2 x float> %l1, <2 x float> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x float> %l3, <2 x float> %l4, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %s = shufflevector <4 x float> %t1, <4 x float> %t2, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  store <8 x float> %s, ptr %dst, align 4
  ret void
}

define void @vst4_v4f32(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v4f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q3, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vst40.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst41.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst42.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst43.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <4 x float>, ptr %src, align 4
  %s2 = getelementptr <4 x float>, ptr %src, i32 1
  %l2 = load <4 x float>, ptr %s2, align 4
  %s3 = getelementptr <4 x float>, ptr %src, i32 2
  %l3 = load <4 x float>, ptr %s3, align 4
  %s4 = getelementptr <4 x float>, ptr %src, i32 3
  %l4 = load <4 x float>, ptr %s4, align 4
  %t1 = shufflevector <4 x float> %l1, <4 x float> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x float> %l3, <4 x float> %l4, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %s = shufflevector <8 x float> %t1, <8 x float> %t2, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  store <16 x float> %s, ptr %dst, align 4
  ret void
}

define void @vst4_v8f32(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v8f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vldrw.u32 q7, [r0, #96]
; CHECK-NEXT:    vldrw.u32 q6, [r0, #64]
; CHECK-NEXT:    vldrw.u32 q5, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q4, [r0]
; CHECK-NEXT:    vldrw.u32 q3, [r0, #112]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #80]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    vst40.32 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    vst41.32 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    vst42.32 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    vst43.32 {q4, q5, q6, q7}, [r1]!
; CHECK-NEXT:    vst40.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst41.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst42.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst43.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x float>, ptr %src, align 4
  %s2 = getelementptr <8 x float>, ptr %src, i32 1
  %l2 = load <8 x float>, ptr %s2, align 4
  %s3 = getelementptr <8 x float>, ptr %src, i32 2
  %l3 = load <8 x float>, ptr %s3, align 4
  %s4 = getelementptr <8 x float>, ptr %src, i32 3
  %l4 = load <8 x float>, ptr %s4, align 4
  %t1 = shufflevector <8 x float> %l1, <8 x float> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x float> %l3, <8 x float> %l4, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %s = shufflevector <16 x float> %t1, <16 x float> %t2, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
  store <32 x float> %s, ptr %dst, align 4
  ret void
}

define void @vst4_v16f32(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v16f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5}
; CHECK-NEXT:    push {r4, r5}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #192
; CHECK-NEXT:    sub sp, #192
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    add r2, sp, #64
; CHECK-NEXT:    vldrw.u32 q4, [r0, #176]
; CHECK-NEXT:    vldrw.u32 q3, [r0, #208]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #144]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #80]
; CHECK-NEXT:    vstmia r2, {d0, d1, d2, d3, d4, d5, d6, d7} @ 64-byte Spill
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #128]
; CHECK-NEXT:    vldrw.u32 q5, [r0, #240]
; CHECK-NEXT:    vmov q6, q4
; CHECK-NEXT:    vldrw.u32 q3, [r0, #192]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #64]
; CHECK-NEXT:    vstmia sp, {d0, d1, d2, d3, d4, d5, d6, d7} @ 64-byte Spill
; CHECK-NEXT:    vldrw.u32 q2, [r0, #160]
; CHECK-NEXT:    vldrw.u32 q4, [r0, #48]
; CHECK-NEXT:    add r2, sp, #128
; CHECK-NEXT:    vmov q7, q5
; CHECK-NEXT:    vldrw.u32 q3, [r0, #224]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #96]
; CHECK-NEXT:    vldrw.u32 q5, [r0, #112]
; CHECK-NEXT:    vstmia r2, {d8, d9, d10, d11, d12, d13, d14, d15} @ 64-byte Spill
; CHECK-NEXT:    vmov q6, q2
; CHECK-NEXT:    vmov q5, q1
; CHECK-NEXT:    vmov q7, q3
; CHECK-NEXT:    vldmia sp, {d0, d1, d2, d3, d4, d5, d6, d7} @ 64-byte Reload
; CHECK-NEXT:    add r2, sp, #64
; CHECK-NEXT:    vldrw.u32 q4, [r0, #32]
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    vst40.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst41.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst42.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst43.32 {q0, q1, q2, q3}, [r0]!
; CHECK-NEXT:    vldmia r2, {d0, d1, d2, d3, d4, d5, d6, d7} @ 64-byte Reload
; CHECK-NEXT:    vst40.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vst41.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vst42.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vst43.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    add.w r0, r1, #192
; CHECK-NEXT:    adds r1, #128
; CHECK-NEXT:    vst40.32 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    vst41.32 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    vst42.32 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    vst43.32 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    add r1, sp, #128
; CHECK-NEXT:    vldmia r1, {d0, d1, d2, d3, d4, d5, d6, d7} @ 64-byte Reload
; CHECK-NEXT:    vst40.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vst41.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vst42.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vst43.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    add sp, #192
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    pop {r4, r5}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x float>, ptr %src, align 4
  %s2 = getelementptr <16 x float>, ptr %src, i32 1
  %l2 = load <16 x float>, ptr %s2, align 4
  %s3 = getelementptr <16 x float>, ptr %src, i32 2
  %l3 = load <16 x float>, ptr %s3, align 4
  %s4 = getelementptr <16 x float>, ptr %src, i32 3
  %l4 = load <16 x float>, ptr %s4, align 4
  %t1 = shufflevector <16 x float> %l1, <16 x float> %l2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %t2 = shufflevector <16 x float> %l3, <16 x float> %l4, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %s = shufflevector <32 x float> %t1, <32 x float> %t2, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
  store <64 x float> %s, ptr %dst, align 4
  ret void
}

define void @vst4_v4f32_align1(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v4f32_align1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vldrw.u32 q1, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q4, [r0]
; CHECK-NEXT:    vmov.f32 s14, s1
; CHECK-NEXT:    vmov.f32 s22, s0
; CHECK-NEXT:    vmov.f32 s26, s3
; CHECK-NEXT:    vmov.f32 s12, s17
; CHECK-NEXT:    vmov.f32 s13, s9
; CHECK-NEXT:    vmov.f32 s15, s5
; CHECK-NEXT:    vmov.f32 s20, s16
; CHECK-NEXT:    vstrb.8 q3, [r1, #16]
; CHECK-NEXT:    vmov.f32 s21, s8
; CHECK-NEXT:    vmov.f32 s23, s4
; CHECK-NEXT:    vmov.f32 s24, s19
; CHECK-NEXT:    vstrb.8 q5, [r1]
; CHECK-NEXT:    vmov.f32 s25, s11
; CHECK-NEXT:    vmov.f32 s27, s7
; CHECK-NEXT:    vmov.f32 s0, s18
; CHECK-NEXT:    vstrb.8 q6, [r1, #48]
; CHECK-NEXT:    vmov.f32 s1, s10
; CHECK-NEXT:    vmov.f32 s3, s6
; CHECK-NEXT:    vstrb.8 q0, [r1, #32]
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <4 x float>, ptr %src, align 4
  %s2 = getelementptr <4 x float>, ptr %src, i32 1
  %l2 = load <4 x float>, ptr %s2, align 4
  %s3 = getelementptr <4 x float>, ptr %src, i32 2
  %l3 = load <4 x float>, ptr %s3, align 4
  %s4 = getelementptr <4 x float>, ptr %src, i32 3
  %l4 = load <4 x float>, ptr %s4, align 4
  %t1 = shufflevector <4 x float> %l1, <4 x float> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x float> %l3, <4 x float> %l4, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %s = shufflevector <8 x float> %t1, <8 x float> %t2, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  store <16 x float> %s, ptr %dst, align 1
  ret void
}

; f16

define void @vst4_v2f16(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v2f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    ldm.w r0, {r2, r3, r12}
; CHECK-NEXT:    vmov.32 q1[0], r12
; CHECK-NEXT:    ldr r0, [r0, #12]
; CHECK-NEXT:    vmov.32 q0[0], r2
; CHECK-NEXT:    vmov.32 q0[1], r3
; CHECK-NEXT:    vmov.32 q1[1], r0
; CHECK-NEXT:    vmovx.f16 s2, s0
; CHECK-NEXT:    vmovx.f16 s6, s1
; CHECK-NEXT:    vmovx.f16 s3, s4
; CHECK-NEXT:    vins.f16 s2, s6
; CHECK-NEXT:    vmovx.f16 s6, s5
; CHECK-NEXT:    vins.f16 s4, s5
; CHECK-NEXT:    vins.f16 s0, s1
; CHECK-NEXT:    vins.f16 s3, s6
; CHECK-NEXT:    vmov.f32 s1, s4
; CHECK-NEXT:    vstrh.16 q0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <2 x half>, ptr %src, align 4
  %s2 = getelementptr <2 x half>, ptr %src, i32 1
  %l2 = load <2 x half>, ptr %s2, align 4
  %s3 = getelementptr <2 x half>, ptr %src, i32 2
  %l3 = load <2 x half>, ptr %s3, align 4
  %s4 = getelementptr <2 x half>, ptr %src, i32 3
  %l4 = load <2 x half>, ptr %s4, align 4
  %t1 = shufflevector <2 x half> %l1, <2 x half> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x half> %l3, <2 x half> %l4, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %s = shufflevector <4 x half> %t1, <4 x half> %t2, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  store <8 x half> %s, ptr %dst, align 2
  ret void
}

define void @vst4_v4f16(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v4f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, lr}
; CHECK-NEXT:    push {r4, r5, r6, lr}
; CHECK-NEXT:    add.w r6, r0, #16
; CHECK-NEXT:    ldrd lr, r12, [r0]
; CHECK-NEXT:    ldrd r3, r2, [r0, #8]
; CHECK-NEXT:    ldm r6, {r4, r5, r6}
; CHECK-NEXT:    vmov q1[2], q1[0], lr, r3
; CHECK-NEXT:    ldr r0, [r0, #28]
; CHECK-NEXT:    vmov q1[3], q1[1], r12, r2
; CHECK-NEXT:    vmov q0[2], q0[0], r4, r6
; CHECK-NEXT:    vmovx.f16 s10, s5
; CHECK-NEXT:    vmov q0[3], q0[1], r5, r0
; CHECK-NEXT:    vins.f16 s5, s7
; CHECK-NEXT:    vmovx.f16 s12, s0
; CHECK-NEXT:    vins.f16 s0, s2
; CHECK-NEXT:    vmovx.f16 s2, s2
; CHECK-NEXT:    vmovx.f16 s11, s1
; CHECK-NEXT:    vins.f16 s12, s2
; CHECK-NEXT:    vmovx.f16 s2, s3
; CHECK-NEXT:    vins.f16 s11, s2
; CHECK-NEXT:    vmovx.f16 s2, s4
; CHECK-NEXT:    vins.f16 s4, s6
; CHECK-NEXT:    vmovx.f16 s6, s6
; CHECK-NEXT:    vins.f16 s1, s3
; CHECK-NEXT:    vins.f16 s2, s6
; CHECK-NEXT:    vmovx.f16 s6, s7
; CHECK-NEXT:    vmov.f32 s8, s5
; CHECK-NEXT:    vins.f16 s10, s6
; CHECK-NEXT:    vmov.f32 s9, s1
; CHECK-NEXT:    vmov.f32 s5, s0
; CHECK-NEXT:    vstrh.16 q2, [r1, #16]
; CHECK-NEXT:    vmov.f32 s6, s2
; CHECK-NEXT:    vmov.f32 s7, s12
; CHECK-NEXT:    vstrh.16 q1, [r1]
; CHECK-NEXT:    pop {r4, r5, r6, pc}
entry:
  %l1 = load <4 x half>, ptr %src, align 4
  %s2 = getelementptr <4 x half>, ptr %src, i32 1
  %l2 = load <4 x half>, ptr %s2, align 4
  %s3 = getelementptr <4 x half>, ptr %src, i32 2
  %l3 = load <4 x half>, ptr %s3, align 4
  %s4 = getelementptr <4 x half>, ptr %src, i32 3
  %l4 = load <4 x half>, ptr %s4, align 4
  %t1 = shufflevector <4 x half> %l1, <4 x half> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x half> %l3, <4 x half> %l4, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %s = shufflevector <8 x half> %t1, <8 x half> %t2, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  store <16 x half> %s, ptr %dst, align 2
  ret void
}

define void @vst4_v8f16(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v8f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q3, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vst40.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst41.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst42.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst43.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x half>, ptr %src, align 4
  %s2 = getelementptr <8 x half>, ptr %src, i32 1
  %l2 = load <8 x half>, ptr %s2, align 4
  %s3 = getelementptr <8 x half>, ptr %src, i32 2
  %l3 = load <8 x half>, ptr %s3, align 4
  %s4 = getelementptr <8 x half>, ptr %src, i32 3
  %l4 = load <8 x half>, ptr %s4, align 4
  %t1 = shufflevector <8 x half> %l1, <8 x half> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x half> %l3, <8 x half> %l4, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %s = shufflevector <16 x half> %t1, <16 x half> %t2, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
  store <32 x half> %s, ptr %dst, align 2
  ret void
}

define void @vst4_v16f16(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v16f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vldrw.u32 q7, [r0, #96]
; CHECK-NEXT:    vldrw.u32 q6, [r0, #64]
; CHECK-NEXT:    vldrw.u32 q5, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q4, [r0]
; CHECK-NEXT:    vldrw.u32 q3, [r0, #112]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #80]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    vst40.16 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    vst41.16 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    vst42.16 {q4, q5, q6, q7}, [r1]
; CHECK-NEXT:    vst43.16 {q4, q5, q6, q7}, [r1]!
; CHECK-NEXT:    vst40.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst41.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst42.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst43.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x half>, ptr %src, align 4
  %s2 = getelementptr <16 x half>, ptr %src, i32 1
  %l2 = load <16 x half>, ptr %s2, align 4
  %s3 = getelementptr <16 x half>, ptr %src, i32 2
  %l3 = load <16 x half>, ptr %s3, align 4
  %s4 = getelementptr <16 x half>, ptr %src, i32 3
  %l4 = load <16 x half>, ptr %s4, align 4
  %t1 = shufflevector <16 x half> %l1, <16 x half> %l2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %t2 = shufflevector <16 x half> %l3, <16 x half> %l4, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %s = shufflevector <32 x half> %t1, <32 x half> %t2, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
  store <64 x half> %s, ptr %dst, align 2
  ret void
}

define void @vst4_v8f16_align1(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v8f16_align1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d9, d10, d11, d12, d13}
; CHECK-NEXT:    vldrw.u32 q1, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q5, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q6, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q2, [r0]
; CHECK-NEXT:    vmovx.f16 s0, s5
; CHECK-NEXT:    vmovx.f16 s2, s21
; CHECK-NEXT:    vins.f16 s0, s2
; CHECK-NEXT:    vmovx.f16 s2, s9
; CHECK-NEXT:    vmovx.f16 s12, s25
; CHECK-NEXT:    vmovx.f16 s19, s4
; CHECK-NEXT:    vins.f16 s2, s12
; CHECK-NEXT:    vmovx.f16 s12, s20
; CHECK-NEXT:    vins.f16 s19, s12
; CHECK-NEXT:    vmovx.f16 s12, s8
; CHECK-NEXT:    vmovx.f16 s14, s24
; CHECK-NEXT:    vmovx.f16 s15, s7
; CHECK-NEXT:    vins.f16 s12, s14
; CHECK-NEXT:    vmovx.f16 s14, s23
; CHECK-NEXT:    vins.f16 s15, s14
; CHECK-NEXT:    vmovx.f16 s14, s11
; CHECK-NEXT:    vmovx.f16 s1, s27
; CHECK-NEXT:    vins.f16 s7, s23
; CHECK-NEXT:    vins.f16 s14, s1
; CHECK-NEXT:    vmovx.f16 s23, s6
; CHECK-NEXT:    vmovx.f16 s1, s22
; CHECK-NEXT:    vins.f16 s6, s22
; CHECK-NEXT:    vins.f16 s5, s21
; CHECK-NEXT:    vins.f16 s4, s20
; CHECK-NEXT:    vins.f16 s23, s1
; CHECK-NEXT:    vmovx.f16 s22, s10
; CHECK-NEXT:    vins.f16 s10, s26
; CHECK-NEXT:    vmovx.f16 s1, s26
; CHECK-NEXT:    vins.f16 s9, s25
; CHECK-NEXT:    vins.f16 s8, s24
; CHECK-NEXT:    vins.f16 s11, s27
; CHECK-NEXT:    vmov q6, q1
; CHECK-NEXT:    vins.f16 s22, s1
; CHECK-NEXT:    vmov.f32 s1, s25
; CHECK-NEXT:    vmov q6, q2
; CHECK-NEXT:    vmov.f32 s3, s0
; CHECK-NEXT:    vmov.f32 s0, s9
; CHECK-NEXT:    vmov.f32 s26, s12
; CHECK-NEXT:    vstrb.8 q0, [r1, #16]
; CHECK-NEXT:    vmov.f32 s25, s4
; CHECK-NEXT:    vmov.f32 s27, s19
; CHECK-NEXT:    vmov.f32 s13, s7
; CHECK-NEXT:    vstrb.8 q6, [r1]
; CHECK-NEXT:    vmov.f32 s12, s11
; CHECK-NEXT:    vmov.f32 s21, s6
; CHECK-NEXT:    vstrb.8 q3, [r1, #48]
; CHECK-NEXT:    vmov.f32 s20, s10
; CHECK-NEXT:    vstrb.8 q5, [r1, #32]
; CHECK-NEXT:    vpop {d9, d10, d11, d12, d13}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x half>, ptr %src, align 4
  %s2 = getelementptr <8 x half>, ptr %src, i32 1
  %l2 = load <8 x half>, ptr %s2, align 4
  %s3 = getelementptr <8 x half>, ptr %src, i32 2
  %l3 = load <8 x half>, ptr %s3, align 4
  %s4 = getelementptr <8 x half>, ptr %src, i32 3
  %l4 = load <8 x half>, ptr %s4, align 4
  %t1 = shufflevector <8 x half> %l1, <8 x half> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x half> %l3, <8 x half> %l4, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %s = shufflevector <16 x half> %t1, <16 x half> %t2, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
  store <32 x half> %s, ptr %dst, align 1
  ret void
}

; f64

define void @vst4_v2f64(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v2f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    vldrw.u32 q0, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q3, [r0]
; CHECK-NEXT:    vmov.f64 d9, d0
; CHECK-NEXT:    vmov.f64 d8, d4
; CHECK-NEXT:    vmov.f64 d11, d2
; CHECK-NEXT:    vstrw.32 q4, [r1, #16]
; CHECK-NEXT:    vmov.f64 d10, d6
; CHECK-NEXT:    vmov.f64 d0, d5
; CHECK-NEXT:    vstrw.32 q5, [r1]
; CHECK-NEXT:    vmov.f64 d2, d7
; CHECK-NEXT:    vstrw.32 q0, [r1, #48]
; CHECK-NEXT:    vstrw.32 q1, [r1, #32]
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <2 x double>, ptr %src, align 4
  %s2 = getelementptr <2 x double>, ptr %src, i32 1
  %l2 = load <2 x double>, ptr %s2, align 4
  %s3 = getelementptr <2 x double>, ptr %src, i32 2
  %l3 = load <2 x double>, ptr %s3, align 4
  %s4 = getelementptr <2 x double>, ptr %src, i32 3
  %l4 = load <2 x double>, ptr %s4, align 4
  %t1 = shufflevector <2 x double> %l1, <2 x double> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x double> %l3, <2 x double> %l4, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %s = shufflevector <4 x double> %t1, <4 x double> %t2, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  store <8 x double> %s, ptr %dst, align 8
  ret void
}

define void @vst4_v4f64(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v4f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #64
; CHECK-NEXT:    sub sp, #64
; CHECK-NEXT:    vldrw.u32 q7, [r0, #80]
; CHECK-NEXT:    vldrw.u32 q5, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q6, [r0]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #96]
; CHECK-NEXT:    vstrw.32 q7, [sp, #32] @ 16-byte Spill
; CHECK-NEXT:    vmov.f64 d15, d10
; CHECK-NEXT:    vldrw.u32 q2, [r0, #64]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q3, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q4, [r0, #112]
; CHECK-NEXT:    vstrw.32 q0, [sp, #16] @ 16-byte Spill
; CHECK-NEXT:    vmov.f64 d14, d12
; CHECK-NEXT:    vstrw.32 q7, [sp, #48] @ 16-byte Spill
; CHECK-NEXT:    vmov.f64 d14, d4
; CHECK-NEXT:    vmov.f64 d15, d2
; CHECK-NEXT:    vstrw.32 q7, [sp] @ 16-byte Spill
; CHECK-NEXT:    vmov.f64 d4, d0
; CHECK-NEXT:    vldrw.u32 q0, [sp, #32] @ 16-byte Reload
; CHECK-NEXT:    vldrw.u32 q7, [sp, #16] @ 16-byte Reload
; CHECK-NEXT:    vmov.f64 d10, d13
; CHECK-NEXT:    vmov.f64 d2, d5
; CHECK-NEXT:    vstrw.32 q5, [r1, #32]
; CHECK-NEXT:    vmov.f64 d5, d6
; CHECK-NEXT:    vstrw.32 q1, [r1, #48]
; CHECK-NEXT:    vmov.f64 d13, d8
; CHECK-NEXT:    vstrw.32 q2, [r1, #64]
; CHECK-NEXT:    vmov.f64 d12, d0
; CHECK-NEXT:    vmov.f64 d8, d1
; CHECK-NEXT:    vldrw.u32 q0, [sp, #48] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q6, [r1, #80]
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vldrw.u32 q0, [sp] @ 16-byte Reload
; CHECK-NEXT:    vmov.f64 d6, d15
; CHECK-NEXT:    vstrw.32 q4, [r1, #112]
; CHECK-NEXT:    vstrw.32 q0, [r1, #16]
; CHECK-NEXT:    vstrw.32 q3, [r1, #96]
; CHECK-NEXT:    add sp, #64
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <4 x double>, ptr %src, align 4
  %s2 = getelementptr <4 x double>, ptr %src, i32 1
  %l2 = load <4 x double>, ptr %s2, align 4
  %s3 = getelementptr <4 x double>, ptr %src, i32 2
  %l3 = load <4 x double>, ptr %s3, align 4
  %s4 = getelementptr <4 x double>, ptr %src, i32 3
  %l4 = load <4 x double>, ptr %s4, align 4
  %t1 = shufflevector <4 x double> %l1, <4 x double> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x double> %l3, <4 x double> %l4, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %s = shufflevector <8 x double> %t1, <8 x double> %t2, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  store <16 x double> %s, ptr %dst, align 8
  ret void
}
