; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals all --version 4
; RUN: opt < %s -passes=amdgpu-sw-lower-lds -S -mtriple=amdgcn-amd-amdhsa | FileCheck %s

@lds_1 = internal addrspace(3) global [1 x i32] poison, align 4

;.
; CHECK: @llvm.amdgcn.sw.lds.atomic_xchg_kernel = internal addrspace(3) global ptr poison, no_sanitize_address, align 4, !absolute_symbol [[META0:![0-9]+]]
; CHECK: @llvm.amdgcn.sw.lds.atomic_xchg_kernel.md = internal addrspace(1) global %llvm.amdgcn.sw.lds.atomic_xchg_kernel.md.type { %llvm.amdgcn.sw.lds.atomic_xchg_kernel.md.item { i32 0, i32 8, i32 32 }, %llvm.amdgcn.sw.lds.atomic_xchg_kernel.md.item { i32 32, i32 4, i32 32 } }, no_sanitize_address
;.
define amdgpu_kernel void @atomic_xchg_kernel(ptr addrspace(1) %out, [8 x i32], [8 x i32], i32 %swap) sanitize_address {
; CHECK-LABEL: define amdgpu_kernel void @atomic_xchg_kernel(
; CHECK-SAME: ptr addrspace(1) [[OUT:%.*]], [8 x i32] [[TMP0:%.*]], [8 x i32] [[TMP1:%.*]], i32 [[SWAP:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  WId:
; CHECK-NEXT:    [[TMP2:%.*]] = call i32 @llvm.amdgcn.workitem.id.x()
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.amdgcn.workitem.id.y()
; CHECK-NEXT:    [[TMP4:%.*]] = call i32 @llvm.amdgcn.workitem.id.z()
; CHECK-NEXT:    [[TMP5:%.*]] = or i32 [[TMP2]], [[TMP3]]
; CHECK-NEXT:    [[TMP6:%.*]] = or i32 [[TMP5]], [[TMP4]]
; CHECK-NEXT:    [[TMP7:%.*]] = icmp eq i32 [[TMP6]], 0
; CHECK-NEXT:    br i1 [[TMP7]], label [[MALLOC:%.*]], label [[TMP20:%.*]]
; CHECK:       Malloc:
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr addrspace(1) getelementptr inbounds ([[LLVM_AMDGCN_SW_LDS_ATOMIC_XCHG_KERNEL_MD_TYPE:%.*]], ptr addrspace(1) @llvm.amdgcn.sw.lds.atomic_xchg_kernel.md, i32 0, i32 1, i32 0), align 4
; CHECK-NEXT:    [[TMP9:%.*]] = load i32, ptr addrspace(1) getelementptr inbounds ([[LLVM_AMDGCN_SW_LDS_ATOMIC_XCHG_KERNEL_MD_TYPE]], ptr addrspace(1) @llvm.amdgcn.sw.lds.atomic_xchg_kernel.md, i32 0, i32 1, i32 2), align 4
; CHECK-NEXT:    [[TMP10:%.*]] = add i32 [[TMP8]], [[TMP9]]
; CHECK-NEXT:    [[TMP11:%.*]] = zext i32 [[TMP10]] to i64
; CHECK-NEXT:    [[TMP12:%.*]] = call ptr @llvm.returnaddress(i32 0)
; CHECK-NEXT:    [[TMP13:%.*]] = ptrtoint ptr [[TMP12]] to i64
; CHECK-NEXT:    [[TMP14:%.*]] = call i64 @__asan_malloc_impl(i64 [[TMP11]], i64 [[TMP13]])
; CHECK-NEXT:    [[TMP15:%.*]] = inttoptr i64 [[TMP14]] to ptr addrspace(1)
; CHECK-NEXT:    store ptr addrspace(1) [[TMP15]], ptr addrspace(3) @llvm.amdgcn.sw.lds.atomic_xchg_kernel, align 8
; CHECK-NEXT:    [[TMP16:%.*]] = getelementptr inbounds i8, ptr addrspace(1) [[TMP15]], i64 8
; CHECK-NEXT:    [[TMP17:%.*]] = ptrtoint ptr addrspace(1) [[TMP16]] to i64
; CHECK-NEXT:    call void @__asan_poison_region(i64 [[TMP17]], i64 24)
; CHECK-NEXT:    [[TMP18:%.*]] = getelementptr inbounds i8, ptr addrspace(1) [[TMP15]], i64 36
; CHECK-NEXT:    [[TMP19:%.*]] = ptrtoint ptr addrspace(1) [[TMP18]] to i64
; CHECK-NEXT:    call void @__asan_poison_region(i64 [[TMP19]], i64 28)
; CHECK-NEXT:    br label [[TMP20]]
; CHECK:       20:
; CHECK-NEXT:    [[XYZCOND:%.*]] = phi i1 [ false, [[WID:%.*]] ], [ true, [[MALLOC]] ]
; CHECK-NEXT:    call void @llvm.amdgcn.s.barrier()
; CHECK-NEXT:    [[TMP21:%.*]] = load ptr addrspace(1), ptr addrspace(3) @llvm.amdgcn.sw.lds.atomic_xchg_kernel, align 8
; CHECK-NEXT:    [[TMP22:%.*]] = load i32, ptr addrspace(1) getelementptr inbounds ([[LLVM_AMDGCN_SW_LDS_ATOMIC_XCHG_KERNEL_MD_TYPE]], ptr addrspace(1) @llvm.amdgcn.sw.lds.atomic_xchg_kernel.md, i32 0, i32 1, i32 0), align 4
; CHECK-NEXT:    [[TMP23:%.*]] = getelementptr inbounds i8, ptr addrspace(3) @llvm.amdgcn.sw.lds.atomic_xchg_kernel, i32 [[TMP22]]
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i32, ptr addrspace(3) [[TMP23]], i32 4
; CHECK-NEXT:    [[TMP24:%.*]] = ptrtoint ptr addrspace(3) [[GEP]] to i32
; CHECK-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i8, ptr addrspace(1) [[TMP21]], i32 [[TMP24]]
; CHECK-NEXT:    [[TMP26:%.*]] = ptrtoint ptr addrspace(1) [[TMP25]] to i64
; CHECK-NEXT:    [[TMP32:%.*]] = add i64 [[TMP26]], 3
; CHECK-NEXT:    [[TMP59:%.*]] = inttoptr i64 [[TMP32]] to ptr addrspace(1)
; CHECK-NEXT:    [[TMP60:%.*]] = ptrtoint ptr addrspace(1) [[TMP25]] to i64
; CHECK-NEXT:    [[TMP27:%.*]] = lshr i64 [[TMP60]], 3
; CHECK-NEXT:    [[TMP28:%.*]] = add i64 [[TMP27]], 2147450880
; CHECK-NEXT:    [[TMP29:%.*]] = inttoptr i64 [[TMP28]] to ptr
; CHECK-NEXT:    [[TMP30:%.*]] = load i8, ptr [[TMP29]], align 1
; CHECK-NEXT:    [[TMP31:%.*]] = icmp ne i8 [[TMP30]], 0
; CHECK-NEXT:    [[TMP33:%.*]] = and i64 [[TMP60]], 7
; CHECK-NEXT:    [[TMP34:%.*]] = trunc i64 [[TMP33]] to i8
; CHECK-NEXT:    [[TMP35:%.*]] = icmp sge i8 [[TMP34]], [[TMP30]]
; CHECK-NEXT:    [[TMP36:%.*]] = and i1 [[TMP31]], [[TMP35]]
; CHECK-NEXT:    [[TMP37:%.*]] = call i64 @llvm.amdgcn.ballot.i64(i1 [[TMP36]])
; CHECK-NEXT:    [[TMP38:%.*]] = icmp ne i64 [[TMP37]], 0
; CHECK-NEXT:    br i1 [[TMP38]], label [[ASAN_REPORT:%.*]], label [[TMP41:%.*]], !prof [[PROF2:![0-9]+]]
; CHECK:       asan.report:
; CHECK-NEXT:    br i1 [[TMP36]], label [[TMP39:%.*]], label [[TMP40:%.*]]
; CHECK:       41:
; CHECK-NEXT:    call void @__asan_report_store1(i64 [[TMP60]]) #[[ATTR6:[0-9]+]]
; CHECK-NEXT:    call void @llvm.amdgcn.unreachable()
; CHECK-NEXT:    br label [[TMP40]]
; CHECK:       42:
; CHECK-NEXT:    br label [[TMP41]]
; CHECK:       43:
; CHECK-NEXT:    [[TMP61:%.*]] = ptrtoint ptr addrspace(1) [[TMP59]] to i64
; CHECK-NEXT:    [[TMP62:%.*]] = lshr i64 [[TMP61]], 3
; CHECK-NEXT:    [[TMP46:%.*]] = add i64 [[TMP62]], 2147450880
; CHECK-NEXT:    [[TMP47:%.*]] = inttoptr i64 [[TMP46]] to ptr
; CHECK-NEXT:    [[TMP48:%.*]] = load i8, ptr [[TMP47]], align 1
; CHECK-NEXT:    [[TMP49:%.*]] = icmp ne i8 [[TMP48]], 0
; CHECK-NEXT:    [[TMP50:%.*]] = and i64 [[TMP61]], 7
; CHECK-NEXT:    [[TMP51:%.*]] = trunc i64 [[TMP50]] to i8
; CHECK-NEXT:    [[TMP52:%.*]] = icmp sge i8 [[TMP51]], [[TMP48]]
; CHECK-NEXT:    [[TMP53:%.*]] = and i1 [[TMP49]], [[TMP52]]
; CHECK-NEXT:    [[TMP54:%.*]] = call i64 @llvm.amdgcn.ballot.i64(i1 [[TMP53]])
; CHECK-NEXT:    [[TMP55:%.*]] = icmp ne i64 [[TMP54]], 0
; CHECK-NEXT:    br i1 [[TMP55]], label [[ASAN_REPORT1:%.*]], label [[TMP58:%.*]], !prof [[PROF2]]
; CHECK:       asan.report1:
; CHECK-NEXT:    br i1 [[TMP53]], label [[TMP56:%.*]], label [[TMP57:%.*]]
; CHECK:       56:
; CHECK-NEXT:    call void @__asan_report_store1(i64 [[TMP61]]) #[[ATTR6]]
; CHECK-NEXT:    call void @llvm.amdgcn.unreachable()
; CHECK-NEXT:    br label [[TMP57]]
; CHECK:       57:
; CHECK-NEXT:    br label [[TMP58]]
; CHECK:       58:
; CHECK-NEXT:    [[TMP42:%.*]] = cmpxchg ptr addrspace(1) [[TMP25]], i32 7, i32 [[SWAP]] seq_cst monotonic, align 4
; CHECK-NEXT:    [[RESULT:%.*]] = extractvalue { i32, i1 } [[TMP42]], 0
; CHECK-NEXT:    store i32 [[RESULT]], ptr addrspace(1) [[OUT]], align 4
; CHECK-NEXT:    br label [[CONDFREE:%.*]]
; CHECK:       CondFree:
; CHECK-NEXT:    call void @llvm.amdgcn.s.barrier()
; CHECK-NEXT:    br i1 [[XYZCOND]], label [[FREE:%.*]], label [[END:%.*]]
; CHECK:       Free:
; CHECK-NEXT:    [[TMP43:%.*]] = call ptr @llvm.returnaddress(i32 0)
; CHECK-NEXT:    [[TMP44:%.*]] = ptrtoint ptr [[TMP43]] to i64
; CHECK-NEXT:    [[TMP45:%.*]] = ptrtoint ptr addrspace(1) [[TMP21]] to i64
; CHECK-NEXT:    call void @__asan_free_impl(i64 [[TMP45]], i64 [[TMP44]])
; CHECK-NEXT:    br label [[END]]
; CHECK:       End:
; CHECK-NEXT:    ret void
;
  %gep = getelementptr i32, ptr addrspace(3) @lds_1, i32 4
  %pair = cmpxchg ptr addrspace(3) %gep, i32 7, i32 %swap seq_cst monotonic
  %result = extractvalue { i32, i1 } %pair, 0
  store i32 %result, ptr addrspace(1) %out, align 4
  ret void
}

!llvm.module.flags = !{!0}
!0 = !{i32 4, !"nosanitize_address", i32 1}

;.
; CHECK: attributes #[[ATTR0]] = { sanitize_address "amdgpu-lds-size"="8" }
; CHECK: attributes #[[ATTR1:[0-9]+]] = { nocallback nofree nosync nounwind speculatable willreturn memory(none) }
; CHECK: attributes #[[ATTR2:[0-9]+]] = { nocallback nofree nosync nounwind willreturn memory(none) }
; CHECK: attributes #[[ATTR3:[0-9]+]] = { convergent nocallback nofree nounwind willreturn }
; CHECK: attributes #[[ATTR4:[0-9]+]] = { convergent nocallback nofree nounwind willreturn memory(none) }
; CHECK: attributes #[[ATTR5:[0-9]+]] = { convergent nocallback nofree nounwind }
; CHECK: attributes #[[ATTR6]] = { nomerge }
;.
; CHECK: [[META0]] = !{i32 0, i32 1}
; CHECK: [[META1:![0-9]+]] = !{i32 4, !"nosanitize_address", i32 1}
; CHECK: [[PROF2]] = !{!"branch_weights", i32 1, i32 1048575}
;.
