; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; radr://6772169
; RUN: llc < %s -fast-isel | FileCheck %s --check-prefix=FASTISEL
; PR30981
; RUN: llc < %s -O0 -mcpu=x86-64 -mattr=+avx512f | FileCheck %s --check-prefix=AVX512F
target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128"
target triple = "x86_64-apple-darwin10"

declare { i32, i1 } @llvm.sadd.with.overflow.i32(i32, i32) nounwind

define fastcc i32 @test() nounwind {
; FASTISEL-LABEL: test:
; FASTISEL:       ## %bb.0: ## %entry
; FASTISEL-NEXT:    movl $1, %eax
; FASTISEL-NEXT:    addl $0, %eax
; FASTISEL-NEXT:    xorl %eax, %eax
; FASTISEL-NEXT:    retq
;
; AVX512F-LABEL: test:
; AVX512F:       ## %bb.0: ## %entry
; AVX512F-NEXT:    movl $1, %eax
; AVX512F-NEXT:    addl $0, %eax
; AVX512F-NEXT:    seto %al
; AVX512F-NEXT:    jo LBB0_2
; AVX512F-NEXT:  ## %bb.1: ## %BB3
; AVX512F-NEXT:  LBB0_2: ## %.backedge
; AVX512F-NEXT:    xorl %eax, %eax
; AVX512F-NEXT:    retq
entry:
	%tmp1 = call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 1, i32 0)
	%tmp2 = extractvalue { i32, i1 } %tmp1, 1
	br i1 %tmp2, label %.backedge, label %BB3

BB3:
	%tmp4 = extractvalue { i32, i1 } %tmp1, 0
	br label %.backedge

.backedge:
	ret i32 0
}
