; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals
; RUN: opt < %s -passes=simplifycfg -simplifycfg-require-and-preserve-domtree=1 -S | FileCheck %s

declare void @llvm.lifetime.start.p0(i64, ptr)
declare void @llvm.lifetime.end.p0(i64, ptr)

declare void @escape(ptr)

declare void @throwing_callee_foo()
declare void @throwing_callee_bar()

declare i32 @__gxx_personality_v0(...)

define void @caller(i1 %c) personality ptr @__gxx_personality_v0 {
; CHECK-LABEL: @caller(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[I0:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 4, ptr nonnull [[I0]])
; CHECK-NEXT:    call void @escape(ptr [[I0]])
; CHECK-NEXT:    [[I2:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 4, ptr nonnull [[I2]])
; CHECK-NEXT:    call void @escape(ptr [[I2]])
; CHECK-NEXT:    [[I4:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 4, ptr nonnull [[I4]])
; CHECK-NEXT:    call void @escape(ptr [[I4]])
; CHECK-NEXT:    [[I6:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 4, ptr nonnull [[I6]])
; CHECK-NEXT:    call void @escape(ptr [[I6]])
; CHECK-NEXT:    br i1 [[C:%.*]], label [[V0:%.*]], label [[V1:%.*]]
; CHECK:       v0:
; CHECK-NEXT:    call void @throwing_callee_foo()
; CHECK-NEXT:    unreachable
; CHECK:       v1:
; CHECK-NEXT:    call void @throwing_callee_bar()
; CHECK-NEXT:    unreachable
;
entry:
  %i0 = alloca i32
  call void @llvm.lifetime.start.p0(i64 4, ptr nonnull %i0)
  call void @escape(ptr %i0)

  %i2 = alloca i32
  call void @llvm.lifetime.start.p0(i64 4, ptr nonnull %i2)
  call void @escape(ptr %i2)

  %i4 = alloca i32
  call void @llvm.lifetime.start.p0(i64 4, ptr nonnull %i4)
  call void @escape(ptr %i4)

  %i6 = alloca i32
  call void @llvm.lifetime.start.p0(i64 4, ptr nonnull %i6)
  call void @escape(ptr %i6)

  br i1 %c, label %v0, label %v1

v0:
  invoke void @throwing_callee_foo()
  to label %invoke.cont unwind label %lpad.v0

v1:
  invoke void @throwing_callee_bar()
  to label %invoke.cont unwind label %lpad.v1

invoke.cont:
  unreachable

lpad.v0:
  %i8 = landingpad { ptr, i32 } cleanup
  call void @llvm.lifetime.end.p0(i64 4, ptr nonnull %i0)
  br label %end

lpad.v1:
  %i9 = landingpad { ptr, i32 } cleanup
  call void @llvm.lifetime.end.p0(i64 4, ptr nonnull %i2)
  br label %end

end:
  %i10 = phi { ptr, i32 } [ %i8, %lpad.v0 ], [ %i9, %lpad.v1 ]
  %i11 = phi ptr [ %i4, %lpad.v0 ], [ %i6, %lpad.v1 ]
  call void @llvm.lifetime.end.p0(i64 4, ptr nonnull %i11)
  resume { ptr, i32 } %i10
}
;.
; CHECK: attributes #[[ATTR0:[0-9]+]] = { nocallback nofree nosync nounwind willreturn memory(argmem: readwrite) }
;.
