; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define i32 @shl_cttz_false(i32 %x, i32 %y) {
; CHECK-LABEL: define i32 @shl_cttz_false(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CTTZ:%.*]] = call range(i32 0, 33) i32 @llvm.cttz.i32(i32 [[Y]], i1 true)
; CHECK-NEXT:    [[RES:%.*]] = shl i32 [[X]], [[CTTZ]]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %cttz = call i32 @llvm.cttz.i32(i32 %y, i1 false)
  %res = shl i32 %x, %cttz
  ret i32 %res
}

; Make sure that noundef is dropped.

define i32 @shl_cttz_false_noundef(i32 %x, i32 %y) {
; CHECK-LABEL: define i32 @shl_cttz_false_noundef(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CTTZ:%.*]] = call range(i32 0, 33) i32 @llvm.cttz.i32(i32 [[Y]], i1 true)
; CHECK-NEXT:    [[RES:%.*]] = shl i32 [[X]], [[CTTZ]]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %cttz = call noundef i32 @llvm.cttz.i32(i32 %y, i1 false)
  %res = shl i32 %x, %cttz
  ret i32 %res
}

define i32 @shl_ctlz_false(i32 %x, i32 %y) {
; CHECK-LABEL: define i32 @shl_ctlz_false(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CTTZ:%.*]] = call range(i32 0, 33) i32 @llvm.ctlz.i32(i32 [[Y]], i1 true)
; CHECK-NEXT:    [[RES:%.*]] = shl i32 [[X]], [[CTTZ]]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %cttz = call i32 @llvm.ctlz.i32(i32 %y, i1 false)
  %res = shl i32 %x, %cttz
  ret i32 %res
}

define i32 @lshr_cttz_false(i32 %x, i32 %y) {
; CHECK-LABEL: define i32 @lshr_cttz_false(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CTTZ:%.*]] = call range(i32 0, 33) i32 @llvm.cttz.i32(i32 [[Y]], i1 true)
; CHECK-NEXT:    [[RES:%.*]] = lshr i32 [[X]], [[CTTZ]]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %cttz = call i32 @llvm.cttz.i32(i32 %y, i1 false)
  %res = lshr i32 %x, %cttz
  ret i32 %res
}

define i32 @ashr_cttz_false(i32 %x, i32 %y) {
; CHECK-LABEL: define i32 @ashr_cttz_false(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CTTZ:%.*]] = call range(i32 0, 33) i32 @llvm.cttz.i32(i32 [[Y]], i1 true)
; CHECK-NEXT:    [[RES:%.*]] = ashr i32 [[X]], [[CTTZ]]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %cttz = call i32 @llvm.cttz.i32(i32 %y, i1 false)
  %res = ashr i32 %x, %cttz
  ret i32 %res
}

define i32 @shl_cttz_false_multiuse(i32 %x, i32 %y) {
; CHECK-LABEL: define i32 @shl_cttz_false_multiuse(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CTTZ:%.*]] = call range(i32 0, 33) i32 @llvm.cttz.i32(i32 [[Y]], i1 false)
; CHECK-NEXT:    call void @use(i32 [[CTTZ]])
; CHECK-NEXT:    [[RES:%.*]] = shl i32 [[X]], [[CTTZ]]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %cttz = call i32 @llvm.cttz.i32(i32 %y, i1 false)
  call void @use(i32 %cttz)
  %res = shl i32 %x, %cttz
  ret i32 %res
}

define i32 @shl_cttz_as_lhs(i32 %x, i32 %y) {
; CHECK-LABEL: define i32 @shl_cttz_as_lhs(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CTTZ:%.*]] = call range(i32 0, 33) i32 @llvm.cttz.i32(i32 [[Y]], i1 false)
; CHECK-NEXT:    [[RES:%.*]] = shl i32 [[CTTZ]], [[X]]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %cttz = call i32 @llvm.cttz.i32(i32 %y, i1 false)
  %res = shl i32 %cttz, %x
  ret i32 %res
}

declare void @use(i32)
