/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (c) Aspeed Technology Inc.
 */
#ifndef __ASM_AST2700_SCU_H__
#define __ASM_AST2700_SCU_H__

/* SCU0: CPU-die SCU */
#define SCU0_HWSTRAP				0x010
#define   SCU0_HWSTRAP_DIS_RVAS			BIT(30)
#define   SCU0_HWSTRAP_DIS_WDTFULL		BIT(25)
#define   SCU0_HWSTRAP_DISARMICE_TZ		BIT(22)
#define   SCU0_HWSTRAP_DISABLE_XHCI		BIT(21)
#define   SCU0_HWSTRAP_BOOTEMMCSPEED		BIT(20)
#define   SCU0_HWSTRAP_VGA_CC			BIT(18)
#define   SCU0_HWSTRAP_EN_OPROM			BIT(17)
#define   SCU0_HWSTRAP_DISARMICE		BIT(16)
#define   SCU0_HWSTRAP_TSPRSNTSEL		BIT(9)
#define   SCU0_HWSTRAP_DISDEBUG			BIT(8)
#define   SCU0_HWSTRAP_HCLKHPLL			BIT(7)
#define   SCU0_HWSTRAP_HCLKSEL			GENMASK(6, 5)
#define   SCU0_HWSTRAP_CPUHPLL			BIT(4)
#define   SCU0_HWSTRAP_HPLLFREQ			GENMASK(3, 2)
#define   SCU0_HWSTRAP_BOOTSPI			BIT(1)
#define   SCU0_HWSTRAP_HWSTRAP_DISCPU		BIT(0)
#define SCU0_DBGCTL				0x0c8
#define   SCU0_DBGCTL_MASK			GENMASK(14, 0)
#define   SCU0_DBGCTL_UARTDBG			BIT(1)
#define SCU0_RSTCTL1				0x200
#define   SCU0_RSTCTL1_EMMC			BIT(17)
#define   SCU0_RSTCTL1_HACE			BIT(4)
#define SCU0_RSTCTL1_CLR			0x204
#define   SCU0_RSTCTL1_CLR_EMMC			BIT(17)
#define   SCU0_RSTCTL1_CLR_HACE			BIT(4)
#define SCU0_CLKGATE1				0x240
#define   SCU0_CLKGATE1_EMMC			BIT(27)
#define   SCU0_CLKGATE1_HACE			BIT(13)
#define   SCU0_CLKGATE1_DDRPHY			BIT(11)
#define SCU0_CLKGATE1_CLR			0x244
#define   SCU0_CLKGATE1_CLR_EMMC		BIT(27)
#define   SCU0_CLKGATE1_CLR_HACE		BIT(13)
#define   SCU0_CLKGATE1_CLR_DDRPHY		BIT(11)
#define SCU0_VGA0_SCRATCH			0x900
#define   SCU0_VGA0_SCRATCH_DRAM_INIT		BIT(6)
#define SCU0_PCI_MISC70				0xa70
#define   SCU0_PCI_MISC70_EN_PCIEXHCI0		BIT(3)
#define   SCU0_PCI_MISC70_EN_PCIEEHCI0		BIT(2)
#define   SCU0_PCI_MISC70_EN_PCIEVGA0		BIT(0)
#define SCU0_PCI_MISC80				0xa80
#define   SCU0_PCI_MISC80_EN_PCIEXHCI1		BIT(3)
#define   SCU0_PCI_MISC80_EN_PCIEEHCI1		BIT(2)
#define   SCU0_PCI_MISC80_EN_PCIEVGA1		BIT(0)
#define SCU0_PCI_MISCF0				0xaf0
#define   SCU0_PCI_MISCF0_EN_PCIEXHCI1		BIT(3)
#define   SCU0_PCI_MISCF0_EN_PCIEEHCI1		BIT(2)
#define   SCU0_PCI_MISCF0_EN_PCIEVGA1		BIT(0)
#define SCU0_WPROT1				0xe04
#define   SCU0_WPROT1_0C8			BIT(18)

/* SCU1: IO-die SCU */
#define SCU1_REVISION				0x000
#define   SCU1_REVISION_HWID			GENMASK(23, 16)
#define   SCU1_REVISION_CHIP_EFUSE		GENMASK(15, 8)
#define SCU1_HWSTRAP1				0x010
#define   SCU1_HWSTRAP1_DIS_CPTRA		BIT(30)
#define   SCU1_HWSTRAP1_RECOVERY_USB_PORT	GENMASK(29, 28)
#define   SCU1_HWSTRAP1_RECOVERY_INTERFACE	GENMASK(27, 26)
#define   SCU1_HWSTRAP1_RECOVERY_I3C		(BIT(26) | BIT(27))
#define   SCU1_HWSTRAP1_RECOVERY_I2C		BIT(27)
#define   SCU1_HWSTRAP1_RECOVERY_USB		BIT(26)
#define   SCU1_HWSTRAP1_SPI_FLASH_4_BYTE_MODE	BIT(25)
#define   SCU1_HWSTRAP1_SPI_FLASH_WAIT_READY	BIT(24)
#define   SCU1_HWSTRAP1_BOOT_UFS		BIT(23)
#define   SCU1_HWSTRAP1_DIS_ROM			BIT(22)
#define   SCU1_HWSTRAP1_DIS_CPTRAJTAG		BIT(20)
#define   SCU1_HWSTRAP1_UARTDBGSEL		BIT(19)
#define   SCU1_HWSTRAP1_DIS_UARTDBG		BIT(18)
#define   SCU1_HWSTRAP1_DIS_WDTFULL		BIT(17)
#define   SCU1_HWSTRAP1_DISDEBUG1		BIT(16)
#define   SCU1_HWSTRAP1_LTPI0_IO_DRIVING	GENMASK(15, 14)
#define   SCU1_HWSTRAP1_ACPI_1			BIT(13)
#define   SCU1_HWSTRAP1_ACPI_0			BIT(12)
#define   SCU1_HWSTRAP1_BOOT_EMMC_UFS		BIT(11)
#define   SCU1_HWSTRAP1_DDR4			BIT(10)
#define   SCU1_HWSTRAP1_LOW_SECURE		BIT(8)
#define   SCU1_HWSTRAP1_EN_EMCS			BIT(7)
#define   SCU1_HWSTRAP1_EN_GPIOPT		BIT(6)
#define   SCU1_HWSTRAP1_EN_SECBOOT		BIT(5)
#define   SCU1_HWSTRAP1_EN_RECOVERY_BOOT	BIT(4)
#define   SCU1_HWSTRAP1_LTPI0_EN		BIT(3)
#define   SCU1_HWSTRAP1_LTPI_IDX		BIT(2)
#define   SCU1_HWSTRAP1_LTPI1_EN		BIT(1)
#define   SCU1_HWSTRAP1_LTPI_MODE		BIT(0)
#define SCU1_HWSTRAP2				0x030
#define   SCU1_HWSTRAP2_FMC_ABR_SINGLE_FLASH	BIT(29)
#define   SCU1_HWSTRAP2_FMC_ABR_CS_SWAP_DIS	BIT(28)
#define   SCU1_HWSTRAP2_SPI_TPM_PCR_EXT_EN	BIT(27)
#define   SCU1_HWSTRAP2_SPI_TPM_HASH_ALGO	GENMASK(26, 25)
#define   SCU1_HWSTRAP2_BOOT_SPI_FREQ		GENMASK(24, 23)
#define   SCU1_HWSTRAP2_RESERVED		GENMASK(22, 19)
#define   SCU1_HWSTRAP2_FWSPI_CRTM		GENMASK(18, 17)
#define   SCU1_HWSTRAP2_EN_FWSPIAUX		BIT(16)
#define   SCU1_HWSTRAP2_FWSPISIZE		GENMASK(15, 13)
#define   SCU1_HWSTRAP2_DIS_REC			BIT(12)
#define   SCU1_HWSTRAP2_EN_CPTRA_DBG		BIT(11)
#define   SCU1_HWSTRAP2_TPM_PCR_INDEX		GENMASK(6, 2)
#define   SCU1_HWSTRAP2_ROM_CLEAR_SRAM		BIT(1)
#define   SCU1_HWSTRAP2_ABR			BIT(0)
#define SCU1_RSTLOG0				0x050
#define   SCU1_RSTLOG0_BMC_CPU			BIT(12)
#define   SCU1_RSTLOG0_ABR			BIT(2)
#define   SCU1_RSTLOG0_EXTRSTN			BIT(1)
#define   SCU1_RSTLOG0_SRST			BIT(0)
#define SCU1_MISC1				0x0c0
#define   SCU1_MISC1_UARTDBG_ROUTE		GENMASK(23, 22)
#define   SCU1_MISC1_UART12_ROUTE		GENMASK(21, 20)
#define SCU1_DBGCTL				0x0c8
#define   SCU1_DBGCTL_MASK			GENMASK(7, 0)
#define   SCU1_DBGCTL_UARTDBG			BIT(6)
#define SCU1_RNG_DATA				0x0f4
#define SCU1_RSTCTL1				0x200
#define   SCU1_RSTCTL1_I3C(x)			(BIT(16) << (x))
#define SCU1_RSTCTL1_CLR			0x204
#define   SCU1_RSTCTL1_CLR_I3C(x)		(BIT(16) << (x))
#define SCU1_RSTCTL2				0x220
#define   SCU1_RSTCTL2_LTPI1			BIT(22)
#define   SCU1_RSTCTL2_LTPI0			BIT(20)
#define   SCU1_RSTCTL2_I2C			BIT(15)
#define   SCU1_RSTCTL2_CPTRA			BIT(9)
#define SCU1_RSTCTL2_CLR			0x224
#define   SCU1_RSTCTL2_CLR_I2C			BIT(15)
#define   SCU1_RSTCTL2_CLR_CPTRA		BIT(9)
#define SCU1_CLKGATE1				0x240
#define   SCU1_CLKGATE1_I3C(x)			(BIT(16) << (x))
#define   SCU1_CLKGATE1_I2C			BIT(15)
#define SCU1_CLKGATE1_CLR			0x244
#define   SCU1_CLKGATE1_CLR_I3C(x)		(BIT(16) << (x))
#define   SCU1_CLKGATE1_CLR_I2C			BIT(15)
#define SCU1_CLKGATE2				0x260
#define   SCU1_CLKGATE2_LTPI1_TX		BIT(19)
#define   SCU1_CLKGATE2_LTPI_AHB		BIT(10)
#define   SCU1_CLKGATE2_LTPI0_TX		BIT(9)
#define SCU1_CLKGATE2_CLR			0x264

#endif
