/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_7_1;

import java.util.List;
import org.virtualbox_7_1.DeviceType;
import org.virtualbox_7_1.FirmwareType;
import org.virtualbox_7_1.GraphicsFeature;
import org.virtualbox_7_1.Helper;
import org.virtualbox_7_1.Holder;
import org.virtualbox_7_1.IGuestOSType;
import org.virtualbox_7_1.IUnknown;
import org.virtualbox_7_1.NetworkAdapterType;
import org.virtualbox_7_1.NetworkAttachmentType;
import org.virtualbox_7_1.ObjectRefManager;
import org.virtualbox_7_1.ParavirtProvider;
import org.virtualbox_7_1.USBControllerType;
import org.virtualbox_7_1.VBoxException;
import org.virtualbox_7_1.jaxws.AudioControllerType;
import org.virtualbox_7_1.jaxws.ChipsetType;
import org.virtualbox_7_1.jaxws.GraphicsControllerType;
import org.virtualbox_7_1.jaxws.InvalidObjectFaultMsg;
import org.virtualbox_7_1.jaxws.IommuType;
import org.virtualbox_7_1.jaxws.NetworkAdapterPromiscModePolicy;
import org.virtualbox_7_1.jaxws.RuntimeFaultMsg;
import org.virtualbox_7_1.jaxws.StorageBus;
import org.virtualbox_7_1.jaxws.StorageControllerType;
import org.virtualbox_7_1.jaxws.TpmType;
import org.virtualbox_7_1.jaxws.UartType;
import org.virtualbox_7_1.jaxws.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPlatformProperties
extends IUnknown {
    public IPlatformProperties(String string, ObjectRefManager objectRefManager, VboxPortType vboxPortType) {
        super(string, objectRefManager, vboxPortType);
    }

    public Boolean getRawModeSupported() {
        try {
            Boolean bl = this.port.iPlatformPropertiesGetRawModeSupported(this.obj);
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Boolean getExclusiveHwVirt() {
        try {
            Boolean bl = this.port.iPlatformPropertiesGetExclusiveHwVirt(this.obj);
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public void setExclusiveHwVirt(Boolean bl) {
        try {
            this.port.iPlatformPropertiesSetExclusiveHwVirt(this.obj, bl);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getSerialPortCount() {
        try {
            Long l = this.port.iPlatformPropertiesGetSerialPortCount(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getParallelPortCount() {
        try {
            Long l = this.port.iPlatformPropertiesGetParallelPortCount(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getMaxBootPosition() {
        try {
            Long l = this.port.iPlatformPropertiesGetMaxBootPosition(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<ParavirtProvider> getSupportedParavirtProviders() {
        try {
            List<org.virtualbox_7_1.jaxws.ParavirtProvider> list = this.port.iPlatformPropertiesGetSupportedParavirtProviders(this.obj);
            return Helper.convertEnums(org.virtualbox_7_1.jaxws.ParavirtProvider.class, ParavirtProvider.class, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<FirmwareType> getSupportedFirmwareTypes() {
        try {
            List<org.virtualbox_7_1.jaxws.FirmwareType> list = this.port.iPlatformPropertiesGetSupportedFirmwareTypes(this.obj);
            return Helper.convertEnums(org.virtualbox_7_1.jaxws.FirmwareType.class, FirmwareType.class, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<IGuestOSType> getSupportedGuestOSTypes() {
        this.getObjMgr().preventObjRelease();
        try {
            List<org.virtualbox_7_1.jaxws.IGuestOSType> list = this.port.iPlatformPropertiesGetSupportedGuestOSTypes(this.obj);
            List<IGuestOSType> list2 = Helper.wrap2(IGuestOSType.class, org.virtualbox_7_1.jaxws.IGuestOSType.class, this.objMgr, this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<org.virtualbox_7_1.GraphicsControllerType> getSupportedGfxControllerTypes() {
        try {
            List<GraphicsControllerType> list = this.port.iPlatformPropertiesGetSupportedGfxControllerTypes(this.obj);
            return Helper.convertEnums(GraphicsControllerType.class, org.virtualbox_7_1.GraphicsControllerType.class, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<org.virtualbox_7_1.NetworkAdapterPromiscModePolicy> getSupportedNetAdpPromiscModePols() {
        try {
            List<NetworkAdapterPromiscModePolicy> list = this.port.iPlatformPropertiesGetSupportedNetAdpPromiscModePols(this.obj);
            return Helper.convertEnums(NetworkAdapterPromiscModePolicy.class, org.virtualbox_7_1.NetworkAdapterPromiscModePolicy.class, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<NetworkAdapterType> getSupportedNetworkAdapterTypes() {
        try {
            List<org.virtualbox_7_1.jaxws.NetworkAdapterType> list = this.port.iPlatformPropertiesGetSupportedNetworkAdapterTypes(this.obj);
            return Helper.convertEnums(org.virtualbox_7_1.jaxws.NetworkAdapterType.class, NetworkAdapterType.class, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<org.virtualbox_7_1.UartType> getSupportedUartTypes() {
        try {
            List<UartType> list = this.port.iPlatformPropertiesGetSupportedUartTypes(this.obj);
            return Helper.convertEnums(UartType.class, org.virtualbox_7_1.UartType.class, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<USBControllerType> getSupportedUSBControllerTypes() {
        try {
            List<org.virtualbox_7_1.jaxws.USBControllerType> list = this.port.iPlatformPropertiesGetSupportedUSBControllerTypes(this.obj);
            return Helper.convertEnums(org.virtualbox_7_1.jaxws.USBControllerType.class, USBControllerType.class, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<org.virtualbox_7_1.AudioControllerType> getSupportedAudioControllerTypes() {
        try {
            List<AudioControllerType> list = this.port.iPlatformPropertiesGetSupportedAudioControllerTypes(this.obj);
            return Helper.convertEnums(AudioControllerType.class, org.virtualbox_7_1.AudioControllerType.class, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<DeviceType> getSupportedBootDevices() {
        try {
            List<org.virtualbox_7_1.jaxws.DeviceType> list = this.port.iPlatformPropertiesGetSupportedBootDevices(this.obj);
            return Helper.convertEnums(org.virtualbox_7_1.jaxws.DeviceType.class, DeviceType.class, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<org.virtualbox_7_1.StorageBus> getSupportedStorageBuses() {
        try {
            List<StorageBus> list = this.port.iPlatformPropertiesGetSupportedStorageBuses(this.obj);
            return Helper.convertEnums(StorageBus.class, org.virtualbox_7_1.StorageBus.class, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<org.virtualbox_7_1.StorageControllerType> getSupportedStorageControllerTypes() {
        try {
            List<StorageControllerType> list = this.port.iPlatformPropertiesGetSupportedStorageControllerTypes(this.obj);
            return Helper.convertEnums(StorageControllerType.class, org.virtualbox_7_1.StorageControllerType.class, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<org.virtualbox_7_1.ChipsetType> getSupportedChipsetTypes() {
        try {
            List<ChipsetType> list = this.port.iPlatformPropertiesGetSupportedChipsetTypes(this.obj);
            return Helper.convertEnums(ChipsetType.class, org.virtualbox_7_1.ChipsetType.class, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<org.virtualbox_7_1.IommuType> getSupportedIommuTypes() {
        try {
            List<IommuType> list = this.port.iPlatformPropertiesGetSupportedIommuTypes(this.obj);
            return Helper.convertEnums(IommuType.class, org.virtualbox_7_1.IommuType.class, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<org.virtualbox_7_1.TpmType> getSupportedTpmTypes() {
        try {
            List<TpmType> list = this.port.iPlatformPropertiesGetSupportedTpmTypes(this.obj);
            return Helper.convertEnums(TpmType.class, org.virtualbox_7_1.TpmType.class, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public static IPlatformProperties queryInterface(IUnknown iUnknown) {
        return iUnknown == null ? null : new IPlatformProperties(iUnknown.getWrapped(), iUnknown.getObjMgr(), iUnknown.getRemoteWSPort());
    }

    public Long getMaxNetworkAdapters(org.virtualbox_7_1.ChipsetType chipsetType) {
        try {
            Long l = this.port.iPlatformPropertiesGetMaxNetworkAdapters(this.obj, ChipsetType.fromValue(chipsetType.name()));
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getMaxNetworkAdaptersOfType(org.virtualbox_7_1.ChipsetType chipsetType, NetworkAttachmentType networkAttachmentType) {
        try {
            Long l = this.port.iPlatformPropertiesGetMaxNetworkAdaptersOfType(this.obj, ChipsetType.fromValue(chipsetType.name()), org.virtualbox_7_1.jaxws.NetworkAttachmentType.fromValue(networkAttachmentType.name()));
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getMaxDevicesPerPortForStorageBus(org.virtualbox_7_1.StorageBus storageBus) {
        try {
            Long l = this.port.iPlatformPropertiesGetMaxDevicesPerPortForStorageBus(this.obj, StorageBus.fromValue(storageBus.name()));
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getMinPortCountForStorageBus(org.virtualbox_7_1.StorageBus storageBus) {
        try {
            Long l = this.port.iPlatformPropertiesGetMinPortCountForStorageBus(this.obj, StorageBus.fromValue(storageBus.name()));
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getMaxPortCountForStorageBus(org.virtualbox_7_1.StorageBus storageBus) {
        try {
            Long l = this.port.iPlatformPropertiesGetMaxPortCountForStorageBus(this.obj, StorageBus.fromValue(storageBus.name()));
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getMaxInstancesOfStorageBus(org.virtualbox_7_1.ChipsetType chipsetType, org.virtualbox_7_1.StorageBus storageBus) {
        try {
            Long l = this.port.iPlatformPropertiesGetMaxInstancesOfStorageBus(this.obj, ChipsetType.fromValue(chipsetType.name()), StorageBus.fromValue(storageBus.name()));
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getSupportedVRAMRange(org.virtualbox_7_1.GraphicsControllerType graphicsControllerType, Boolean bl, Holder<Long> holder, Holder<Long> holder2) {
        try {
            javax.xml.ws.Holder holder3 = new javax.xml.ws.Holder();
            javax.xml.ws.Holder holder4 = new javax.xml.ws.Holder();
            javax.xml.ws.Holder holder5 = new javax.xml.ws.Holder();
            this.port.iPlatformPropertiesGetSupportedVRAMRange(this.obj, GraphicsControllerType.fromValue(graphicsControllerType.name()), bl, (javax.xml.ws.Holder<Long>)holder3, (javax.xml.ws.Holder<Long>)holder4, (javax.xml.ws.Holder<Long>)holder5);
            holder.value = holder3.value;
            holder2.value = holder4.value;
            return (Long)holder5.value;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<GraphicsFeature> getSupportedGfxFeaturesForType(org.virtualbox_7_1.GraphicsControllerType graphicsControllerType) {
        try {
            List<org.virtualbox_7_1.jaxws.GraphicsFeature> list = this.port.iPlatformPropertiesGetSupportedGfxFeaturesForType(this.obj, GraphicsControllerType.fromValue(graphicsControllerType.name()));
            return Helper.convertEnums(org.virtualbox_7_1.jaxws.GraphicsFeature.class, GraphicsFeature.class, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<DeviceType> getDeviceTypesForStorageBus(org.virtualbox_7_1.StorageBus storageBus) {
        try {
            List<org.virtualbox_7_1.jaxws.DeviceType> list = this.port.iPlatformPropertiesGetDeviceTypesForStorageBus(this.obj, StorageBus.fromValue(storageBus.name()));
            return Helper.convertEnums(org.virtualbox_7_1.jaxws.DeviceType.class, DeviceType.class, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public org.virtualbox_7_1.StorageBus getStorageBusForControllerType(org.virtualbox_7_1.StorageControllerType storageControllerType) {
        try {
            StorageBus storageBus = this.port.iPlatformPropertiesGetStorageBusForControllerType(this.obj, StorageControllerType.fromValue(storageControllerType.name()));
            return org.virtualbox_7_1.StorageBus.fromValue(storageBus.value());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<org.virtualbox_7_1.StorageControllerType> getStorageControllerTypesForBus(org.virtualbox_7_1.StorageBus storageBus) {
        try {
            List<StorageControllerType> list = this.port.iPlatformPropertiesGetStorageControllerTypesForBus(this.obj, StorageBus.fromValue(storageBus.name()));
            return Helper.convertEnums(StorageControllerType.class, org.virtualbox_7_1.StorageControllerType.class, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Boolean getStorageControllerHotplugCapable(org.virtualbox_7_1.StorageControllerType storageControllerType) {
        try {
            Boolean bl = this.port.iPlatformPropertiesGetStorageControllerHotplugCapable(this.obj, StorageControllerType.fromValue(storageControllerType.name()));
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getMaxInstancesOfUSBControllerType(org.virtualbox_7_1.ChipsetType chipsetType, USBControllerType uSBControllerType) {
        try {
            Long l = this.port.iPlatformPropertiesGetMaxInstancesOfUSBControllerType(this.obj, ChipsetType.fromValue(chipsetType.name()), org.virtualbox_7_1.jaxws.USBControllerType.fromValue(uSBControllerType.name()));
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }
}

