# This file has been autogenerated by the pywayland scanner

# Copyright © 2023 Carlos Garnacho
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import Global, Interface, Proxy, Resource


class XdgDialogV1(Interface):
    """Dialog object

    A :class:`XdgDialogV1` object is an ancillary object tied to a
    :class:`~pywayland.protocol.xdg_shell.XdgToplevel`. Its purpose is hinting
    the compositor that the toplevel is a "dialog" (e.g. a temporary window)
    relative to another toplevel (see :func:`XdgToplevel.set_parent()
    <pywayland.protocol.xdg_shell.XdgToplevel.set_parent>`). If the
    :class:`~pywayland.protocol.xdg_shell.XdgToplevel` is destroyed, the
    :class:`XdgDialogV1` becomes inert.

    Through this object, the client may provide additional hints about the
    purpose of the secondary toplevel. This interface has no effect on
    toplevels that are not attached to a parent toplevel.
    """

    name = "xdg_dialog_v1"
    version = 1


class XdgDialogV1Proxy(Proxy[XdgDialogV1]):
    interface = XdgDialogV1

    @XdgDialogV1.request()
    def destroy(self) -> None:
        """Destroy the dialog object

        Destroys the :class:`XdgDialogV1` object. If this object is destroyed
        before the related :class:`~pywayland.protocol.xdg_shell.XdgToplevel`,
        the compositor should unapply its effects.
        """
        self._marshal(0)
        self._destroy()

    @XdgDialogV1.request()
    def set_modal(self) -> None:
        """Mark dialog as modal

        Hints that the dialog has "modal" behavior. Modal dialogs typically
        require to be fully addressed by the user (i.e. closed) before resuming
        interaction with the parent toplevel, and may require a distinct
        presentation.

        Clients must implement the logic to filter events in the parent
        toplevel on their own.

        Compositors may choose any policy in event delivery to the parent
        toplevel, from delivering all events unfiltered to using them for
        internal consumption.
        """
        self._marshal(1)

    @XdgDialogV1.request()
    def unset_modal(self) -> None:
        """Mark dialog as not modal

        Drops the hint that this dialog has "modal" behavior. See
        :func:`XdgDialogV1.set_modal()` for more details.
        """
        self._marshal(2)


class XdgDialogV1Resource(Resource):
    interface = XdgDialogV1


class XdgDialogV1Global(Global):
    interface = XdgDialogV1


XdgDialogV1._gen_c()
XdgDialogV1.proxy_class = XdgDialogV1Proxy
XdgDialogV1.resource_class = XdgDialogV1Resource
XdgDialogV1.global_class = XdgDialogV1Global
