/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.children;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.util.Mutex;

public class ChildrenSupport {
    static final int NO_CHILDREN_CACHED = 0;
    static final int SOME_CHILDREN_CACHED = 1;
    static final int ALL_CHILDREN_CACHED = 2;
    private Set<FileNaming> notExistingChildren;
    private Set<FileNaming> existingChildren;
    private int status = 0;
    private static final Mutex.Privileged mutexPrivileged = new Mutex.Privileged();
    private static final Mutex mutex = new Mutex(mutexPrivileged);

    public final Mutex.Privileged getMutexPrivileged() {
        return mutexPrivileged;
    }

    public static boolean isLock() {
        return mutex.isReadAccess() || mutex.isWriteAccess();
    }

    public synchronized Set<FileNaming> getCachedChildren() {
        return new HashSet<FileNaming>(this.getExisting(false));
    }

    public synchronized Set<FileNaming> getChildren(FileNaming fileNaming, boolean bl, Runnable[] runnableArray) {
        if (bl || !this.isStatus(2)) {
            if (this.rescanChildren(fileNaming, false, runnableArray) == null) {
                return null;
            }
            this.setStatus(2);
        }
        return this.getExisting(false);
    }

    public boolean isCacheInitialized() {
        return !this.isStatus(0);
    }

    public synchronized FileNaming getChild(String string, FileNaming fileNaming, boolean bl) {
        return this.getChild(string, fileNaming, bl, null);
    }

    public synchronized FileNaming getChild(String string, FileNaming fileNaming, boolean bl, Runnable[] runnableArray) {
        FileNaming fileNaming2 = null;
        if (bl || this.isStatus(0)) {
            fileNaming2 = this.rescanChild(fileNaming, string, bl, runnableArray);
        } else if (this.isStatus(1)) {
            fileNaming2 = this.lookupChildInCache(fileNaming, string, true);
            if (fileNaming2 == null && this.lookupChildInCache(fileNaming, string, false) == null) {
                fileNaming2 = this.rescanChild(fileNaming, string, bl, runnableArray);
            }
        } else if (this.isStatus(2)) {
            fileNaming2 = this.lookupChildInCache(fileNaming, string, true);
        }
        this.setStatus(1);
        return fileNaming2;
    }

    public synchronized void removeChild(FileNaming fileNaming, FileNaming fileNaming2) {
        assert (fileNaming2 != null);
        this.getExisting().remove(fileNaming2);
        if (fileNaming2.getParent().equals(fileNaming)) {
            this.getNotExisting().add(fileNaming2);
        }
    }

    private synchronized void addChild(FileNaming fileNaming, FileNaming fileNaming2) {
        assert (fileNaming2 != null);
        assert (fileNaming2.getParent().equals(fileNaming)) : "childName: " + fileNaming2.getFile() + " folderName: " + fileNaming.getFile();
        this.getExisting().add(fileNaming2);
        this.getNotExisting().remove(fileNaming2);
    }

    public synchronized Map<FileNaming, Integer> refresh(FileNaming fileNaming, Runnable[] runnableArray) {
        Map<FileNaming, Integer> map = new HashMap<FileNaming, Integer>();
        HashSet<FileNaming> hashSet = new HashSet<FileNaming>(this.getExisting(false));
        HashSet<FileNaming> hashSet2 = new HashSet<FileNaming>(this.getNotExisting(false));
        if (this.isStatus(1)) {
            FileNaming fileNaming2;
            HashSet<FileNaming> hashSet3 = new HashSet<FileNaming>(hashSet);
            for (FileNaming object2 : hashSet3) {
                fileNaming2 = this.rescanChild(fileNaming, object2.getName(), true, true);
                if (fileNaming2 != null) continue;
                map.put(object2, ChildrenCache.REMOVED_CHILD);
            }
            HashSet<FileNaming> hashSet4 = new HashSet<FileNaming>(hashSet2);
            Iterator iterator = hashSet4.iterator();
            while (iterator.hasNext()) {
                fileNaming2 = (FileNaming)iterator.next();
                assert (fileNaming2 != null);
                FileNaming fileNaming3 = this.rescanChild(fileNaming, fileNaming2.getName(), true, false);
                if (fileNaming3 == null) continue;
                map.put(fileNaming2, ChildrenCache.ADDED_CHILD);
            }
        } else if (this.isStatus(2)) {
            map = this.rescanChildren(fileNaming, true, runnableArray);
        }
        return map;
    }

    public String toString() {
        return this.getExisting(false).toString();
    }

    boolean isStatus(int n) {
        return this.status == n;
    }

    private void setStatus(int n) {
        if (this.status < n) {
            this.status = n;
        }
    }

    private FileNaming rescanChild(FileNaming fileNaming, String string, boolean bl, Runnable[] runnableArray) {
        return this.rescanChild(fileNaming, string, bl, true, runnableArray);
    }

    private FileNaming rescanChild(FileNaming fileNaming, String string, boolean bl, boolean bl2) {
        return this.rescanChild(fileNaming, string, bl, bl2, null);
    }

    private FileNaming rescanChild(final FileNaming fileNaming, String string, final boolean bl, final boolean bl2, Runnable[] runnableArray) {
        class IOJob
        implements Runnable {
            private FileNaming fileNaming = null;

            IOJob() {
            }

            @Override
            public void run() {
                boolean bl3 = fileInfo.isConvertibleToFileObject();
                this.fileNaming = bl3 ? NamingFactory.fromFile(fileNaming, file2, bl, bl2) : null;
            }
        }
        IOJob iOJob;
        File file = fileNaming.getFile();
        final File file2 = new File(file, string);
        final FileInfo fileInfo = new FileInfo(file2);
        if (runnableArray != null && runnableArray[0] == null) {
            runnableArray[0] = new IOJob();
            return null;
        }
        if (runnableArray == null) {
            iOJob = new IOJob();
            iOJob.run();
        } else {
            iOJob = (IOJob)runnableArray[0];
        }
        if (iOJob.fileNaming != null) {
            this.addChild(fileNaming, iOJob.fileNaming);
        } else {
            FileName fileName = new FileName(fileNaming, file2, null){

                @Override
                public boolean isDirectory() {
                    return false;
                }

                @Override
                public boolean isFile() {
                    return false;
                }
            };
            this.removeChild(fileNaming, fileName);
        }
        return iOJob.fileNaming;
    }

    private Map<FileNaming, Integer> rescanChildren(final FileNaming fileNaming, final boolean bl, Runnable[] runnableArray) {
        IdentityHashMap<FileNaming, Integer> identityHashMap = new IdentityHashMap<FileNaming, Integer>();
        final File file = fileNaming.getFile();
        assert (fileNaming.getFile().getAbsolutePath().equals(fileNaming.toString()));
        class IOJob
        implements Runnable {
            boolean folderExists;
            Set<FileNaming> newChildren;

            IOJob() {
            }

            @Override
            public void run() {
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    this.newChildren = new LinkedHashSet<FileNaming>();
                    for (int i = 0; i < fileArray.length; ++i) {
                        FileInfo fileInfo = new FileInfo(fileArray[i], 1);
                        if (!fileInfo.isConvertibleToFileObject()) continue;
                        FileNaming fileNaming2 = NamingFactory.fromFile(fileNaming, fileArray[i], bl);
                        this.newChildren.add(fileNaming2);
                    }
                } else {
                    this.folderExists = file.exists();
                }
            }
        }
        if (!(runnableArray[0] instanceof IOJob)) {
            runnableArray[0] = new IOJob();
            return null;
        }
        IOJob iOJob = (IOJob)runnableArray[0];
        if (iOJob.newChildren == null) {
            if (iOJob.folderExists) {
                return identityHashMap;
            }
            iOJob.newChildren = new LinkedHashSet<FileNaming>();
        }
        Set<FileNaming> set = ChildrenSupport.deepMinus(this.getExisting(false), iOJob.newChildren);
        for (FileNaming object2 : set) {
            this.removeChild(fileNaming, object2);
            identityHashMap.put(object2, ChildrenCache.REMOVED_CHILD);
        }
        Set<FileNaming> set2 = ChildrenSupport.deepMinus(iOJob.newChildren, this.getExisting(false));
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            FileNaming fileNaming2 = (FileNaming)iterator.next();
            this.addChild(fileNaming, fileNaming2);
            identityHashMap.put(fileNaming2, ChildrenCache.ADDED_CHILD);
        }
        return identityHashMap;
    }

    private static Set<FileNaming> deepMinus(Set<FileNaming> set, Set<FileNaming> set2) {
        HashMap<FileNaming, FileNaming> hashMap = new HashMap<FileNaming, FileNaming>(set.size() * 2);
        for (FileNaming fileNaming : set) {
            hashMap.put(fileNaming, fileNaming);
        }
        assert (set2 != null);
        for (FileNaming fileNaming : set2) {
            FileNaming fileNaming2 = (FileNaming)hashMap.remove(fileNaming);
            if (fileNaming2 == null || fileNaming2.isFile() == fileNaming.isFile()) continue;
            hashMap.put(fileNaming2, fileNaming2);
        }
        return hashMap.keySet();
    }

    private FileNaming lookupChildInCache(final FileNaming fileNaming, final String string, boolean bl) {
        Set<FileNaming> set;
        final File file = new File(fileNaming.getFile(), string);
        final Integer n = NamingFactory.createID(file);
        class FakeNaming
        implements FileNaming {
            public FileNaming lastEqual;

            FakeNaming() {
            }

            @Override
            public String getName() {
                return string;
            }

            @Override
            public FileNaming getParent() {
                return fileNaming;
            }

            @Override
            public boolean isRoot() {
                return false;
            }

            @Override
            public File getFile() {
                return file;
            }

            @Override
            public Integer getId() {
                return n;
            }

            @Override
            public FileNaming rename(String string2, ProvidedExtensions.IOHandler iOHandler) {
                throw new IllegalStateException();
            }

            public boolean equals(Object object) {
                if (this.hashCode() == object.hashCode() && this.getName().equals(((FileNaming)object).getName())) {
                    assert (this.lastEqual == null) : "Just one can be there";
                    if (object instanceof FileNaming) {
                        this.lastEqual = (FileNaming)object;
                    }
                    return true;
                }
                return false;
            }

            public int hashCode() {
                return n;
            }

            @Override
            public boolean isFile() {
                return this.getFile().isFile();
            }

            @Override
            public boolean isDirectory() {
                return !this.isFile();
            }
        }
        FakeNaming fakeNaming = new FakeNaming();
        Set<FileNaming> set2 = set = bl ? this.getExisting(false) : this.getNotExisting(false);
        if (set.contains(fakeNaming)) {
            assert (fakeNaming.lastEqual != null) : "If cache contains the object, we set lastEqual";
            assert (fakeNaming.lastEqual.getName().equals(string)) : "childName: " + string + " equals: " + fakeNaming.lastEqual;
            return fakeNaming.lastEqual;
        }
        return null;
    }

    private synchronized Set<FileNaming> getExisting() {
        return this.getExisting(true);
    }

    private synchronized Set<FileNaming> getExisting(boolean bl) {
        if (bl && this.existingChildren == null) {
            this.existingChildren = new HashSet<FileNaming>();
        }
        return this.existingChildren != null ? this.existingChildren : Collections.emptySet();
    }

    private synchronized Set<FileNaming> getNotExisting() {
        return this.getNotExisting(true);
    }

    private synchronized Set<FileNaming> getNotExisting(boolean bl) {
        if (bl && this.notExistingChildren == null) {
            this.notExistingChildren = new HashSet<FileNaming>();
        }
        return this.notExistingChildren != null ? this.notExistingChildren : Collections.emptySet();
    }

    protected final synchronized void copyTo(ChildrenSupport childrenSupport, FileNaming fileNaming) {
        assert (childrenSupport != this && childrenSupport.existingChildren == null && childrenSupport.notExistingChildren == null);
        for (FileNaming fileNaming2 : this.getExisting(false)) {
            childrenSupport.getChild(fileNaming2.getName(), fileNaming, true);
        }
        for (FileNaming fileNaming2 : this.getNotExisting(false)) {
            childrenSupport.getChild(fileNaming2.getName(), fileNaming, true);
        }
        childrenSupport.status = this.status;
    }
}

