﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace GuardDuty
{
namespace Model
{
  class StartMalwareScanResult
  {
  public:
    AWS_GUARDDUTY_API StartMalwareScanResult();
    AWS_GUARDDUTY_API StartMalwareScanResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_GUARDDUTY_API StartMalwareScanResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>A unique identifier that gets generated when you invoke the API without any
     * error. Each malware scan has a corresponding scan ID. Using this scan ID, you
     * can monitor the status of your malware scan.</p>
     */
    inline const Aws::String& GetScanId() const{ return m_scanId; }

    /**
     * <p>A unique identifier that gets generated when you invoke the API without any
     * error. Each malware scan has a corresponding scan ID. Using this scan ID, you
     * can monitor the status of your malware scan.</p>
     */
    inline void SetScanId(const Aws::String& value) { m_scanId = value; }

    /**
     * <p>A unique identifier that gets generated when you invoke the API without any
     * error. Each malware scan has a corresponding scan ID. Using this scan ID, you
     * can monitor the status of your malware scan.</p>
     */
    inline void SetScanId(Aws::String&& value) { m_scanId = std::move(value); }

    /**
     * <p>A unique identifier that gets generated when you invoke the API without any
     * error. Each malware scan has a corresponding scan ID. Using this scan ID, you
     * can monitor the status of your malware scan.</p>
     */
    inline void SetScanId(const char* value) { m_scanId.assign(value); }

    /**
     * <p>A unique identifier that gets generated when you invoke the API without any
     * error. Each malware scan has a corresponding scan ID. Using this scan ID, you
     * can monitor the status of your malware scan.</p>
     */
    inline StartMalwareScanResult& WithScanId(const Aws::String& value) { SetScanId(value); return *this;}

    /**
     * <p>A unique identifier that gets generated when you invoke the API without any
     * error. Each malware scan has a corresponding scan ID. Using this scan ID, you
     * can monitor the status of your malware scan.</p>
     */
    inline StartMalwareScanResult& WithScanId(Aws::String&& value) { SetScanId(std::move(value)); return *this;}

    /**
     * <p>A unique identifier that gets generated when you invoke the API without any
     * error. Each malware scan has a corresponding scan ID. Using this scan ID, you
     * can monitor the status of your malware scan.</p>
     */
    inline StartMalwareScanResult& WithScanId(const char* value) { SetScanId(value); return *this;}


    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }

    
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }

    
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }

    
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }

    
    inline StartMalwareScanResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}

    
    inline StartMalwareScanResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}

    
    inline StartMalwareScanResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}

  private:

    Aws::String m_scanId;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
