﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/IoT_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoT {
namespace Model {

/**
 * <p>A summary of information about a software package.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iot-2015-05-28/PackageSummary">AWS
 * API Reference</a></p>
 */
class PackageSummary {
 public:
  AWS_IOT_API PackageSummary() = default;
  AWS_IOT_API PackageSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOT_API PackageSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name for the target software package.</p>
   */
  inline const Aws::String& GetPackageName() const { return m_packageName; }
  inline bool PackageNameHasBeenSet() const { return m_packageNameHasBeenSet; }
  template <typename PackageNameT = Aws::String>
  void SetPackageName(PackageNameT&& value) {
    m_packageNameHasBeenSet = true;
    m_packageName = std::forward<PackageNameT>(value);
  }
  template <typename PackageNameT = Aws::String>
  PackageSummary& WithPackageName(PackageNameT&& value) {
    SetPackageName(std::forward<PackageNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the default package version.</p>
   */
  inline const Aws::String& GetDefaultVersionName() const { return m_defaultVersionName; }
  inline bool DefaultVersionNameHasBeenSet() const { return m_defaultVersionNameHasBeenSet; }
  template <typename DefaultVersionNameT = Aws::String>
  void SetDefaultVersionName(DefaultVersionNameT&& value) {
    m_defaultVersionNameHasBeenSet = true;
    m_defaultVersionName = std::forward<DefaultVersionNameT>(value);
  }
  template <typename DefaultVersionNameT = Aws::String>
  PackageSummary& WithDefaultVersionName(DefaultVersionNameT&& value) {
    SetDefaultVersionName(std::forward<DefaultVersionNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date that the package was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationDate() const { return m_creationDate; }
  inline bool CreationDateHasBeenSet() const { return m_creationDateHasBeenSet; }
  template <typename CreationDateT = Aws::Utils::DateTime>
  void SetCreationDate(CreationDateT&& value) {
    m_creationDateHasBeenSet = true;
    m_creationDate = std::forward<CreationDateT>(value);
  }
  template <typename CreationDateT = Aws::Utils::DateTime>
  PackageSummary& WithCreationDate(CreationDateT&& value) {
    SetCreationDate(std::forward<CreationDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date that the package was last updated.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedDate() const { return m_lastModifiedDate; }
  inline bool LastModifiedDateHasBeenSet() const { return m_lastModifiedDateHasBeenSet; }
  template <typename LastModifiedDateT = Aws::Utils::DateTime>
  void SetLastModifiedDate(LastModifiedDateT&& value) {
    m_lastModifiedDateHasBeenSet = true;
    m_lastModifiedDate = std::forward<LastModifiedDateT>(value);
  }
  template <typename LastModifiedDateT = Aws::Utils::DateTime>
  PackageSummary& WithLastModifiedDate(LastModifiedDateT&& value) {
    SetLastModifiedDate(std::forward<LastModifiedDateT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_packageName;

  Aws::String m_defaultVersionName;

  Aws::Utils::DateTime m_creationDate{};

  Aws::Utils::DateTime m_lastModifiedDate{};
  bool m_packageNameHasBeenSet = false;
  bool m_defaultVersionNameHasBeenSet = false;
  bool m_creationDateHasBeenSet = false;
  bool m_lastModifiedDateHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
