/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dynamodbv2.model.ImportTableDescription;
import java.util.Date;

@SdkInternalApi
public class ImportTableDescriptionMarshaller {
    private static final MarshallingInfo<String> IMPORTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportArn").build();
    private static final MarshallingInfo<String> IMPORTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportStatus").build();
    private static final MarshallingInfo<String> TABLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableArn").build();
    private static final MarshallingInfo<String> TABLEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableId").build();
    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientToken").build();
    private static final MarshallingInfo<StructuredPojo> S3BUCKETSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BucketSource").build();
    private static final MarshallingInfo<Long> ERRORCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCount").build();
    private static final MarshallingInfo<String> CLOUDWATCHLOGGROUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchLogGroupArn").build();
    private static final MarshallingInfo<String> INPUTFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputFormat").build();
    private static final MarshallingInfo<StructuredPojo> INPUTFORMATOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputFormatOptions").build();
    private static final MarshallingInfo<String> INPUTCOMPRESSIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputCompressionType").build();
    private static final MarshallingInfo<StructuredPojo> TABLECREATIONPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableCreationParameters").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Long> PROCESSEDSIZEBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessedSizeBytes").build();
    private static final MarshallingInfo<Long> PROCESSEDITEMCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessedItemCount").build();
    private static final MarshallingInfo<Long> IMPORTEDITEMCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportedItemCount").build();
    private static final MarshallingInfo<String> FAILURECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureCode").build();
    private static final MarshallingInfo<String> FAILUREMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureMessage").build();
    private static final ImportTableDescriptionMarshaller instance = new ImportTableDescriptionMarshaller();

    public static ImportTableDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImportTableDescription importTableDescription, ProtocolMarshaller protocolMarshaller) {
        if (importTableDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)importTableDescription.getImportArn(), IMPORTARN_BINDING);
            protocolMarshaller.marshall((Object)importTableDescription.getImportStatus(), IMPORTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)importTableDescription.getTableArn(), TABLEARN_BINDING);
            protocolMarshaller.marshall((Object)importTableDescription.getTableId(), TABLEID_BINDING);
            protocolMarshaller.marshall((Object)importTableDescription.getClientToken(), CLIENTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)importTableDescription.getS3BucketSource(), S3BUCKETSOURCE_BINDING);
            protocolMarshaller.marshall((Object)importTableDescription.getErrorCount(), ERRORCOUNT_BINDING);
            protocolMarshaller.marshall((Object)importTableDescription.getCloudWatchLogGroupArn(), CLOUDWATCHLOGGROUPARN_BINDING);
            protocolMarshaller.marshall((Object)importTableDescription.getInputFormat(), INPUTFORMAT_BINDING);
            protocolMarshaller.marshall((Object)importTableDescription.getInputFormatOptions(), INPUTFORMATOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)importTableDescription.getInputCompressionType(), INPUTCOMPRESSIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)importTableDescription.getTableCreationParameters(), TABLECREATIONPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)importTableDescription.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)importTableDescription.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)importTableDescription.getProcessedSizeBytes(), PROCESSEDSIZEBYTES_BINDING);
            protocolMarshaller.marshall((Object)importTableDescription.getProcessedItemCount(), PROCESSEDITEMCOUNT_BINDING);
            protocolMarshaller.marshall((Object)importTableDescription.getImportedItemCount(), IMPORTEDITEMCOUNT_BINDING);
            protocolMarshaller.marshall((Object)importTableDescription.getFailureCode(), FAILURECODE_BINDING);
            protocolMarshaller.marshall((Object)importTableDescription.getFailureMessage(), FAILUREMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

