/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.ShapeQuery;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Line;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.NumericUtils;

final class LatLonShapeQuery
extends ShapeQuery {
    private final LatLonGeometry[] geometries;
    private final Component2D component2D;

    LatLonShapeQuery(String field, ShapeField.QueryRelation queryRelation, LatLonGeometry ... geometries) {
        super(field, queryRelation);
        if (queryRelation == ShapeField.QueryRelation.WITHIN) {
            for (LatLonGeometry geometry : geometries) {
                if (!(geometry instanceof Line)) continue;
                throw new IllegalArgumentException("LatLonShapeQuery does not support " + (Object)((Object)ShapeField.QueryRelation.WITHIN) + " queries with line geometries");
            }
        }
        this.component2D = LatLonGeometry.create(geometries);
        this.geometries = (LatLonGeometry[])geometries.clone();
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        double minLat = GeoEncodingUtils.decodeLatitude(NumericUtils.sortableBytesToInt(minTriangle, minYOffset));
        double minLon = GeoEncodingUtils.decodeLongitude(NumericUtils.sortableBytesToInt(minTriangle, minXOffset));
        double maxLat = GeoEncodingUtils.decodeLatitude(NumericUtils.sortableBytesToInt(maxTriangle, maxYOffset));
        double maxLon = GeoEncodingUtils.decodeLongitude(NumericUtils.sortableBytesToInt(maxTriangle, maxXOffset));
        return this.component2D.relate(minLon, maxLon, minLat, maxLat);
    }

    @Override
    protected boolean queryMatches(byte[] t, ShapeField.DecodedTriangle scratchTriangle, ShapeField.QueryRelation queryRelation) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
        double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
        double blat = GeoEncodingUtils.decodeLatitude(scratchTriangle.bY);
        double blon = GeoEncodingUtils.decodeLongitude(scratchTriangle.bX);
        double clat = GeoEncodingUtils.decodeLatitude(scratchTriangle.cY);
        double clon = GeoEncodingUtils.decodeLongitude(scratchTriangle.cX);
        switch (queryRelation) {
            case INTERSECTS: {
                return this.component2D.relateTriangle(alon, alat, blon, blat, clon, clat) != PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            case WITHIN: {
                return this.component2D.relateTriangle(alon, alat, blon, blat, clon, clat) == PointValues.Relation.CELL_INSIDE_QUERY;
            }
            case DISJOINT: {
                return this.component2D.relateTriangle(alon, alat, blon, blat, clon, clat) == PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        }
        throw new IllegalArgumentException("Unsupported query type :[" + (Object)((Object)queryRelation) + "]");
    }

    @Override
    protected Component2D.WithinRelation queryWithin(byte[] t, ShapeField.DecodedTriangle scratchTriangle) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
        double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
        double blat = GeoEncodingUtils.decodeLatitude(scratchTriangle.bY);
        double blon = GeoEncodingUtils.decodeLongitude(scratchTriangle.bX);
        double clat = GeoEncodingUtils.decodeLatitude(scratchTriangle.cY);
        double clon = GeoEncodingUtils.decodeLongitude(scratchTriangle.cX);
        return this.component2D.withinTriangle(alon, alat, scratchTriangle.ab, blon, blat, scratchTriangle.bc, clon, clat, scratchTriangle.ca);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("[");
        for (int i = 0; i < this.geometries.length; ++i) {
            sb.append(this.geometries[i].toString());
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && Arrays.equals(this.geometries, ((LatLonShapeQuery)o).geometries);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.geometries);
        return hash;
    }
}

