/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;

public abstract class PublicKeyKeyEncryptionMethodGenerator
extends PGPKeyEncryptionMethodGenerator {
    private PGPPublicKey pubKey;

    protected PublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pubKey) {
        this.pubKey = pubKey;
        switch (pubKey.getAlgorithm()) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                throw new IllegalArgumentException("Can't use an RSA_SIGN key for encryption.");
            }
            case 16: 
            case 20: {
                break;
            }
            case 18: {
                break;
            }
            case 17: {
                throw new IllegalArgumentException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new IllegalArgumentException("Can't use ECDSA for encryption.");
            }
            default: {
                throw new IllegalArgumentException("unknown asymmetric algorithm: " + pubKey.getAlgorithm());
            }
        }
    }

    public byte[][] processSessionInfo(byte[] encryptedSessionInfo) throws PGPException {
        byte[][] data;
        switch (this.pubKey.getAlgorithm()) {
            case 1: 
            case 2: {
                data = new byte[][]{this.convertToEncodedMPI(encryptedSessionInfo)};
                break;
            }
            case 16: 
            case 20: {
                byte[] b1 = new byte[encryptedSessionInfo.length / 2];
                byte[] b2 = new byte[encryptedSessionInfo.length / 2];
                System.arraycopy(encryptedSessionInfo, 0, b1, 0, b1.length);
                System.arraycopy(encryptedSessionInfo, b1.length, b2, 0, b2.length);
                data = new byte[][]{this.convertToEncodedMPI(b1), this.convertToEncodedMPI(b2)};
                break;
            }
            case 18: {
                data = new byte[][]{encryptedSessionInfo};
                break;
            }
            default: {
                throw new PGPException("unknown asymmetric algorithm: " + this.pubKey.getAlgorithm());
            }
        }
        return data;
    }

    private byte[] convertToEncodedMPI(byte[] encryptedSessionInfo) throws PGPException {
        try {
            return new MPInteger(new BigInteger(1, encryptedSessionInfo)).getEncoded();
        }
        catch (IOException e) {
            throw new PGPException("Invalid MPI encoding: " + e.getMessage(), e);
        }
    }

    public ContainedPacket generate(int encAlgorithm, byte[] sessionInfo) throws PGPException {
        return new PublicKeyEncSessionPacket(this.pubKey.getKeyID(), this.pubKey.getAlgorithm(), this.processSessionInfo(this.encryptSessionInfo(this.pubKey, sessionInfo)));
    }

    protected abstract byte[] encryptSessionInfo(PGPPublicKey var1, byte[] var2) throws PGPException;
}

