/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.label;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.label.AbstractGoodsLabel;
import net.sf.freecol.client.gui.label.CargoLabel;
import net.sf.freecol.client.gui.label.Draggable;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;

public final class MarketLabel
extends AbstractGoodsLabel
implements CargoLabel,
Draggable,
PropertyChangeListener {
    private final Market market;

    public MarketLabel(FreeColClient freeColClient, GoodsType type, Market market) {
        super(freeColClient, new AbstractGoods(type, 100));
        if (market == null) {
            throw new RuntimeException("Null market for " + this);
        }
        this.market = market;
        this.update();
    }

    private void update() {
        GoodsType type = this.getType();
        Player player = this.market.getOwner();
        Object toolTipText = Messages.getName(type);
        if (player == null || player.canTrade(type)) {
            this.setEnabled(true);
        } else {
            toolTipText = Messages.message(type.getLabel());
            this.setEnabled(false);
        }
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
            toolTipText = (String)toolTipText + " " + this.market.getAmountInMarket(type);
        }
        this.setToolTipText((String)toolTipText);
        this.setText(this.market.getPaidForSale(type) + "/" + this.market.getCostToBuy(type));
    }

    public MarketLabel addBorder() {
        this.setBorder(Utility.getTopCellBorder());
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        return this;
    }

    public Market getMarket() {
        return this.market;
    }

    @Override
    public void setDefaultAmount() {
        this.setAmount(100);
    }

    @Override
    public boolean isOnCarrier() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.update();
    }

    @Override
    public boolean addCargo(Component comp, Unit carrier, CargoPanel cargoPanel) {
        MarketLabel label = (MarketLabel)comp;
        Player player = carrier.getOwner();
        if (!player.canTrade(label.getType())) {
            cargoPanel.igc().payArrears(label.getType());
            return false;
        }
        int loadable = carrier.getLoadableAmount(label.getType());
        if (loadable <= 0) {
            return false;
        }
        if (loadable > label.getAmount()) {
            loadable = label.getAmount();
        }
        if (cargoPanel.igc().buyGoods(label.getType(), loadable, carrier)) {
            cargoPanel.igc().nextModelMessage();
            cargoPanel.update();
            return true;
        }
        return false;
    }
}

