/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.label.CargoLabel;
import net.sf.freecol.client.gui.label.FreeColLabel;
import net.sf.freecol.client.gui.label.GoodsLabel;
import net.sf.freecol.client.gui.label.UnitLabel;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.DropTarget;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;

public class CargoPanel
extends FreeColPanel
implements DropTarget,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(CargoPanel.class.getName());
    private Unit carrier = null;
    private DefaultTransferHandler defaultTransferHandler = new DefaultTransferHandler(this.getFreeColClient(), this);

    public CargoPanel(FreeColClient freeColClient, boolean withTitle) {
        super(freeColClient, "CargoPanelUI", new MigLayout("wrap 6, fill, insets 0"));
        if (withTitle) {
            this.setBorder(Utility.localizedBorder("cargoOnCarrier"));
        }
    }

    public void initialize() {
        this.addPropertyChangeListeners();
        this.update();
    }

    public void cleanup() {
        this.removePropertyChangeListeners();
    }

    protected void addPropertyChangeListeners() {
        if (this.carrier != null) {
            this.carrier.addPropertyChangeListener("CARGO_CHANGE", this);
            this.carrier.getGoodsContainer().addPropertyChangeListener(this);
        }
    }

    protected void removePropertyChangeListeners() {
        if (this.carrier != null) {
            this.carrier.removePropertyChangeListener("CARGO_CHANGE", this);
            this.carrier.getGoodsContainer().removePropertyChangeListener(this);
        }
    }

    public void update() {
        this.removeAll();
        if (this.carrier != null) {
            FreeColLabel label;
            FreeColClient fcc = this.getFreeColClient();
            DragListener dl = new DragListener(fcc, this);
            for (Unit unit : this.carrier.getUnitList()) {
                label = new UnitLabel(fcc, unit);
                if (this.isEditable()) {
                    label.setTransferHandler(this.defaultTransferHandler);
                    label.addMouseListener(dl);
                }
                this.add(label);
            }
            for (Goods g : this.carrier.getGoodsList()) {
                label = new GoodsLabel(fcc, g);
                if (this.isEditable()) {
                    label.setTransferHandler(this.defaultTransferHandler);
                    label.addMouseListener(dl);
                }
                this.add(label);
            }
        }
        this.updateTitle();
        this.revalidate();
        this.repaint();
    }

    public boolean isActive() {
        return this.carrier != null;
    }

    public Unit getCarrier() {
        return this.carrier;
    }

    public void setCarrier(Unit newCarrier) {
        if (newCarrier != this.carrier) {
            this.cleanup();
            this.carrier = newCarrier;
            this.initialize();
        }
    }

    private void updateTitle() {
        Utility.localizeBorder(this, this.carrier == null ? StringTemplate.key("cargoOnCarrier") : ((StringTemplate)StringTemplate.template("cargoPanel.cargoAndSpace").addStringTemplate("%name%", this.carrier.getLabel(Unit.UnitLabelType.NATIONAL))).addAmount("%space%", this.carrier.getSpaceLeft()));
    }

    @Override
    public boolean accepts(Goods goods) {
        return this.carrier != null && this.carrier.canAdd(goods);
    }

    @Override
    public boolean accepts(Unit unit) {
        return this.carrier != null && this.carrier.canAdd(unit);
    }

    @Override
    public Component add(Component comp, boolean editState) {
        if (this.carrier != null && comp instanceof CargoLabel && editState && ((CargoLabel)((Object)comp)).addCargo(comp, this.carrier, this)) {
            return comp;
        }
        return null;
    }

    @Override
    public int suggested(GoodsType type) {
        return this.carrier.getLoadableAmount(type);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        logger.finest("CargoPanel change " + event.getPropertyName() + ": " + event.getOldValue() + " -> " + event.getNewValue());
        this.update();
    }

    @Override
    public void remove(Component comp) {
        if (comp instanceof CargoLabel) {
            ((CargoLabel)((Object)comp)).removeCargo(comp, this);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        this.removePropertyChangeListeners();
        this.defaultTransferHandler = null;
    }
}

