/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.openord;

import java.util.ArrayDeque;
import org.gephi.layout.plugin.openord.Node;

public class DensityGrid
implements Cloneable {
    private static final int GRID_SIZE = 1000;
    private static final float VIEW_SIZE = 4000.0f;
    private static final int RADIUS = 10;
    private static final int HALF_VIEW = 2000;
    private static final float VIEW_TO_GRID = 0.25f;
    private float[][] density;
    private float[][] fallOff;
    private ArrayDeque<Node>[][] bins;

    public static float getViewSize() {
        return 3120.0f;
    }

    public void init() {
        this.density = new float[1000][1000];
        this.fallOff = new float[21][21];
        this.bins = new ArrayDeque[1000][1000];
        for (int i = -10; i <= 10; ++i) {
            for (int j = -10; j <= 10; ++j) {
                this.fallOff[i + 10][j + 10] = (10.0f - Math.abs((float)i)) / 10.0f * ((10.0f - Math.abs((float)j)) / 10.0f);
            }
        }
    }

    public float getDensity(float nX, float nY, boolean fineDensity) {
        float density = 0.0f;
        int boundary = 10;
        int xGrid = (int)(((double)(nX + 2000.0f) + 0.5) * 0.25);
        int yGrid = (int)(((double)(nY + 2000.0f) + 0.5) * 0.25);
        if (xGrid > 1000 - boundary || xGrid < boundary) {
            return 10000.0f;
        }
        if (yGrid > 1000 - boundary || yGrid < boundary) {
            return 10000.0f;
        }
        if (fineDensity) {
            for (int i = yGrid - 1; i <= yGrid + 1; ++i) {
                for (int j = xGrid - 1; j <= xGrid + 1; ++j) {
                    ArrayDeque<Node> deque = this.bins[i][j];
                    if (deque == null) continue;
                    for (Node bi : deque) {
                        float xDist = nX - bi.x;
                        float yDist = nY - bi.y;
                        float distance = xDist * xDist + yDist * yDist;
                        density = (float)((double)density + 1.0E-4 / ((double)distance + 1.0E-50));
                    }
                }
            }
        } else {
            density = this.density[yGrid][xGrid];
            density *= density;
        }
        return density;
    }

    public void add(Node n, boolean fineDensity) {
        if (fineDensity) {
            this.fineAdd(n);
        } else {
            this.add(n);
        }
    }

    public void substract(Node n, boolean firstAdd, boolean fineFirstAdd, boolean fineDensity) {
        if (fineDensity && !fineFirstAdd) {
            this.fineSubstract(n);
        } else if (!firstAdd) {
            this.substract(n);
        }
    }

    private void substract(Node n) {
        int xGrid = (int)((n.subX + 2000.0f + 0.5f) * 0.25f);
        int yGrid = (int)((n.subY + 2000.0f + 0.5f) * 0.25f);
        xGrid -= 10;
        yGrid -= 10;
        int diam = 20;
        for (int i = 0; i <= diam; ++i) {
            int oldXGrid = xGrid;
            for (int j = 0; j <= diam; ++j) {
                float[] fArray = this.density[yGrid];
                int n2 = xGrid++;
                fArray[n2] = fArray[n2] - this.fallOff[i][j];
            }
            ++yGrid;
            xGrid = oldXGrid;
        }
    }

    private void add(Node n) {
        int xGrid = (int)(((double)(n.x + 2000.0f) + 0.5) * 0.25);
        int yGrid = (int)(((double)(n.y + 2000.0f) + 0.5) * 0.25);
        n.subX = n.x;
        n.subY = n.y;
        int diam = 20;
        if ((xGrid -= 10) + 10 >= 1000 || xGrid < 0 || (yGrid -= 10) + 10 >= 1000 || yGrid < 0) {
            throw new RuntimeException("Error: Exceeded density grid with xGrid = " + xGrid + " and yGrid = " + yGrid);
        }
        for (int i = 0; i <= diam; ++i) {
            int oldXGrid = xGrid;
            for (int j = 0; j <= diam; ++j) {
                float[] fArray = this.density[yGrid];
                int n2 = xGrid++;
                fArray[n2] = fArray[n2] + this.fallOff[i][j];
            }
            ++yGrid;
            xGrid = oldXGrid;
        }
    }

    private void fineSubstract(Node n) {
        int yGrid = (int)(((double)(n.subY + 2000.0f) + 0.5) * 0.25);
        int xGrid = (int)(((double)(n.subX + 2000.0f) + 0.5) * 0.25);
        ArrayDeque<Node> deque = this.bins[yGrid][xGrid];
        if (deque != null) {
            deque.pollFirst();
        }
    }

    private void fineAdd(Node n) {
        int xGrid = (int)(((double)(n.x + 2000.0f) + 0.5) * 0.25);
        int yGrid = (int)(((double)(n.y + 2000.0f) + 0.5) * 0.25);
        n.subX = n.x;
        n.subY = n.y;
        ArrayDeque<Node> deque = this.bins[yGrid][xGrid];
        if (deque == null) {
            this.bins[yGrid][xGrid] = deque = new ArrayDeque();
        }
        deque.addLast(n);
    }
}

