/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.annotation;

import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.Script;
import io.micronaut.ast.groovy.utils.AstGenericUtils;
import io.micronaut.ast.groovy.utils.AstMessageUtils;
import io.micronaut.ast.groovy.utils.ExtendedParameter;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.annotation.AnnotatedElementValidator;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

public class GroovyAnnotationMetadataBuilder
extends AbstractAnnotationMetadataBuilder<AnnotatedNode, AnnotationNode> {
    public static final ClassNode ANN_OVERRIDE = ClassHelper.make(Override.class);
    public static final String VALIDATOR_KEY = "io.micronaut.VALIDATOR";
    final SourceUnit sourceUnit;
    final AnnotatedElementValidator elementValidator;
    final CompilationUnit compilationUnit;

    public GroovyAnnotationMetadataBuilder(SourceUnit sourceUnit, CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
        this.sourceUnit = sourceUnit;
        if (sourceUnit != null) {
            ModuleNode ast = sourceUnit.getAST();
            if (ast != null) {
                Object validator = ast.getNodeMetaData((Object)VALIDATOR_KEY);
                if (validator instanceof AnnotatedElementValidator) {
                    this.elementValidator = (AnnotatedElementValidator)validator;
                } else {
                    this.elementValidator = SoftServiceLoader.load(AnnotatedElementValidator.class).firstAvailable().orElse(null);
                    ast.putNodeMetaData((Object)VALIDATOR_KEY, (Object)this.elementValidator);
                }
            } else {
                this.elementValidator = null;
            }
        } else {
            this.elementValidator = null;
        }
    }

    protected boolean isValidationRequired(AnnotatedNode member) {
        List annotations;
        if (member != null && CollectionUtils.isNotEmpty((Collection)(annotations = member.getAnnotations()))) {
            return annotations.stream().anyMatch(it -> it.getClassNode().getName().startsWith("javax.validation"));
        }
        return false;
    }

    protected boolean isExcludedAnnotation(@NonNull AnnotatedNode element, @NonNull String annotationName) {
        if (element instanceof ClassNode && ((ClassNode)element).isAnnotationDefinition() && annotationName.startsWith("java.lang.annotation")) {
            return false;
        }
        return super.isExcludedAnnotation((Object)element, annotationName);
    }

    protected AnnotatedNode getAnnotationMember(AnnotatedNode originatingElement, CharSequence member) {
        List methods;
        if (originatingElement instanceof ClassNode && CollectionUtils.isNotEmpty((Collection)(methods = ((ClassNode)originatingElement).getMethods(member.toString())))) {
            return (AnnotatedNode)methods.iterator().next();
        }
        return null;
    }

    protected RetentionPolicy getRetentionPolicy(@NonNull AnnotatedNode annotation) {
        List annotations = annotation.getAnnotations();
        for (AnnotationNode ann : annotations) {
            Expression expr;
            Iterator i;
            if (!ann.getClassNode().getName().equals(Retention.class.getName()) || !(i = ann.getMembers().values().iterator()).hasNext() || !((expr = (Expression)i.next()) instanceof PropertyExpression)) continue;
            PropertyExpression pe = (PropertyExpression)expr;
            try {
                return RetentionPolicy.valueOf(pe.getPropertyAsString());
            }
            catch (Throwable e) {
                return RetentionPolicy.RUNTIME;
            }
        }
        return RetentionPolicy.RUNTIME;
    }

    protected AnnotatedElementValidator getElementValidator() {
        return this.elementValidator;
    }

    protected void addError(@NonNull AnnotatedNode originatingElement, @NonNull String error) {
        AstMessageUtils.error(this.sourceUnit, (ASTNode)originatingElement, error);
    }

    protected void addWarning(@NonNull AnnotatedNode originatingElement, @NonNull String warning) {
        AstMessageUtils.warning(this.sourceUnit, (ASTNode)originatingElement, warning);
    }

    protected boolean isMethodOrClassElement(AnnotatedNode element) {
        return element instanceof ClassNode || element instanceof MethodNode;
    }

    protected String getDeclaringType(@NonNull AnnotatedNode element) {
        if (element instanceof ClassNode) {
            return ((ClassNode)element).getName();
        }
        ClassNode declaringClass = element.getDeclaringClass();
        if (declaringClass != null) {
            return declaringClass.getName();
        }
        return null;
    }

    protected boolean hasAnnotation(AnnotatedNode element, Class<? extends Annotation> annotation) {
        return !element.getAnnotations(ClassHelper.makeCached(annotation)).isEmpty();
    }

    protected boolean hasAnnotation(AnnotatedNode element, String annotation) {
        for (AnnotationNode ann : element.getAnnotations()) {
            if (!ann.getClassNode().getName().equals(annotation)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasAnnotations(AnnotatedNode element) {
        return CollectionUtils.isNotEmpty((Collection)element.getAnnotations());
    }

    protected VisitorContext createVisitorContext() {
        return new GroovyVisitorContext(this.sourceUnit, this.compilationUnit);
    }

    protected AnnotatedNode getTypeForAnnotation(AnnotationNode annotationMirror) {
        return annotationMirror.getClassNode();
    }

    protected String getRepeatableName(AnnotationNode annotationMirror) {
        return this.getRepeatableNameForType((AnnotatedNode)annotationMirror.getClassNode());
    }

    protected String getRepeatableNameForType(AnnotatedNode annotationType) {
        Expression expression;
        List annotationNodes = annotationType.getAnnotations(ClassHelper.makeCached(Repeatable.class));
        if (CollectionUtils.isNotEmpty((Collection)annotationNodes) && (expression = ((AnnotationNode)annotationNodes.get(0)).getMember("value")) instanceof ClassExpression) {
            return expression.getType().getName();
        }
        return null;
    }

    protected Optional<AnnotatedNode> getAnnotationMirror(String annotationName) {
        ClassNode cn = ClassUtils.forName((String)annotationName, (ClassLoader)GroovyAnnotationMetadataBuilder.class.getClassLoader()).map(ClassHelper::make).orElseGet(() -> ClassHelper.make((String)annotationName));
        if (!cn.getName().equals("java.lang.Object")) {
            return Optional.of(cn);
        }
        return Optional.empty();
    }

    protected String getAnnotationTypeName(AnnotationNode annotationMirror) {
        return annotationMirror.getClassNode().getName();
    }

    protected String getElementName(AnnotatedNode element) {
        if (element instanceof ClassNode) {
            return ((ClassNode)element).getName();
        }
        if (element instanceof MethodNode) {
            return ((MethodNode)element).getName();
        }
        if (element instanceof FieldNode) {
            return ((FieldNode)element).getName();
        }
        if (element instanceof PropertyNode) {
            return ((PropertyNode)element).getName();
        }
        if (element instanceof PackageNode) {
            return ((PackageNode)element).getName();
        }
        throw new IllegalArgumentException("Cannot establish name for node type: " + element.getClass().getName());
    }

    protected List<? extends AnnotationNode> getAnnotationsForType(AnnotatedNode element) {
        List annotations = element.getAnnotations();
        ArrayList<AnnotationNode> expanded = new ArrayList<AnnotationNode>(annotations.size());
        for (AnnotationNode node : annotations) {
            Expression value = node.getMember("value");
            boolean repeatable = false;
            if (value instanceof ListExpression) {
                for (Expression expression : ((ListExpression)value).getExpressions()) {
                    String name;
                    if (!(expression instanceof AnnotationConstantExpression) || (name = this.getRepeatableNameForType((AnnotatedNode)expression.getType())) == null || !name.equals(node.getClassNode().getName())) continue;
                    repeatable = true;
                    expanded.add((AnnotationNode)((AnnotationConstantExpression)expression).getValue());
                }
            }
            if (repeatable && node.getMembers().size() <= 1) continue;
            expanded.add(node);
        }
        return expanded;
    }

    protected List<AnnotatedNode> buildHierarchy(AnnotatedNode element, boolean inheritTypeAnnotations, boolean declaredOnly) {
        if (declaredOnly) {
            return Collections.singletonList(element);
        }
        if (element instanceof ClassNode) {
            ArrayList<AnnotatedNode> hierarchy = new ArrayList<AnnotatedNode>();
            ClassNode cn = (ClassNode)element;
            hierarchy.add((AnnotatedNode)cn);
            if (cn.isAnnotationDefinition()) {
                return hierarchy;
            }
            this.populateTypeHierarchy(cn, hierarchy);
            Collections.reverse(hierarchy);
            return hierarchy;
        }
        if (element instanceof MethodNode) {
            MethodNode mn = (MethodNode)element;
            List<Object> hierarchy = inheritTypeAnnotations ? this.buildHierarchy((AnnotatedNode)mn.getDeclaringClass(), false, declaredOnly) : new ArrayList();
            if (!mn.getAnnotations(ANN_OVERRIDE).isEmpty()) {
                hierarchy.addAll(this.findOverriddenMethods(mn));
            }
            hierarchy.add(mn);
            return hierarchy;
        }
        if (element instanceof ExtendedParameter) {
            ExtendedParameter p = (ExtendedParameter)element;
            ArrayList<AnnotatedNode> hierarchy = new ArrayList<AnnotatedNode>();
            MethodNode methodNode = p.getMethodNode();
            if (!methodNode.getAnnotations(ANN_OVERRIDE).isEmpty()) {
                int variableIdx = Arrays.asList(methodNode.getParameters()).indexOf(p.getParameter());
                for (MethodNode overridden : this.findOverriddenMethods(methodNode)) {
                    hierarchy.add(new ExtendedParameter(overridden, overridden.getParameters()[variableIdx]));
                }
            }
            hierarchy.add(p);
            return hierarchy;
        }
        if (element == null) {
            return new ArrayList<AnnotatedNode>();
        }
        return Collections.singletonList(element);
    }

    protected void readAnnotationRawValues(AnnotatedNode originatingElement, String annotationName, AnnotatedNode member, String memberName, Object annotationValue, Map<CharSequence, Object> annotationValues) {
        Object v;
        if (!annotationValues.containsKey(memberName) && (v = this.readAnnotationValue(originatingElement, member, memberName, annotationValue)) != null) {
            this.validateAnnotationValue(originatingElement, annotationName, member, memberName, v);
            annotationValues.put(memberName, v);
        }
    }

    protected Map<? extends AnnotatedNode, ?> readAnnotationDefaultValues(String annotationName, AnnotatedNode annotationType) {
        LinkedHashMap<MethodNode, Object> defaultValues;
        block12: {
            defaultValues = new LinkedHashMap<MethodNode, Object>();
            if (!(annotationType instanceof ClassNode)) break block12;
            ClassNode classNode = (ClassNode)annotationType;
            ArrayList methods = new ArrayList(classNode.getMethods());
            if (classNode.isResolved()) {
                Class resolved = classNode.getTypeClass();
                for (MethodNode method : methods) {
                    try {
                        Object defaultValue = resolved.getDeclaredMethod(method.getName(), new Class[0]).getDefaultValue();
                        if (defaultValue == null) continue;
                        if (defaultValue instanceof Class) {
                            defaultValues.put(method, new ClassExpression(ClassHelper.makeCached((Class)((Class)defaultValue))));
                            continue;
                        }
                        if (defaultValue instanceof String) {
                            if (!StringUtils.isNotEmpty((CharSequence)((String)defaultValue))) continue;
                            defaultValues.put(method, new ConstantExpression(defaultValue));
                            continue;
                        }
                        defaultValues.put(method, new ConstantExpression(defaultValue));
                    }
                    catch (NoSuchMethodError | NoSuchMethodException defaultValue) {}
                }
            } else {
                for (MethodNode method : methods) {
                    ConstantExpression ce;
                    Object v;
                    Statement stmt = method.getCode();
                    Expression expression = null;
                    if (stmt instanceof ReturnStatement) {
                        expression = ((ReturnStatement)stmt).getExpression();
                    } else if (stmt instanceof ExpressionStatement) {
                        expression = ((ExpressionStatement)stmt).getExpression();
                    }
                    if (!(expression instanceof ConstantExpression) || (v = (ce = (ConstantExpression)expression).getValue()) == null) continue;
                    if (v instanceof String) {
                        if (!StringUtils.isNotEmpty((CharSequence)((String)v))) continue;
                        defaultValues.put(method, new ConstantExpression(v));
                        continue;
                    }
                    defaultValues.put(method, expression);
                }
            }
        }
        return defaultValues;
    }

    protected boolean isInheritedAnnotation(@NonNull AnnotationNode annotationMirror) {
        List annotations = annotationMirror.getClassNode().getAnnotations();
        if (CollectionUtils.isNotEmpty((Collection)annotations)) {
            return annotations.stream().anyMatch(ann -> ann.getClassNode().getName().equals(Inherited.class.getName()));
        }
        return false;
    }

    protected boolean isInheritedAnnotationType(@NonNull AnnotatedNode annotationType) {
        List annotations = annotationType.getAnnotations();
        if (CollectionUtils.isNotEmpty((Collection)annotations)) {
            return annotations.stream().anyMatch(ann -> ann.getClassNode().getName().equals(Inherited.class.getName()));
        }
        return false;
    }

    protected Map<String, ? extends AnnotatedNode> getAnnotationMembers(String annotationType) {
        ClassNode cn;
        AnnotatedNode node = this.getAnnotationMirror(annotationType).orElse(null);
        if (node instanceof ClassNode && (cn = (ClassNode)node).isAnnotationDefinition()) {
            return cn.getDeclaredMethodsMap();
        }
        return Collections.emptyMap();
    }

    protected boolean hasSimpleAnnotation(AnnotatedNode element, String simpleName) {
        if (element != null) {
            List annotations = element.getAnnotations();
            for (AnnotationNode ann : annotations) {
                if (!ann.getClassNode().getNameWithoutPackage().equalsIgnoreCase(simpleName)) continue;
                return true;
            }
        }
        return false;
    }

    protected Map<? extends AnnotatedNode, ?> readAnnotationDefaultValues(AnnotationNode annotationMirror) {
        ClassNode classNode = annotationMirror.getClassNode();
        String annotationName = classNode.getName();
        return this.readAnnotationDefaultValues(annotationName, (AnnotatedNode)classNode);
    }

    protected Object readAnnotationValue(AnnotatedNode originatingElement, AnnotatedNode member, String memberName, Object annotationValue) {
        if (annotationValue instanceof ConstantExpression) {
            if (annotationValue instanceof AnnotationConstantExpression) {
                AnnotationConstantExpression ann = (AnnotationConstantExpression)annotationValue;
                AnnotationNode value = (AnnotationNode)ann.getValue();
                AnnotationValue av = this.readNestedAnnotationValue(originatingElement, value);
                if (member instanceof MethodNode && ((MethodNode)member).getReturnType().isArray()) {
                    return new AnnotationValue[]{av};
                }
                return av;
            }
            return ((ConstantExpression)annotationValue).getValue();
        }
        if (annotationValue instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)annotationValue;
            if (pe.getObjectExpression() instanceof ClassExpression) {
                ClassExpression ce = (ClassExpression)pe.getObjectExpression();
                ClassNode propertyType = ce.getType();
                if (propertyType.isEnum()) {
                    return pe.getPropertyAsString();
                }
                if (propertyType.isResolved()) {
                    Class typeClass = propertyType.getTypeClass();
                    try {
                        Field f = ReflectionUtils.getRequiredField((Class)typeClass, (String)pe.getPropertyAsString());
                        f.setAccessible(true);
                        return f.get(typeClass);
                    }
                    catch (Throwable f) {}
                }
            }
        } else {
            if (annotationValue instanceof ClassExpression) {
                return new AnnotationClassValue(((ClassExpression)annotationValue).getType().getName());
            }
            if (annotationValue instanceof ListExpression) {
                ListExpression le = (ListExpression)annotationValue;
                ArrayList<Object> converted = new ArrayList<Object>();
                Class<Object> arrayType = Object.class;
                for (Expression exp : le.getExpressions()) {
                    if (exp instanceof PropertyExpression) {
                        Object value;
                        PropertyExpression propertyExpression = (PropertyExpression)exp;
                        Expression valueExpression = propertyExpression.getProperty();
                        Expression objectExpression = propertyExpression.getObjectExpression();
                        if (valueExpression instanceof ConstantExpression && objectExpression instanceof ClassExpression && (value = ((ConstantExpression)valueExpression).getValue()) != null) {
                            ClassNode enumType;
                            if (value instanceof CharSequence) {
                                value = value.toString();
                            }
                            arrayType = (enumType = objectExpression.getType()).isResolved() ? enumType.getTypeClass() : String.class;
                            converted.add(value);
                        }
                    }
                    if (exp instanceof AnnotationConstantExpression) {
                        arrayType = AnnotationValue.class;
                        AnnotationConstantExpression ann = (AnnotationConstantExpression)exp;
                        AnnotationNode value = (AnnotationNode)ann.getValue();
                        converted.add(this.readNestedAnnotationValue(originatingElement, value));
                        continue;
                    }
                    if (exp instanceof ConstantExpression) {
                        Object value = ((ConstantExpression)exp).getValue();
                        if (value == null) continue;
                        if (value instanceof CharSequence) {
                            value = value.toString();
                        }
                        arrayType = value.getClass();
                        converted.add(value);
                        continue;
                    }
                    if (!(exp instanceof ClassExpression)) continue;
                    arrayType = AnnotationClassValue.class;
                    ClassExpression classExp = (ClassExpression)exp;
                    String typeName = classExp.getType().isArray() ? "[L" + classExp.getType().getComponentType().getName() + ";" : classExp.getType().getName();
                    converted.add(new AnnotationClassValue(typeName));
                }
                return ConversionService.SHARED.convert(converted, Array.newInstance(arrayType, 0).getClass()).orElse(null);
            }
            if (annotationValue instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)annotationValue;
                Variable variable = ve.getAccessedVariable();
                if (variable != null && variable.hasInitialExpression()) {
                    return this.readAnnotationValue(originatingElement, member, memberName, (Object)variable.getInitialExpression());
                }
            } else if (annotationValue != null && ClassUtils.isJavaLangType(annotationValue.getClass())) {
                return annotationValue;
            }
        }
        return null;
    }

    protected Map<? extends AnnotatedNode, ?> readAnnotationRawValues(AnnotationNode annotationMirror) {
        Map members = annotationMirror.getMembers();
        LinkedHashMap values = new LinkedHashMap();
        ClassNode annotationClassNode = annotationMirror.getClassNode();
        members.forEach((key, value) -> values.put((MethodNode)annotationClassNode.getMethods(key).get(0), value));
        return values;
    }

    protected OptionalValues<?> getAnnotationValues(AnnotatedNode originatingElement, AnnotatedNode member, Class<?> annotationType) {
        List anns;
        if (member != null && CollectionUtils.isNotEmpty((Collection)(anns = member.getAnnotations(ClassHelper.make(annotationType))))) {
            AnnotationNode ann = (AnnotationNode)anns.get(0);
            LinkedHashMap converted = new LinkedHashMap();
            ann.getMembers().forEach((key, value) -> this.readAnnotationRawValues(originatingElement, annotationType.getName(), member, (String)key, value, (Map<CharSequence, Object>)converted));
            return OptionalValues.of(Object.class, converted);
        }
        return OptionalValues.empty();
    }

    protected String getAnnotationMemberName(AnnotatedNode member) {
        return ((MethodNode)member).getName();
    }

    private void populateTypeHierarchy(ClassNode classNode, List<AnnotatedNode> hierarchy) {
        while (classNode != null) {
            ClassNode[] interfaces;
            for (ClassNode anInterface : interfaces = classNode.getInterfaces()) {
                if (hierarchy.contains(anInterface) || anInterface.getName().equals(GroovyObject.class.getName())) continue;
                hierarchy.add((AnnotatedNode)anInterface);
                this.populateTypeHierarchy(anInterface, hierarchy);
            }
            if ((classNode = classNode.getSuperClass()) == null || classNode.equals((Object)ClassHelper.OBJECT_TYPE) || classNode.getName().equals(Script.class.getName()) || classNode.getName().equals(GroovyObjectSupport.class.getName())) break;
            hierarchy.add((AnnotatedNode)classNode);
        }
    }

    private List<MethodNode> findOverriddenMethods(MethodNode methodNode) {
        ArrayList<MethodNode> overriddenMethods = new ArrayList<MethodNode>();
        ClassNode classNode = methodNode.getDeclaringClass();
        String methodName = methodNode.getName();
        Map<String, Map<String, ClassNode>> genericsInfo = AstGenericUtils.buildAllGenericElementInfo(classNode, this.createVisitorContext());
        block0: while (classNode != null && !classNode.getName().equals(Object.class.getName())) {
            for (ClassNode i : classNode.getAllInterfaces()) {
                for (MethodNode parent : i.getMethods(methodName)) {
                    if (!this.methodOverrides(methodNode, parent, genericsInfo.get(i.getName()))) continue;
                    overriddenMethods.add(parent);
                }
            }
            if ((classNode = classNode.getSuperClass()) == null || classNode.getName().equals(Object.class.getName())) continue;
            for (MethodNode parent : classNode.getMethods(methodName)) {
                if (!this.methodOverrides(methodNode, parent, genericsInfo.get(classNode.getName()))) continue;
                if (!parent.isPrivate()) {
                    overriddenMethods.add(parent);
                }
                if (!parent.getAnnotations(ANN_OVERRIDE).isEmpty()) continue;
                break block0;
            }
        }
        return overriddenMethods;
    }

    private boolean methodOverrides(MethodNode child, MethodNode parent, Map<String, ClassNode> genericsSpec) {
        Parameter[] parentParameters;
        Parameter[] childParameters = child.getParameters();
        if (childParameters.length == (parentParameters = parent.getParameters()).length) {
            int n = childParameters.length;
            for (int i = 0; i < n; ++i) {
                ClassNode bType;
                ClassNode aType = childParameters[i].getType();
                if (aType.equals((Object)(bType = parentParameters[i].getType()))) continue;
                if (bType.isGenericsPlaceHolder() && genericsSpec != null) {
                    ClassNode classNode = genericsSpec.get(bType.getUnresolvedName());
                    if (aType.equals((Object)classNode)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }
}

