/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jnr.posix.util.Platform;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.util.ByteList;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.StringSupport;

public class OSEnvironment {
    public static Map<RubyString, RubyString> environmentVariableMap(Ruby runtime2) {
        Map<String, String> env = runtime2.getInstanceConfig().getEnvironment();
        if (env != null) {
            return OSEnvironment.asMapOfRubyStrings(runtime2, env);
        }
        if (Ruby.isSecurityRestricted()) {
            return Collections.emptyMap();
        }
        return OSEnvironment.asMapOfRubyStrings(runtime2, System.getenv());
    }

    public Map<RubyString, RubyString> getEnvironmentVariableMap(Ruby runtime2) {
        HashMap envMap = OSEnvironment.environmentVariableMap(runtime2);
        return envMap == Collections.EMPTY_MAP ? new HashMap(4) : envMap;
    }

    public static Map<String, String> propertiesToStringMap(Properties properties) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            map2.put((String)entry.getKey(), (String)entry.getValue());
        }
        return map2;
    }

    public static Map<RubyString, RubyString> systemPropertiesMap(Ruby runtime2) {
        if (Ruby.isSecurityRestricted()) {
            return Collections.emptyMap();
        }
        return OSEnvironment.asMapOfRubyStrings(runtime2, (Properties)System.getProperties().clone());
    }

    public Map<RubyString, RubyString> getSystemPropertiesMap(Ruby runtime2) {
        HashMap sysMap = OSEnvironment.systemPropertiesMap(runtime2);
        return sysMap == Collections.EMPTY_MAP ? new HashMap(4) : sysMap;
    }

    private static Map<RubyString, RubyString> asMapOfRubyStrings(Ruby runtime2, Map<?, ?> map2) {
        HashMap<RubyString, RubyString> rubyMap = new HashMap<RubyString, RubyString>(map2.size() + 2);
        Encoding encoding2 = runtime2.getEncodingService().getEnvEncoding();
        if (Platform.IS_WINDOWS) {
            String home2 = SafePropertyAccessor.getProperty("user.home");
            String user = SafePropertyAccessor.getProperty("user.name");
            OSEnvironment.putRubyKeyValuePair(runtime2, rubyMap, "HOME", encoding2, home2 == null ? "/" : home2, encoding2);
            OSEnvironment.putRubyKeyValuePair(runtime2, rubyMap, "USER", encoding2, user == null ? "" : user, encoding2);
        }
        for (Map.Entry<?, ?> entry : map2.entrySet()) {
            Object val = entry.getKey();
            if (!(val instanceof String)) continue;
            String key2 = (String)val;
            if (Platform.IS_WINDOWS && StringSupport.startsWith((CharSequence)key2, '=') || !((val = entry.getValue()) instanceof String)) continue;
            OSEnvironment.putRubyKeyValuePair(runtime2, rubyMap, key2, encoding2, (String)val, encoding2);
        }
        return rubyMap;
    }

    private static void putRubyKeyValuePair(Ruby runtime2, Map<RubyString, RubyString> map2, String key2, Encoding keyEncoding, String value2, Encoding valueEncoding) {
        ByteList keyBytes = RubyString.encodeBytelist((CharSequence)key2, keyEncoding);
        ByteList valueBytes = RubyString.encodeBytelist((CharSequence)value2, valueEncoding);
        RubyString keyString = runtime2.newString(keyBytes);
        RubyString valueString = runtime2.newString(valueBytes);
        keyString.setFrozen(true);
        valueString.setFrozen(true);
        map2.put(keyString, valueString);
    }
}

