/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.sessions.AuthenticationSessionModel;

public class AuthenticationFlowHistoryHelper {
    private static final Logger log = Logger.getLogger(AuthenticationFlowHistoryHelper.class);
    private static final String SUCCESSFUL_ACTION_EXECUTIONS = "successful.action.executions";
    private static final String DELIMITER = "::";
    private static final Pattern PATTERN = Pattern.compile("::");
    private final AuthenticationSessionModel authenticationSession;
    private final String flowPath;
    private final String authNoteName;

    public AuthenticationFlowHistoryHelper(AuthenticationProcessor processor) {
        this(processor.getAuthenticationSession(), processor.getFlowPath());
    }

    public AuthenticationFlowHistoryHelper(AuthenticationSessionModel authenticationSession, String flowPath) {
        this.authenticationSession = authenticationSession;
        this.flowPath = flowPath;
        this.authNoteName = "successful.action.executions::" + flowPath;
    }

    public void pushExecution(String executionId) {
        if (this.containsExecution(executionId)) {
            log.tracef("Not adding execution %s to authentication session. Execution is already there", (Object)executionId);
            return;
        }
        log.tracef("Adding execution %s to authentication session. Flow path: %s", (Object)executionId, (Object)this.flowPath);
        String history = this.authenticationSession.getAuthNote(this.authNoteName);
        history = history == null ? executionId : history + DELIMITER + executionId;
        this.authenticationSession.setAuthNote(this.authNoteName, history);
    }

    public boolean hasAnyExecution() {
        return this.authenticationSession.getAuthNote(this.authNoteName) != null;
    }

    public String pullExecution() {
        String history = this.authenticationSession.getAuthNote(this.authNoteName);
        if (history == null) {
            return null;
        }
        String[] splits = PATTERN.split(history);
        String lastActionExecutionId = splits[splits.length - 1];
        if (splits.length == 1) {
            this.authenticationSession.removeAuthNote(this.authNoteName);
        } else {
            String newHistory = history.substring(0, history.length() - DELIMITER.length() - lastActionExecutionId.length());
            this.authenticationSession.setAuthNote(this.authNoteName, newHistory);
        }
        log.tracef("Returning to execution %s in the authentication session. Flow path: %s", (Object)lastActionExecutionId, (Object)this.flowPath);
        return lastActionExecutionId;
    }

    private boolean containsExecution(String executionId) {
        String history = this.authenticationSession.getAuthNote(this.authNoteName);
        if (history == null) {
            return false;
        }
        String[] splits = PATTERN.split(history);
        return Arrays.asList(splits).contains(executionId);
    }
}

