/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.util.TokenUtil;

public class DefaultClientSessionContext
implements ClientSessionContext {
    private static Logger logger = Logger.getLogger(DefaultClientSessionContext.class);
    private final AuthenticatedClientSessionModel clientSession;
    private final Set<String> clientScopeIds;
    private Set<ClientScopeModel> clientScopes;
    private Set<RoleModel> roles;
    private Set<ProtocolMapperModel> protocolMappers;
    private Set<RoleModel> userRoles;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    private DefaultClientSessionContext(AuthenticatedClientSessionModel clientSession, Set<String> clientScopeIds) {
        this.clientSession = clientSession;
        this.clientScopeIds = clientScopeIds;
    }

    public static DefaultClientSessionContext fromClientSessionScopeParameter(AuthenticatedClientSessionModel clientSession) {
        return DefaultClientSessionContext.fromClientSessionAndScopeParameter(clientSession, clientSession.getNote("scope"));
    }

    public static DefaultClientSessionContext fromClientSessionAndScopeParameter(AuthenticatedClientSessionModel clientSession, String scopeParam) {
        Set<ClientScopeModel> requestedClientScopes = TokenManager.getRequestedClientScopes(scopeParam, clientSession.getClient());
        return DefaultClientSessionContext.fromClientSessionAndClientScopes(clientSession, requestedClientScopes);
    }

    public static DefaultClientSessionContext fromClientSessionAndClientScopeIds(AuthenticatedClientSessionModel clientSession, Set<String> clientScopeIds) {
        return new DefaultClientSessionContext(clientSession, clientScopeIds);
    }

    public static DefaultClientSessionContext fromClientSessionAndClientScopes(AuthenticatedClientSessionModel clientSession, Set<ClientScopeModel> clientScopes) {
        HashSet<String> clientScopeIds = new HashSet<String>();
        for (ClientScopeModel clientScope : clientScopes) {
            clientScopeIds.add(clientScope.getId());
        }
        return new DefaultClientSessionContext(clientSession, clientScopeIds);
    }

    public AuthenticatedClientSessionModel getClientSession() {
        return this.clientSession;
    }

    public Set<String> getClientScopeIds() {
        return this.clientScopeIds;
    }

    public Set<ClientScopeModel> getClientScopes() {
        if (this.clientScopes == null) {
            this.clientScopes = this.loadClientScopes();
        }
        return this.clientScopes;
    }

    public Set<RoleModel> getRoles() {
        if (this.roles == null) {
            this.roles = this.loadRoles();
        }
        return this.roles;
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        if (this.protocolMappers == null) {
            this.protocolMappers = this.loadProtocolMappers();
        }
        return this.protocolMappers;
    }

    private Set<RoleModel> getUserRoles() {
        if (this.userRoles == null) {
            this.userRoles = this.loadUserRoles();
        }
        return this.userRoles;
    }

    public String getScopeString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (ClientScopeModel clientScope : this.getClientScopes()) {
            if (clientScope instanceof ClientModel || !clientScope.isIncludeInTokenScope()) continue;
            if (first) {
                first = false;
            } else {
                builder.append(" ");
            }
            builder.append(clientScope.getName());
        }
        String scopeParam = builder.toString();
        String scopeSent = this.clientSession.getNote("scope");
        if (TokenUtil.isOIDCRequest((String)scopeSent)) {
            scopeParam = TokenUtil.attachOIDCScope((String)scopeParam);
        }
        return scopeParam;
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public <T> T getAttribute(String name, Class<T> clazz) {
        Object value = this.attributes.get(name);
        return clazz.cast(value);
    }

    private Set<ClientScopeModel> loadClientScopes() {
        HashSet<ClientScopeModel> clientScopes = new HashSet<ClientScopeModel>();
        for (String scopeId : this.clientScopeIds) {
            ClientScopeModel clientScope = KeycloakModelUtils.findClientScopeById((RealmModel)this.clientSession.getClient().getRealm(), (ClientModel)this.getClientSession().getClient(), (String)scopeId);
            if (clientScope == null) continue;
            if (this.isClientScopePermittedForUser(clientScope)) {
                clientScopes.add(clientScope);
                continue;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.tracef("User '%s' not permitted to have client scope '%s'", (Object)this.clientSession.getUserSession().getUser().getUsername(), (Object)clientScope.getName());
        }
        return clientScopes;
    }

    private boolean isClientScopePermittedForUser(ClientScopeModel clientScope) {
        if (clientScope instanceof ClientModel) {
            return true;
        }
        Set clientScopeRoles = clientScope.getScopeMappings();
        if (clientScopeRoles.isEmpty()) {
            return true;
        }
        clientScopeRoles = RoleUtils.expandCompositeRoles((Set)clientScopeRoles);
        clientScopeRoles.retainAll(this.getUserRoles());
        return !clientScopeRoles.isEmpty();
    }

    private Set<RoleModel> loadRoles() {
        UserModel user = this.clientSession.getUserSession().getUser();
        ClientModel client = this.clientSession.getClient();
        Set<ClientScopeModel> clientScopes = this.getClientScopes();
        return TokenManager.getAccess(user, client, clientScopes);
    }

    private Set<ProtocolMapperModel> loadProtocolMappers() {
        Set<ClientScopeModel> clientScopes = this.getClientScopes();
        String protocol = this.clientSession.getClient().getProtocol();
        if (protocol == null) {
            logger.warnf("Client '%s' doesn't have protocol set. Fallback to openid-connect. Please fix client configuration", (Object)this.clientSession.getClient().getClientId());
            protocol = "openid-connect";
        }
        HashSet<ProtocolMapperModel> protocolMappers = new HashSet<ProtocolMapperModel>();
        for (ClientScopeModel clientScope : clientScopes) {
            Set currentMappers = clientScope.getProtocolMappers();
            for (ProtocolMapperModel currentMapper : currentMappers) {
                if (!protocol.equals(currentMapper.getProtocol())) continue;
                protocolMappers.add(currentMapper);
            }
        }
        return protocolMappers;
    }

    private Set<RoleModel> loadUserRoles() {
        UserModel user = this.clientSession.getUserSession().getUser();
        return RoleUtils.getDeepUserRoleMappings((UserModel)user);
    }
}

