/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote.expiration;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class UpdateLastAccessCommand
extends BaseRpcCommand
implements TopologyAffectedCommand,
SegmentSpecificCommand {
    private Object key;
    private long acessTime;
    private InternalDataContainer<Object, Object> container;
    private int topologyId = -1;
    private int segment;
    public static final byte COMMAND_ID = 82;

    private UpdateLastAccessCommand() {
        this(null);
    }

    public UpdateLastAccessCommand(ByteString cacheName) {
        super(cacheName);
        this.segment = -1;
    }

    public UpdateLastAccessCommand(ByteString cacheName, Object key, int segment, long accessTime) {
        super(cacheName);
        this.key = key;
        this.segment = segment;
        this.acessTime = accessTime;
    }

    public void inject(InternalDataContainer container) {
        this.container = container;
    }

    @Override
    public byte getCommandId() {
        return 82;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)this.segment);
        UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)this.acessTime);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.segment = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        this.acessTime = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        InternalCacheEntry<Object, Object> ice = this.container.peek(this.segment, this.key);
        if (ice != null) {
            ice.touch(this.acessTime);
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public int getSegment() {
        return this.segment;
    }
}

