/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import org.keycloak.credential.CredentialModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;

public class AuthenticationSelectionOption {
    private final AuthenticationExecutionModel authExec;
    private final CredentialModel credential;
    private final AuthenticationFlowModel authFlow;
    private boolean showCredentialName = true;
    private boolean showCredentialType = true;

    public AuthenticationSelectionOption(AuthenticationExecutionModel authExec) {
        this.authExec = authExec;
        this.credential = new CredentialModel();
        this.authFlow = null;
    }

    public AuthenticationSelectionOption(AuthenticationExecutionModel authExec, CredentialModel credential) {
        this.authExec = authExec;
        this.credential = credential.shallowClone();
        this.credential.setSecretData("");
        this.authFlow = null;
    }

    public AuthenticationSelectionOption(AuthenticationExecutionModel authExec, AuthenticationFlowModel authFlow) {
        this.authExec = authExec;
        this.credential = new CredentialModel();
        this.authFlow = authFlow;
    }

    public void setShowCredentialName(boolean showCredentialName) {
        this.showCredentialName = showCredentialName;
    }

    public void setShowCredentialType(boolean showCredentialType) {
        this.showCredentialType = showCredentialType;
    }

    public boolean showCredentialName() {
        if (this.credential.getId() == null) {
            return false;
        }
        return this.showCredentialName;
    }

    public boolean showCredentialType() {
        return this.showCredentialType;
    }

    public AuthenticationExecutionModel getAuthenticationExecution() {
        return this.authExec;
    }

    public String getCredentialId() {
        return this.credential.getId();
    }

    public String getAuthExecId() {
        return this.authExec.getId();
    }

    public String getCredentialName() {
        StringBuilder sb = new StringBuilder();
        if (this.showCredentialName()) {
            if (this.showCredentialType()) {
                sb.append(" - ");
            }
            if (this.credential.getUserLabel() == null || this.credential.getUserLabel().isEmpty()) {
                sb.append(this.credential.getId());
            } else {
                sb.append(this.credential.getUserLabel());
            }
        }
        return sb.toString();
    }

    public String getAuthExecName() {
        if (this.authFlow != null) {
            String authFlowLabel = this.authFlow.getAlias();
            if (authFlowLabel == null || authFlowLabel.isEmpty()) {
                authFlowLabel = this.authFlow.getId();
            }
            return authFlowLabel;
        }
        return this.authExec.getAuthenticator();
    }

    public String getId() {
        if (this.getCredentialId() == null) {
            return this.getAuthExecId() + "|";
        }
        return this.getAuthExecId() + "|" + this.getCredentialId();
    }

    public CredentialModel getCredential() {
        return this.credential;
    }
}

