/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.rotation;

import java.security.Key;
import java.security.KeyManagementException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.rotation.KeyLocator;

public class CompositeKeyLocator
implements KeyLocator,
Iterable<Key> {
    private final List<KeyLocator> keyLocators = new LinkedList<KeyLocator>();

    @Override
    public Key getKey(String kid) throws KeyManagementException {
        for (KeyLocator keyLocator : this.keyLocators) {
            Key k = keyLocator.getKey(kid);
            if (k == null) continue;
            return k;
        }
        return null;
    }

    @Override
    public void refreshKeyCache() {
        for (KeyLocator keyLocator : this.keyLocators) {
            keyLocator.refreshKeyCache();
        }
    }

    public void addFirst(KeyLocator keyLocator) {
        this.keyLocators.add(0, keyLocator);
    }

    public void add(KeyLocator keyLocator) {
        this.keyLocators.add(keyLocator);
    }

    public void clear() {
        this.keyLocators.clear();
    }

    public String toString() {
        if (this.keyLocators.size() == 1) {
            return this.keyLocators.get(0).toString();
        }
        StringBuilder sb = new StringBuilder("Key locator chain: [");
        Iterator<KeyLocator> it = this.keyLocators.iterator();
        while (it.hasNext()) {
            KeyLocator keyLocator = it.next();
            sb.append(keyLocator.toString());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.append("]").toString();
    }

    @Override
    public Iterator<Key> iterator() {
        Iterator<Iterable<Key>> iterablesIterator = this.getKeyLocatorIterators().iterator();
        return new JointKeyIterator(iterablesIterator).iterator();
    }

    private Iterable<Iterable<Key>> getKeyLocatorIterators() {
        LinkedList<Iterable> res = new LinkedList<Iterable>();
        for (KeyLocator kl : this.keyLocators) {
            if (!(kl instanceof Iterable)) continue;
            res.add((Iterable)((Object)kl));
        }
        return Collections.unmodifiableCollection(res);
    }

    private class JointKeyIterator
    implements Iterable<Key> {
        private final Iterator<Iterable<Key>> iterablesIterator;

        public JointKeyIterator(Iterator<Iterable<Key>> iterablesIterator) {
            this.iterablesIterator = iterablesIterator;
        }

        @Override
        public Iterator<Key> iterator() {
            if (!this.iterablesIterator.hasNext()) {
                return Collections.emptyIterator();
            }
            return (new Iterator<Key>(){
                private Iterator<Key> currentIterator = this.nextIterator();

                @Override
                public boolean hasNext() {
                    return this.currentIterator.hasNext();
                }

                @Override
                public Key next() {
                    Key next = this.currentIterator.next();
                    this.findNext();
                    return next;
                }

                private Iterator<Key> nextIterator() {
                    return ((Iterable)JointKeyIterator.this.iterablesIterator.next()).iterator();
                }

                private Iterator<Key> findNext() {
                    while (!this.currentIterator.hasNext() && JointKeyIterator.this.iterablesIterator.hasNext()) {
                        this.currentIterator = this.nextIterator();
                    }
                    return this;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            }).findNext();
        }
    }
}

