/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.idm.model.PartitionManagerAddHandler;
import org.wildfly.extension.picketlink.idm.model.PartitionManagerRemoveHandler;
import org.wildfly.extension.picketlink.idm.service.PartitionManagerService;

public class IDMConfigWriteAttributeHandler
extends RestartParentWriteAttributeHandler {
    IDMConfigWriteAttributeHandler(AttributeDefinition ... attributes) {
        super(ModelElement.PARTITION_MANAGER.getName(), attributes);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                PathAddress address = IDMConfigWriteAttributeHandler.this.getParentAddress(PathAddress.pathAddress((ModelNode)operation.require("address")));
                Resource resource = context.readResourceFromRoot(address);
                ModelNode parentModel = Resource.Tools.readModel((Resource)resource);
                PartitionManagerAddHandler.INSTANCE.validateModel(context, address.getLastElement().getValue(), parentModel);
            }
        }, OperationContext.Stage.MODEL);
        super.execute(context, operation);
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
        String federationName = parentAddress.getLastElement().getValue();
        PartitionManagerRemoveHandler.INSTANCE.removeIdentityStoreServices(context, parentModel, federationName, new String[0]);
        PartitionManagerAddHandler.INSTANCE.createPartitionManagerService(context, parentAddress.getLastElement().getValue(), parentModel, false);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        return PartitionManagerService.createServiceName(parentAddress.getLastElement().getValue());
    }
}

