/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.TimeUnit;
import org.xnio.Xnio;
import org.xnio.nio.Log;
import org.xnio.nio.NioXnio;

final class SelectorUtils {
    private SelectorUtils() {
    }

    public static void await(NioXnio nioXnio, SelectableChannel channel, int op) throws IOException {
        SelectionKey selectionKey;
        if (NioXnio.IS_HP_UX) {
            SelectorUtils.await(nioXnio, channel, op, 1L, TimeUnit.SECONDS);
            return;
        }
        Xnio.checkBlockingAllowed();
        Selector selector = nioXnio.getSelector();
        try {
            selectionKey = channel.register(selector, op);
        }
        catch (ClosedChannelException e) {
            return;
        }
        selector.select();
        selector.selectedKeys().clear();
        if (Thread.currentThread().isInterrupted()) {
            throw Log.log.interruptedIO();
        }
        selectionKey.cancel();
        selector.selectNow();
    }

    public static void await(NioXnio nioXnio, SelectableChannel channel, int op, long time, TimeUnit unit) throws IOException {
        SelectionKey selectionKey;
        if (time <= 0L) {
            SelectorUtils.await(nioXnio, channel, op);
            return;
        }
        Xnio.checkBlockingAllowed();
        Selector selector = nioXnio.getSelector();
        try {
            selectionKey = channel.register(selector, op);
        }
        catch (ClosedChannelException e) {
            return;
        }
        long timeoutInMillis = unit.toMillis(time);
        selector.select(timeoutInMillis == 0L ? 1L : timeoutInMillis);
        selector.selectedKeys().clear();
        if (Thread.currentThread().isInterrupted()) {
            throw Log.log.interruptedIO();
        }
        selectionKey.cancel();
        selector.selectNow();
    }
}

