/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.events;

import java.util.Set;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheManager;
import org.keycloak.models.cache.infinispan.authorization.events.AuthorizationCacheInvalidationEvent;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;

public class PermissionTicketUpdatedEvent
extends InvalidationEvent
implements AuthorizationCacheInvalidationEvent {
    private String id;
    private String owner;
    private String resource;
    private String scope;
    private String serverId;
    private String requester;
    private String resourceName;

    public static PermissionTicketUpdatedEvent create(String id, String owner, String requester, String resource, String resourceName, String scope, String serverId) {
        PermissionTicketUpdatedEvent event = new PermissionTicketUpdatedEvent();
        event.id = id;
        event.owner = owner;
        event.requester = requester;
        event.resource = resource;
        event.resourceName = resourceName;
        event.scope = scope;
        event.serverId = serverId;
        return event;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return String.format("PermissionTicketUpdatedEvent [ id=%s, name=%s]", this.id, this.resource);
    }

    @Override
    public void addInvalidations(StoreFactoryCacheManager cache, Set<String> invalidations) {
        cache.permissionTicketUpdated(this.id, this.owner, this.requester, this.resource, this.resourceName, this.scope, this.serverId, invalidations);
    }
}

