/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class GroupAddedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String groupId;
    private String realmId;

    public static GroupAddedEvent create(String groupId, String realmId) {
        GroupAddedEvent event = new GroupAddedEvent();
        event.realmId = realmId;
        event.groupId = groupId;
        return event;
    }

    @Override
    public String getId() {
        return this.groupId;
    }

    public String toString() {
        return String.format("GroupAddedEvent [ realmId=%s, groupId=%s ]", this.realmId, this.groupId);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.groupQueriesInvalidations(this.realmId, invalidations);
    }

    public static class ExternalizerImpl
    implements Externalizer<GroupAddedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, GroupAddedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.groupId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.realmId, (ObjectOutput)output);
        }

        public GroupAddedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public GroupAddedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            GroupAddedEvent res = new GroupAddedEvent();
            res.groupId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.realmId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

