/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.changes.ClientSessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.InfinispanChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.Tasks;
import org.keycloak.models.sessions.infinispan.changes.UserSessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.sessions.CrossDCLastSessionRefreshChecker;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class AuthenticatedClientSessionAdapter
implements AuthenticatedClientSessionModel {
    private final KeycloakSession kcSession;
    private final InfinispanUserSessionProvider provider;
    private AuthenticatedClientSessionEntity entity;
    private final ClientModel client;
    private final InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx;
    private final InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionUpdateTx;
    private UserSessionModel userSession;
    private boolean offline;

    public AuthenticatedClientSessionAdapter(KeycloakSession kcSession, InfinispanUserSessionProvider provider, AuthenticatedClientSessionEntity entity, ClientModel client, UserSessionModel userSession, InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx, InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionUpdateTx, boolean offline) {
        if (userSession == null) {
            throw new NullPointerException("userSession must not be null");
        }
        this.kcSession = kcSession;
        this.provider = provider;
        this.entity = entity;
        this.userSession = userSession;
        this.client = client;
        this.userSessionUpdateTx = userSessionUpdateTx;
        this.clientSessionUpdateTx = clientSessionUpdateTx;
        this.offline = offline;
    }

    private void update(UserSessionUpdateTask task) {
        this.userSessionUpdateTx.addTask(this.userSession.getId(), task);
    }

    private void update(ClientSessionUpdateTask task) {
        this.clientSessionUpdateTx.addTask(this.entity.getId(), task);
    }

    public void detachFromUserSession() {
        this.userSession = null;
        SessionUpdateTask removeTask = Tasks.removeSync();
        this.clientSessionUpdateTx.addTask(this.entity.getId(), removeTask);
    }

    public UserSessionModel getUserSession() {
        return this.userSession;
    }

    public String getRedirectUri() {
        return this.entity.getRedirectUri();
    }

    public void setRedirectUri(final String uri) {
        ClientSessionUpdateTask task = new ClientSessionUpdateTask(){

            @Override
            public void runUpdate(AuthenticatedClientSessionEntity entity) {
                entity.setRedirectUri(uri);
            }
        };
        this.update(task);
    }

    public String getId() {
        return null;
    }

    public RealmModel getRealm() {
        return this.userSession.getRealm();
    }

    public ClientModel getClient() {
        return this.client;
    }

    public int getTimestamp() {
        return this.entity.getTimestamp();
    }

    public void setTimestamp(final int timestamp) {
        ClientSessionUpdateTask task = new ClientSessionUpdateTask(){

            @Override
            public void runUpdate(AuthenticatedClientSessionEntity entity) {
                entity.setTimestamp(timestamp);
            }

            @Override
            public SessionUpdateTask.CrossDCMessageStatus getCrossDCMessageStatus(SessionEntityWrapper<AuthenticatedClientSessionEntity> sessionWrapper) {
                return new CrossDCLastSessionRefreshChecker(AuthenticatedClientSessionAdapter.this.provider.getLastSessionRefreshStore(), AuthenticatedClientSessionAdapter.this.provider.getOfflineLastSessionRefreshStore()).shouldSaveClientSessionToRemoteCache(AuthenticatedClientSessionAdapter.this.kcSession, AuthenticatedClientSessionAdapter.this.client.getRealm(), sessionWrapper, AuthenticatedClientSessionAdapter.this.userSession, AuthenticatedClientSessionAdapter.this.offline, timestamp);
            }

            public String toString() {
                return "setTimestamp(" + timestamp + ')';
            }
        };
        this.update(task);
    }

    public int getCurrentRefreshTokenUseCount() {
        return this.entity.getCurrentRefreshTokenUseCount();
    }

    public void setCurrentRefreshTokenUseCount(final int currentRefreshTokenUseCount) {
        ClientSessionUpdateTask task = new ClientSessionUpdateTask(){

            @Override
            public void runUpdate(AuthenticatedClientSessionEntity entity) {
                entity.setCurrentRefreshTokenUseCount(currentRefreshTokenUseCount);
            }
        };
        this.update(task);
    }

    public String getCurrentRefreshToken() {
        return this.entity.getCurrentRefreshToken();
    }

    public void setCurrentRefreshToken(final String currentRefreshToken) {
        ClientSessionUpdateTask task = new ClientSessionUpdateTask(){

            @Override
            public void runUpdate(AuthenticatedClientSessionEntity entity) {
                entity.setCurrentRefreshToken(currentRefreshToken);
            }
        };
        this.update(task);
    }

    public String getAction() {
        return this.entity.getAction();
    }

    public void setAction(final String action) {
        ClientSessionUpdateTask task = new ClientSessionUpdateTask(){

            @Override
            public void runUpdate(AuthenticatedClientSessionEntity entity) {
                entity.setAction(action);
            }
        };
        this.update(task);
    }

    public String getProtocol() {
        return this.entity.getAuthMethod();
    }

    public void setProtocol(final String method) {
        ClientSessionUpdateTask task = new ClientSessionUpdateTask(){

            @Override
            public void runUpdate(AuthenticatedClientSessionEntity entity) {
                entity.setAuthMethod(method);
            }
        };
        this.update(task);
    }

    public String getNote(String name) {
        return this.entity.getNotes().get(name);
    }

    public void setNote(final String name, final String value) {
        ClientSessionUpdateTask task = new ClientSessionUpdateTask(){

            @Override
            public void runUpdate(AuthenticatedClientSessionEntity entity) {
                entity.getNotes().put(name, value);
            }
        };
        this.update(task);
    }

    public void removeNote(final String name) {
        ClientSessionUpdateTask task = new ClientSessionUpdateTask(){

            @Override
            public void runUpdate(AuthenticatedClientSessionEntity entity) {
                entity.getNotes().remove(name);
            }
        };
        this.update(task);
    }

    public Map<String, String> getNotes() {
        if (this.entity.getNotes().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.entity.getNotes());
        return copy;
    }
}

