/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import java.util.Date;
import javax.json.JsonObjectBuilder;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.predicate.SessionFilterPredicate;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.utils.JsonLoader;

public class SessionView
extends ActiveMQAbstractView<ServerSession> {
    private static final String defaultSortColumn = "id";

    public SessionView() {
        this.predicate = new SessionFilterPredicate();
    }

    @Override
    public Class getClassT() {
        return ServerSession.class;
    }

    @Override
    public JsonObjectBuilder toJson(ServerSession session) {
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add(defaultSortColumn, this.toString(session.getName())).add("user", this.toString(session.getUsername())).add("creationTime", new Date(session.getCreationTime()).toString()).add("consumerCount", session.getConsumerCount()).add("producerCount", session.getProducerCount()).add("connectionID", session.getConnectionID().toString());
        return obj;
    }

    @Override
    public Object getField(ServerSession session, String fieldName) {
        switch (fieldName) {
            case "id": {
                return session.getName();
            }
            case "user": {
                return session.getUsername();
            }
            case "creationTime": {
                return new Date(session.getCreationTime());
            }
            case "consumerCount": {
                return session.getConsumerCount();
            }
            case "producerCount": {
                return session.getProducerCount();
            }
            case "connectionID": {
                return session.getConnectionID();
            }
        }
        throw new IllegalArgumentException("Unsupported field, " + fieldName);
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortColumn;
    }
}

