/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl;

import java.util.Objects;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.SyncStrongCounter;
import org.infinispan.counter.impl.Util;

public class SyncStrongCounterAdapter
implements SyncStrongCounter {
    private final StrongCounter counter;

    public SyncStrongCounterAdapter(StrongCounter counter) {
        this.counter = Objects.requireNonNull(counter);
    }

    @Override
    public long addAndGet(long delta) {
        return Util.awaitCounterOperation(this.counter.addAndGet(delta));
    }

    @Override
    public void reset() {
        Util.awaitCounterOperation(this.counter.reset());
    }

    @Override
    public long getValue() {
        return Util.awaitCounterOperation(this.counter.getValue());
    }

    @Override
    public long compareAndSwap(long expect, long update) {
        return Util.awaitCounterOperation(this.counter.compareAndSwap(expect, update));
    }

    @Override
    public String getName() {
        return this.counter.getName();
    }

    @Override
    public CounterConfiguration getConfiguration() {
        return this.counter.getConfiguration();
    }

    @Override
    public void remove() {
        Util.awaitCounterOperation(this.counter.remove());
    }

    public String toString() {
        return "SyncStrongCounter{counter=" + this.counter + '}';
    }
}

