/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.buffer.ByteBuf;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.transaction.manager.RemoteXid;
import org.infinispan.commons.io.SignedNumeric;
import org.infinispan.commons.util.Util;

public final class ByteBufUtil {
    private ByteBufUtil() {
    }

    public static byte[] readArray(ByteBuf buf) {
        int length = ByteBufUtil.readVInt(buf);
        byte[] bytes = new byte[length];
        buf.readBytes(bytes, 0, length);
        return bytes;
    }

    public static String readString(ByteBuf buf) {
        byte[] strContent = ByteBufUtil.readArray(buf);
        return new String(strContent, HotRodConstants.HOTROD_STRING_CHARSET);
    }

    public static void writeString(ByteBuf buf, String string) {
        if (string != null && !string.isEmpty()) {
            ByteBufUtil.writeArray(buf, string.getBytes(HotRodConstants.HOTROD_STRING_CHARSET));
        } else {
            ByteBufUtil.writeVInt(buf, 0);
        }
    }

    public static void writeOptionalString(ByteBuf buf, String string) {
        if (string == null) {
            ByteBufUtil.writeSignedVInt(buf, -1);
        } else {
            ByteBufUtil.writeOptionalArray(buf, string.getBytes(HotRodConstants.HOTROD_STRING_CHARSET));
        }
    }

    public static void writeArray(ByteBuf buf, byte[] toAppend) {
        ByteBufUtil.writeVInt(buf, toAppend.length);
        buf.writeBytes(toAppend);
    }

    public static void writeArray(ByteBuf buf, byte[] toAppend, int offset, int count) {
        ByteBufUtil.writeVInt(buf, count);
        buf.writeBytes(toAppend, offset, count);
    }

    public static int estimateArraySize(byte[] array) {
        return ByteBufUtil.estimateVIntSize(array.length) + array.length;
    }

    public static int estimateVIntSize(int value) {
        return (32 - Integer.numberOfLeadingZeros(value)) / 7 + 1;
    }

    public static void writeOptionalArray(ByteBuf buf, byte[] toAppend) {
        ByteBufUtil.writeSignedVInt(buf, toAppend.length);
        buf.writeBytes(toAppend);
    }

    public static void writeVInt(ByteBuf buf, int i) {
        while ((i & 0xFFFFFF80) != 0) {
            buf.writeByte((int)((byte)(i & 0x7F | 0x80)));
            i >>>= 7;
        }
        buf.writeByte((int)((byte)i));
    }

    public static void writeSignedVInt(ByteBuf buf, int i) {
        ByteBufUtil.writeVInt(buf, SignedNumeric.encode((int)i));
    }

    public static void writeVLong(ByteBuf buf, long i) {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buf.writeByte((int)((byte)(i & 0x7FL | 0x80L)));
            i >>>= 7;
        }
        buf.writeByte((int)((byte)i));
    }

    public static int estimateVLongSize(long value) {
        return (64 - Long.numberOfLeadingZeros(value)) / 7 + 1;
    }

    public static long readVLong(ByteBuf buf) {
        byte b = buf.readByte();
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = buf.readByte();
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    public static int readVInt(ByteBuf buf) {
        byte b = buf.readByte();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = buf.readByte();
            i = (int)((long)i | ((long)b & 0x7FL) << shift);
            shift += 7;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hexDump(ByteBuf buf) {
        if (buf.hasArray()) {
            return Util.hexDump((byte[])buf.array());
        }
        int currentReaderIndex = buf.readerIndex();
        try {
            buf.resetReaderIndex();
            if (buf.readerIndex() < buf.writerIndex()) {
                byte[] bytes = new byte[Math.min(1024, buf.readableBytes())];
                buf.getBytes(buf.readerIndex(), bytes);
                String dump = Util.hexDump((byte[])bytes);
                if (buf.readableBytes() > 1024) {
                    dump = dump + "... " + (buf.readableBytes() - 1024) + " more bytes";
                }
                String string = dump;
                return string;
            }
            String string = "ri: " + buf.readerIndex() + ", wi: " + buf.writerIndex();
            return string;
        }
        finally {
            buf.readerIndex(currentReaderIndex);
        }
    }

    public static int estimateXidSize(Xid xid) {
        if (xid instanceof RemoteXid) {
            return ((RemoteXid)((Object)xid)).estimateSize();
        }
        return ByteBufUtil.estimateVIntSize(xid.getFormatId()) + 64 + 64;
    }

    public static void writeXid(ByteBuf buf, Xid xid) {
        if (xid instanceof RemoteXid) {
            ((RemoteXid)((Object)xid)).writeTo(buf);
        } else {
            ByteBufUtil.writeSignedVInt(buf, xid.getFormatId());
            ByteBufUtil.writeArray(buf, xid.getGlobalTransactionId());
            ByteBufUtil.writeArray(buf, xid.getBranchQualifier());
        }
    }
}

