"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var __1 = require("../../..");
var constants_1 = require("../../../../specs/constants");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var commons_1 = require("../../../../utils/commons");
var events_1 = require("../../../../utils/events");
var common_1 = require("../utils/common");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var get_brush_area_1 = require("./get_brush_area");
var get_computed_scales_1 = require("./get_computed_scales");
var is_brush_available_1 = require("./is_brush_available");
var is_histogram_mode_enabled_1 = require("./is_histogram_mode_enabled");
var getLastDragSelector = function (state) { return state.interactions.pointer.lastDrag; };
function createOnBrushEndCaller() {
    var prevProps = null;
    var selector = null;
    return function (state) {
        if (selector === null && state.chartType === __1.ChartTypes.XYAxis) {
            if (!is_brush_available_1.isBrushAvailableSelector(state)) {
                selector = null;
                prevProps = null;
                return;
            }
            selector = re_reselect_1.default([
                getLastDragSelector,
                get_settings_specs_1.getSettingsSpecSelector,
                get_computed_scales_1.getComputedScalesSelector,
                compute_chart_dimensions_1.computeChartDimensionsSelector,
                is_histogram_mode_enabled_1.isHistogramModeEnabledSelector,
            ], function (lastDrag, _a, computedScales, _b, histogramMode) {
                var onBrushEnd = _a.onBrushEnd, rotation = _a.rotation, brushAxis = _a.brushAxis, minBrushDelta = _a.minBrushDelta, roundHistogramBrushValues = _a.roundHistogramBrushValues, allowBrushingLastHistogramBucket = _a.allowBrushingLastHistogramBucket;
                var chartDimensions = _b.chartDimensions;
                var nextProps = {
                    lastDrag: lastDrag,
                    onBrushEnd: onBrushEnd,
                };
                if (lastDrag !== null && events_1.hasDragged(prevProps, nextProps)) {
                    if (onBrushEnd) {
                        var brushArea = {};
                        var yScales = computedScales.yScales, xScale = computedScales.xScale;
                        if (brushAxis === constants_1.BrushAxis.X || brushAxis === constants_1.BrushAxis.Both) {
                            brushArea.x = getXBrushExtent(chartDimensions, lastDrag, rotation, histogramMode, xScale, minBrushDelta, roundHistogramBrushValues, allowBrushingLastHistogramBucket);
                        }
                        if (brushAxis === constants_1.BrushAxis.Y || brushAxis === constants_1.BrushAxis.Both) {
                            brushArea.y = getYBrushExtents(chartDimensions, lastDrag, rotation, yScales, minBrushDelta);
                        }
                        if (brushArea.x !== undefined || brushArea.y !== undefined) {
                            onBrushEnd(brushArea);
                        }
                    }
                }
                prevProps = nextProps;
            })({
                keySelector: function (state) { return state.chartId; },
            });
        }
        if (selector) {
            selector(state);
        }
    };
}
exports.createOnBrushEndCaller = createOnBrushEndCaller;
function getXBrushExtent(chartDimensions, lastDrag, rotation, histogramMode, xScale, minBrushDelta, roundHistogramBrushValues, allowBrushingLastHistogramBucket) {
    var startPos = get_brush_area_1.getLeftPoint(chartDimensions, lastDrag.start.position);
    var endPos = get_brush_area_1.getLeftPoint(chartDimensions, lastDrag.end.position);
    var chartMax = chartDimensions.width;
    if (common_1.isVerticalRotation(rotation)) {
        startPos = get_brush_area_1.getTopPoint(chartDimensions, lastDrag.start.position);
        endPos = get_brush_area_1.getTopPoint(chartDimensions, lastDrag.end.position);
        chartMax = chartDimensions.height;
    }
    var minPos = commons_1.minValueWithLowerLimit(startPos, endPos, 0);
    var maxPos = commons_1.maxValueWithUpperLimit(startPos, endPos, chartMax);
    if (rotation === -90 || rotation === 180) {
        minPos = chartMax - minPos;
        maxPos = chartMax - maxPos;
    }
    if (minBrushDelta !== undefined ? Math.abs(maxPos - minPos) < minBrushDelta : maxPos === minPos) {
        return;
    }
    var offset = histogramMode ? 0 : -(xScale.bandwidth + xScale.bandwidthPadding) / 2;
    var invertValue = roundHistogramBrushValues
        ? function (value) { var _a; return (_a = xScale.invertWithStep(value, xScale.domain)) === null || _a === void 0 ? void 0 : _a.value; }
        : function (value) { return xScale.invert(value); };
    var minPosScaled = invertValue(minPos + offset);
    var maxPosScaled = invertValue(maxPos + offset);
    var maxDomainValue = xScale.domain[1] + (allowBrushingLastHistogramBucket ? xScale.minInterval : 0);
    var minValue = commons_1.minValueWithLowerLimit(minPosScaled, maxPosScaled, xScale.domain[0]);
    var maxValue = commons_1.maxValueWithUpperLimit(minPosScaled, maxPosScaled, maxDomainValue);
    return [minValue, maxValue];
}
function getYBrushExtents(chartDimensions, lastDrag, rotation, yScales, minBrushDelta) {
    var yValues = [];
    yScales.forEach(function (yScale, groupId) {
        var startPos = get_brush_area_1.getTopPoint(chartDimensions, lastDrag.start.position);
        var endPos = get_brush_area_1.getTopPoint(chartDimensions, lastDrag.end.position);
        var chartMax = chartDimensions.height;
        if (common_1.isVerticalRotation(rotation)) {
            startPos = get_brush_area_1.getLeftPoint(chartDimensions, lastDrag.start.position);
            endPos = get_brush_area_1.getLeftPoint(chartDimensions, lastDrag.end.position);
            chartMax = chartDimensions.width;
        }
        var minPos = commons_1.minValueWithLowerLimit(startPos, endPos, 0);
        var maxPos = commons_1.maxValueWithUpperLimit(startPos, endPos, chartMax);
        if (rotation === -90 || rotation === 180) {
            minPos = chartMax - minPos;
            maxPos = chartMax - maxPos;
        }
        if (minBrushDelta !== undefined ? Math.abs(maxPos - minPos) < minBrushDelta : maxPos === minPos) {
            return;
        }
        var minPosScaled = yScale.invert(minPos);
        var maxPosScaled = yScale.invert(maxPos);
        var minValue = commons_1.minValueWithLowerLimit(minPosScaled, maxPosScaled, yScale.domain[0]);
        var maxValue = commons_1.maxValueWithUpperLimit(minPosScaled, maxPosScaled, yScale.domain[1]);
        yValues.push({ extent: [minValue, maxValue], groupId: groupId });
    });
    return yValues.length === 0 ? undefined : yValues;
}
//# sourceMappingURL=on_brush_end_caller.js.map